/* Ustawienie katalogu domowego (katalogu instalacji oprogramowania) */
%default HOME `echo \$HOME/Software/`

/* Avro używa biblioteki json-simple i jest w bibliotekach piggybank; od wersji Pig 0.12 AvroStorage i TrevniStorage są elementami wbudowanymi */
REGISTER $HOME/pig/build/ivy/lib/Pig/avro-1.5.3.jar
REGISTER $HOME/pig/build/ivy/lib/Pig/json-simple-1.1.jar
REGISTER $HOME/pig/contrib/piggybank/java/piggybank.jar

DEFINE AvroStorage org.apache.pig.piggybank.storage.avro.AvroStorage();

/* Pakiety .jar Elasticsearcha */
REGISTER $HOME/elasticsearch-0.20.2/lib/*.jar

/* Rejestrowanie wonderdoga - do integracji z Elasticsearchem */
REGISTER $HOME/wonderdog/target/wonderdog-1.0-SNAPSHOT.jar

/* Usunięcie starych plików json */
rmf /tmp/inbox_json

/* Wyczyszczenie indeksu w ElasticSearch-u (utworzymy nowe) */
sh curl -XDELETE 'http://localhost:9200/inbox/emails'

/* Załadowanie plików Avro, i zapis w formacie JSON */
emails = LOAD '/me/Data/test_mbox' USING AvroStorage();
STORE emails INTO '/tmp/inbox_json' USING JsonStorage();


/* Załadowanie JSON-a do pojedynczego pola znakowego i zaindeksowanie go w ElasticSearchu za pomocą Wonderdoga */
email_json = LOAD '/tmp/inbox_json' AS (email:chararray);
STORE email_json INTO 'es://inbox/emails?json=true&size=1000' USING com.infochimps.elasticsearch.pig.ElasticSearchStorage(
  '$HOME/elasticsearch-0.20.2/config/elasticsearch.yml', 
  '$HOME/elasticsearch-0.20.2/plugins');

/* Poszukajmy słowa Hadoop, żeby się upewnić, że indeks wiadomości został zasilony */
sh curl -XGET 'http://localhost:9200/inbox/emails/_search?q=hadoop&pretty=true&size=1'
