/* Ustawienie katalogu domowego (katalogu instalacji oprogramowania) */
%default HOME `echo \$HOME/Software/`

/* Avro używa biblioteki json-simple i jest w bibliotekach piggybank; od wersji Pig 0.12 AvroStorage i TrevniStorage są elementami wbudowanymi */
REGISTER $HOME/pig/build/ivy/lib/Pig/avro-1.5.3.jar
REGISTER $HOME/pig/build/ivy/lib/Pig/json-simple-1.1.jar
REGISTER $HOME/pig/contrib/piggybank/java/piggybank.jar

DEFINE AvroStorage org.apache.pig.piggybank.storage.avro.AvroStorage();

REGISTER $HOME/varaha/lib/*.jar /* */
REGISTER $HOME/varaha/target/varaha-1.0-SNAPSHOT.jar

define TokenizeText varaha.text.TokenizeText();
define LDATopics varaha.topic.LDATopics();
define RangeConcat org.pygmalion.udf.RangeBasedStringConcat('0', ' ');

set default_parallel 10
set mapred.map.tasks.speculative.execution false
set mapred.reduce.tasks.speculative.execution false

-- 
-- Wczytanie dokumentów
-- 
emails = load '/me/Data/test_mbox' using AvroStorage();
raw_documents = foreach emails generate message_id, body;
--
-- Tokenizacja tekstu w celu usunięcia słów nieznaczących (ang. stopwords)
--
tokenized = foreach raw_documents generate message_id, flatten(TokenizeText(body)) as (token:chararray);
 
--
-- Złączenie przefiltrowanych wyrazów w ciąg (spacjami)
--
documents = foreach (group tokenized by message_id) generate group as message_id, RangeConcat(tokenized.token) as text;
 
--
-- Sprawdzenie, czy wszystkie dokumenty zawierają treść
--
for_lda = filter documents by message_id IS NOT NULL and text IS NOT NULL;
 
--
-- Grupowanie dokumentów według tematów
--
-- UWAGA: nie do użytku produkcyjnego; lepiej grupować po metadanych dzielących
-- dokumenty na mniejsze partycje.
--
topics = foreach (group for_lda all) generate
           FLATTEN(LDATopics(20, for_lda)) as (
           topic_num:int,
           keywords:bag {t:tuple(keyword:chararray, weight:int)}
         );
 
 
store topics into '/tmp/lda_topics.txt';
