from flask import Flask, render_template
import pymongo
import json
import re

# Przygotowanie Flask-a
app = Flask(__name__)

# Przygotowanie MongoDB
conn = pymongo.Connection() # domyślnie 'localhost'
db = conn.agile_data

# Pobranie i wypisanie listy liczników from/to
@app.route("/sent_counts")
def sent_counts():
  sent_counts = db['sent_counts'].find()
  results = {}
  results['keys'] = 'from', 'to', 'total'
  results['values'] = [[s['from'], s['to'], s['total']] for s in sent_counts if re.search('apache', str(s['from'])) or re.search('apache', str(s['to']))]
  results['values'] = results['values'][0:17]
  return render_template('table.html', results=results)

if __name__ == "__main__":
  app.run(debug=True)
