import pymongo
from datetime import datetime
from avro import schema, datafile, io
import pprint
import sys
import json
from nltk.tokenize import word_tokenize

import dateutil.parser

pp = pprint.PrettyPrinter()

conn = pymongo.Connection() # domyślnie 'localhost'
db = conn.agile_data
from_to_reply_ratios = db['from_to_reply_ratios']
hourly_from_reply_probs = db['hourly_from_reply_probs']
token_reply_rates = db['token_reply_rates']

# Test wczytywania plików avro
rec_reader = io.DatumReader()
# Utworzenie obiektu czytającego plik danych (avro)
df_reader = datafile.DataFileReader(
  open("/me/Data/test_mbox/part-1.avro"),
  rec_reader
)

# Przetworzenie wszystkich wiadomości w formacie avro...
for record in df_reader:
  # Wyłuskujemy identyfikator wiadomości, 'from', pierwszy adres z 'to' oraz ciało wiadomości
  message_id = record['message_id']
  froms = record['from']['address']
  if record['tos']:
    if record['tos'][0]:
      to = record['tos'][0]['address']
  
  # Każdy wyraz z treści wiadomości, jeśli występuje w MongoDB,
  # dołączamy do listy w celu późniejszego uśrednienia prawdopodobieństwa
  word_probs = []
  body = record['body']
  for token in word_tokenize(body):
    search = token_reply_rates.find_one({'token': token})
    if search:
      word_probs.append(search['reply_rate'])
  len_probs = float(len(probs))
  if(len_probs > 0):
    token_rate = sum(probs) / len_probs
  else:
    continue
  
  # Użyj prawdopodobieństwa dla pary from-to (jeśli jest znane)
  ftrr = from_to_reply_ratios.find_one({'from': froms, 'to': to})
  if ftrr:
    p_from_to_reply = ftrr['ratio']
  else:
    continue
  
  # Próbuj zwiększać wagi o 0.01 dla wyważenia wektorów
  for i in [x / 10.0 for x in range(0, 11, 1)]:
    result = (token_rate * i) + (p_from_to_reply * (1 - i))
    print message_id + "\t" + str(i) + "\t" + str(1 - i) + "\t" + str(result)

# Hura - teraz do test_results.pig, w celu określenia właściwych wag.
