from flask import Flask
import pymongo
import json

# Przygotowanie Flask-a
app = Flask(__name__)

# Przygotowanie MongoDB
conn = pymongo.Connection() # domyślnie 'localhost'
db = conn.agile_data
sent_counts = db['sent_counts']

# Pobranie liczników from/to dla pary adresów e-mail
@app.route("/sent_counts/<from_address>/<to_address>")
def sent_count(from_address, to_address):
  sent_count = sent_counts.find_one( {'from': from_address, 'to': to_address} )
  return json.dumps( {'from': sent_count['from'], 'to': sent_count['to'], 'total': sent_count['total']} )

if __name__ == "__main__":
  app.run(debug=True)
