// Tworzy nowy obiekt z dwiema właściwościami. Druga właściwość jest obiektem
var obj = {
  greeting: "Witaj",
  innerObj: {}
};
// Zamraża nasz obiekt
Object.freeze(obj);
// Występuje niesygnalizowany błąd
obj.greeting = 'Witaj świecie';
// innerObj wciąż może zostać uaktualniony
obj.innerObj.greeting = 'Witaj świecie';
console.log('obj.innerObj.greeting = ' + obj.innerObj.greeting);
// Nie można przekształcić istniejącej właściwości do postaci metody dostępowej
// Wyrzuca błąd TypeError
Object.defineProperty(obj, 'greeting', {get:function(){return 'Witaj świecie'; } });
// Nie można usunąć właściwości błąd niesygnalizowany
delete obj.greeting;
function makeTypeError(){
  'use strict';
}
// W chwili usuwania właściwości tworzy błąd TypeError
delete obj.greeting;
// Zamraża obiekt wewnętrzny
Object.freeze(obj.innerObj);
// innerObj jest teraz zamrożony. Niesygnalizowany błąd
obj.innerObj.greeting = 'Jak dotąd pracowałem...';
function makeTypeError(){
  'use strict';
  // wszystkie próby wygenerują błąd TypeError
  delete obj.greeting;
  obj.innerObj.greeting = 'Jak dotąd pracowałem...';
  obj.greeting = "Witaj";
};
makeTypeError();