# -*- coding: utf-8 -*-

from Adafruit_PWM_Servo_Driver import PWM  
import RPi.GPIO as GPIO
from pygame import mixer
import time

PIR_PIN = 23    # 1
GPIO.setmode(GPIO.BCM)
GPIO.setup(PIR_PIN, GPIO.IN)

pwm = PWM(0x40)
mixer.init()    # 2
mixer.music.load("pepe_1.wav")

servoMin = 150  # minimalna długość impulsu z zakresu 4096    
servoMax = 600  # maksymalna długość impulsu z zakresu 4096

dance = [     
  #lr  ln  pn  pr
  [130, 20, 20, 130],
  [30, 160, 160, 30],    
  [90, 90, 90, 90]
]

delay = 0.2   
  
def map(value, from_low, from_high, to_low, to_high):  
  from_range = from_high - from_low
  to_range = to_high - to_low
  scale_factor = float(from_range) / float(to_range)
  return to_low + (value / scale_factor)
  
  
def set_angle(channel, angle):  
  pulse = int(map(angle, 0, 180, servoMin, servoMax))
  pwm.setPWM(channel, 0, pulse)
  
def dance_step(step):  
  set_angle(0, step[0])
  set_angle(1, step[1])
  set_angle(2, step[2])
  set_angle(3, step[3])
  
def dance_pupet():    # 3
    for i in range(1, 10):
        for step in dance:
            dance_step(step)
            time.sleep(delay)
    
pwm.setPWMFreq(60)   


while (True):  
  if GPIO.input(PIR_PIN) == True:   # 4
      mixer.music.play()
      dance_pupet()
      time.sleep(2)
