# -*- coding: utf-8 -*-
import RPi.GPIO as GPIO
import time

servo_pin = 18

# Precyzyjne dobranie tych wartości pozwala na korzystanie z pełnego zakresu ruchu ramienia.
deg_0_pulse = 0.5   # ms (1)
deg_180_pulse = 2.5 # ms
f = 50.0   # 50 Hz = 20 ms pomiędzy impulsami (2)

# Obliczanie parametrów długości impulsów.
period = 1000 / f # 20 ms  (3)
k = 100 / period         # cykl roboczy 0-100 przez 20 ms (4)
deg_0_duty = deg_0_pulse * k  # (5)
pulse_range = deg_180_pulse - deg_0_pulse
duty_range = pulse_range * k  # (6)

# Inicjalizuj pin GPIO.
GPIO.setmode(GPIO.BCM)
GPIO.setup(servo_pin, GPIO.OUT)  # (7)
pwm = GPIO.PWM(servo_pin, f)      
pwm.start(0)

def set_angle(angle):   # (8)
    duty = deg_0_duty + (angle / 180.0) * duty_range
    pwm.ChangeDutyCycle(duty)

try:
    while True:    # (9)
        angle = input("Podaj kąt (od 0 do 180): ")
        set_angle(angle)
finally:
    print("Czyszczenie")
    GPIO.cleanup()
