package com.allendowney.thinkdast;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

import redis.clients.jedis.Jedis;


public class JedisMaker {

   /**
    * Tworzy obiekt Jedisa i autoryzuje go.
    *
    * @return
    * @throws IOException
    */
   public static Jedis make() throws IOException {
      
      // złóż nazwę katalogu
      String slash = File.separator;
      String filename = "resources" + slash + "redis_url.txt";
      URL fileURL = JedisMaker.class.getClassLoader().getResource(filename);
      String filepath = URLDecoder.decode(fileURL.getFile(), "UTF-8");
      
      // otwórz plik
      StringBuilder sb = new StringBuilder();
      BufferedReader br;
      try {
         br = new BufferedReader(new FileReader(filepath));
      } catch (FileNotFoundException e1) {
         System.out.println("Plik nie został znaleziony: " + filename);
         printInstructions();
         return null;
      }

      // odczytaj plik
      while (true) {
         String line = br.readLine();
         if (line == null) break;
         sb.append(line);
      }
      br.close();

      // sparsuj URL
      URI uri;
      try {
         uri = new URI(sb.toString());
      } catch (URISyntaxException e) {
         System.out.println("Odczytuję plik: " + filename);
         System.out.println("Wygląda na to, że plik nie zawiera prawidłowego ciągu URI.");
         printInstructions();
         return null;
      }
      String host = uri.getHost();
      int port = uri.getPort();

      String[] array = uri.getAuthority().split("[:@]");
      String auth = array[1];
      
      // połącz się z serwerem
      Jedis jedis = new Jedis(host, port);

      try {
         jedis.auth(auth);
      } catch (Exception e) {
         System.out.println("Próbuję się połączyć z " + host);
         System.out.println("za pomocą portu " + port);
         System.out.println("z kodem autoryzacji " + auth);
         System.out.println("Został zgłoszony wyjątek " + e);
         printInstructions();
         return null;
      }
      return jedis;
   }


   /**
    *
    */
   private static void printInstructions() {
      System.out.println("");
      System.out.println("Aby połączyć się z RedisToGo, musisz zapewnić plik o nazwie");
      System.out.println("redis_url.txt, który zawiera URL Twojego serwera Redisa.");
      System.out.println("Jeśli wybierzesz instancję na stronie internetowej RedisToGo,");
      System.out.println("powinieneś zobaczyć URL, który zawiera potrzebne Ci informacje:");
      System.out.println("redis://redistogo:AUTH@HOST:PORT");
      System.out.println("Utwórz plik o nazwie redis_url.txt w katalogu src/resources");
      System.out.println("i wklej do niego ten URL.");
   }


   /**
    * @param args
    * @throws IOException
    */
   public static void main(String[] args) throws IOException {

      Jedis jedis = make();

      // łańcuch znakowy
      jedis.set("mykey", "myvalue");
      String value = jedis.get("mykey");
       System.out.println("Otrzymana wartość: " + value);

       // zbiór
       jedis.sadd("myset", "element1", "element2", "element3");
       System.out.println("element2 jest składnikiem: " + jedis.sismember("myset", "element2"));

       // lista
       jedis.rpush("mylist", "element1", "element2", "element3");
       System.out.println("Element pod indeksem 1: " + jedis.lindex("mylist", 1));

       // hasz
       jedis.hset("myhash", "word1", Integer.toString(2));
       jedis.hincrBy("myhash", "word2", 1);
       System.out.println("Częstotliwość występowania klucza word1: " + jedis.hget("myhash", "word1"));
       System.out.println("Częstotliwość występowania klucza word2: " + jedis.hget("myhash", "word2"));

       jedis.close();
   }
}