package com.allendowney.thinkdast;

import java.util.HashMap;
import java.util.Map;

import org.jfree.data.xy.XYSeries;

import com.allendowney.thinkdast.Profiler.Timeable;

public class ProfileMapPut {
   
   /**
    * @param args
    */
   public static void main(String[] args) {
      //profileHashMapPut();
      //profileMyHashMapPut();
      profileMyFixedHashMapPut();
   }

   /**
    * Określa czas wykonania operacji umieszczenia klucza w kolekcji java.util.HashMap
    */
   public static void profileHashMapPut() {
      Timeable timeable = new Timeable() {
         Map<String, Integer> map;

         public void setup(int n) {
            map = new HashMap<String, Integer>();
         }

         public void timeMe(int n) {
            for (int i=0; i<n; i++) {
               map.put(String.format("%10d", i), i);
            }
         }
      };
      int startN = 8000;
      int endMillis = 1000;
      runProfiler("Umieszczenie w kolekcji HashMap", timeable, startN, endMillis);
   }
   
   /**
    * Określa czas wykonania operacji umieszczenia klucza w kolekcji MyHashMap
    */
   public static void profileMyHashMapPut() {
      Timeable timeable = new Timeable() {
         Map<String, Integer> map;

         public void setup(int n) {
            map = new MyHashMap<String, Integer>();
         }

         public void timeMe(int n) {
            for (int i=0; i<n; i++) {
               map.put(String.format("%10d", i), i);
            }
         }
      };
      int startN = 1000;
      int endMillis = 5000;
      runProfiler("Umieszczenie w kolekcji MyHashMap", timeable, startN, endMillis);
   }
   

   /**
    * Określa czas wykonania operacji umieszczenia klucza w kolekcji MyFixedHashMap
    */
   public static void profileMyFixedHashMapPut() {
      Timeable timeable = new Timeable() {
         Map<String, Integer> map;

         public void setup(int n) {
            map = new MyFixedHashMap<String, Integer>();
         }

         public void timeMe(int n) {
            for (int i=0; i<n; i++) {
               map.put(String.format("%10d", i), i);
            }
         }
      };
      int startN = 8000;
      int endMillis = 1000;
      runProfiler("Umieszczenie w kolekcji MyFixedHashMap", timeable, startN, endMillis);
   }
   
   /**
    * Uruchamia profilowanie i wyświetla wyniki.
    * 
    * @param timeable
    * @param startN
    * @param endMillis
    */
   private static void runProfiler(String title, Timeable timeable, int startN, int endMillis) {
      Profiler profiler = new Profiler(title, timeable);
      XYSeries series = profiler.timingLoop(startN, endMillis);
      profiler.plotResults(series);
   }
}