<?php

class My_Validate_Date extends Zend_Validate_Abstract
{
    const WRONG_DATE = 'wrongDate';

    protected $_messageTemplates = array(
        self::WRONG_DATE => 'Podana data jest niepoprawna'
    );

    public function isValid($value, $context = null)
    {

        $dzien = (string) $value;
        $this->_setValue($dzien);

        if (
            is_array($context)
            && isset($context['rokwydania'])
            && ($rok = $context['rokwydania'])
            && isset($context['miesiacwydania'])
            && ($miesiac = $context['miesiacwydania'])
            && (checkdate($miesiac, $dzien, $rok))
        ) {
            return true;
        }

        $this->_error(self::WRONG_DATE);
        return false;
    }
}
