SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

DROP SCHEMA IF EXISTS `kontynenty` ;
CREATE SCHEMA IF NOT EXISTS `kontynenty` DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci ;
USE `kontynenty` ;

-- -----------------------------------------------------
-- Table `kontynenty`.`kontynent`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`kontynent` (
  `kontynent_id` INT NOT NULL AUTO_INCREMENT ,
  `nazwa` VARCHAR(45) NULL ,
  `slug` VARCHAR(45) NOT NULL ,
  PRIMARY KEY (`kontynent_id`) ,
  UNIQUE INDEX `u_slug` (`slug` ASC) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `kontynenty`.`panstwo`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`panstwo` (
  `panstwo_id` INT NOT NULL AUTO_INCREMENT ,
  `nazwa` VARCHAR(45) NULL ,
  `slug` VARCHAR(45) NOT NULL ,
  `kontynent_id` INT NOT NULL ,
  PRIMARY KEY (`panstwo_id`) ,
  UNIQUE INDEX `u_slug` (`slug` ASC) ,
  INDEX `fk_panstwo_kontynent` (`kontynent_id` ASC) ,
  CONSTRAINT `fk_panstwo_kontynent`
    FOREIGN KEY (`kontynent_id` )
    REFERENCES `kontynenty`.`kontynent` (`kontynent_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `kontynenty`.`user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`user` (
  `user_id` INT NOT NULL AUTO_INCREMENT ,
  `username` VARCHAR(128) NOT NULL ,
  `password` VARCHAR(128) NULL ,
  `salt` VARCHAR(128) NULL ,
  `email` VARCHAR(128) NULL ,
  PRIMARY KEY (`user_id`) ,
  UNIQUE INDEX `username_UNIQUE` (`username` ASC) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `kontynenty`.`action`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`action` (
  `action_id` INT NOT NULL AUTO_INCREMENT ,
  `module` VARCHAR(45) NULL ,
  `controller` VARCHAR(45) NULL ,
  `action` VARCHAR(45) NULL ,
  `is_secure` TINYINT(1)  NULL ,
  PRIMARY KEY (`action_id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `kontynenty`.`action_has_user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `kontynenty`.`action_has_user` (
  `action_id` INT NOT NULL ,
  `user_id` INT NOT NULL ,
  PRIMARY KEY (`action_id`, `user_id`) ,
  INDEX `fk_action_has_user_action1` (`action_id` ASC) ,
  INDEX `fk_action_has_user_user1` (`user_id` ASC) ,
  CONSTRAINT `fk_action_has_user_action1`
    FOREIGN KEY (`action_id` )
    REFERENCES `kontynenty`.`action` (`action_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_action_has_user_user1`
    FOREIGN KEY (`user_id` )
    REFERENCES `kontynenty`.`user` (`user_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;


grant all on kontynenty.* to redaktor@localhost identified by 'tajnehaslo';
flush privileges;
