-- phpMyAdmin SQL Dump
-- version 3.1.5
-- http://www.phpmyadmin.net
--
-- Host: localhost
-- Czas wygenerowania: 03 Sie 2011, 06:47
-- Wersja serwera: 5.1.44
-- Wersja PHP: 5.2.13

SET FOREIGN_KEY_CHECKS=0;

SET SQL_MODE="NO_AUTO_VALUE_ON_ZERO";


/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;

--
-- Baza danych: `artykuly`
--

-- --------------------------------------------------------

--
-- Struktura tabeli dla  `artykul`
--

DROP TABLE IF EXISTS `artykul`;
CREATE TABLE IF NOT EXISTS `artykul` (
  `artykul_id` int(11) NOT NULL AUTO_INCREMENT,
  `tytul` varchar(128) COLLATE utf8_polish_ci DEFAULT NULL,
  `lid` text COLLATE utf8_polish_ci,
  `spistresci` text COLLATE utf8_polish_ci,
  `tresc` text COLLATE utf8_polish_ci,
  `slug` varchar(128) COLLATE utf8_polish_ci NOT NULL,
  PRIMARY KEY (`artykul_id`),
  UNIQUE KEY `u_slug` (`slug`)
) ENGINE=InnoDB  DEFAULT CHARSET=utf8 COLLATE=utf8_polish_ci AUTO_INCREMENT=13 ;

--
-- Zrzut danych tabeli `artykul`
--

INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(1, 'Składnia języka HTML', 'Język HTML jest ściśle związany z siecią WWW od początków jej istnienia.\r\nWygoda korzystania z hipertekstu zawierającego odnośniki w połączeniu\r\nz prostotą samego języka spowodowała lawinowy wzrost zarówno użytkowników,\r\njak i osób publikujących na łamach WWW.\r\nDo tworzenia atrakcyjnych, a zarazem poprawnych dokumentów HTML\r\nnie wystarczy jednak pobieżna znajomość kilku znaczników.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Strony WWW</a></li>\r\n<li><a href="#R2">2. Języki znacznikowe</a></li>\r\n<li><a href="#R3">3. Składnia języka HTML 4.01</a>\r\n    <ol>\r\n        <li><a href="#P3-1">3.1 Znaczniki i elementy</a></li>\r\n        <li><a href="#P3-2">3.2 Znaki specjalne</a></li>\r\n        <li><a href="#P3-3">3.3 Zagnieżdżanie znaczników</a></li>\r\n        <li><a href="#P3-4">3.4 Znaczniki wymagane, opcjonalne oraz elementy puste</a></li>\r\n        <li><a href="#P3-5">3.5 Białe znaki w dokumencie HTML</a></li>\r\n        <li><a href="#P3-6">3.6 Atrybuty znaczników</a></li>\r\n        <li><a href="#P3-7">3.7 Komentarze w HTML</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R4">4. Struktura dokumentu HTML</a>\r\n    <ol>\r\n        <li><a href="#P4-1">4.1 Wersje języka HTML: ścisła, przejściowa oraz dopuszczająca ramki</a></li>\r\n        <li><a href="#P4-2">4.2 Nagłówek strony WWW</a></li>\r\n        <li><a href="#P4-3">4.3 Treść dokumentu</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R5">5. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Strony WWW</h3>\r\n\r\n<p>Dokumenty dostępne w sieci WWW, nazywane potocznie\r\nstronami internetowymi lub stronami WWW\r\nsą zapisane <em>w plikach tekstowych</em>.\r\nZawartość plików tekstowych możemy przeglądać i edytować\r\nniemal każdym edytorem, na przykład notatnikiem.\r\nNajczęściej stosowane jest rozszerzenie <span class="plik">.html</span>,\r\n\r\n<span class="plik">.htm</span> lub\r\n<span class="plik">.xml</span>,\r\njednakże w pewnych sytuacjach możemy się spotkać z\r\n<span class="plik">.php</span>,\r\n<span class="plik">.asp</span>,\r\n<span class="plik">.pl</span>,\r\n<span class="plik">.cgi</span>,\r\n<span class="plik">.sh</span> czy nawet\r\n<span class="plik">.exe</span>.\r\nRozszerzenia różne od <span class="plik">.html</span>,\r\n\r\n<span class="plik">.htm</span> oraz <span class="plik">.xml</span>\r\nmówią o tym, że dana strona jest wynikiem działania pewnego\r\nprogramu uruchomionego na serwerze WWW.</p>\r\n\r\n<p>Treść strony internetowej opisujemy w\r\njednym z języków HTML, XHTML lub XML.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\nW najprostszym przypadku, strona WWW to plik tekstowy o\r\nrozszerzeniu <span class="plik">.html</span> zawierający\r\nkod w języku HTML.\r\n\r\n\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R2">2. Języki znacznikowe</h3>\r\n\r\n<p>Języki HTML, XHTML oraz XML należą do rodziny języków\r\n<em>znacznikowych</em> (z ang. <em>MarkUp Languages</em>).\r\nW językach takich, zawartość dokumentu przeplata się z\r\npewnymi specjalnymi napisami nazywanymi <em>znacznikami</em> (z ang. <em>tag</em>).\r\nOgólnie, znaczniki spełniają trzy funkcje:</p>\r\n\r\n<ul>\r\n\r\n<li>\r\nnadają dokumentowi <strong>strukturę</strong>,\r\ndefiniując różne jego elementy, takie jak rozdziały, podrozdziały czy akapity,\r\n</li>\r\n\r\n<li>określają <strong>prezentacyjne</strong> cechy takie jak kolor i krój czcionki,</li>\r\n<li>definiują <strong>semantyczne</strong> znaczenie fragmentów dokumentu.</li>\r\n\r\n</ul>\r\n\r\n<p>W językach HTML oraz XHTML rola znaczników w głównej mierze ogranicza się do pierwszego punktu:\r\nustalenia struktury zawartości. Prezentacyjną stronę dokumentów  HTML oraz XHTML\r\nokreślamy stosując język CSS.\r\nWsparcie semantyczne języków HTML i XHTML jest marginalne.</p>\r\n\r\n<p>W dalszej części skupimy się na języku HTML w wersji 4.01.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Szczegółowe informacje dotyczące języków znacznikowych znajdziemy\r\nna stronach  konsorcjum W3C (<a href="http://www.w3c.org/">http://www.w3c.org/</a>)\r\nodpowiedzialnego za\r\nustalanie standardów obowiązujących w sieci WWW:</p>\r\n\r\n<ul>\r\n<li>HTML, XHTML <a href="http://www.w3c.org/markup/">http://www.w3c.org/MarkUp/</a></li>\r\n<li>XML <a href="http://www.w3c.org/xml/">http://www.w3c.org/XML/</a></li>\r\n</ul>\r\n\r\n<p>Kompletna dokumentacja języka HTML 4.01\r\njest dostępna pod adresem <a href="http://www.w3.org/tr/html4/">http://www.w3.org/TR/html4/</a>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R3">3. Składnia języka HTML 4.01</h3>\r\n\r\n<p>Poznawanie języka HTML rozpoczniemy od składni.\r\nKolejno omówimy:</p>\r\n\r\n<ul>\r\n<li>czym są znaczniki oraz elementy,</li>\r\n<li>zbiór znaków, które mogą wystąpić w dokumencie\r\n(szczególną uwagę poświęcimy białym znakom),</li>\r\n<li>scharakteryzujemy zagnieżdżanie elementów\r\nuwzględniając znaczniki wymagane, opcjonalne oraz elementy puste,</li>\r\n\r\n<li>przyjrzymy się atrybutom znaczników.</li>\r\n</ul>\r\n\r\n<p>Rozważania dotyczące składni zakończymy omówieniem komentarzy.</p>\r\n\r\n<p>Część przykładów występujących w dalszej części artykułu\r\nbędzie przedstawiała poprawne zapisy, a część &mdash; niepoprawne.\r\nW celu uniknięcia dwuznaczności przyjmiemy zasadę stosowaną w dokumentacji języka.\r\nKażdy niepoprawny przykład zostanie poprzedzony uwagą\r\n<strong>PRZYKŁAD NIEPOPRAWNY</strong>.\r\nNatomiast przykłady, które są poprawne ale niezalecane oznaczymy\r\nuwagą <strong>PRZYKŁAD NIEZALECANY</strong>.</p>\r\n\r\n<h4 id="P3-1">3.1 Znaczniki i elementy</h4>\r\n\r\n<p><em>Znaczniki</em> to napisy otoczone znakami <span class="zmienna">&lt;</span>\r\noraz <span class="zmienna">&gt;</span>. Bezpośrednio po znaku\r\n<span class="zmienna">&lt;</span> występuje nazwa znacznika:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STRONG&gt;</pre>\r\n\r\n<p>Przedstawiony znacznik nazywa się <span class="zmienna">STRONG</span> i\r\njest to <em>znacznik otwierający</em>\r\nelementu <span class="zmienna">STRONG</span>.\r\nDuża część znaczników otwierających, lecz nie wszystkie, posiada\r\nodpowiadające im znaczniki zamykające. Znacznik zamykający różni się\r\nod znacznika otwierającego znakiem <span class="zmienna">/</span>\r\nnazywanym ukośnikiem (<span class="ang">ang. slash</span>):</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;/STRONG&gt;</pre>\r\n\r\n<p>Znaczniki otwierający i zamykający otaczają pewien fragment\r\ntekstu nadając mu odpowiednie znaczenie.\r\nNa przykład przedstawiony znacznik <span class="zmienna">STRONG</span>\r\nuwypukla fragment dokumentu:</p>\r\n\r\n<pre class="syntax-highlight:xml">Stoi na stacji &lt;STRONG&gt;lokomotywa&lt;/STRONG&gt;</pre>\r\n\r\n<p>W powyższym przykładzie znaczniki otwierający <span class="zmienna">&lt;STRONG&gt;</span>\r\noraz zamykający <span class="zmienna">&lt;/STRONG&gt;</span> otaczają\r\nwyraz &bdquo;lokomotywa&rdquo;. W ten sposób określamy, że słowo lokomotywa\r\npowinno zostać uwypuklone.</p>\r\n\r\n<p>Para znaczników, znacznik otwierający\r\noraz znacznik zamykający, określa <em>element</em>.\r\nPrzedstawiony przykład zawierał element <span class="zmienna">STRONG</span>.\r\nInnym przykładem jest:</p>\r\n\r\n<pre class="syntax-highlight:xml">Ciężka, ogromna i &lt;EM&gt;pot&lt;/EM&gt; z niej spływa.</pre>\r\n\r\n<p>Mówimy, że w powyższym tekście występuje element <strong>EM</strong>\r\no zawartości &bdquo;pot&rdquo;. Zasięg elementu określają znaczniki:\r\notwierający <span class="zmienna">&lt;EM&gt;</span>,\r\noraz zamykający <span class="zmienna">&lt;/EM&gt;</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p><strong>Element to nie to samo, co znacznik!</strong></p>\r\n\r\n<p>W kodzie:</p>\r\n\r\n<pre class="syntax-highlight:xml">E = mc&lt;SUP&gt;2&lt;/SUP&gt;</pre>\r\n\r\n<p>występuje element <strong>SUP</strong> o zawartości &bdquo;2&rdquo;\r\nzdefiniowany przez znacznik otwierający\r\n<span class="zmienna">&lt;SUP&gt;</span>\r\noraz znacznik zamykający\r\n<span class="zmienna">&lt;/SUP&gt;</span>.\r\nPisząc &bdquo;element <strong>SUP</strong>&rdquo; nie używamy\r\nznaków <span class="zmienna">&lt;</span>\r\n\r\nani <span class="zmienna">&gt;</span>.\r\nWówczas mamy na myśli zawartość:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SUP&gt;2&lt;/SUP&gt;</pre>\r\n\r\n<p>Jeśli natomiast piszemy &bdquo;znacznik\r\n<span class="zmienna">&lt;SUP&gt;</span>&rdquo;\r\nwówczas wskazujemy, że chodzi jedynie o zawartość:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SUP&gt;</pre>\r\n\r\n<p>Analogicznie, stwierdzenie &bdquo;znacznik\r\n<span class="zmienna">&lt;/SUP&gt;</span>&rdquo;\r\ndotyczy wyłącznie:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;/SUP&gt;</pre>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Nazwy znaczników możemy pisać literami dowolnej wielkości.\r\nWszystkie poniższe przykłady określają ten sam znacznik\r\n<span class="zmienna">&lt;TD&gt;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt; &lt;Td&gt; &lt;tD&gt; &lt;td&gt;</pre>\r\n\r\n<p>Specyfikacja języka HTML stosuje konwencję pisania nazw znaczników\r\ndużymi literami i takiej też zasady będziemy się trzymali w dalszych przykładach.</p>\r\n\r\n<p>Wewnątrz znaczników mogą pojawić się białe znaki.\r\nZarówno:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P     &gt;</pre>\r\n\r\n<p>jak i</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P\r\n\r\n        &gt;</pre>\r\n\r\n<p>jest poprawnym znacznikiem otwierającym elementu\r\n<span class="zmienna">P</span>.\r\nNależy jednak zwrócić uwagę, że białe znaki poprzedzające\r\nnazwę znacznika są niedozwolone. Zatem żaden z\r\nponiższych trzech znaczników nie jest poprawny:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;   EM&gt;  ,  &lt;  /SPAN&gt; ,  &lt;/  DIV&gt;</pre>\r\n\r\n<p>Tabela 1 zawiera sumaryczne zestawienie wszystkich\r\nelementów języka HTML opisanych w dokumentacji.\r\nUwaga, tabelka nie zawiera żadnych elementów,\r\nktóre zostały wycofane z języka (ang. <em>deprecated</em>).\r\nPrzestarzałymi elementami\r\nsą:\r\n<span class="zmienna">APPLET</span>,\r\n<span class="zmienna">BASEFONT</span>,\r\n<span class="zmienna">CENTER</span>,\r\n<span class="zmienna">DIR</span>,\r\n<span class="zmienna">FONT</span>,\r\n<span class="zmienna">ISINDEX</span>,\r\n\r\n<span class="zmienna">MENU</span>\r\n<span class="zmienna">S</span>\r\n<span class="zmienna">STRIKE</span> oraz\r\n<span class="zmienna">U</span>.\r\n\r\nPominięte zostały również elementy niezalecane\r\n<span class="zmienna">B</span>,\r\n<span class="zmienna">I</span>,\r\n<span class="zmienna">TT</span>,\r\n<span class="zmienna">BIG</span>,\r\n\r\n<span class="zmienna">SMALL</span>\r\noraz elementy dotyczące ramek\r\n\r\n<span class="zmienna">FRAMESET</span>,\r\n<span class="zmienna">FRAME</span>,\r\n<span class="zmienna">NOFRAMES</span> i\r\n<span class="zmienna">IFRAME</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Najlepiej nie umieszczać białych znaków wewnątrz znaczników.\r\nNie stanowi to żadnego ograniczenia, a\r\nuchroni nas przed trudnymi do odnalezienia błędami.\r\nZamiast:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STRONG    &gt;KOT&lt;/STRONG\r\n\r\n\r\n   &gt;</pre>\r\n\r\n<p>piszmy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STRONG&gt;KOT&lt;/STRONG&gt;</pre>\r\n\r\n<p>Konieczność stosowania białych znaków wewnątrz znaczników\r\nbędzie nieunikniona,  ale dopiero wówczas, gdy będziemy\r\nokreślali atrybuty znaczników.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>lp.</th><th>Znaczenie</th><th>Znaczniki</th><th>liczba</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>lp.</th><th>Znaczenie</th><th>Znaczniki</th><th>liczba</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Definicja dokumentu</td>\r\n\r\n<td><span class="zmienna">DOCTYPE</span>, <span class="zmienna">HTML</span>, <span class="zmienna">HEAD</span>, <span class="zmienna">TITLE</span>, <span class="zmienna">BODY</span>, <span class="zmienna">ADDRESS</span></td>\r\n\r\n<td>6</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Dane dodatkowe o dokumencie</td>\r\n\r\n<td><span class="zmienna">META</span></td>\r\n\r\n<td>1</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Elementy ogólne</td>\r\n\r\n<td><span class="zmienna">DIV</span>, <span class="zmienna">SPAN</span></td>\r\n\r\n<td>2</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Nagłówki</td>\r\n\r\n<td><span class="zmienna">H1</span>, <span class="zmienna">H2</span>, <span class="zmienna">H3</span>, <span class="zmienna">H4</span>, <span class="zmienna">H5</span>, <span class="zmienna">H6</span></td>\r\n\r\n<td>6</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Tekst dokumentu</td>\r\n\r\n<td><span class="zmienna">P</span>, <span class="zmienna">BR</span><br /><span class="zmienna">PRE</span><br /><span class="zmienna">EM</span>, <span class="zmienna">STRONG</span>, <span class="zmienna">DFN</span>, <span class="zmienna">CODE</span>, <span class="zmienna">SAMP</span>, <span class="zmienna">KBD</span>, <span class="zmienna">VAR</span>, <span class="zmienna">CITE</span>, <span class="zmienna">ABBR</span>, <span class="zmienna">ACRONYM</span><br /><span class="zmienna">Q</span>, <span class="zmienna">BLOCKQUOTE</span><br /><span class="zmienna">SUB</span>, <span class="zmienna">SUP</span></td>\r\n\r\n<td>17</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Zmiany w dokumencie</td>\r\n\r\n<td><span class="zmienna">INS</span>, <span class="zmienna">DEL</span></td>\r\n\r\n<td>2</td>\r\n\r\n</tr>\r\n\r\n<tr><td>6.</td>\r\n\r\n<td>Listy</td>\r\n\r\n<td><span class="zmienna">UL</span>, <span class="zmienna">OL</span>, <span class="zmienna">LI</span>, <span class="zmienna">DL</span>, <span class="zmienna">DT</span>, <span class="zmienna">DD</span></td>\r\n\r\n<td>6</td>\r\n\r\n</tr>\r\n\r\n<tr><td>7.</td>\r\n\r\n<td>Tabelki</td>\r\n\r\n<td><span class="zmienna">TABLE</span>, <span class="zmienna">TR</span>, <span class="zmienna">TD</span>, <span class="zmienna">TH</span>, <span class="zmienna">CAPTION</span>, <span class="zmienna">THEAD</span>, <span class="zmienna">TFOOT</span>, <span class="zmienna">TBODY</span>, <span class="zmienna">COL</span>, <span class="zmienna">COLGROUP</span></td>\r\n\r\n<td>10</td>\r\n\r\n</tr>\r\n\r\n<tr><td>8.</td>\r\n\r\n<td>Hiperłącza</td>\r\n\r\n<td><span class="zmienna">A</span>, <span class="zmienna">LINK</span>, <span class="zmienna">BASE</span></td>\r\n\r\n<td>3</td>\r\n\r\n</tr>\r\n\r\n<tr><td>9.</td>\r\n\r\n<td>Obrazy i obiekty</td>\r\n\r\n<td><span class="zmienna">IMG</span>, <span class="zmienna">OBJECT</span>, <span class="zmienna">PARAM</span>, <span class="zmienna">MAP</span>, <span class="zmienna">AREA</span></td>\r\n\r\n<td>5</td>\r\n\r\n</tr>\r\n\r\n<tr><td>10.</td>\r\n\r\n<td>Style</td>\r\n\r\n<td><span class="zmienna">STYLE</span></td>\r\n\r\n<td>1</td>\r\n\r\n</tr>\r\n\r\n<tr><td>11.</td>\r\n\r\n<td>Formularze</td>\r\n\r\n<td><span class="zmienna">FORM</span>, <span class="zmienna">INPUT</span>, <span class="zmienna">BUTTON</span>, <span class="zmienna">SELECT</span>, <span class="zmienna">OPTION</span>, <span class="zmienna">OPTGROUP</span>, <span class="zmienna">TEXTAREA</span>, <span class="zmienna">LABEL</span>, <span class="zmienna">FIELDSET</span>, <span class="zmienna">LEGEND</span></td>\r\n\r\n<td>10</td>\r\n\r\n</tr>\r\n\r\n<tr><td>12.</td>\r\n\r\n<td>Skrypty</td>\r\n\r\n<td><span class="zmienna">SCRIPT</span>, <span class="zmienna">NOSCRIPT</span></td>\r\n\r\n<td>2</td>\r\n\r\n</tr>\r\n\r\n<tr><td>13.</td>\r\n\r\n<td>Inne</td>\r\n\r\n<td><span class="zmienna">HR</span>, <span class="zmienna">&lt;!--    --&gt;</span>, <span class="zmienna">BDO</span></td>\r\n\r\n<td>3</td>\r\n\r\n</tr>\r\n\r\n<tr><td>&nbsp;</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n<td>RAZEM</td>\r\n\r\n<td>74</td>\r\n\r\n</tr>\r\n\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nZestawienie wszystkich poprawnych elementów języka HTML 4.01 w wersji "strict"</p>\r\n</div>\r\n\r\n\r\n\r\n<h4 id="P3-2">3.2 Znaki specjalne</h4>\r\n\r\n<p>Z uwagi na to, że znaki <span class="zmienna">&lt;</span>\r\noraz <span class="zmienna">&gt;</span> otaczają znaczniki,\r\nwprowadzenie tekstu poniższych nierówności:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\na&lt;b a&gt;7</pre>\r\n\r\n<p>będzie prowadziło do dwuznaczności.\r\nNapis <span class="zmienna">&lt;b a&gt;</span>\r\nzostanie zinterpretowany jako znacznik!\r\nW jaki zatem sposób wprowadzić znak mniejszości\r\ntak, by został on potraktowany jako fragment tekstu?\r\nSłużą do tego\r\n<em>znaki specjalne</em> (ang. <em>character references</em>).</p>\r\n\r\n<p>Zamiast znaku <span class="zmienna">&lt;</span>\r\nnależy użyć napisu <span class="zmienna">&amp;lt;</span>,\r\na zamiast znaku  <span class="zmienna">&gt;</span> &mdash;  napisu\r\n<span class="zmienna">&amp;gt;</span>.\r\nWszystkich znaków specjalnych jest kilkaset.\r\nKilka najczęściej stosowanych zostało zawartych w tabeli 2.</p>\r\n<p>Poprzedni przykład, po zastosowaniu znaków specjalnych ma postać</p>\r\n\r\n<pre class="syntax-highlight:xml">a&amp;lt;b a&amp;gt;7</pre>\r\n\r\n<p>Znaki specjalne możemy również wprowadzać podając kod dziesiętny lub szesnastkowy.\r\nNa przykład znak ASCII o kodzie 229 możemy uzyskać\r\npisząc <span class="zmienna">&amp;#229;</span> (kod dziesiętny)\r\nlub <span class="zmienna">&amp;#xE5;</span> (kod szesnastkowy).</p>\r\n\r\n<p>Średnik umieszczany na końcu znaków specjalnych jest opcjonalny,\r\njednakże specyfikacja zaleca jego stosowanie.</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEZALECANY</strong>\r\n7 &amp;lt a</pre>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>lp.</th><th>Nazwa</th><th>Znak drukowany</th><th>Znak specjalny</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>lp.</th><th>Nazwa</th><th>Znak drukowany</th><th>Znak specjalny</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Znak mniejszości</td>\r\n\r\n<td><span class="zmienna">&lt;</span></td>\r\n\r\n<td><span class="zmienna">&amp;lt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Znak większości</td>\r\n\r\n<td><span class="zmienna">&gt;</span></td>\r\n\r\n<td><span class="zmienna">&amp;gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Ampersand</td>\r\n\r\n<td><span class="zmienna">&amp;</span></td>\r\n\r\n<td><span class="zmienna">&amp;amp;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Copyright</td>\r\n\r\n<td><span class="zmienna">&copy;</span></td>\r\n\r\n<td><span class="zmienna">&amp;copy</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Twarda spacja</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n<td><span class="zmienna">&amp;nbsp;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>6.</td>\r\n\r\n<td>Cudzysłów</td>\r\n\r\n<td><span class="zmienna">&quot;</span></td>\r\n\r\n<td><span class="zmienna">&amp;quot;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>7.</td>\r\n\r\n<td>Apostrof</td>\r\n\r\n<td><span class="zmienna">''</span></td>\r\n\r\n<td><span class="zmienna">&amp;#39;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>8.</td>\r\n\r\n<td>Myślnik</td>\r\n\r\n<td><span class="zmienna">&mdash;</span></td>\r\n\r\n<td><span class="zmienna">&amp;mdash;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>9.</td>\r\n\r\n<td>Półpauza</td>\r\n\r\n<td><span class="zmienna">&ndash;</span></td>\r\n\r\n<td><span class="zmienna">&amp;ndash;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>10.</td>\r\n\r\n<td>Otwierający polski cudzysłów</td>\r\n\r\n<td>&bdquo;</td>\r\n\r\n<td><span class="zmienna">&amp;bdquo;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>11.</td>\r\n\r\n<td>Zamykający polski cudzysłów</td>\r\n\r\n<td>&rdquo;</td>\r\n\r\n<td><span class="zmienna">&amp;rdquo;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>12.</td>\r\n\r\n<td>Iloczyn kartezjański</td>\r\n\r\n<td><span class="zmienna">&times;</span></td>\r\n\r\n<td><span class="zmienna">&amp;times;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>13.</td>\r\n\r\n<td>Wielokropek</td>\r\n\r\n<td><span class="zmienna">&hellip;</span></td>\r\n\r\n<td><span class="zmienna">&amp;hellip;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>14.</td>\r\n\r\n<td>Strzałka w prawo</td>\r\n\r\n<td><span class="zmienna">&rarr;</span></td>\r\n\r\n<td><span class="zmienna">&amp;rarr;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>15.</td>\r\n\r\n<td>Strzałka do góry</td>\r\n\r\n<td><span class="zmienna">&uarr;</span></td>\r\n\r\n<td><span class="zmienna">&amp;uarr;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>16.</td>\r\n\r\n<td>Strzałka do dołu</td>\r\n\r\n<td><span class="zmienna">&darr;</span></td>\r\n\r\n<td><span class="zmienna">&amp;darr;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>17.</td>\r\n\r\n<td>Strzałka w lewo</td>\r\n\r\n<td><span class="zmienna">&larr;</span></td>\r\n\r\n<td><span class="zmienna">&amp;larr;</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 2.\r\nNajczęściej stosowane znaki specjalne</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Znaki <span class="zmienna">&lt;</span>\r\noraz <span class="zmienna">&gt;</span>\r\nmają wewnątrz dokumentu HTML specjalne znaczenie:\r\nrozpoczynają i kończą znaczniki.\r\n<strong>Nie wolno ich używać w treści dokumentu.</strong>\r\nJeśli chcemy zawrzeć w dokumencie\r\nznaki <span class="zmienna">&lt;</span>\r\nlub <span class="zmienna">&gt;</span>\r\nwówczas trzeba wykorzystać znaki specjalne\r\n<span class="zmienna">&amp;lt;</span> oraz\r\n\r\n<span class="zmienna">&amp;gt;</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<h4 id="P3-3">3.3 Zagnieżdżanie znaczników</h4>\r\n\r\n<p>Elementy HTML możemy zagnieżdżać. Oznacza to,\r\nże jeden element HTML może zawierać inny element</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;&lt;STRONG&gt;Witaj!&lt;/STRONG&gt;&lt;/P&gt;</pre>\r\n\r\n<p>W powyższym przykładzie występują dwa elementy:\r\nelement <span class="zmienna">P</span> oraz\r\nelement <span class="zmienna">STRONG</span>, przy czym\r\nelement <span class="zmienna">STRONG</span> jest zawarty\r\nwewnątrz elementu <span class="zmienna">P</span>.\r\nZwróćmy uwagę, na sposób otwierania i zamykania znaczników.\r\nJest on podobny do zasad stosowanych w wyrażeniach arytmetycznych.\r\nWyrażenie <span class="zmienna">2*(1/[2+3])</span>\r\njest poprawne, natomiast wyrażenie\r\n\r\n<span class="zmienna">2*(1/[2)+3]</span> jest błędne.\r\nPodobnie, niepoprawny jest kod:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;P&gt;&lt;EM&gt;Żegnaj!&lt;/P&gt;&lt;/EM&gt;</pre>\r\n\r\n<p>Poprawna wersja przedstawionego przykładu jest następująca:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;&lt;EM&gt;Żegnaj!&lt;/EM&gt;&lt;/P&gt;</pre>\r\n\r\n<p>O ile powyższa kwestia poprawnego rozmieszczania znaczników otwierających\r\ni zamykających jest &mdash; przez swoją analogię do notacji nawiasowej\r\nznanej z matematyki &mdash; dość oczywista, to sprawa\r\ndopuszczalności danego zagnieżdżenia jest o wiele bardziej skomplikowana.\r\nNa przykład element <span class="zmienna">SPAN</span>\r\n\r\nmoże być zawarty wewnątrz komórki tabelki\r\ndefiniowanej elementem <span class="zmienna">TD</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt;&lt;SPAN&gt;Pomidor?&lt;/SPAN&gt;&lt;/TD&gt;</pre>\r\n\r\n<p>Natomiast zagnieżdżenie elementu <span class="zmienna">DIV</span>\r\n\r\nwewnątrz elementu <span class="zmienna">TITLE</span> jest niedopuszczalne:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;TITLE&gt;&lt;DIV&gt;Kartofel!&lt;/DIV&gt;&lt;/TITLE&gt;</pre>\r\n\r\n<p>Każdy element HTML ma ściśle zdefiniowaną dopuszczalną zawartość.\r\nNiedozwolone jest tworzenie &bdquo;kwiatków&rdquo; postaci:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;EM&gt;&lt;BODY&gt;&lt;TITLE&gt;&lt;PRE&gt;UFF!&lt;/PRE&gt;&lt;/TITLE&gt;&lt;/BODY&gt;&lt;/EM&gt;</pre>\r\n\r\n<p>Wprawdzie przedstawione cztery elementy <span class="zmienna">EM</span>,\r\n<span class="zmienna">BODY</span>,\r\n<span class="zmienna">TITLE</span> oraz\r\n<span class="zmienna">PRE</span> są poprawnie\r\npootwierane i pozamykane &mdash;\r\nprzypominają wyrażenie <span class="zmienna">([{/ UFF! /}])</span> &mdash;\r\n\r\njednakże zagnieżdżenia takie nie są dopuszczalne w składni HTML.\r\nPo pierwsze element <span class="zmienna">EM</span> nie może zawierać elementu\r\n<span class="zmienna">BODY</span>. Po drugie\r\nelement <span class="zmienna">BODY</span> nie może zawierać\r\nelementu <span class="zmienna">TITLE</span>.\r\nWreszcie element <span class="zmienna">TITLE</span> nie może zawierać żadnego elementu,\r\nw szczególności <span class="zmienna">PRE</span>.</p>\r\n\r\n<p>Zasady dotyczące poprawności zagnieżdżania elementów HTML\r\nbędziemy poznawali w miarę przyswajania nowych elementów.\r\nNajlepiej nie stosować zagnieżdżeń, których nie jesteśmy pewni.</p>\r\n\r\n<h4 id="P3-4">3.4 Znaczniki wymagane, opcjonalne oraz elementy puste</h4>\r\n\r\n<p>Pośród wielu znaczników występujących w języku HTML część\r\njest opcjonalna, natomiast część &mdash; konieczna.\r\nSą i takie, które są zabronione.</p>\r\n\r\n<p>Przykładami znaczników opcjonalnych są znaczniki otwierające i zamykające\r\nelementów <span class="zmienna">HTML</span>, <span class="zmienna">HEAD</span>\r\n\r\noraz <span class="zmienna">BODY</span>. Oznacza to, że pełny kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HTML&gt;\r\n  &lt;HEAD&gt;\r\n\r\n  &lt;/HEAD&gt;\r\n  &lt;BODY&gt;\r\n\r\n  &lt;/BODY&gt;\r\n&lt;/HTML&gt;</pre>\r\n\r\n<p>możemy również napisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HTML&gt;&lt;HEAD&gt;</pre>\r\n\r\n<p>i będzie on znaczył dokładnie tyle samo.  Elementom\r\n<span class="zmienna">HEAD</span> oraz\r\n<span class="zmienna">HTML</span> usunęliśmy\r\nznacznik zamykający, zaś element\r\n<span class="zmienna">BODY</span> został pozbawiony obydwu znaczników.</p>\r\n\r\n<p>Tak liberalne zasady, pozwalające usunąć zarówno znacznik otwierający jak i\r\nzamykający, dotyczą tylko niewielu elementów. Drugą klasę stanowią elementy,\r\nktóre muszą posiadać znacznik otwierający, zaś znacznik zamykający jest opcjonalny.\r\nPrzykładem takiego elementu jest <span class="zmienna">LI</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LI&gt;Abra\r\n&lt;LI&gt;Kadabra\r\n&lt;LI&gt;Bęc</pre>\r\n\r\n<p>W przypadku elementu <span class="zmienna">LI</span>, otwierający\r\nznacznik <span class="zmienna">&lt;LI&gt;</span>\r\n\r\nautomatycznie zamyka niezamknięte wcześniej elementy <span class="zmienna">LI</span>.\r\nKod ten jest równoważny poniższemu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LI&gt;Abra&lt;/LI&gt;\r\n&lt;LI&gt;Kadabra&lt;/LI&gt;\r\n&lt;LI&gt;Bęc&lt;/LI&gt;</pre>\r\n\r\n<p>Kolejna kategoria elementów, to takie elementy, które muszą posiadać oba znaczniki:\r\notwierający i zamykający. Przykładem jest elementy\r\n<span class="zmienna">EM</span>. Kod:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;EM&gt;Miała &lt;EM&gt;Baba &lt;EM&gt;Koguta</pre>\r\n\r\n<p>jest niepoprawny i powinien być zapisany:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;EM&gt;Miała&lt;/EM&gt; &lt;EM&gt;Baba&lt;/EM&gt; &lt;EM&gt;Koguta&lt;/EM&gt;</pre>\r\n\r\n<p>Ostatni rodzaj elementów, to takie elementy, które nie posiadają\r\nznacznika zamykającego ani żadnej treści. Nazywamy je <em>elementami\r\npustymi</em> (ang. <em>empty elements</em>).  Przykładem elementu pustego jest\r\n<span class="zmienna">BR</span> &mdash; element powodujący złamanie wiersza.\r\nPonieważ element jest pusty, nie możemy napisać:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;BR&gt;RED&lt;/BR&gt;&lt;BR&gt;GREEN&lt;/BR&gt;&lt;BR&gt;BLUE&lt;/BR&gt;</pre>\r\n\r\n<p>Znaczniki zamykające <span class="zmienna">&lt;/BR&gt;</span> są niedozwolone\r\ni muszą zostać usunięte:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;BR&gt;RED&lt;BR&gt;GREEN&lt;BR&gt;BLUE</pre>\r\n\r\n<p>Jak sobie radzić z tymi czterema skomplikowanymi kategoriami?\r\nRozwiązanie jest bardzo proste. Wystarczy zapamiętać elementy puste,\r\na tych jest naprawdę niewiele.\r\n<span class="zmienna">AREA</span>,\r\n<span class="zmienna">BASE</span>,\r\n\r\n<span class="zmienna">BR</span>,\r\n<span class="zmienna">COL</span>,\r\n<span class="zmienna">HR</span>,\r\n<span class="zmienna">IMG</span>,\r\n<span class="zmienna">INPUT</span>,\r\n<span class="zmienna">LINK</span>,\r\n<span class="zmienna">META</span> oraz\r\n<span class="zmienna">PARAM</span>\r\n\r\nto kompletna lista\r\npustych znaczników\r\n(pominięty został jedynie element <span class="zmienna">FRAME</span>).\r\n.\r\nWszystkie inne znaczniki piszemy w pełnej postaci.</p>\r\n\r\n<p>Zauważmy jeszcze, że w odniesieniu do elementów pustych\r\nzamienne stosowanie terminów &bdquo;element&rdquo; oraz\r\n&bdquo;znacznik&rdquo; nie prowadzi do\r\nniejasności.</p>\r\n\r\n<h4 id="P3-5">3.5 Białe znaki w dokumencie HTML</h4>\r\n\r\n<p>Obserwując przykład przedstawiający elementy\r\n<span class="zmienna">HTML</span>, <span class="zmienna">HEAD</span>\r\noraz <span class="zmienna">BODY</span> prezentujący podział kodu na linie\r\ni wcięcia przypominające formatowanie programów komputerowych\r\nnależy się zastanowić, czy jest to poprawne?\r\nJak przeglądarki powinny interpretować\r\nbiałe znaki pomiędzy elementami HTML?</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n\r\n<thead>\r\n<tr><th>lp.</th><th>Nazwa</th><th>Znak specjalny</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>lp.</th><th>Nazwa</th><th>Znak specjalny</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>spacja</td>\r\n\r\n<td>&amp;#x0020;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>tabulacja</td>\r\n\r\n<td>&amp;#x0009;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>wysunięcie papieru</td>\r\n\r\n<td>&amp;#x000C;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>spacja o zerowej szerokości</td>\r\n\r\n<td>&amp;#x200B;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>powrót karetki (CR)</td>\r\n\r\n<td>&amp;#x000D;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>6.</td>\r\n\r\n<td>złamanie wiersza (LF)</td>\r\n\r\n<td>&amp;#x000A;</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 3.\r\nBiałe znaki języka HTML</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Dokumentacja mówi, że białe znaki nie mają wpływu na\r\npoprawność kodu HTML i <strong>nie powinny</strong> mieć wpływu\r\nna to jak przeglądarka dany dokument wyświetli.\r\nO ile uwaga dotycząca poprawności kodu\r\njest jak najbardziej prawdziwa (przynajmniej z punktu widzenia oprogramowania\r\nwalidującego kod HTML udostępnianego przez W3C),\r\nto graficzna prezentacja strony przez przeglądarki może zostać\r\nzakłócona przez białe znaki.</p>\r\n\r\n<p>Specyfikacja HTML przestrzega przed umieszczaniem białych znaków\r\nwewnątrz znaczników. Na przykład kod:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEZALECANY</strong>\r\nFiat&lt;EM&gt;  Audi  &lt;/EM&gt;Ford</pre>\r\n\r\n<p>bezpieczniej zapisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">Fiat   &lt;EM&gt;Audi&lt;/EM&gt;   Ford</pre>\r\n\r\n<p>Najczęściej spotykanym przykładem potwierdzającym,\r\nże białe znaki mogą wpływać na wygląd strony\r\njest seria obrazów wstawionych do dokumentu\r\nelementem <span class="zmienna">IMG</span>.\r\nJeśli elementy <span class="zmienna">IMG</span>\r\n\r\nnie są oddzielone białymi znakami:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="kot.jpg" alt="KOT"&gt;&lt;IMG src="pies.jpg" alt="PIES"&gt;</pre>\r\n\r\n<p>wówczas obrazy będą się stykały. Natomiast umieszczenie elementów\r\n<span class="zmienna">IMG</span> w osobnych liniach:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="kot.jpg"  alt="KOT"&gt;\r\n&lt;IMG src="pies.jpg" alt="PIES"&gt;</pre>\r\n\r\n<p>spowoduje, że pomiędzy obrazami pojawi się drobny odstęp.\r\nOczywiście istnieją sposoby osiągnięcia dokładnie zamierzonego\r\nrozkładu elementów, jednak przytoczony przykład\r\nwskazuje, że białe znaki mogą niekiedy wpływać na sposób\r\ngraficznego przedstawienia strony przez przeglądarkę.</p>\r\n\r\n<p>Jeśli chodzi o umieszczenie białych znaków wewnątrz tekstu,\r\nna przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">Kto\r\n      to\r\n               taki?\r\n    Kasztaniaki!</pre>\r\n\r\n<p>to ich rola sprowadza się do separacji wyrazów.\r\nIdentyczny efekt osiągniemy pisząc:</p>\r\n\r\n<pre class="syntax-highlight:xml">Kto to taki? Kasztaniaki!</pre>\r\n\r\n<p>Zarówno spacje, jak i znaki złamania wiersza zostaną potraktowane\r\njako pojedyncze separatory wyrazów.\r\nJeśli koniecznie zależy nam na umieszczeniu\r\nw tekście spacji lub znaku złamania wiersza, wówczas należy się\r\nposłużyć znakiem specjalnym  <span class="zmienna">&amp;nbsp;</span> (spacja)\r\noraz znacznikiem <span class="zmienna">&lt;BR&gt;</span> (złamanie wiersza).\r\nKod:</p>\r\n\r\n<pre class="syntax-highlight:xml">LIS&amp;nbsp;&amp;nbsp;&amp;nbsp;&amp;nbsp;ZAJĄC</pre>\r\n\r\n<p>spowoduje oddzielenie wyrazów &bdquo;LIS&rdquo; oraz &bdquo;ZAJĄC&rdquo; czterema spacjami.\r\nPonieważ spacja <span class="zmienna">&amp;nbsp;</span>\r\n\r\nto tzw. twarda spacja (ang. <em>non-breakable space</em>),\r\nzatem przeglądarka nie powinna złamać wiersza pomiędzy słowami\r\n&bdquo;LIS&rdquo; oraz\r\n&bdquo;ZAJĄC&rdquo;:</p>\r\n\r\n<pre class="syntax-highlight:xml">LIS&nbsp;&nbsp;&nbsp;&nbsp;ZAJĄC</pre>\r\n\r\n<h4 id="P3-6">3.6 Atrybuty znaczników</h4>\r\n\r\n<p>Przedstawiony przed chwilą element <span class="zmienna">IMG</span>\r\nprezentuje ostatnią nieomówioną cechę znaczników.\r\nOtóż znaczniki (niemal wszystkie) mogą posiadać atrybuty.\r\nPrzykładami atrybutów są napisy\r\n<span class="zmienna">src="pies.jpg"</span> oraz\r\n<span class="zmienna">alt="PIES"</span> w znaczniku:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="pies.jpg" alt="PIES"&gt;</pre>\r\n\r\n<p>Każdy z atrybutów ma swoją nazwę. W powyższym przykładzie atrybuty nazywają się\r\n<span class="zmienna">alt</span> oraz <span class="zmienna">src</span>.\r\nPo nazwie atrybutu następuje znak równości oraz wartość atrybutu.\r\nNależy zwrócić uwagę, by nie stawiać znaków spacji dookoła\r\nznaku równa się. Żaden z poniższych dwóch znaczników nie jest poprawny:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;H1 class  =  "proba"&gt;\r\n&lt;UL id  =  "nazwiska"&gt;</pre>\r\n\r\n<p>Nazwę atrybutu możemy pisać, podobnie jak nazwę znacznika, literami dowolnej\r\nwielkości:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;strong CLASS="zielona"&gt;\r\n&lt;sTrOnG claSS="zielona"&gt;</pre>\r\n\r\n<p>Wygodnie jest jednak przyjąć zasadę stosowaną w specyfikacji języka:\r\nnazwy znaczników piszemy dużymi literami, zaś nazwy atrybutów &mdash; małymi.</p>\r\n\r\n<p>Białe znaki oddzielające atrybuty, jak i kolejność atrybutów nie gra roli.\r\nOba poniższe znaczniki są równoważne:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="Zima.jpg" alt="Zdjęcie" id="zd1"&gt;\r\n&lt;IMG\r\n    alt="Zdjęcie"\r\n    id="zd1"\r\n    src="Zima.jpg"\r\n&gt;</pre>\r\n\r\n<p>Oczywiście każdy ze znaczników może przyjmować tylko określone atrybuty.\r\nPodobnie jak w przypadku zagnieżdżania znaczników najlepiej\r\nużycie każdego atrybutu poprzedzić sprawdzeniem.</p>\r\n\r\n<p>Dodatkowo, pewne atrybuty są konieczne.\r\nPrzykładem atrybutu\r\nkoniecznego jest atrybut <span class="zmienna">alt</span>\r\nelementu <span class="zmienna">IMG</span>.\r\nPominięcie go:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;IMG src="las.png"&gt;</pre>\r\n\r\n<p>powoduje, że znacznik jest niepoprawny.</p>\r\n\r\n<p>Wartości atrybutów powinny być otoczone znakami\r\n" (cudzysłów) lub '' (apostrof).\r\nPominięcie cudzysłowów oraz apostrofów jest dopuszczalne jedynie w przypadku, gdy\r\nwartość atrybutu składa się wyłącznie z\r\nliter, cyfr, myślników, kropek, znaków podkreślenia oraz dwukropków.\r\nJednakże i wówczas autorzy specyfikacji zalecają stosowanie\r\ncudzysłowów lub apostrofów.</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEZALECANY</strong>\r\n&lt;IMG src=kot.jpg alt=Fotografia5&gt;</pre>\r\n\r\n<p>Jeśli w wartości atrybutu chcemy zawrzeć cudzysłów, wówczas wartość otaczamy\r\nznakami apostrofu, jeśli wartość zawiera znak apostrofu, wówczas\r\nstosujemy cudzysłów. Ewentualnie możemy również znaki zacytować:\r\n<span class="zmienna">&amp;#34;</span> lub <span class="zmienna">&amp;quot;</span>\r\n\r\n(cudzysłów <span class="zmienna">"</span>) oraz\r\n<span class="zmienna">&amp;#39;</span> (apostrof <span class="zmienna">''</span>).</p>\r\n\r\n<p>Wartością części atrybutów może być nazwa pliku lub adres strony WWW.\r\nZatem wielkość liter ma znaczenie w części przypadków.</p>\r\n\r\n<p>Niektóre atrybuty posiadają wartości logiczne.\r\nObecność atrybutu określa daną cechę jako <span class="zmienna">TRUE</span>.\r\nBrak atrybutu oznacza wartość <span class="zmienna">FALSE</span>.</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;OPTION selected&gt;</pre>\r\n\r\n<p>Atrybuty takie nie mają znaku równości i wartości.\r\nWprawdzie specyfikacja określa jako poprawne również\r\natrybuty logiczne postaci</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEZALECANY</strong>\r\n&lt;OPTION selected="selected"&gt;</pre>\r\n\r\n<p>jednak ze względu na to,  że wiele przeglądarek może mieć z takim\r\nzapisem kłopot zalecana jest notacja skrócona.</p>\r\n\r\n<h4 id="P3-7">3.7 Komentarze w HTML</h4>\r\n\r\n<p>Analizę składni zakończymy\r\nomówieniem komentarzy stosowanych w języku HTML.\r\nKomentarze w języku HTML rozpoczynamy\r\nnapisem  <span class="zmienna">&lt;!--</span>, zaś kończymy\r\n<span class="zmienna">--&gt;</span></p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!--  komentarz  --&gt;</pre>\r\n\r\n<p>Komentarzy nie można zagnieżdżać.\r\nMożna natomiast umieszczać w nich znaczniki:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!--  &lt;strong&gt;CAT&lt;/strong&gt;  --&gt;\r\n&lt;!--  &lt;em&gt;  --&gt;\r\nDOG\r\n&lt;!--  &lt;/em&gt;  --&gt;</pre>\r\n\r\n<h3 id="R4">4. Struktura dokumentu HTML</h3>\r\n\r\n<p>Poprawny, pusty dokument w języku HTML został przedstawiony na listingu 1.\r\nSkłada się on z trzech części:</p>\r\n\r\n<ul>\r\n<li>definicji typu dokumentu (element <span class="zmienna">DOCTYPE</span>),</li>\r\n<li>nagłówka dokumentu (element <span class="zmienna">HEAD</span>),</li>\r\n<li>treści dokumentu (element <span class="zmienna">BODY</span>).</li>\r\n\r\n</ul>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01//EN&quot;\r\n          &quot;http://www.w3.org/TR/html4/strict.dtd&quot;&gt;\r\n&lt;HTML&gt;\r\n  &lt;HEAD&gt;\r\n    &lt;TITLE&gt;&lt;/TITLE&gt;\r\n    &lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;\r\n  &lt;/HEAD&gt;\r\n&lt;BODY&gt;\r\n\r\n&lt;/BODY&gt;\r\n&lt;/HTML&gt;</pre>\r\n<p class="podpis">\r\nListing 1.\r\nPusta, polska strona WWW w języku HTML 4.01 strict</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h4 id="P4-1">4.1 Wersje języka HTML: ścisła, przejściowa oraz dopuszczająca ramki</h4>\r\n\r\n<p>Element  <span class="zmienna">DOCTYPE</span>\r\nokreślający użyty dialekt języka HTML\r\njest obowiązkowy i nie może zostać pominięty.\r\nW języku HTML 4.01 dostępne są trzy dialekty:</p>\r\n\r\n<ul>\r\n<li>ścisły (ang. <em>strict</em>),</li>\r\n<li>przejściowy (ang. <em>transitional</em>),</li>\r\n<li>zawierający ramki (ang. <em>frameset</em>).</li>\r\n\r\n</ul>\r\n\r\n<p>W zależności od wybranego dialektu część znaczników\r\ni elementów może być niedostępna.\r\nNajwęższym dialektem jest wersja ścisła.\r\nElement <span class="zmienna">DOCTYPE</span>\r\nma wówczas postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01//EN"\r\n          "http://www.w3.org/TR/html4/strict.dtd"&gt;</pre>\r\n\r\n<p>Wersja ścisła dopuszcza tylko nieprzestarzałe elementy i nie dopuszcza ramek.</p>\r\n\r\n<p>Wersja przejściowa jest rozszerzeniem wersji ścisłej.\r\nDokumenty w wersji przejściowej rozpoczynają się\r\nnastępującym element <span class="zmienna">DOCTYPE</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"\r\n          "http://www.w3.org/TR/html4/loose.dtd"&gt;</pre>\r\n\r\n<p>i mogą zawierać wszystkie elementy dozwolone w wersji ścisłej\r\njak również elementy wycofane z języka\r\n(ang. <em>deprecated</em>).</p>\r\n\r\n<p>Ostatni możliwy typ dokumentu, to wersja z ramkami:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC "-//W3C//DTD HTML 4.01 Frameset//EN"\r\n          "http://www.w3.org/TR/html4/frameset.dtd"&gt;</pre>\r\n\r\n<p>Stosując wersję z ramkami możemy używać wszystkich elementów\r\ndopuszczonych w wersji przejściowej,\r\na także elementów definiujących ramki.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p><strong>Każdy</strong> dokument w języku\r\nHTML musi zawierać element <span class="zmienna">DOCTYPE</span>.\r\nBrak elementu <span class="zmienna">DOCTYPE</span>\r\npowoduje, że dokument nie jest poprawny!</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Dalsza część artykułu będzie poświęcona wyłącznie językowi HTML 4.01\r\nw wersji ścisłej.</p>\r\n\r\n<h4 id="P4-2">4.2 Nagłówek strony WWW</h4>\r\n\r\n<p>Drugim elementem strony WWW jest jej nagłówek.\r\nNagłówek znajduje się pomiędzy znacznikami\r\n<span class="zmienna">&lt;HEAD&gt;</span> oraz\r\n<span class="zmienna">&lt;/HEAD&gt;</span> i\r\nzawiera informacje charakteryzujące dany dokument.\r\nPrzykładami takich informacji są\r\nimię i nazwisko autora, język dokumentu\r\nczy jego tytuł.\r\nDecyzja o tym, jakie informacje ogólne o dokumencie umieścić\r\nw nagłówku należy do autora strony.\r\nKonieczne jest jedynie umieszczenie tytułu\r\ndokumentu oraz informacji na temat stosowanego kodowania znaków.</p>\r\n\r\n<p>Tytuł dokumentu określamy znacznikami <span class="zmienna">&lt;TITLE&gt;</span>\r\noraz <span class="zmienna">&lt;/TITLE&gt;</span>.\r\nPamiętajmy, że jest to element niezmiernie istotny z punktu widzenia klasyfikacji\r\nnaszego dokumentu przez wyszukiwarki internetowe.\r\nJedna z tak zwanych &bdquo;podpowiedzi dnia&rdquo;\r\n(ang. <em>Tip of The Day</em>) dostępnych na stronach\r\nkonsorcjum W3C mówi:\r\n<em>"<span class="zmienna">TITLE</span> &mdash; najważniejszy element dobrej witryny WWW"</em>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Element <span class="zmienna">TITLE</span> jest\r\nbardzo ważny i nie może zostać pominięty!\r\nTytuły nadawane stronom WWW powinny być\r\njasne i zwięzłe.\r\nWarto pamiętać, że element <span class="zmienna">TITLE</span>\r\nodgrywa niezmiernie ważną rolę w pozycjonowaniu naszych\r\nstron w wyszukiwarkach.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Jeśli chodzi o polskie znaki, to pewne zamieszanie powoduje fakt, że istnieją\r\ndwa sposoby kodowania. Pierwszy z nich, to sposób propagowany\r\nprzez firmę Microsoft,\r\nzaś drugi, to międzynarodowy standard zatwierdzony przez organizację ISO.\r\nFormaty te są identyfikowane jako\r\n<span class="zmienna">windows-1250</span>\r\noraz <span class="zmienna">iso-8859-2</span>.</p>\r\n\r\n<p>W formacie <span class="zmienna">windows-1250</span>\r\nlitera Ą ma kod dziesiętny 165. Kodem tej samej litery\r\nĄ w standardzie <span class="zmienna">iso-8859-2</span>\r\n\r\njest natomiast liczba 161.\r\n(Kody wszystkich polskich znaków\r\nw obydwu standardach są przedstawione w dokumencie\r\n<span class="plik">polskieznaki.html</span>.)</p>\r\n\r\n<p>Sposób zakodowania polskich liter w pliku\r\ntekstowym jest cechą danego pliku.\r\nPlik albo zawiera kodowanie <span class="zmienna">iso-8859-2</span>\r\nalbo <span class="zmienna">windows-1250</span>\r\n(oczywiście może się zdarzyć frapujący przypadek\r\nzastosowania obu kodów na raz; sytuacja taka może się pojawić\r\npo niepoprawnej konwersji kodów i należy ją traktować jako błędną).\r\nZ poziomu języka HTML nie możemy dokonać konwersji.\r\nŻaden ze znaczników HTML <strong>nie modyfikuje</strong> strony\r\nodczytanej z pliku.\r\nTak jak nie ma znaczników, które powodują zamianę liter małych na duże,\r\ntak nie ma znaczników zmieniających kodowanie polskich znaków\r\n(konwersja liter dużych na małe dotyczy prezentacji\r\ndokumentu i jest osiągalna przy użyciu stylów).</p>\r\n\r\n<p>Zatem przygotowując stronę WWW musimy wiedzieć, jakie kodowanie polskich\r\nznaków stosuje dany edytor. Na przykład oprogramowanie Windows\r\nstosuje kodowanie <span class="zmienna">windows-1250</span>\r\n(Oczywiście każda aplikacja może mieć opcję: <span class="opcja">Zapisz w formacie ...</span>,\r\nktóra dokonuje konwersji. Jednak wykonanie polecenia\r\n<span class="opcja">Plik &rarr; Zapisz</span>\r\nw większości\r\naplikacji Windows utworzy plik w kodzie <span class="zmienna">windows-1250</span>).\r\nOznacza to tyle, że tworząc stronę WWW programem\r\nnotatnik otrzymujemy dokument z kodami <span class="zmienna">windows-1250</span>.</p>\r\n\r\n<p>Element <span class="zmienna">META</span> języka HTML służy\r\nmiedzy innymi do ustalenia kodowania znaków w dokumencie.\r\nPamiętajmy jednak, by w dokumencie umieszczać\r\ninformacje o kodowaniu\r\n<strong>zgodną z fizycznym zapisem</strong> pliku.\r\nJeżeli plik zawiera polską literę Ą zakodowaną kodem 165 (kod <span class="zmienna">windows-1250</span>)\r\nto należy umieścić element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv="Content-Type" content="text/html; charset=windows-1250"&gt;</pre>\r\n\r\n<p>Jeśli natomiast kodem litery Ą jest liczba 161\r\n(kod <span class="zmienna">iso-8859-2</span>), to należy użyć\r\nelementu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv="Content-Type" content="text/html; charset=iso-8859-2"&gt;</pre>\r\n\r\n<p>W środowisku internautów przeważa opinia, że należy stosować kodowanie\r\nw formacie ISO.</p>\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Dokument HTML przygotowany standardowym notatnikiem\r\nWindows zawiera polskie znaki w formacie\r\n<span class="zmienna">windows-1250</span>.\r\nW dokumencie takim należy umieścić element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv="Content-Type" content="text/html; charset=windows-1250"&gt;</pre>\r\n\r\n<p>Zmiana znacznika kodowania <span class="zmienna">META</span>\r\n\r\nz <span class="zmienna">windows-1250</span>\r\nna <span class="zmienna">iso-8859-2</span> nie wystarczy.\r\nNależy jeszcze dokument poddać konwersji znaków.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<h4 id="P4-3">4.3 Treść dokumentu</h4>\r\n\r\n<p>Treść dokumentu jest zawarta wewnątrz elementu <span class="zmienna">BODY</span>,\r\nczyli pomiędzy znacznikami <span class="zmienna">&lt;BODY&gt;</span>\r\noraz <span class="zmienna">&lt;/BODY&gt;</span>.\r\nWarto zapamiętać, że wewnątrz elementu <span class="zmienna">BODY</span>\r\nnie możemy umieszczać tekstu:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;BODY&gt;\r\n  Witam na mojej stronie!\r\n&lt;/BODY&gt;</pre>\r\n\r\n<p>a jedynie inne elementy HTML:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;BODY&gt;\r\n  &lt;P&gt;\r\n    Witam na mojej stronie!\r\n  &lt;/P&gt;\r\n&lt;/BODY&gt;</pre>\r\n\r\n\r\n<h3 id="R5">5. Podsumowanie</h3>\r\n\r\n<p>Osobom rozpoczynającym naukę\r\njęzyka HTML może się wydawać, że\r\nskładnia języka HTML jest zawiła i\r\nniejednoznaczna. Tak nie jest.\r\nMyślę, że samodzielne przygotowanie kilku\r\ndokumentów wystarczy do opanowania\r\nHTML w dostatecznym stopniu.</p>\r\n\r\n<p>Rzeczą, która najbardziej przeraża dużą część\r\nosób, szczególnie tych, które się zetknęły z\r\nedytorami WYSIWYG w rodzaju FrontPage, jest ręczne wklepywanie znaczników.\r\nAle i na to znajdzie się rada.</p>\r\n\r\n<p>Dodajmy jeszcze na zachęte, że nauka HTML jest konieczna jeśli myślimy\r\no tym, by w przyszłości tworzyć strony WWW w języku PHP.</p>', 'skladnia-jezyka-html');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(2, 'HTML - aplikacja języka SGML', 'Składnia języka HTML jest formalnie opisana w języku SGML.\r\nSpecyfikacja, nazywana w skrócie DTD,\r\nprecyzuje nie tylko dostępne znaczniki i elementy oraz\r\nzasady dotyczące ich zamykania, ale także \r\ndopuszczalne atrybuty i poprawne wartości atrybutów, jak również\r\nokreśla dokładnie zawartość każdego elementu HTML.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Język SGML</a></li>\r\n<li><a href="#R2">2. ENTITY, ELEMENT, ATTLIST - jednostki leksykalne definicji DTD</a>\r\n    <ol>\r\n        <li><a href="#P2-1">2.1 Makrodefinicje ENTITY</a></li>\r\n        <li><a href="#P2-2">2.2 Deklaracje ELEMENT</a></li>\r\n        <li><a href="#P2-3">2.3 Deklaracje ATTLIST</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R3">3. Typy danych użyte w DTD</a></li>\r\n<li><a href="#R4">4. Grupy atrybutów: %coreattrs;, %i18n;, %events; oraz %attrs;</a></li>\r\n<li><a href="#R5">5. Elementy tekstowe, elementy blokowe</a></li>\r\n<li><a href="#R6">6. Elementy określające strukturę strony</a></li>\r\n<li><a href="#R7">7. Walidacja dokumentu HTML</a></li>\r\n<li><a href="#R8">8. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Język SGML</h3>\r\n\r\n<p>Języki znacznikowe, m.in. HTML, XHTML i WML,\r\nsą formalnie opisywane w języku SGML\r\n(ang. <span class="ang">Standard Generalized Markup Language</span>).\r\nTaki szczegółowy opis, określany mianem <em>DTD</em>\r\n(ang. <span class="ang">Document Type Definition</span>),\r\ndefiniuje wszystkie dostępne znaczniki\r\nelementy, atrybuty, dopuszczalne wartości atrybutów\r\noraz precyzuje sposób zagnieżdżania elementów.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Składnia języka HTML jest opisana w dokumencie DTD.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Mówimy, że <em>HTML jest aplikacją języka SGML</em>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Język HTML jest aplikacją języka SGML.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>W skład definicji języka HTML 4.01 wchodzą trzy dialekty:\r\nstrict, transitional oraz frameset.\r\nRóżnią się one między sobą kilkoma znacznikami oraz atrybutami.\r\nKażdy z dialektów\r\nposiada swoją definicję DTD.\r\nDalsza część artykułu będzie poświęcona wyłącznie wersji strict\r\njęzyka HTML.</p>\r\n\r\n<h3 id="R2">2. ENTITY, ELEMENT, ATTLIST - jednostki leksykalne definicji DTD</h3>\r\n\r\n<p>W opisie DTD języka HTML występują cztery rodzaje zapisów:\r\nkomentarze, <span class="zmienna">ENTITY</span>,\r\n\r\n<span class="zmienna">ELEMENT</span> oraz\r\n<span class="zmienna">ATTLIST</span>.\r\nZapisy <span class="zmienna">ELEMENT</span>\r\noraz <span class="zmienna">ATTLIST</span> będziemy nazywali <em>deklaracjami</em>,\r\nzaś <span class="zmienna">ENTITY</span> - <em>makrodefinicjami</em>.</p>\r\n\r\n<p>Rola komentarzy jest oczywista. Ułatwiają one analizę\r\nspecyfikacji. Komentarze są oznaczane w specyfikacji, podobnie jak\r\nw samym HTML, za pomocą napisów <span class="zmienna">&lt;!--</span>\r\noraz <span class="zmienna">--&gt;</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Komentarze w języku HTML są ograniczone\r\nznacznikami <span class="zmienna">&lt;!--</span>\r\n\r\noraz <span class="zmienna">--&gt;</span>.\r\nPomiędzy napisami <span class="zmienna">&lt;!</span> oraz\r\n<span class="zmienna">--</span> nie mogą pojawić się białe znaki.\r\nOtwarcie komentarza HTML realizują jedynie cztery następujące po sobie znaki\r\n<span class="zmienna">&lt;!--</span>.\r\nNatomiast zamknięcie komentarza HTML\r\nmoże zawierać białe znaki pomiędzy napisami\r\n<span class="zmienna">--</span> oraz <span class="zmienna">&gt;</span>.\r\nOto przykłady poprawnych komentarzy w HTML</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!--  komentarz\r\n      pierwszy   --&gt;\r\n\r\n&lt;!--\r\n      komentarz\r\n      drugi --\r\n\r\n&gt;</pre>\r\n\r\n\r\n<p>Należy zatem pamiętać, by nie umieszczać wewnątrz komentarzy HTML\r\ndwóch znaków <span class="zmienna">--</span>.</p>\r\n\r\n<p>Komentarze wewnątrz DTD, oznaczane podwójnymi minusami, mają postać</p>\r\n\r\n<pre class="syntax-highlight:xml">-- komentarz --</pre>\r\n\r\n\r\n<p>Dopuszczalne są białe znaki pomiędzy napisami\r\n<span class="zmienna">&lt;!</span> oraz <span class="zmienna">&gt;</span>,\r\na podwójnym minusem</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!\r\n     -- poprawny komentarz DTD --\r\n     --\r\n       drugi\r\n       poprawny\r\n       komentarz DTD\r\n     --\r\n&gt;</pre>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Deklaracja <span class="zmienna">ELEMENT</span>\r\ndefiniuje powinien konkretny element (lub grupę elementów)\r\njęzyka HTML (np. <span class="zmienna">IMG</span> lub <span class="zmienna">H1, H2, ..., H6</span>).\r\nDeklaracja <span class="zmienna">ATTLIST</span> definiuje dopuszczalne atrybuty\r\nelementu lub elementów.\r\nNatomiast deklaracja <span class="zmienna">ENTITY</span> jest makrodefinicją,\r\nktóra skraca całą specyfikację i czynią ją bardziej czytelną.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Formalny opis języka HTML 4.01,\r\nskłada się wyłącznie z\r\n\r\nmakrodefinicji\r\n<span class="zmienna">ENTITY</span>\r\n\r\noraz\r\ndeklaracji\r\n<span class="zmienna">ELEMENT</span> i\r\n<span class="zmienna">ATTLIST</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<h4 id="P2-1">2.1 Makrodefinicje ENTITY</h4>\r\n\r\n<p>Przyjrzyjmy się przykładowi:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % heading "H1|H2|H3|H4|H5|H6"  -- nagłówki --&gt;</pre>\r\n\r\n<p>Jest to makrodefinicja ustalającą\r\nznaczenie napisu <span class="zmienna">%heading;</span>.\r\nRozpoczyna się ona od <span class="zmienna">&lt;!ENTITY %</span>,\r\nzaś kończy <span class="zmienna">&gt;</span>.\r\nWewnątrz występuje nazwa makrodefinicji\r\n<span class="zmienna">heading</span>,\r\nujęty w cudzysłów napis\r\n<span class="zmienna">"H1|H2|H3|H4|H5|H6"</span>\r\nbędący wartością\r\noraz komentarz <span class="zmienna">-- nagłówki --</span>.</p>\r\n\r\n<p>Każde wystąpienie napisu <span class="zmienna">%heading;</span>\r\nzostanie zastąpione napisem <span class="zmienna">H1|H2|H3|H4|H5|H6</span>.\r\nWywołanie makrodefinicji ma postać: <span class="zmienna">%heading;</span>.\r\nSkłada się ono ze znaku procentu,\r\nnazwy makrodefinicji oraz opcjonalnego średnika.</p>\r\n\r\n<p>Cel wprowadzenia makrodefinicji <span class="zmienna">ENTITY</span> stanie się jasny,\r\nprzy omawianiu konkretnych znaczników. Najczęściej stosowanymi makrami będą\r\ndefinicje dzielące elementy HTML na dwie grupy: elementy tekstowe -\r\n<span class="zmienna">%inline;</span>, oraz elementy blokowe -\r\n\r\n<span class="zmienna">%block;</span>,\r\njak również trzy główne grupy atrybutów\r\n<span class="zmienna">%coreattrs;</span>,\r\n<span class="zmienna">%i18n;</span> i\r\n<span class="zmienna">%events;</span>.\r\nDodatkowo makrodefinicja <span class="zmienna">%flow;</span>\r\nłącząca elementy blokowe i tekstowe, zaś\r\n<span class="zmienna">%attrs;</span>\r\nzwiera wszystkie atrybuty zdefiniowane w trzech grupach\r\n<span class="zmienna">%coreattrs;</span>,\r\n\r\n<span class="zmienna">%i18n;</span> i\r\n<span class="zmienna">%events;</span>.\r\nKażda z deklaracji definiująca\r\nkonkretne elementy będzie się odwoływała przynajmniej do\r\nczęści z powyższych siedmiu makrodefinicji.</p>\r\n\r\n<p>Uwaga, makrodefinicje nie mogą występować w HTML a jedynie w DTD.\r\nPewnym rodzajem makr są znaki specjalne (ang. <span class="ang">character references</span>), np.\r\n<span class="zmienna">&amp;lt;</span> czy\r\n<span class="zmienna">&amp;nbsp;</span>.\r\nOne mogą występować w tekście wewnątrz HTML oraz w wartościach atrybutów.</p>\r\n\r\n<p>Dodajmy, że makrodefinicja może wykorzystywać inne,\r\njuż zdefiniowane makrodefinicje, np.:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % list "UL | OL"&gt;\r\n\r\n&lt;!ENTITY % preformatted "PRE"&gt;\r\n\r\n&lt;!ENTITY % block\r\n     "P | %heading; | %list; | %preformatted; | DL | DIV | NOSCRIPT |\r\n      BLOCKQUOTE | FORM | HR | TABLE | FIELDSET | ADDRESS"&gt;</pre>\r\n\r\n<p>W podanym przykładzie definiujemy makro <span class="zmienna">%block;</span>.\r\nW opisie wartości stosujemy zdefiniowaną wcześniej makrodefinicję\r\n<span class="zmienna">%heading;</span> oraz dwie makrodefinicje podane\r\npowyżej: <span class="zmienna">%list;</span>\r\ni <span class="zmienna">%preformatted;</span>.</p>\r\n\r\n<h4 id="P2-2">2.2 Deklaracje ELEMENT</h4>\r\n\r\n<p>Deklaracja <span class="zmienna">ELEMENT</span> ma postać</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT BR - O EMPTY -- forced line break --&gt;</pre>\r\n\r\n<p>Określa ona składnię elementu języka HTML.\r\nDeklaracja zawiera trzy ważne informacje.\r\nPo pierwsze nazwę definiowanego elementu. W przykładzie jest nią <span class="zmienna">BR</span>.\r\nPo drugie ustala czy znaczniki otwierający i zamykający są dopuszczalne,\r\nwymagane czy opcjonalne. W przykładzie jest to napis  <span class="zmienna">- O</span>.\r\nPo trzecie określa poprawną zawartość elementu\r\n(ang. <span class="ang">content model definition</span>).\r\nW przykładzie: <span class="zmienna">EMPTY</span>.\r\nNapis <span class="zmienna">-- forced line break --</span>\r\n\r\njest oczywiście komentarzem.</p>\r\n\r\n<p>Powyższy przykład ustala składnię elementu <span class="zmienna">BR</span>.\r\nNapis <span class="zmienna">- O</span> określa, że znacznik otwierający jest wymagany,\r\nzaś znacznik zamykający - opcjonalny. Pierwszy znak określa znacznik otwierający,\r\na drugi - znacznik zamykający. W specyfikacji stosowane są dwa znaki:\r\n<span class="zmienna">-</span> oraz\r\n<span class="zmienna">O</span>. Znak minus oznacza,\r\nże znacznik jest wymagany, zaś litera\r\n<span class="zmienna">O</span> - że znacznik jest opcjonalny.</p>\r\n\r\n<p>Element <span class="zmienna">BR</span>\r\nnie posiada żadnej zawartości (napis <span class="zmienna">EMPTY</span>).\r\nJest to tak zwany element pusty.\r\nW przypadku elementów pustych znacznik zamykający jest zabroniony.</p>\r\n\r\n<p>Rozważmy drugi przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT (%heading;)  - - (%inline;)* -- nagłówek --&gt;</pre>\r\n\r\n<p>Jest to deklaracja nagłówków <span class="zmienna">H1</span>, ...,\r\n<span class="zmienna">H6</span>.\r\nPodana wcześniej makrodefinicja  <span class="zmienna">%heading;</span>\r\nzostanie rozwinięta do <span class="zmienna">"H1|H2|H3|H4|H5|H6"</span>.\r\nZatem definiowanymi elementami są <span class="zmienna">H1</span>, ...,\r\n<span class="zmienna">H6</span>.\r\nZnak <span class="zmienna">|</span>\r\n\r\nużyty w makrodefinicji jest znakiem alternatywy, zaś nawiasy okrągłe otaczające\r\nmakro <span class="zmienna">(%heading;)</span> są użyte do grupowania.\r\nInnymi słowy deklaracja określa każdy z elementów\r\n<span class="zmienna">H1</span>, ..., <span class="zmienna">H6</span> z osobna\r\n(można ją interpretować identycznie jak sześć niezależnych deklaracji\r\npostaci <span class="zmienna">&lt;!ELEMENT H1 .... &gt;</span>,\r\n<span class="zmienna">&lt;!ELEMENT H2 .... &gt;</span>,  itd.)</p>\r\n\r\n<p>Jeśli chodzi o znaczniki otwierający i zamykający każdego elementu\r\n\r\n<span class="zmienna">H1</span>, ...,\r\n<span class="zmienna">H6</span> to są one wymagane.\r\nDecyduje o tym napis <span class="zmienna">- -</span>.</p>\r\n\r\n<p>Poprawna zawartość natomiast jest określona napisem <span class="zmienna">(%inline;)*</span>.\r\nMakrodefinicja <span class="zmienna">%inline;</span>\r\nzostanie omówiona w kolejnych punktach, teraz zajmijmy się znaczeniem\r\nnapisu <span class="zmienna">(...)*</span>.\r\nNawiasy okrągłe grupują elementy, zaś gwiazdka określa, że elementy\r\nzawarte w nawiasach mogą wystąpić dowolna liczbę razy.\r\nTabela 1 zawiera zestawienie stosowanych operatorów ustalających liczbę powtórzeń.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Zapis</th><th>Znaczenie</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Zapis</th><th>Znaczenie</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">(...)</span></td>\r\n\r\n<td>Grupowanie</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A</span></td>\r\n\r\n<td>może wystąpić dokładnie jeden raz</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A+</span></td>\r\n\r\n<td>może wystąpić jeden lub więcej razy</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A?</span></td>\r\n\r\n<td>może wystąpić jeden raz lub nie wystąpić wcale</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A*</span></td>\r\n\r\n<td>może wystąpić zero lub więcej razy</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">+(A)</span></td>\r\n\r\n<td>może wystąpić</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">-(A)</span></td>\r\n\r\n<td>nie może wystąpić</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A | B</span></td>\r\n\r\n<td>musi wystąpić dokładnie jeden element: A lub B (nie oba, nie żaden, a dokładnie jeden z nich)</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A , B</span></td>\r\n\r\n<td>muszą wystąpić oba elementy A i B w dokładnie takiej kolejności</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">A &amp; B</span></td>\r\n\r\n<td>muszą wystąpić oba elementy A i B w dowolnej kolejności</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nSkładnia opisu zawartości elementów</p>\r\n</div>\r\n\r\n\r\n<p>Zatem napis <span class="zmienna">(%inline;)*</span> mówi, że poprawną zawartością elementów\r\n<span class="zmienna">H1</span>, ...,\r\n<span class="zmienna">H6</span>\r\njest dowolna liczba, tj. zero, jeden lub więcej, napisów określonych makrodefinicją\r\n<span class="zmienna">%inline;</span>.</p>\r\n\r\n<p>Kolejny przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT UL - - (LI)+ -- unordered list --&gt;</pre>\r\n\r\n<p>jest deklaracją elementu <span class="zmienna">UL</span>.\r\nZnacznik otwierający i zamykający są obowiązkowe\r\n(mówią o tym dwa znaki <span class="zmienna">- -</span>),\r\nzaś poprawną zawartością jest jeden lub więcej elementów <span class="zmienna">LI</span>\r\n(mówi o tym napis <span class="zmienna">(LI)+</span>).</p>\r\n\r\n<p>Wreszcie przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT A - - (%inline;)* -(A) -- anchor --&gt;</pre>\r\n\r\n<p>pokazuje wykluczanie części elementów z zawartości.\r\nDeklaracja ta mówi, że element <span class="zmienna">A</span>\r\nposiada dwa wymagane znaczniki, otwierający i zamykający.\r\nPoprawna zawartość jest zdefiniowana jako\r\n<span class="zmienna">(%inline;)* -(A)</span>. Zatem może zawierać dowolna liczbę\r\nelementów typu <span class="zmienna">%inline;</span>,\r\nnatomiast nie może zawierać\r\nelementu <span class="zmienna">A</span> (element <span class="zmienna">A</span>\r\n\r\njest zawarty w zbiorze elementów <span class="zmienna">%inline;</span>).\r\nJawne wykluczenie ma większą wagę od dołączania.</p>\r\n\r\n<h4 id="P2-3">2.3 Deklaracje ATTLIST</h4>\r\n\r\n<p>Ostatni rodzaj deklaracji, <span class="zmienna">ATTLIST</span>,\r\nwygląda następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ATTLIST BR %coreattrs; -- atrybuty znacznika złamania wiersza --&gt;</pre>\r\n\r\n<p>Definicja <span class="zmienna">ATTLIST</span> ustala zbiór\r\ndopuszczalnych atrybutów elementu.</p>\r\n\r\n<p>Deklaracja rozpoczyna się od napisu <span class="zmienna">&lt;!ATTLIST</span>,\r\na kończy  <span class="zmienna">&gt;</span>.\r\nWewnątrz, po napisie <span class="zmienna">ATTLIST</span>\r\nwystępuje nazwa elementu <span class="zmienna">BR</span>\r\n\r\n(zamiast nazwy jednego elementu może pojawić się makrodefinicja).\r\nPodany przykład ustala dopuszczalne atrybuty elementu <span class="zmienna">BR</span>.\r\nW deklaracji tej, po nazwie elementu występują atrybuty.\r\nW przykładzie użyto makrodefinicji <span class="zmienna">%coreattrs;</span>.\r\nNapis <span class="zmienna">atrybuty znacznika złamania wiersza</span>\r\npojawia się po dwóch minusach,\r\nwięc jest komentarzem.</p>\r\n\r\n<p>Stwierdzenie, jakie konkretnie atrybuty są dopuszczalne\r\ndla elementu <span class="zmienna">BR</span>\r\nwymaga sprawdzenia makrodefinicji <span class="zmienna">%coreattrs;</span>.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Jednostka leksykalna SGML</th><th>Znaczenie</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Jednostka leksykalna SGML</th><th>Znaczenie</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">ENTITY</span></td>\r\n\r\n<td>Makrodefinicje skracające specyfikację i ułatwiające jej analizę.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">ELEMENT</span></td>\r\n\r\n<td>Deklaracja elementu HTML. Ustalenie konieczności/dopuszczalności/opcjonalności stosowania znaczników otwierającego i zamykającego. Ustalenie poprawnej zawartości elementu.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">ATTLIST</span></td>\r\n\r\n<td>Deklaracja atrybutów elementu HTML.</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 2.\r\nJednostki leksykalne SGML użyte w DTD</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R3">3. Typy danych użyte w DTD</h3>\r\n\r\n<p>Składnia HTML wyrażona w języku SGML\r\nzawiera kilka rodzajów danych.\r\nWartość atrybutu <span class="zmienna">href</span>\r\nznacznika <span class="zmienna">&lt;A href="..."&gt;</span> jest innego typu niż na przykład\r\nwartość atrybutu <span class="zmienna">class</span>  znacznika\r\n<span class="zmienna">&lt;H1 class="..."&gt;</span>.\r\nW celu odróżnienia wartości atrybutów wprowadzono\r\ntypy danych oraz pewne makrodefinicje.</p>\r\n\r\n<p>Dokument DTD stosuje następujące rodzaje danych:</p>\r\n\r\n<ul>\r\n<li>\r\n<span class="zmienna">CDATA</span> - ciąg znaków, nie zawierający\r\nkodu HTML (dozwolone jest stosowanie znaków specjalnych);\r\n</li>\r\n<li>\r\n<span class="zmienna">ID</span> oraz <span class="zmienna">NAME</span>\r\nto napisy, które rozpoczynają się od dużej lub małej litery łacińskiej\r\n(w notacji wyrażeń regularnych: <span class="zmienna">[a-zA-Z]</span>),\r\npo której następuje dowolna liczba cyfr, liter, myślników, podkreśleń,\r\ndwukropków i kropek;\r\n\r\n</li>\r\n<li><span class="zmienna">NUMBER</span> - niepusty ciąg cyfr;</li>\r\n<li><span class="zmienna">IDREF</span> i <span class="zmienna">IDREFS</span>\r\n- odwołania do identyfikatorów <span class="zmienna">ID</span> zdefiniowanych w dokumencie.\r\n</li>\r\n</ul>\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Dane typu <span class="zmienna">CDATA</span>\r\noraz\r\n<span class="zmienna">#PCDATA</span>\r\nto teksty nie zawierające kodu HTML.</p>\r\n\r\n<p><span class="zmienna">CDATA</span> to tekst stosowany wewnątrz dokumentu DTD,\r\nzaś <span class="zmienna">#PCDATA</span> to tekst, jaki występuje w\r\ndokumencie HTML.</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">...\r\n&lt;TITLE&gt;&amp;quot;Witaj!&amp;quot;&lt;/TITLE&gt;\r\n...\r\n&lt;BODY&gt;\r\n  &lt;H1&gt;Cześć!&lt;/H1&gt;\r\n\r\n\r\n  &lt;P class="wprowadzenie"&gt;\r\n  ...\r\n  treść strony\r\n  ...\r\n  Zajrzyj &lt;A href="adres.html"&gt;tutaj&lt;/A&gt;.\r\n  ...\r\n  &lt;/P&gt;\r\n&lt;/BODY&gt;</pre>\r\n\r\n<p>W przedstawionym przykładzie danymi typu <span class="zmienna">#PCDATA</span> są napisy:</p>\r\n\r\n<ul>\r\n\r\n<li>\r\n<span class="zmienna">&amp;quot;Witaj!&amp;quot;</span>\r\n- zawartość elementu <span class="zmienna">TITLE</span>;\r\n</li>\r\n\r\n<li>\r\n<span class="zmienna">Cześć!</span>\r\n- zawartość elementu <span class="zmienna">H1</span>;\r\n\r\n</li>\r\n\r\n\r\n<li>\r\n<span class="zmienna">wprowadzenie</span>\r\n- wartość atrybutu <span class="zmienna">class</span>;\r\n</li>\r\n\r\n<li>\r\n<span class="zmienna">treść strony</span>\r\n- zawartość elementu <span class="zmienna">P</span>;\r\n\r\n</li>\r\n\r\n<li>\r\n<span class="zmienna">Zajrzyj:</span>\r\n- zawartość elementu <span class="zmienna">P</span>;\r\n</li>\r\n\r\n<li>\r\n<span class="zmienna">adres.html</span>\r\n- wartość atrybutu <span class="zmienna">href</span>;\r\n</li>\r\n\r\n<li>\r\n<span class="zmienna">tutaj</span>\r\n- zawartość elementu <span class="zmienna">A</span>.\r\n</li>\r\n\r\n</ul>\r\n\r\n\r\n<p>Jedynymi elementami, które mogą zawierać dane <span class="zmienna">#PCDATA</span> są: elementy\r\ntekstowe (patrz tabele 4 i 6),\r\n<span class="zmienna">TITLE</span>,\r\n\r\n<span class="zmienna">OPTION</span>,\r\n<span class="zmienna">TEXTAREA</span>\r\noraz\r\n<span class="zmienna">FIELDSET</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Opisy wartości atrybutów oraz zawartości elementów\r\nbędą stosowały dane typu\r\n<span class="zmienna">CDATA</span>,\r\n\r\n<span class="zmienna">ID</span>,\r\n<span class="zmienna">NAME</span>,\r\n<span class="zmienna">NUMBER</span>,\r\n<span class="zmienna">IDREF</span> oraz\r\n<span class="zmienna">IDREFS</span>.</p>\r\n\r\n<p>Na bazie typu <span class="zmienna">CDATA</span> określone są makrodefinicje\r\n\r\n<span class="zmienna">%StyleSheet;</span> oraz\r\n<span class="zmienna">%URI;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % StyleSheet "CDATA" -- style sheet data --&gt;\r\n\r\n&lt;!ENTITY % URI "CDATA"\r\n    -- a Uniform Resource Identifier,\r\n       see [URI]\r\n    --&gt;</pre>\r\n\r\n<p>Zarówno <span class="zmienna">%StyleSheet;</span> jak i <span class="zmienna">%URI;</span>\r\n\r\nzostaną rozwinięte do <span class="zmienna">CDATA</span>.</p>\r\n\r\n<p>Specyfikacja języka HTML nie nakłada żadnych ograniczeń na to, czym jest\r\npoprawny styl lub adres URI. Jedyne, co jest powiedziane w specyfikacji to to, że\r\nsą to teksty nie zawierające kodu HTML. W razie potrzeby dozwolone\r\njest użycie znaków specjalnych.\r\n(W istocie,\r\nw przypadku skryptów i stylów\r\nsprawa jest nieco bardziej skomplikowana.\r\nOtóż skrypt i styl mogą zawierać znaczniki i znaki specjalne, a mimo to nie podlegają\r\ninterpretacji. Zostają przekazane w niezmienionej postaci do\r\nodpowiedniego modułu odpowiedzialnego za interpretacje skryptu bądź stylu.\r\nPierwsze wystąpienie sekwencji znaków <span class="zmienna">&lt;/</span>\r\nstanowi znak końca skryptu lub stylu.)</p>\r\n\r\n<p>W identyczny sposób zdefiniowano makrodefinicje:\r\n<span class="zmienna">%ContentType;</span>,\r\n<span class="zmienna">%ContentTypes;</span>,\r\n\r\n<span class="zmienna">%Charset;</span>,\r\n<span class="zmienna">%Charsets;</span>,\r\n<span class="zmienna">%LinkTypes;</span>,\r\n<span class="zmienna">%MediaDesc;</span>,\r\n<span class="zmienna">%Datetime;</span>,\r\n<span class="zmienna">%Script;</span> oraz\r\n<span class="zmienna">%Text</span>.</p>\r\n\r\n<p>Zapamiętajmy zatem, że powyższe makra, w pewnym uproszczeniu,\r\nstanowią po prostu tekst nie zawierający kodu HTML.</p>\r\n\r\n<h3 id="R4">4. Grupy atrybutów: %coreattrs;, %i18n;, %events; oraz %attrs;</h3>\r\n\r\n<p>W specyfikacji, niemal na każdym kroku występują cztery grupy atrybutów\r\n<span class="zmienna">%coreattrs;</span>,\r\n<span class="zmienna">%i18n;</span>,\r\n<span class="zmienna">%events;</span> oraz\r\n<span class="zmienna">%attrs;</span>.\r\nPrzyjrzyjmy się makrodefinicjom, które definiują podane grupy.</p>\r\n\r\n<p>Makrodefinicja <span class="zmienna">%coreattrs;</span> jest następująca:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % coreattrs\r\n "id          ID             #IMPLIED  -- document-wide unique id --\r\n  class       CDATA          #IMPLIED  -- space-separated list of classes --\r\n  style       %StyleSheet;   #IMPLIED  -- associated style info --\r\n  title       %Text;         #IMPLIED  -- advisory title --"\r\n&gt;</pre>\r\n\r\n<p>Wynika z niej, że <span class="zmienna">%coreattrs;</span>\r\n\r\nto następujące atrybuty:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">id</span> o poprawnej zawartości <span class="zmienna">ID</span>,</li>\r\n<li><span class="zmienna">class</span> o poprawnej zawartości <span class="zmienna">CDATA</span>,</li>\r\n<li><span class="zmienna">style</span> o poprawnej zawartości <span class="zmienna">%StyleSheet;</span>,</li>\r\n\r\n<li><span class="zmienna">title</span> o poprawnej zawartości <span class="zmienna">%Text;</span>.</li>\r\n</ul>\r\n\r\n<p>Teksty ograniczone znakami <span class="zmienna">--</span>\r\nto oczywiście komentarze, zaś\r\nnapis <span class="zmienna">#IMPLIED</span> oznacza, że jeżeli zadany atrybut nie\r\nzostał określony wewnątrz dokumentu HTML,\r\nto ustaleniem jego wartości zajmuje się przeglądarka WWW.\r\nInnymi napisami, które mogą się pojawić w miejscu\r\n<span class="zmienna">#IMPLIED</span> są:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">REQUIRED</span> - atrybut wymagany,</li>\r\n<li><span class="zmienna">FIXED</span> - wartość atrybutu jest ustalona na stałe.</li>\r\n</ul>\r\n\r\n<p>Cała wartość makra <span class="zmienna">%coreattrs;</span>\r\n\r\njest ograniczona znakami <span class="zmienna">&quot;</span>.\r\nWymaga tego składnia makrodefinicji\r\n<span class="zmienna">ENTITY</span>.</p>\r\n\r\n<p>Jak widać w skład grupy <span class="zmienna">coreattrs</span>\r\nwchodzą atrybuty  <span class="zmienna">id</span>,\r\n<span class="zmienna">class</span>,\r\n<span class="zmienna">style</span> oraz\r\n\r\n<span class="zmienna">title</span> ustalające identyfikator, klasę,\r\nstyl oraz tytuł elementu.</p>\r\n\r\n<p>Druga ważna grupa atrybutów to atrybuty <span class="zmienna">%i18n;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % i18n\r\n "lang        %LanguageCode; #IMPLIED  -- language code --\r\n  dir         (ltr|rtl)      #IMPLIED  -- direction for weak/neutral text --"\r\n&gt;</pre>\r\n\r\n<p>Wartość atrybutu <span class="zmienna">lang</span>\r\njest określona poprzez makro <span class="zmienna">%LanguageCode;</span>,\r\nzaś atrybut <span class="zmienna">dir</span> może przyjmować\r\njedną z dwóch wartości: <span class="zmienna">ltr</span> lub\r\n<span class="zmienna">rtl</span>.</p>\r\n\r\n<p>Atrybuty te służą do określenia języka danego elementu oraz kierunku\r\nprzetwarzania tekstu:\r\nod lewej do prawej (<span class="zmienna">ltr</span>)\r\nlub od prawej do lewej (<span class="zmienna">rtl</span>).</p>\r\n\r\n<p>Wreszcie atrybuty <span class="zmienna">%events;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % events\r\n "onclick     %Script;       #IMPLIED  -- a pointer button was clicked --\r\n  ondblclick  %Script;       #IMPLIED  -- a pointer button was double clicked--\r\n  onmousedown %Script;       #IMPLIED  -- a pointer button was pressed down --\r\n  onmouseup   %Script;       #IMPLIED  -- a pointer button was released --\r\n  onmouseover %Script;       #IMPLIED  -- a pointer was moved onto --\r\n  onmousemove %Script;       #IMPLIED  -- a pointer was moved within --\r\n  onmouseout  %Script;       #IMPLIED  -- a pointer was moved away --\r\n  onkeypress  %Script;       #IMPLIED  -- a key was pressed and released --\r\n  onkeydown   %Script;       #IMPLIED  -- a key was pressed down --\r\n  onkeyup     %Script;       #IMPLIED  -- a key was released --"\r\n&gt;</pre>\r\n\r\n<p>definiują procedury obsługi zdarzeń. Ich poprawna wartość jest zdefiniowana makrem\r\n<span class="zmienna">%Script;</span>.</p>\r\n\r\n<p>Makro <span class="zmienna">%attrs;</span> stanowi jedynie skrót,\r\nktóry uwzględnia wszystkie atrybuty występujące w grupach\r\n<span class="zmienna">%coreattrs;</span>, <span class="zmienna">%i18n;</span>\r\noraz <span class="zmienna">%events;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % attrs "%coreattrs; %i18n; %events;"&gt;</pre>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Makrodefinicja</th><th>Atrybuty</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Makrodefinicja</th><th>Atrybuty</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">%coreattrs;</span></td>\r\n\r\n<td><span class="zmienna">id</span>, <span class="zmienna">class</span>, <span class="zmienna">style</span>, <span class="zmienna">title</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%i18n;</span></td>\r\n\r\n<td><span class="zmienna">lang</span>, </td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%events;</span></td>\r\n\r\n<td><span class="zmienna">onclick</span>, <span class="zmienna">ondblclick</span>, <span class="zmienna">onmousedown</span>, <span class="zmienna">onmouseup</span>, <span class="zmienna">onmouseover</span>, <span class="zmienna">onmousemove</span>, <span class="zmienna">onmouseout</span>,  <span class="zmienna">onkeypress</span>, <span class="zmienna">onkeydown</span>, <span class="zmienna">onkeyup</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%attrs;</span></td>\r\n\r\n<td>wszystkie powyższe</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 3.\r\nTrzy główne grupy atrybutów i ich makrodefinicje</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R5">5. Elementy tekstowe, elementy blokowe</h3>\r\n\r\n<p>Specyfikacja HTML dzieli wszystkie dostępne elementy języka\r\nna dwie główne grupy:\r\nelementy tekstowe (ang. <span class="ang">inline elements</span>)\r\noraz elementy blokowe (ang. <span class="ang">block elements</span>).\r\nPrzykładami elementów tekstowych są\r\n<span class="zmienna">STRONG</span> oraz <span class="zmienna">EM</span>,\r\nzaś blokowych - <span class="zmienna">P</span>,\r\n\r\n<span class="zmienna">DIV</span> czy <span class="zmienna">TABLE</span>.\r\nW pewnym uproszczeniu można powiedzieć, że\r\nzawartość elementów tekstowych jest ograniczona do\r\nnapisów ewentualnie wzbogaconych o inne elementy tekstowe,\r\nzaś elementy blokowe to duże kontenery, które mogą zawierać\r\nzarówno inne elementy blokowe jak i tekstowe.</p>\r\n\r\n<p>Szczegółowa definicja zbioru elementów tekstowych i blokowych jest kilku etapowa.</p>\r\n\r\n<p>Najpierw zdefiniowane są makra ustalające cztery grupy elementów HTML:\r\nstyle czcionek (<span class="zmienna">%fontstyle;</span>),\r\nelementy frazowe (<span class="zmienna">%phrase;</span>),\r\nelementy specjalne (<span class="zmienna">%special;</span>)\r\noraz kontrolki formularzy\r\n(<span class="zmienna">%formctrl;</span>):</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % fontstyle "TT | I | B | BIG | SMALL"&gt;\r\n&lt;!ENTITY % phrase    "EM | STRONG | DFN | CODE | SAMP | KBD | VAR | CITE | ABBR | ACRONYM"&gt;\r\n&lt;!ENTITY % special   "A | IMG | OBJECT | BR | SCRIPT | MAP | Q | SUB | SUP | SPAN | BDO"&gt;\r\n&lt;!ENTITY % formctrl  "INPUT | SELECT | TEXTAREA | LABEL | BUTTON"&gt;</pre>\r\n\r\n<p>Wykorzystując powyższe cztery makrodefinicje, elementy tekstowe są zdefiniowane jako:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % inline "#PCDATA | %fontstyle; | %phrase; | %special; | %formctrl;"&gt;</pre>\r\n\r\n<p>Uwaga, wprawdzie elementy z grupy <span class="zmienna">%fontstyle;</span>,\r\nczyli <span class="zmienna">TT</span>,\r\n<span class="zmienna">I</span>,\r\n<span class="zmienna">B</span>,\r\n<span class="zmienna">BIG</span> oraz\r\n\r\n<span class="zmienna">SMALL</span>, nie są zabronione w języku HTML 4.01 strict,\r\njednak specyfikacja wyraźnie odradza ich stosowanie.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Makrodefinicja</th><th>Elementy</th><th>Uwagi</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Makrodefinicja</th><th>Elementy</th><th>Uwagi</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">#PCDATA</span></td>\r\n\r\n<td>tekst nie zawierający kodu HTML</td>\r\n\r\n<td>dozwolone są znaki specjalne</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%fontstyle;</span></td>\r\n\r\n<td><span class="zmienna">TT</span>, <span class="zmienna">I</span>, <span class="zmienna">B</span>, <span class="zmienna">BIG</span>, <span class="zmienna">SMALL</span></td>\r\n\r\n<td>elementy niezalecane</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%phrase;</span></td>\r\n\r\n<td><span class="zmienna">EM</span>, <span class="zmienna">STRONG</span>, <span class="zmienna">DFN</span>, <span class="zmienna">CODE</span>, <span class="zmienna">SAMP</span>, <span class="zmienna">KBD</span>, <span class="zmienna">VAR</span>, <span class="zmienna">CITE</span>, <span class="zmienna">ABBR</span>, <span class="zmienna">ACRONYM</span></td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%special;</span></td>\r\n\r\n<td><span class="zmienna">A</span>, <span class="zmienna">IMG</span>, <span class="zmienna">OBJECT</span>, <span class="zmienna">BR</span>, <span class="zmienna">SCRIPT</span>, <span class="zmienna">MAP</span>, <span class="zmienna">Q</span>, <span class="zmienna">SUB</span>, <span class="zmienna">SUP</span>, <span class="zmienna">SPAN</span>, <span class="zmienna">BDO</span></td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%formctrl;</span></td>\r\n\r\n<td><span class="zmienna">INPUT</span>, <span class="zmienna">SELECT</span>, <span class="zmienna">TEXTAREA</span>, <span class="zmienna">LABEL</span>, <span class="zmienna">BUTTON</span></td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 4.\r\nElementy tekstowe języka HTML</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Definicja elementów blokowych rozpoczyna się od określenia makr:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % heading "H1|H2|H3|H4|H5|H6"&gt;\r\n&lt;!ENTITY % list "UL | OL"&gt;\r\n&lt;!ENTITY % preformatted "PRE"&gt;</pre>\r\n\r\n<p>Do grupy elementów blokowy należą elementy wymienione w następującej makrodefinicji:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % block\r\n     "P | %heading; | %list; | %preformatted; | DL | DIV | NOSCRIPT |\r\n      BLOCKQUOTE | FORM | HR | TABLE | FIELDSET | ADDRESS"&gt;</pre>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Makrodefinicja</th><th>Elementy</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Makrodefinicja</th><th>Elementy</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">%heading;</span></td>\r\n\r\n<td><span class="zmienna">H1</span>, <span class="zmienna">H2</span>, <span class="zmienna">H3</span>, <span class="zmienna">H4</span>, <span class="zmienna">H5</span>, <span class="zmienna">H6</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%list;</span></td>\r\n\r\n<td><span class="zmienna">UL</span>, <span class="zmienna">OL</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">%preformatted;</span></td>\r\n\r\n<td><span class="zmienna">PRE</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>-</td>\r\n\r\n<td><span class="zmienna">P</span>, <span class="zmienna">DL</span>, <span class="zmienna">DIV</span>, <span class="zmienna">NOSCRIPT</span>, <span class="zmienna">BLOCKQUOTE</span>, <span class="zmienna">FORM</span>, <span class="zmienna">HR</span>, <span class="zmienna">TABLE</span>, <span class="zmienna">FIELDSET</span>, <span class="zmienna">ADDRESS</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 5.\r\nElementy blokowe języka HTML</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Dodatkowa makrodefinicja <span class="zmienna">%flow;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % flow "%block; | %inline;"&gt;</pre>\r\n\r\n<p>będzie przydatna wówczas, gdy dopuszczalną wartością elementu\r\nbędą zarówno elementy blokowe jak i tekstowe.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Tekstowe</th><th>Blokowe</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Tekstowe</th><th>Blokowe</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">EM</span>, <span class="zmienna">STRONG</span>, <span class="zmienna">DFN</span>, <span class="zmienna">CODE</span>, <span class="zmienna">SAMP</span>, <span class="zmienna">KBD</span>, <span class="zmienna">VAR</span>, <span class="zmienna">CITE</span>, <span class="zmienna">ABBR</span>, <span class="zmienna">ACRONYM</span>, <span class="zmienna">A</span>, <span class="zmienna">IMG</span>, <span class="zmienna">OBJECT</span>, <span class="zmienna">BR</span>, <span class="zmienna">SCRIPT</span>, <span class="zmienna">MAP</span>, <span class="zmienna">Q</span>, <span class="zmienna">SUB</span>, <span class="zmienna">SUP</span>, <span class="zmienna">SPAN</span>, <span class="zmienna">BDO</span>, <span class="zmienna">INPUT</span>, <span class="zmienna">SELECT</span>, <span class="zmienna">TEXTAREA</span>, <span class="zmienna">LABEL</span>, <span class="zmienna">BUTTON</span></td>\r\n\r\n<td><span class="zmienna">H1</span>, <span class="zmienna">H2</span>, <span class="zmienna">H3</span>, <span class="zmienna">H4</span>, <span class="zmienna">H5</span>, <span class="zmienna">H6</span>, <span class="zmienna">UL</span>, <span class="zmienna">OL</span>, <span class="zmienna">PRE</span>, <span class="zmienna">P</span>, <span class="zmienna">DL</span>, <span class="zmienna">DIV</span>, <span class="zmienna">NOSCRIPT</span>, <span class="zmienna">BLOCKQUOTE</span>, <span class="zmienna">FORM</span>, <span class="zmienna">HR</span>, <span class="zmienna">TABLE</span>, <span class="zmienna">FIELDSET</span>, <span class="zmienna">ADDRESS</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 6.\r\nDwie główne grupy elementów HTML</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R6">6. Elementy określające strukturę strony</h3>\r\n\r\n<p>Po wstępnym omówieniu zawartości dokumentu DTD\r\nprzyjrzyjmy się konkretnym znacznikom.\r\nRozpocznijmy od elementów definiujących strukturę dokumentu:\r\n\r\n<span class="zmienna">HTML</span>,\r\n<span class="zmienna">HEAD</span>, <span class="zmienna">BODY</span>,\r\n<span class="zmienna">TITLE</span>.</p>\r\n\r\n<p>Element <span class="zmienna">HTML</span> jest zdefiniowany następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % html.content "HEAD, BODY"&gt;\r\n\r\n&lt;!ELEMENT HTML O O (%html.content;)    -- document root element --&gt;\r\n&lt;!ATTLIST HTML\r\n  %i18n;                               -- lang, dir --\r\n&gt;</pre>\r\n\r\n<p>Jak widać element <span class="zmienna">HTML</span>\r\nma oba znaczniki opcjonalne (dwie litery <span class="zmienna">O O</span>).\r\nJego zawartość stanowią zawsze dwa elementy:\r\npierwszym jest <span class="zmienna">HEAD</span>,\r\ndrugim - <span class="zmienna">BODY</span>\r\n\r\n(patrz zapis <span class="zmienna">A , B</span> w tabeli 1).\r\nZauważmy, że element <span class="zmienna">HTML</span> zawiera\r\nelementy <span class="zmienna">HEAD</span> i <span class="zmienna">BODY</span>\r\nnawet wówczas, gdy dokument jest pozbawiony znaczników\r\notwierających lub zamykających elementy <span class="zmienna">HTML</span>,\r\n<span class="zmienna">HEAD</span> oraz <span class="zmienna">BODY</span>.\r\nJedynymi atrybutami, jakie można nadać elementowi <span class="zmienna">HTML</span>\r\n\r\nsą atrybuty grupy\r\n<span class="zmienna">%i18n;</span> ustalające język i kierunek przetwarzania tekstu.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element HTML</h5>\r\n<p>Znacznik otwierający: <strong>opcjonalny</strong>.</p>\r\n<p>Znacznik zamykający: <strong>opcjonalny</strong>.</p>\r\n\r\n<p>Zawartość: muszą wystąpić elementy\r\n<span class="zmienna">HEAD</span> oraz <span class="zmienna">BODY</span> (w dokładnie takiej kolejności).</p>\r\n<p>Nie może wystąpić wewnątrz żadnego elementu.</p>\r\n<p>Atrybuty: <span class="zmienna">%i18n;</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n<p>Oto definicja elementu <span class="zmienna">BODY</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT BODY O O (%block;|SCRIPT)+ +(INS|DEL) -- document body --&gt;\r\n&lt;!ATTLIST BODY\r\n  %attrs;                              -- %coreattrs, %i18n, %events --\r\n  onload          %Script;   #IMPLIED  -- the document has been loaded --\r\n  onunload        %Script;   #IMPLIED  -- the document has been removed --\r\n&gt;</pre>\r\n\r\n<p>Wynika z niej, że element body posiada wszystkie atrybuty grup\r\n\r\n<span class="zmienna">%coreattrs;</span>, <span class="zmienna">%i18n;</span>\r\noraz <span class="zmienna">%events;</span>.\r\nDodatkowo element ten posiada dwa atrybuty ustalające obsługę zdarzeń\r\n<span class="zmienna">onload</span> oraz <span class="zmienna">onunload</span>.\r\nPoprawną zawartością elementu <span class="zmienna">BODY</span> jest\r\njakikolwiek element blokowy lub element <span class="zmienna">SCRIPT</span>\r\n\r\n(element blokowy lub element <span class="zmienna">SCRIPT</span>\r\nmusi wystąpić co najmniej raz).\r\nZawartość może dodatkowo zawierać elementy\r\n<span class="zmienna">INS</span> oraz <span class="zmienna">DEL</span>.\r\nZ definicji tej wynika między innymi fakt, że bezpośrednio\r\nw treści dokumentu nie możemy umieszczać tekstu.\r\nKod</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;BODY&gt;\r\n  Witaj na mojej stronie!\r\n&lt;/BODY&gt;</pre>\r\n\r\n<p>jest niepoprawny.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element BODY</h5>\r\n<p>Znacznik otwierający: <strong>opcjonalny</strong>.</p>\r\n\r\n<p>Znacznik zamykający: <strong>opcjonalny</strong>.</p>\r\n<p>Zawartość: dowolny element blokowy lub element <span class="zmienna">SCRIPT</span>\r\nco najmniej jeden raz. Dodatkowo mogą wystąpić elementy\r\n<span class="zmienna">INS</span> oraz <span class="zmienna">DEL</span>.</p>\r\n<p>Występuje zawsze dokładnie raz (nawet jeśli strona nie zawiera\r\nznaczników <span class="zmienna">&lt;BODY&gt;</span>\r\n\r\noraz <span class="zmienna">&lt;/BODY&gt;</span>)\r\nwewnątrz elementu <span class="zmienna">HTML</span>\r\npo elemencie <span class="zmienna">HEAD</span>.</p>\r\n<p>Atrybuty: <span class="zmienna">%attrs;</span>,\r\n<span class="zmienna">onload</span>, <span class="zmienna">onunload</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Nagłówek strony, stanowiący zawartość elementu <span class="zmienna">HEAD</span>,\r\njest zdefiniowany następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ENTITY % head.misc "SCRIPT|STYLE|META|LINK|OBJECT" -- repeatable head elements --&gt;\r\n\r\n&lt;!ENTITY % head.content &quot;TITLE &amp; BASE?&quot;&gt;\r\n\r\n&lt;!ELEMENT HEAD O O (%head.content;) +(%head.misc;) -- document head --&gt;\r\n&lt;!ATTLIST HEAD\r\n  %i18n;                               -- lang, dir --\r\n  profile     %URI;          #IMPLIED  -- named dictionary of meta info --\r\n&gt;</pre>\r\n\r\n<p>Z definicji tej wynika, że zarówno znacznik otwierający jak i zamykający elementu\r\n<span class="zmienna">HEAD</span> są opcjonalne.\r\nAtrybutami, jakie możemy określić w odniesieniu do <span class="zmienna">HEAD</span> są\r\natrybuty grupy <span class="zmienna">%i18n;</span>\r\n\r\noraz <span class="zmienna">profile</span>.\r\nPoprawna zawartość jest opisana w sposób dość zawiły.</p>\r\n\r\n<p>Makro <span class="zmienna">head.content</span>\r\nma wartość <span class="zmienna">"TITLE &amp; BASE?"</span>.\r\nZnak zapytania mówi, że <span class="zmienna">BASE</span>\r\nwystępuje jeden raz lub nie występuje wcale.\r\nNatomiast znak <span class="zmienna">&amp;</span>\r\n\r\ndefiniuje, że zarówno <span class="zmienna">TITLE</span>\r\njak i <span class="zmienna">BASE?</span> muszą wystąpić dokładnie po razie\r\nw dowolnej kolejności. Łącząc oba warunki otrzymamy, że\r\npoprawną zawartością jest albo sam element <span class="zmienna">TITLE</span>,\r\nalbo <span class="zmienna">TITLE</span> i <span class="zmienna">BASE</span>\r\nwystępujące w dowolnej kolejności.</p>\r\n\r\n<p>Po rozszyfrowaniu makra wróćmy do poprawnej zawartości elementu\r\n<span class="zmienna">HEAD</span>. Zawartość jest zdefiniowana\r\njako <span class="zmienna">(%head.content;) +(%head.misc;)</span>.\r\nA zatem, tak jak powiedzieliśmy element <span class="zmienna">TITLE</span> musi się pojawić;\r\newentualnie może mu towarzyszyć element <span class="zmienna">BASE</span>.\r\nDodatkowo może się pojawić dowolną liczbę razy\r\nkażdy z elementów\r\n<span class="zmienna">SCRIPT</span>,\r\n<span class="zmienna">STYLE</span>,\r\n<span class="zmienna">META</span>,\r\n\r\n<span class="zmienna">LINK</span> oraz\r\n<span class="zmienna">OBJECT</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element HEAD</h5>\r\n<p>Znacznik otwierający: <strong>opcjonalny</strong>.</p>\r\n\r\n<p>Znacznik zamykający: <strong>opcjonalny</strong>.</p>\r\n<p>Zawartość: musi pojawić się dokładnie jeden\r\nelement <span class="zmienna">TITLE</span>,\r\newentualnie może pojawić się dokładnie jeden element <span class="zmienna">BASE</span>.\r\nDodatkowo może zawierać dowolną liczbę elementów\r\n<span class="zmienna">SCRIPT</span>,\r\n<span class="zmienna">STYLE</span>,\r\n<span class="zmienna">META</span>,\r\n<span class="zmienna">LINK</span> oraz\r\n\r\n<span class="zmienna">OBJECT</span> (w dowolnej kolejności).</p>\r\n<p>Występuje zawsze dokładnie jeden raz wewnątrz elementu <span class="zmienna">HTML</span>\r\nprzed elementem <span class="zmienna">BODY</span>.</p>\r\n<p>Atrybuty: <span class="zmienna">%i18n;</span>, <span class="zmienna">profile</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Deklaracja elementu <span class="zmienna">TITLE</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT TITLE - - (#PCDATA) -(%head.misc;) -- document title --&gt;\r\n&lt;!ATTLIST TITLE %i18n&gt;</pre>\r\n\r\n<p>mówi, że dopuszczalną wartością jest jedynie tekst nie zawierający kodu HTML.\r\nElement <span class="zmienna">TITLE</span> posiada\r\njedynie atrybuty grupy <span class="zmienna">%i18n;</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element TITLE</h5>\r\n<p>Znacznik otwierający: <strong>wymagany</strong>.</p>\r\n\r\n<p>Znacznik zamykający: <strong>wymagany</strong>.</p>\r\n<p>Zawartość: może zawierać jedynie tekst, bez kodu HTML.</p>\r\n<p>Musi wystąpić dokładnie raz wewnątrz elementu <span class="zmienna">HEAD</span>.\r\nMoże być poprzedzony jedynie przez element <span class="zmienna">BASE</span>.</p>\r\n<p>Atrybuty: <span class="zmienna">%i18n;</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Element <span class="zmienna">BASE</span> jest pusty,\r\ni posiada jeden wymagany atrybut <span class="zmienna">href</span>,\r\nktóry jest adresem URI:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT BASE - O EMPTY               -- document base URI --&gt;\r\n&lt;!ATTLIST BASE\r\n  href        %URI;          #REQUIRED -- URI that acts as base URI --\r\n&gt;</pre>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element BASE</h5>\r\n<p>Znacznik otwierający: <strong>wymagany</strong>.</p>\r\n<p>Znacznik zamykający: <strong>zabroniony</strong>.</p>\r\n<p>Zawartość: element pusty.</p>\r\n\r\n<p>Może wystąpić dokładnie jeden\r\nwewnątrz elementu <span class="zmienna">HEAD</span>.</p>\r\n<p>Atrybuty: wymagany <span class="zmienna">href</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Drugim pustym elementem nagłówka jest\r\nelement <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT META - O EMPTY               -- generic metainformation --&gt;\r\n&lt;!ATTLIST META\r\n  %i18n;                               -- lang, dir, for use with content --\r\n  http-equiv  NAME           #IMPLIED  -- HTTP response header name  --\r\n  name        NAME           #IMPLIED  -- metainformation name --\r\n  content     CDATA          #REQUIRED -- associated information --\r\n  scheme      CDATA          #IMPLIED  -- select form of content --\r\n&gt;</pre>\r\n\r\n<p>Atrybutami elementu <span class="zmienna">META</span> są\r\natrybuty grupy <span class="zmienna">%i18n;</span> oraz\r\n\r\n<span class="zmienna">http-equiv</span>,\r\n<span class="zmienna">name</span>,\r\n<span class="zmienna">content</span> i\r\n<span class="zmienna">scheme</span>, przy czym atrybut\r\n<span class="zmienna">content</span> jest zawsze wymagany.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element META</h5>\r\n<p>Znacznik otwierający: <strong>wymagany</strong>.</p>\r\n<p>Znacznik zamykający: <strong>zabroniony</strong>.</p>\r\n<p>Zawartość: element pusty.</p>\r\n<p>Może wystąpić dowolną liczbę razy\r\nw nagłówku (tj. wewnątrz elementu <span class="zmienna">HEAD</span>).</p>\r\n<p>Atrybuty: wymagany <span class="zmienna">content</span>,\r\n<span class="zmienna">%i18n;</span>,\r\n<span class="zmienna">http-equiv</span>,\r\n<span class="zmienna">name</span>,\r\n<span class="zmienna">scheme</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n<p>Ostatnimi dwoma elementami nagłówka są\r\n<span class="zmienna">STYLE</span> oraz <span class="zmienna">SCRIPT</span>,\r\nktórych definicje przedstawia listing 1.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;!ELEMENT STYLE - - %StyleSheet        -- style info --&gt;\r\n&lt;!ATTLIST STYLE\r\n  %i18n;                               -- lang, dir, for use with title --\r\n  type        %ContentType;  #REQUIRED -- content type of style language --\r\n  media       %MediaDesc;    #IMPLIED  -- designed for use with these media --\r\n  title       %Text;         #IMPLIED  -- advisory title --\r\n  &gt;\r\n\r\n&lt;!ELEMENT SCRIPT - - %Script;          -- script statements --&gt;\r\n&lt;!ATTLIST SCRIPT\r\n  charset     %Charset;      #IMPLIED  -- char encoding of linked resource --\r\n  type        %ContentType;  #REQUIRED -- content type of script language --\r\n  src         %URI;          #IMPLIED  -- URI for an external script --\r\n  defer       (defer)        #IMPLIED  -- UA may defer execution of script --\r\n  event       CDATA          #IMPLIED  -- reserved for possible future use --\r\n  for         %URI;          #IMPLIED  -- reserved for possible future use --\r\n&gt;</pre>\r\n<p class="podpis">\r\nListing 1.\r\nDTD elementów <span class="zmienna">STYLE</span> oraz <span class="zmienna">SCRIPT</span>.</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Oba te elementy posiadają obowiązkowy atrybut <span class="zmienna">type</span>.\r\nZnaczniki otwierający i zamykający są obowiązkowe zarówno w przypadku\r\nelementu <span class="zmienna">SCRIPT</span> jak i <span class="zmienna">STYLE</span>.\r\nNatomiast zawartością każdego z nich może być tekst nie zawierający kodu HTML\r\n(wartością makr <span class="zmienna">%StyleSheet;</span> i <span class="zmienna">%Script;</span>\r\njest <span class="zmienna">CDATA</span>).</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element STYLE</h5>\r\n<p>Znacznik otwierający: <strong>wymagany</strong>.</p>\r\n<p>Znacznik zamykający: <strong>wymagany</strong>.</p>\r\n<p>Zawartość: tekst <span class="zmienna">CDATA</span> nie zawierający kodu HTML.\r\nFaktycznym znakiem końca elementu <span class="zmienna">STYLE</span> jest znacznik\r\n\r\n<span class="zmienna">&lt;/STYLE&gt;</span>.\r\nCała zawartość elementu <span class="zmienna">STYLE</span>\r\njest przekazywana do modułu interpretacji styli\r\nbez jakiejkolwiek interpretacji ze strony parsera HTML.</p>\r\n<p>Może wystąpić dowolną liczbę razy\r\nw nagłówku (tj. wewnątrz elementu <span class="zmienna">HEAD</span>).</p>\r\n\r\n<p>Atrybuty: wymagany <span class="zmienna">type</span>,\r\n<span class="zmienna">%i18n;</span>,\r\n\r\n<span class="zmienna">media</span>,\r\n<span class="zmienna">title</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h5>Element SCRIPT</h5>\r\n\r\n<p>Znacznik otwierający: <strong>wymagany</strong>.</p>\r\n<p>Znacznik zamykający: <strong>wymagany</strong>.</p>\r\n<p>Zawartość: tekst <span class="zmienna">CDATA</span> nie zawierający kodu HTML.\r\nFaktycznym znakiem końca elementu <span class="zmienna">SCRIPT</span> jest znacznik\r\n<span class="zmienna">&lt;/SCRIPT&gt;</span>.\r\nCała zawartość elementu <span class="zmienna">SCRIPT</span>\r\n\r\njest przekazywana do modułu wykonującego skrypt\r\nbez jakiejkolwiek interpretacji ze strony parsera HTML.</p>\r\n\r\n<p>Może wystąpić dowolną liczbę razy\r\nw nagłówku (tj. wewnątrz elementu <span class="zmienna">HEAD</span>).</p>\r\n\r\n<p>Atrybuty: wymagany <span class="zmienna">type</span>,\r\n<span class="zmienna">charset</span>,\r\n<span class="zmienna">src</span>,\r\n<span class="zmienna">defer</span>,\r\n\r\n<span class="zmienna">event</span>,\r\n<span class="zmienna">for</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R7">7. Walidacja dokumentu HTML</h3>\r\n\r\n<p>Jak się okazuje, język HTML nie jest wcale\r\ntaki banalny jak to wygląda na pierwszy rzut oka.\r\nJuż reguły składniowe dotyczące pierwszych elementów\r\n<span class="zmienna">HTML</span>,\r\n\r\n<span class="zmienna">HEAD</span>,\r\n<span class="zmienna">BODY</span>,\r\n<span class="zmienna">TITLE</span>,\r\n<span class="zmienna">BASE</span>,\r\n<span class="zmienna">META</span>,\r\n<span class="zmienna">LINK</span>,\r\n<span class="zmienna">OBJECT</span>\r\n<span class="zmienna">SCRIPT</span> i\r\n\r\n<span class="zmienna">STYLE</span>\r\nsą na tyle zawiłe, że warto się zastanowić, w jaki\r\nsposób nad nimi zapanować.</p>\r\n\r\n<p>Z pomocą przychodzą nam programy, które wykrywają\r\nbłędy języka HTML. Programy takie nazywane\r\nsą w żargonie <em>walidatorami</em>;\r\nobszerny przegląd walidatorów został opublikowany na łamach MI 10/2003.</p>\r\n\r\n<p>Organizacja W3C, zajmująca się standaryzacją WWW,\r\nprowadzi serwis walidacyjny pod adresem\r\n<a href="http://validator.w3.org">http://validator.w3.org</a>.\r\nSkorzystanie z tego serwisu wymaga\r\numieszczenia badanej witryny na dowolnym serwerze\r\n(tak by strona posiadała adres URL).</p>\r\n\r\n<p>Dokument <span class="plik">walidacja.html</span>\r\nzawiera wyniki analizy kilku wariantów jednej strony WWW.\r\nStrona ta zawiera wyłącznie\r\nelementy\r\n<span class="zmienna">HTML</span>,\r\n<span class="zmienna">HEAD</span>,\r\n<span class="zmienna">BODY</span>,\r\n<span class="zmienna">TITLE</span>,\r\n<span class="zmienna">META</span> (kodowanie polskich znaków),\r\n<span class="zmienna">H1</span>\r\n\r\noraz znacznik <span class="zmienna">DOCTYPE</span>.\r\nKolejno usuwane są różne elementy, zmieniana ich kolejność\r\ni analizowane informacje zwrócone przez walidator.\r\nNa tej podstawie ustalony zostaje szablon pustego dokumentu WWW.</p>\r\n\r\n<h3 id="R8">8. Podsumowanie</h3>\r\n\r\n<p>Czy tak dokładna znajomość języka HTML jest konieczna?\r\nCzy jest przydatna?</p>\r\n\r\n<p>Cóż, odpowiedzi na te pytania każdy musi szukać sam.\r\nMoim zdaniem tworzenie poprawnych dokumentów HTML od początku pracy nad serwisem i\r\nnadawanie im odpowiedniej struktury w ramach rozwoju aplikacji ma praktyczne korzyści.\r\nJakie?\r\nJeśli kod HTML jest poprawny i posiada odpowiednią strukturę,\r\nto wprowadzanie poprawek i ulepszeń będzie stosunkowo proste, a przynajmniej wykonalne.\r\nPrzeglądając różne kody HTML, niejednokrotnie dochodzę do wniosku, że\r\nszybciej przygotuję nowe rozwiązanie, niż przeanalizuję i poprawię stare.</p>\r\n\r\n<p>Zwróćmy uwagę, że kontrola poprawności\r\nkodu HTML jest automatyczna i nie wymaga\r\ngodzin ślęczenia w celu odnalezienia błędu.\r\nA zatem niewielkim kosztem, tj. sprawdzając poprawność kodu w miarę\r\ntworzenia serwisu WWW, a nie po fakcie, możemy nie tylko\r\nprzygotować poprawne strony WWW, ale także nabrać nawyków,\r\nktóre zaowocują w przyszłości.</p>', 'html-aplikacja-jezyka-sgml');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(3, 'HTML - ćwiczenia w przygotowywaniu dokumentów zawierających tekst', 'Po teoretycznym opisie języka HTML\r\npora na ćwiczenia praktyczne.\r\nPrzedstawiona seria ćwiczeń pomaga w opanowaniu języka HTML oraz CSS\r\nw stopniu wystarczającym do tworzenia dokumentów składających się z tekstów.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Edycja dokumentów HTML</a></li>\r\n<li><a href="#R2">2. NotH - tworzymy pierwszy dokument HTML</a></li>\r\n<li><a href="#R3">3. Wstawianie, usuwanie i zmiana znaczników</a></li>\r\n<li><a href="#R4">4. Skróty czy paski narzędzi?</a></li>\r\n<li><a href="#R5">5. Tekst na stronach WWW</a></li>\r\n<li><a href="#R6">6. Nagłówki</a></li>\r\n<li><a href="#R7">7. Tekst preformatowany</a></li>\r\n<li><a href="#R8">8. Znaki specjalne</a></li>\r\n<li><a href="#R9">9. Pozioma linia</a></li>\r\n<li><a href="#R10">10. Komentarze</a></li>\r\n<li><a href="#R11">11. Style, czyli jak modyfikować wyglądu dokumentów</a>\r\n    <ol>\r\n        <li><a href="#P11-1">11.1 Modyfikacja czcionki</a></li>\r\n        <li><a href="#P11-2">11.2 Modyfikacja atrybutów akapitu</a></li>\r\n        <li><a href="#P11-3">11.3 Marginesy</a></li>\r\n        <li><a href="#P11-4">11.4 Modyfikacja kolorów</a></li>\r\n    </ol>\r\n</li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Edycja dokumentów HTML</h3>\r\n\r\n<p>Dokument w języku HTML zawiera - oprócz swojej treści -\r\ncałkiem dużo różnych napisów, które ustalają strukturę tekstu i powodują\r\ntaki, a nie inny wygląd dokumentu w przeglądarce.\r\nChodzi oczywiście o znaczniki.\r\nPrzygotowując dokument HTML musimy napisać\r\noprócz samej treści strony także znaczniki HTML.\r\nJeśli na stronie chcemy umieścić wytłuszczony\r\nnapis <strong>OSA</strong>,\r\nto koniecznym będzie napisanie</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STRONG&gt;OSA&lt;/STRONG&gt;</pre>\r\n\r\n<p>dwudziestu znaków zamiast 3. Jeśli później dojdziemy do\r\nwniosku, że napis <strong>OSA</strong>\r\nma być pochylony, znaczniki <span class="zmienna">&lt;STRONG&gt;</span>\r\n\r\ni <span class="zmienna">&lt;/STRONG&gt;</span>\r\nnależy zastąpić znacznikami\r\n<span class="zmienna">&lt;EM&gt;</span> oraz\r\n<span class="zmienna">&lt;/EM&gt;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;EM&gt;OSA&lt;/EM&gt;</pre>\r\n\r\n<p>Abstrahując od sensu elementów <span class="zmienna">EM</span>\r\ni <span class="zmienna">STRONG</span> widzimy, że ilość pracy edytorskiej jest\r\nwyjątkowo duża.\r\nMyślę, że jest to jeden z głównych powodów, dla których\r\nwiele osób rezygnuje z przygotowywania dokumentów HTML na rzecz\r\nedytorów wizualnych.</p>\r\n\r\n<p>Jednym ze sposobów przyspieszenia\r\nedycji plików html jest użycie skrótów klawiszowych.\r\nProgram <span class="program">NotH</span>\r\n(zawarty na płycie dołączonej do czasopisma)\r\nułatwia pracę nad dokumentami HTML dzięki zdefiniowanym skrótom\r\ni funkcjom ukierunkowanym na edycje kodu HTML.\r\nDowolny element HTML możemy uzyskać naciskając dwa klawisze.</p>\r\n\r\n<h3 id="R2">2. NotH - tworzymy pierwszy dokument HTML</h3>\r\n\r\n<p>Najczęściej stosowanym skrótem programu <span class="program">NotH</span>\r\njest skrót <span class="zmienna">Ctrl+S+A</span>.\r\nSkrót ten tworzy pusty dokument HTML, umieszczając w nim\r\nelementy <span class="zmienna">HTML</span>,\r\n<span class="zmienna">HEAD</span>,\r\n<span class="zmienna">TITLE</span>,\r\n\r\n<span class="zmienna">BODY</span> oraz\r\n<span class="zmienna">META</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Skróty klawiszowe <span class="zmienna">Ctrl+S+A</span>\r\nsą zapisywane również jako <span class="zmienna">^SA</span>.\r\nSkrót taki oznacza, że należy:</p>\r\n\r\n<ul>\r\n<li>nacisnąć i przytrzymać klawisz <span class="zmienna">Ctrl</span>;</li>\r\n<li>następnie nacisnąć (<strong>jeden raz, szybko!</strong>)\r\nklawisz <span class="zmienna">S</span>\r\n(klawisz <span class="zmienna">Ctrl</span> powinien być cały czas naciśnięty);</li>\r\n\r\n<li>zwolnić klawisz <span class="zmienna">Ctrl</span>;</li>\r\n<li>nacisnąć jeden raz klawisz <span class="zmienna">A</span>.</li>\r\n</ul>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Po aktywacji skrótu <span class="zmienna">^SA</span>,\r\nmożemy przystąpić do wpisywania zawartości dokumentu.\r\nKursor jest umieszczony pomiędzy znacznikami\r\n\r\n<span class="zmienna">&lt;TITLE&gt;</span> oraz\r\n<span class="zmienna">&lt;/TITLE&gt;</span>.\r\nWpiszmy jako tytuł strony napis <em>Witaj!</em>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TITLE&gt;Witaj!&lt;/TITLE&gt;</pre>\r\n\r\n<p>Następnie przejdźmy do zawartości strony, i pomiędzy znacznikami\r\n<span class="zmienna">&lt;BODY&gt;</span> i\r\n<span class="zmienna">&lt;/BODY&gt;</span>\r\nwprowadźmy tekst:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H1&gt;Moja pierwsza strona&lt;/H1&gt;</pre>\r\n\r\n<p>Do umieszczenia znaczników <span class="zmienna">&lt;H1&gt;</span>\r\noraz <span class="zmienna">&lt;/H1&gt;</span> służy skrót\r\n<span class="zmienna">^P1</span>\r\n(tj. <span class="zmienna">Ctrl+P+1</span>).</p>\r\n\r\n<p>Tak przygotowany dokument zapisujemy w folderze\r\n<span class="plik">D:\\www\\cw-1.html</span>, po czym naciskamy klawisz\r\n\r\n<span class="zmienna">F9</span>.\r\nKlawisz <span class="zmienna">F9</span> uruchamia domyślną przeglądarkę\r\ni pokazuje wygląd utworzonego dokumentu.\r\nDokument ten został przedstawiony na rysunku 1.\r\nZauważmy, że napis <em>Witaj!</em>, który umieściliśmy pomiędzy\r\nznacznikami elementu <span class="zmienna">TITLE</span>\r\nwidnieje na belce tytułowej przeglądarki,\r\nzaś tekst <em>Moja pierwsza strona</em> - zawartość elementu\r\n<span class="zmienna">H1</span> - stanowi streść strony WWW.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-01.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nStrona wykonana programem <span class="program">NotH</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Wszystkie przykłady omówione w tekście zostały umieszczone na płycie WWW.\r\nW celu obejrzenia wyglądu przykładu należy odpowiedni plik podwójnie kliknąć.\r\nKod HTML strony obejrzymy otwierając wybrany dokument\r\nprogramem <span class="program">NotH</span> lub wykonując w\r\nprzeglądarce operację <span class="opcja">Widok | Źródło</span>.</p>\r\n\r\n<h3 id="R3">3. Wstawianie, usuwanie i zmiana znaczników</h3>\r\n\r\n<p>Zanim przejdziemy do omawiania kolejnych ćwiczeń,\r\nskupmy uwagę na edycji HTML.\r\nBędziemy chcieli wykonywać trzy rodzaje operacji:</p>\r\n\r\n<ul>\r\n\r\n<li>wstawianie znaczników,</li>\r\n<li>usuwanie znaczników,</li>\r\n<li>zmiana jednego znacznika na drugi.</li>\r\n</ul>\r\n\r\n<p>Wstawianie znaczników realizujemy naciskając skrót klawiszowy.\r\nWykonujemy skrót <span class="zmienna">Ctrl+S+A</span> - mamy pustą stronę\r\nnaciskamy <span class="zmienna">Ctrl+P+1</span> - pojawia się nagłówek\r\n<span class="zmienna">H1</span>, po naciśnięciu <span class="zmienna">Ctrl+F+S</span>\r\n\r\n- dostaniemy element <span class="zmienna">STRONG</span>.\r\nI tak dalej. Trudność może z początku stwarzać konieczność zapamiętania skrótów.\r\nJednak z racji na fakt, że faktycznie stosowanych znaczników jest około\r\ndwudziestu nie jest to zadanie karkołomne.\r\nNatomiast po opanowaniu skrótów,\r\nszybkość edycji kodu HTML wzrośnie kilkukrotnie.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<h3 id="R4">4. Skróty czy paski narzędzi?</h3>\r\n\r\n<p>Współczesne programy komputerowe zawierają najprzeróżniejsze\r\nfunkcje mające na celu zwiększenie produktywności.\r\nNiektóre funkcje programów są aktywowane przy uruchomieniu lub zamknięciu\r\naplikacji (np. konwersja kodowania znaków).\r\nCzasami programy wykonują operacje o zadanych porach dnia,\r\nlub co zadany odcinek czasu (np. funkcje zapisu).</p>\r\n\r\n<p>Operacje wykonywane na żądanie wymagają interakcji użytkownika.\r\nW większości aplikacji, funkcje programu możemy aktywować:</p>\r\n\r\n<ul>\r\n<li>za pomocą menu,</li>\r\n<li>za pomocą pasków narzędzi,</li>\r\n<li>skrótami klawiszowymi.</li>\r\n</ul>\r\n\r\n<p>Zaletą skrótów klawiszowych jest szybkość.\r\nNajlepszym przykładem tego jest operacja kopiuj-wklej.\r\nJeśli do skopiowania i wklejenia\r\nstosujemy myszkę i menu główne lub paski narzędzi,\r\nto trwa to kilkukrotnie dłużej niż\r\nw przypadku wykorzystania wyłącznie klawiatury.</p>\r\n\r\n<p>W programach, które stosujemy warto od czasu do czasu\r\nsprawdzić dostępne skróty klawiszowe.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Po aktywacji każdego ze skrótów, kursor myszki jest ustawiany w\r\nmiejscu, w którym najprawdopodobniej będziemy chcieli wprowadzać tekst.\r\nI tak po aktywacji skrótu\r\n<span class="zmienna">Ctrl+P+P</span> otrzymamy akapit,\r\na kursor zostanie umieszczony pomiędzy znacznikami:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\n|-położenie kursora\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Po aktywacji skrótu <span class="zmienna">Ctrl+P+2</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H2&gt;kursor umieszczony zostanie wewnątrz znaczników&lt;/H2&gt;</pre>\r\n\r\n<p>otrzymamy nagłówek\r\n<span class="zmienna">H2</span> z kursorem umieszczonym\r\npomiędzy znacznikami otwierającym i zamykającym.\r\nWreszcie skrót <span class="zmienna">Ctrl+P+I</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="|-pozycja kursora" alt=""&gt;</pre>\r\n\r\n<p>wstawi element <span class="zmienna">IMG</span>, przesuwając kursor\r\nwewnątrz atrybutu <span class="zmienna">src</span>.</p>\r\n\r\n\r\n<p>Jedną z dodatkowych korzyści, jaką niesie za sobą korzystanie ze skrótów oraz\r\ninnych metod wstawiania kodu jest fakt, że otrzymamy kod pozbawiony czeskich błędów.\r\nWiele osób, na początku nauki pisze\r\n<span class="zmienna">scr</span> zamiast <span class="zmienna">src</span>,\r\n<span class="zmienna">herf</span> a nie <span class="zmienna">href</span>.\r\nCzasami zgubi się slash, który rozpoczyna znacznik zamykający:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TITLE&gt;Witaj!&lt;TITLE&gt;</pre>\r\n\r\n<p>Te trzy błędy <span class="zmienna">scr</span>,\r\n<span class="zmienna">herf</span> oraz <span class="zmienna">TITLE</span>\r\nbez znaku <span class="zmienna">/</span> sprawiają bardzo dużo problemów\r\npoczątkującym webmasterom, podczas gdy korzystanie ze skrótów\r\neliminuje wszystkie tego typu błędy.</p>\r\n\r\n<p><strong>Znaczniki wstawiamy korzystając wyłącznie ze skrótów klawiszowych.</strong></p>\r\n\r\n<p>Jeśli zdarzy się tak, że napisany tekst chcemy modyfikować,\r\nwówczas należy korzystać ze skrótów i zaznaczania tekstu.\r\nAktywacja większości skrótów powoduje <strong>obejmowanie</strong> zaznaczonego tekstu.\r\nJeśli w zdaniu\r\n<em>Przyszło to na świat wątłe, słabe</em> zaznaczymy wyraz świat, po czym\r\nnaciśniemy skrót <span class="zmienna">Ctrl+F+E</span>, wówczas otrzymamy kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">Przyszło to na &lt;EM&gt;świat&lt;/EM&gt; wątłe, słabe</pre>\r\n\r\n<p>Po wykonaniu takiej operacji zaznaczony jest blok obejmujący wstawiony\r\nelement wraz z zawartością.</p>\r\n\r\n<p>Drugim rodzajem operacji jest usuwanie znaczników.\r\nW NotHu służy do tego skrót <span class="zmienna">Ctrl+Del</span>.\r\nNależy najpierw zaznaczyć cały element, od początku znacznika otwierającego\r\ndo końca znacznika zamykającego. Naciśnięcie <span class="zmienna">Ctrl+Del</span>\r\n\r\nspowoduje usunięcie znacznika otwierającego i zamykającego.</p>\r\n\r\n<p>Wreszcie ostatnia, nie mniej potrzebna operacja to zamiana\r\nelementów. Do tej operacji wykorzystujemy klawisz <span class="zmienna">Shift</span>.\r\nJeśli w tekście <em>Ene, due, ryke, fake</em> zaznaczymy napis <em>ryke</em>\r\ni wykonamy skrót <span class="zmienna">Ctrl+F+E</span>, to dostaniemy kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">Ene, due, &lt;EM&gt;ryke&lt;/EM&gt;, fake</pre>\r\n\r\n<p>z zaznaczonym całym elementem <span class="zmienna">EM</span>.\r\nJeśli element ten chcemy zamienić na nagłówek <span class="zmienna">H1</span>,\r\nto należy skorzystać ze skrótu\r\n<span class="zmienna">Ctrl+P+1</span>\r\nprzytrzymując klawisz <span class="zmienna">Shift</span>. Dostaniemy wówczas kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">Ene, due, &lt;H1&gt;ryke&lt;/H1&gt;, fake</pre>\r\n\r\n<p>z zaznaczonym elementem <span class="zmienna">H1</span>.\r\nJeśli teraz <span class="zmienna">H1</span> chcemy\r\nzmienić na <span class="zmienna">STRONG</span>, to naciskamy skrót\r\n\r\n<span class="zmienna">Ctrl+F+S</span>  przytrzymując <span class="zmienna">Shift</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">Ene, due, &lt;STRONG&gt;ryke&lt;/STRONG&gt;, fake</pre>\r\n\r\n<p>Gdy uznamy, że <span class="zmienna">STRONG</span> jest zbędny,\r\nnaciskamy <span class="zmienna">Ctrl+Del</span>.\r\nOtrzymamy ponownie:</p>\r\n\r\n<pre class="syntax-highlight:xml">Ene, due, ryke, fake</pre>\r\n\r\n<p>W ten sposób jeden zestaw skrótów służy zarówno do wstawiania jak i zmiany\r\nznaczników.</p>\r\n\r\n<p>Podsumowując, ułatwienia jakie wnosi <span class="program">NotH</span> w edycję kodu to:</p>\r\n\r\n<ul>\r\n<li>wstawianie znaczników skrótami klawiszowymi; znaczniki są wolne od literówek;</li>\r\n<li>pozycjonowanie kursora: kursor jest ustawiany w miejscu,\r\nw którym najprawdopodobniej będziemy chcieli wprowadzać tekst;</li>\r\n<li>obejmowanie zaznaczonego bloku tekstu znacznikami;</li>\r\n<li>usuwanie znaczników (skrót <span class="zmienna">Ctrl+Del</span>);</li>\r\n<li>zamiana znaczników (klawisz <span class="zmienna">Shift</span>).</li>\r\n</ul>\r\n\r\n<h3 id="R5">5. Tekst na stronach WWW</h3>\r\n\r\n<p>Pierwszy etap nauki języka HTML polega na\r\nopanowaniu umiejętności przygotowania dokumentów zawierających tekst.\r\nOpowiadania, powieści, artykuły, teksty piosenek, wiersze,\r\nstreszczenia, przewodniki,\r\nfora dyskusyjne i katalogi adresów WWW  - niemal wszystkie dokumenty dostępne w\r\nInternecie zawierają teksty.\r\nW istocie trudno sobie wyobrazić witrynę WWW, która nie zawiera żadnych tekstów.</p>\r\n\r\n<p>Z tekstem związane są następujące elementy HTML:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">&lt;P&gt;&lt;/P&gt;</span> -\r\njeden akapit tekstu;\r\n</li>\r\n\r\n<li><span class="zmienna"><span class="zmienna">&lt;BR&gt;</span> - złamanie wiersza;\r\n</span>\r\n</li>\r\n\r\n<li><span class="zmienna">&lt;EM&gt;&lt;/EM&gt;</span> - uwypuklenie tekstu;</li>\r\n\r\n<li><span class="zmienna">&lt;STRONG&gt;&lt;/STRONG&gt;</span> - uwypuklenie tekstu.</li>\r\n\r\n</ul>\r\n\r\n<p>Do elementów tych mamy skróty:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">^PP</span> - <span class="zmienna">&lt;P&gt;&lt;/P&gt;</span></li>\r\n<li><span class="zmienna">^PR</span> - <span class="zmienna">&lt;BR&gt;</span></li>\r\n\r\n<li><span class="zmienna">^FE</span> - <span class="zmienna">&lt;EM&gt;&lt;/EM&gt;</span></li>\r\n<li><span class="zmienna">^FS</span> - <span class="zmienna">&lt;STRONG&gt;&lt;/STRONG&gt;</span></li>\r\n</ul>\r\n\r\n<p>Pamiętając, że skrót <span class="zmienna">^SA</span> tworzy pustą stronę, przejdźmy do ćwiczeń.\r\nW celu uniknięcia konieczności wklepywania\r\ntekstów zawartych w ćwiczeniach, na płycie CD zostały zawarte\r\nodpowiednie dokumenty tekstowe.\r\nPozwoli to skupić uwagę na ćwiczeniu języka HTML, a nie przepisywaniu tekstów.\r\nĆwiczenia możemy wykonywać korzystając z techniki kopiuj-wklej lub też\r\npoddawać modyfikacjom pliki tekstowe.</p>\r\n\r\n<h5>Ćwiczenie 2</h5>\r\n\r\n<p>Przygotuj stronę prezentującą kilka przysłów.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nAkapity zawierające przysłowia</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tworzymy w <span class="program">NotHu</span> nowy dokument.\r\nW tym celu naciskamy <span class="zmienna">^SA</span>.\r\nPomiędzy dwoma znacznikami <span class="zmienna">TITLE</span> wprowadzamy tytuł strony\r\n<em>Przysłowia</em>.\r\nNastępnie przechodzimy pomiędzy elementy <span class="zmienna">BODY</span>,\r\npo czym wstawiamy trzy puste akapity, jeden pod drugim.\r\nNaciskamy trzykrotnie skrót <span class="zmienna">^PP</span>,\r\nza każdym razem przesuwając kursor w dół.\r\nNa koniec, otwieramy dokument tekstowy z przysłowiami, i korzystając z techniki kopiuj-wklej,\r\nkopiujemy przysłowia do trzech wstawionych akapitów.</p>\r\n\r\n<p>Na koniec dokument zapisujemy, i włączamy podgląd (klawisz <span class="zmienna">F9</span>).</p>\r\n\r\n<h5>Ćwiczenie 3</h5>\r\n\r\n<p>Przygotuj stronę z treścią wyliczanki <em>Ene-due</em>.</p>\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-03.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nZłamanie linii po każdym wersie wiersza</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tym razem, w programie <span class="program">NotH</span>  otwieramy\r\nplik testowy zawierający treść wyliczanki.\r\nZaznaczamy cały tekst (skrót <span class="zmienna">Ctrl+A</span>\r\n\r\njest stosowany w większości aplikacji), po czym aktywujemy skrót <span class="zmienna">^PP</span>.\r\nTekst wyliczanki zostanie zawarty we wnętrzu akapitu.\r\nZaznaczony blok obejmuje w tym momencie tekst wyliczanki i znaczniki <span class="zmienna">P</span>.</p>\r\n\r\n<p>Aktywujemy teraz skrót <span class="zmienna">^SA</span> i otrzymamy pustą stronę,\r\nzawierająca akapit z wyliczanką.\r\nTeraz, pomiędzy znacznikami <span class="zmienna">TITLE</span>, wprowadzamy tytuł strony.</p>\r\n\r\n<p>Otrzymaną stronę zapisujemy, po czym włączamy podgląd.\r\nJak widać, pomimo, że kolejne wersy wyliczanki zostały umieszczone w nowych\r\nlinijkach, to w przeglądarce tekst stanowi jedną, niezłamaną linię.</p>\r\n\r\n<p>Do złamania linii wewnątrz akapitu używamy znacznika <span class="zmienna">&lt;BR&gt;</span>.\r\nPo dodaniu elementów <span class="zmienna">BR</span>, kod strony wygląda następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\nEne, due, ryke, fake,&lt;BR&gt;\r\n\r\nTorbe, burbe, ósme, smake,&lt;BR&gt;\r\nDes, deus kosmateus,&lt;BR&gt;\r\nI morele baks.&lt;BR&gt;\r\n&lt;/P&gt;</pre>\r\n\r\n<h5>Ćwiczenie 4</h5>\r\n\r\n<p>Przygotuj stronę z wierszykami, śpiewanymi\r\nprzez dziecięcy zespół muzyczny Kapela Radości Małych,  w celu poprawienia dykcji.\r\nW każdym wierszyku wytłuść lub pochyl dowolny wyraz.\r\nW rozwiązaniu zawartym na płycie uwypuklono akcentowane wyrazy.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-04.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nUwypuklanie tekstu</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tworzymy nową stronę (<span class="zmienna">^SA</span>).\r\nWprowadzamy, pomiędzy znacznikami <span class="zmienna">TITLE</span>\r\ntytuł\r\n<em>Rozśpiewki</em>, a następnie kopiujemy  i wklejamy treść rozśpiewek.\r\nWklejone linijki tekstu zaznaczamy i obejmujemy\r\nznacznikami <span class="zmienna">&lt;P&gt;</span> (<span class="zmienna">^PP</span>).\r\nPo każdej rozśpiewce dodajemy znak złamania wiersza, po czym\r\nzaznaczamy kolejno różne wyrazy i aktywujemy skróty\r\n<span class="zmienna">^FS</span> i <span class="zmienna">^FE</span>.</p>\r\n\r\n<p>Otrzymany dokument zapisujemy i przechodzimy do podglądu (<span class="zmienna">F9</span>).</p>\r\n\r\n<p>Domyślne formatowanie elementu <span class="zmienna">STRONG</span>\r\nto wytłuszczenie kroju, zaś element\r\n<span class="zmienna">EM</span> zmienia krój czcionki na pochylony.</p>\r\n\r\n<h3 id="R6">6. Nagłówki</h3>\r\n\r\n<p>Dokumenty z poprzednich ćwiczeń nie zawierały bardzo ważnych elementów.\r\nNagłówków. Nagłówki dzielą dokument na rozdziały, podrozdziały oraz sekcje.\r\nHTML umożliwia sześciostopniowy podział dokumentu.</p>\r\n\r\n<p>Nagłówki oznaczamy elementami\r\n<span class="zmienna">H1</span>,\r\n<span class="zmienna">H2</span>,\r\n<span class="zmienna">H3</span>,\r\n<span class="zmienna">H4</span>,\r\n\r\n<span class="zmienna">H5</span> oraz\r\n<span class="zmienna">H6</span>.\r\nDo elementów tych mamy skróty\r\n<span class="zmienna">^P1</span> - <span class="zmienna">H1</span>,\r\n<span class="zmienna">^P2</span> - <span class="zmienna">H2</span>, itd.</p>\r\n\r\n<h5>Ćwiczenie 5</h5>\r\n\r\n<p>Przygotuj stronę prezentującą prolog dramatu Williama Shakespeare''a\r\n<em>Henryk VIII</em>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-05.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nDokument z nagłówkami <span class="zmienna">H1</span>, <span class="zmienna">H2</span> i <span class="zmienna">H3</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Otwieramy dokument tekstowy w <span class="program">NotHu</span>, zaznaczamy całość\r\n(<span class="zmienna">Ctrl+A</span>),\r\ni przekształcamy w stronę WWW (<span class="zmienna">^SA</span>).\r\nTeraz zaznaczamy blok obejmujący tytuł i\r\naktywujemy skrót <span class="zmienna">^P1</span>.\r\nOtrzymamy nagłówek <span class="zmienna">H1</span> obejmujący tytuł.</p>\r\n\r\n<p>Następnie zaznaczamy blok obejmujący nazwisko autora, i\r\nnaciskamy <span class="zmienna">^P2</span>.\r\nW dokumencie pojawi się nagłówek <span class="zmienna">H2</span>.</p>\r\n\r\n<p>Podobnie, dodajemy nagłówek <span class="zmienna">H3</span>\r\n(skrót <span class="zmienna">^P3</span>). Nagłówkiem tym obejmujemy wyraz <em>Prolog</em>.</p>\r\n\r\n<p>Teraz, zaznaczamy cały prolog, po czym przekształcamy go\r\nw akapit (<span class="zmienna">^PP</span>).\r\nNa końcu każdej linijki prologu\r\ndodajemy znacznik <span class="zmienna">&lt;BR&gt;</span>.</p>\r\n\r\n<p>Ćwiczenie kończymy wpisując pomiędzy\r\nznacznikami <span class="zmienna">TITLE</span> tytuł dokumentu</p>\r\n\r\n<h5>Ćwiczenie 6</h5>\r\n\r\n<p>Przygotuj stronę WWW z treścią noweli Henryka Sienkiewicza <em>Latarnik</em>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-06.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 6.\r\nTreść noweli sformatowana elementami <span class="zmienna">P</span>, <span class="zmienna">BR</span>, <span class="zmienna">H1</span>, <span class="zmienna">H2</span>, <span class="zmienna">H3</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Po otworzeniu dokumentu tekstowego w programie <span class="program">NotH</span>\r\nwykonujemy kolejno:</p>\r\n\r\n<ul>\r\n<li>zaznaczamy całość (<span class="zmienna">Ctrl+A</span>);</li>\r\n\r\n<li>przekształcamy w stronę WWW (<span class="zmienna">^SA</span>);</li>\r\n<li>dodajemy nagłówki obejmujące autora i tytuł\r\n(<span class="zmienna">^P1</span>, <span class="zmienna">^P2</span>);</li>\r\n<li>dodajemy nagłówek <span class="zmienna">H3</span>\r\nobejmujący rzymski numer rozdziału (<span class="zmienna">^P3</span>);</li>\r\n\r\n<li>kolejne akapity obejmujemy znacznikami <span class="zmienna">P</span>\r\n(<span class="zmienna">^PP</span>);</li>\r\n<li>w treści cytatów <em>Pana Tadeusza</em> dodajemy\r\nna końcu każdej linijki, znaki złamania wiersza (<span class="zmienna">^PR</span>);</li>\r\n<li>zmieniamy tytuł dokumentu;</li>\r\n<li>dokument zapisujemy, i włączamy podgląd (<span class="zmienna">F9</span>).</li>\r\n\r\n</ul>\r\n\r\n<h3 id="R7">7. Tekst preformatowany</h3>\r\n\r\n<p>Tekst preformatowany zachowuje białe znaki: spację oraz złamanie wiersza.\r\nDodatkowo jest on pisany czcionka stałej szerokości.\r\nGłównie stosujemy go do kodów programów i skryptów komputerowych.\r\nTekst preformatowany obejmujemy znacznikami\r\n<span class="zmienna">&lt;PRE&gt;&lt;/PRE&gt;</span>\r\nuzyskiwanymi skrótem <span class="zmienna">^FP</span>.</p>\r\n\r\n<h5>Ćwiczenie 7</h5>\r\n\r\n<p>Przygotuj stronę prezentująca kod funkcji <span class="zmienna">filesFromFolder</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-07.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 7.\r\nTekst preformatowany</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Otwieramy dokument tekstowy,\r\nzaznaczamy cały tekst i obejmujemy znacznikami\r\n<span class="zmienna">&lt;PRE&gt;</span> i\r\n<span class="zmienna">&lt;/PRE&gt;</span>.\r\nTeraz dodajemy szablon pustej strony (gdy zaznaczony jest\r\ncały tekst naciskamy <span class="zmienna">^SA</span>),\r\ndodajemy nagłówek i zmieniamy tytuł dokumentu.\r\nGotową stronę zapisujemy i otwieramy w przeglądarce.</p>\r\n\r\n<h5>Ćwiczenie 8</h5>\r\n\r\n<p>Przygotuj stronę z wierszykiem Jana Brzechwy Chrząszcz.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-08.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 8.\r\nTekst preformatowany zastosowany do wiersza</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Element <span class="zmienna">PRE</span> możemy również użyć do\r\nzwykłego tekstu.\r\nPo otworzeniu pliku z treścią wierszyka, korzystając ze skrótów\r\n<span class="zmienna">^SA</span> (szablon pustej strony),\r\n<span class="zmienna">^FP</span> (tekst preformatowany obejmujący tekst wierszyka),\r\n<span class="zmienna">^P1</span> (nagłówek <span class="zmienna">H1</span> strony,\r\nzawierający nazwisko autora)\r\noraz\r\n\r\n<span class="zmienna">^P2</span> (nagłówek <span class="zmienna">H2</span> strony -\r\ntytuł wiersza) tworzymy stronę WWW.</p>\r\n\r\n<h3 id="R8">8. Znaki specjalne</h3>\r\n\r\n<p>Ponieważ znaki &lt; oraz &gt; obejmują znaczniki, zatem nie należy ich używać w innym celu.\r\nJeśli na przykład chcemy na stronie poświęconej językowi HTML umieścić informację,\r\nże <em>"... znacznik &lt;STRONG&gt; ma takie, a takie działanie..."</em> wówczas musimy znaki\r\n\r\n<span class="zmienna">&lt;</span> i <span class="zmienna">&gt;</span>\r\nzastąpić napisami\r\n<span class="zmienna">&amp;lt;</span> oraz\r\n<span class="zmienna">&amp;gt;</span>.</p>\r\n\r\n<h5>Ćwiczenie 9</h5>\r\n\r\n<p>Przygotuj samouczek języka HTML na temat elementów\r\n<span class="zmienna">EM</span> oraz <span class="zmienna">STRONG</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-09.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 9.\r\nZnaki specjalne</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Po utworzeniu nowego, pustego dokumentu\r\nwklejamy tekst z pliku tekstowego.</p>\r\n\r\n<p>Znaki specjalne możemy uzyskać w <span class="program">NotHu</span> na\r\ndwa sposoby: korzystając ze skrótów klawiszowych,\r\noraz wykonując konwersję.\r\nSkróty <span class="zmienna">^QL</span>,\r\n<span class="zmienna">^QG</span>,\r\n<span class="zmienna">^QA</span> oraz\r\n<span class="zmienna">^QS</span> wstawiają znaki\r\n\r\n<span class="zmienna">&amp;lt;</span>,\r\n<span class="zmienna">&amp;gt;</span>,\r\n<span class="zmienna">&amp;amp;</span>\r\noraz spację.</p>\r\n\r\n<p>W celu wykonania konwersji znaków, zaznaczamy pierwszy akapit testu,\r\npo czym naciskamy klawisze <span class="zmienna">Ctrl+F11</span>.\r\nZnaki mniejszości i większości powinny się zamienić na odpowiadające im\r\nznaki specjalne.\r\nNaciśnięcie samego klawisza <span class="zmienna">F11</span>\r\ndokona konwersji odwrotnej.</p>\r\n\r\n<p>Do tekstu dodajemy znaczniki akapitu oraz stosując operację konwersji\r\n(Ctrl+F11) zmieniamy odpowiednie fragmenty tekstu</p>\r\n\r\n<h5>Ćwiczenie 10</h5>\r\n\r\n<p>Przygotuj stronę przedstawiającą kod\r\nprogramu wyznaczającego największy wspólny dzielnik.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-10.jpg" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 10.\r\nTekst preformatowany i znaki specjalne użyte do prezentacji programu komputerowego</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Po otworzeniu kodu programu w programie <span class="zmienna">NotH</span>,\r\nzaznaczamy cały dokument i wykonujemy skróty:\r\nnajpierw\r\n<span class="zmienna">Ctrl+F11</span>, następnie\r\n<span class="zmienna">^FP</span>, wreszcie <span class="zmienna">^SA</span>.\r\nPowinniśmy otrzymać stronę z tekstem preformatowanym\r\nzawierającym znaki specjalne.</p>\r\n\r\n<h3 id="R9">9. Pozioma linia</h3>\r\n\r\n<p>Znacznik  &lt;HR&gt;\r\nwstawia do strony WWW pozioma linię.\r\nWprawdzie jest to element dość staromodny, rzadko dzisiaj używany,\r\nale czasami jest użyteczny.\r\nElement ten uzyskamy skrótem <span class="zmienna">^LH</span>.</p>\r\n\r\n<h5>Ćwiczenie 11</h5>\r\n\r\n<p>Przygotuj stronę z cytatami Alberta Camusa.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-11.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 11.\r\nPozioma linia</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Po przygotowaniu strony zawierającej\r\nkażdy cytat w osobnym paragrafie,\r\nprzesuwamy kursor pomiędzy paragrafy\r\ni aktywujemy skrót <span class="zmienna">^LH</span>.</p>\r\n\r\n<h3 id="R10">10. Komentarze</h3>\r\n\r\n<p>Ostatnim elementem przedstawionym w dzisiejszej serii ćwiczeń jest\r\nkomentarz HTML.\r\nZnaczniki</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;!--    --&gt;</pre>\r\n\r\n<p>uzyskamy skrótem <span class="zmienna">^PK</span>.</p>\r\n\r\n<h5>Ćwiczenie 12</h5>\r\n\r\n<p>Przygotuj stronę z tekstem piosenki <em>Deszcz niespokojne</em>.\r\nKażdą ze zwrotek poprzedź komentarzem\r\nz numerem zwrotki.</p>\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-12.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 12.\r\nKomentarze w HTML</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Po wykonaniu strony z tekstem piosenki, umiejscawiamy kursor przed pierwszą zwrotką,\r\nnaciskamy <span class="zmienna">^PK</span>, po czym wewnątrz komentarza wpisujemy numer zwrotki.\r\nOczywiście komentarz nie będzie widoczny w przeglądarce.</p>\r\n\r\n<p>W identyczny sposób dodajemy komentarz przed drugą zwrotką.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>lp.</th><th>Element</th><th>Kod HTML</th><th>Skrót</th><th>Zapis skrótu</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>lp.</th><th>Element</th><th>Kod HTML</th><th>Skrót</th><th>Zapis skrótu</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Szablon pustej strony</td>\r\n\r\n<td>-</td>\r\n\r\n<td>Ctrl+S+A</td>\r\n\r\n<td>^SA</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Akapit</td>\r\n\r\n<td>&lt;P&gt;&lt;/P&gt;</td>\r\n\r\n<td>Ctrl+P+P</td>\r\n\r\n<td>^PP</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Złamanie wiersza</td>\r\n\r\n<td>&lt;BR&gt;</td>\r\n\r\n<td>Ctrl+P+R</td>\r\n\r\n<td>^PR</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Uwypuklanie tekstu</td>\r\n\r\n<td>&lt;STRONG&gt;&lt;/STRONG&gt;</td>\r\n\r\n<td>Ctrl+F+S</td>\r\n\r\n<td>^FS</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Uwypuklanie tekstu</td>\r\n\r\n<td>&lt;EM&gt;&lt;/EM&gt;</td>\r\n\r\n<td>Ctrl+F+E</td>\r\n\r\n<td>^FE</td>\r\n\r\n</tr>\r\n\r\n<tr><td>6.</td>\r\n\r\n<td>Nagłówek H1</td>\r\n\r\n<td>&lt;H1&gt;&lt;/H1&gt;</td>\r\n\r\n<td>Ctrl+P+1</td>\r\n\r\n<td>^P1</td>\r\n\r\n</tr>\r\n\r\n<tr><td>7.</td>\r\n\r\n<td>Nagłówek H2</td>\r\n\r\n<td>&lt;H2&gt;&lt;/H2&gt;</td>\r\n\r\n<td>Ctrl+P+2</td>\r\n\r\n<td>^P2</td>\r\n\r\n</tr>\r\n\r\n<tr><td>8.</td>\r\n\r\n<td>Nagłówek H3</td>\r\n\r\n<td>&lt;H3&gt;&lt;/H3&gt;</td>\r\n\r\n<td>Ctrl+P+3</td>\r\n\r\n<td>^P3</td>\r\n\r\n</tr>\r\n\r\n<tr><td>9.</td>\r\n\r\n<td>Pozostałe nagłówki uzyskujemy analogicznie</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>10.</td>\r\n\r\n<td>Tekst preformatowany</td>\r\n\r\n<td>&lt;PRE&gt;&lt;/PRE&gt;</td>\r\n\r\n<td>Ctrl+F+P</td>\r\n\r\n<td>^FP</td>\r\n\r\n</tr>\r\n\r\n<tr><td>11.</td>\r\n\r\n<td>Znaki specjalne</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n<td>Ctrl+F11 oraz F11</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>12.</td>\r\n\r\n<td>Znak &lt;</td>\r\n\r\n<td>&amp;lt;</td>\r\n\r\n<td>Ctrl+Q+L</td>\r\n\r\n<td>^QL</td>\r\n\r\n</tr>\r\n\r\n<tr><td>13.</td>\r\n\r\n<td>Znak &gt;</td>\r\n\r\n<td>&amp;gt;</td>\r\n\r\n<td>Ctrl+Q+G</td>\r\n\r\n<td>^QG</td>\r\n\r\n</tr>\r\n\r\n<tr><td>14.</td>\r\n\r\n<td>Znak &amp;</td>\r\n\r\n<td>&amp;amp;</td>\r\n\r\n<td>Ctrl+Q+A</td>\r\n\r\n<td>^QA</td>\r\n\r\n</tr>\r\n\r\n<tr><td>15.</td>\r\n\r\n<td>Spacja</td>\r\n\r\n<td>&amp;nbsp;</td>\r\n\r\n<td>Ctrl+Q+S</td>\r\n\r\n<td>^QS</td>\r\n\r\n</tr>\r\n\r\n<tr><td>16.</td>\r\n\r\n<td>Pozioma linia</td>\r\n\r\n<td>&lt;HR&gt;</td>\r\n\r\n<td>Ctrl+L+H</td>\r\n\r\n<td>^LH</td>\r\n\r\n</tr>\r\n\r\n<tr><td>17.</td>\r\n\r\n<td>Komentarz</td>\r\n\r\n<td>&lt;!-- --&gt;</td>\r\n\r\n<td>Ctrl+P+K</td>\r\n\r\n<td>^PK</td>\r\n\r\n</tr>\r\n\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nZestawienie omówionych elementów</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Warto elementy i skróty przedstawione w tabelce 1\r\nprzećwiczyć przygotowując kilkanaście dokumentów\r\nz różnymi wierszykami, piosenkami oraz nowelami.\r\nPamiętajmy przy tym, by tworzone dokumenty od czasu do czasu\r\nsprawdzać walidatorem\r\n<a href="http://validator.w3.org/">http://validator.w3.org/</a>.\r\nUstrzeże nas to przed nabieraniem złych nawyków!</p>\r\n\r\n<h3 id="R11">11. Style, czyli jak modyfikować wyglądu dokumentów</h3>\r\n\r\n<p>Gdy umiemy już przygotować proste dokumenty tekstowe,\r\nto naturalnym następnym krokiem nauki będzie modyfikacja\r\natrybutów tekstu. Zmiana kroju czcionki,\r\nkoloru tła czy wyjustowanie akapitów to\r\nprzykłady operacji, bez których trudno wyobrazić sobie edycje tekstu.</p>\r\n\r\n<p>Język HTML nie zawiera żadnych wbudowanych mechanizmów\r\npozwalających na modyfikacje wyglądu dokumentów.\r\nElementy takie jak <span class="zmienna">CENTER</span>\r\nczy <span class="zmienna">FONT</span>\r\noraz atrybuty w rodzaju <span class="zmienna">align</span>\r\nzostały definitywnie wycofane z języka.\r\nW ich miejsce pojawiły się <em>kaskadowe arkusze stylów</em> (CSS).</p>\r\n\r\n<p>Nie wnikając w szczegóły składniowe, można powiedzieć, że\r\ndefinicja stylów to lista elementów HTML\r\nz opisem właściwości wizualnych.</p>\r\n\r\n<p>Na przykład, jeśli chcemy zmienić czcionkę elementu <span class="zmienna">P</span>\r\nna <span class="zmienna">Courier</span>, to zrealizujemy\r\nstylem:</p>\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n    font-family: Courier;\r\n}</pre>\r\n\r\n<p>Wyrównanie do prawej, wytłuszczenie i\r\nzmianę koloru czcionki na czerwony\r\nnagłówka <span class="zmienna">H1</span>\r\nrealizuje styl:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    text-align  : right;\r\n    font-weight : bold;\r\n    color       : red;\r\n}</pre>\r\n\r\n<p>Jak widać, opis stylu ma postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">nazwa-elementu {\r\n   atrybut : wartość;\r\n   atrybut : wartość;\r\n   ...\r\n   atrybut : wartość;\r\n}</pre>\r\n\r\n<p>Style umieszczamy w dokumencie HTML wewnątrz\r\nnagłówka, na przykład po elemencie <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HEAD&gt;\r\n  &lt;TITLE&gt;&lt;/TITLE&gt;\r\n\r\n  &lt;META http-equiv="Content-Type" content="text/html; charset=iso-8859-2"&gt;\r\n  &lt;STYLE type="text/css"&gt;\r\n  &lt;!--\r\n\r\n  opis stylów\r\n\r\n  --&gt;\r\n  &lt;/STYLE&gt;\r\n&lt;/HEAD&gt;</pre>\r\n\r\n<p>Skrót <span class="zmienna">^SW</span>\r\nwstawia element <span class="zmienna">STYLE</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STYLE type="text/css"&gt;\r\n&lt;!--\r\n\r\n--&gt;\r\n&lt;/STYLE&gt;</pre>\r\n\r\n<p>oraz skrót <span class="zmienna">^SB</span>,\r\nktóry tworzy szablon pustej strony zawierającej style.</p>\r\n\r\n<h4 id="P11-1">11.1 Modyfikacja czcionki</h4>\r\n\r\n<p>Do modyfikacji czcionek służą atrybuty:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">font-family</span>,</li>\r\n\r\n<li><span class="zmienna">font-size</span>,</li>\r\n<li><span class="zmienna">font-weight</span>,</li>\r\n<li><span class="zmienna">font-style</span>.</li>\r\n</ul>\r\n\r\n<p>Wartością atrybutu  <span class="zmienna">font-family</span> jest nazwa kroju czcionki.\r\nAtrybut <span class="zmienna">font-size</span>\r\n\r\nokreśla wielkość kroju. Do liczby wyrażającej wielość przyklejamy\r\nskrót <span class="zmienna">px</span> (piksele)\r\nlub <span class="zmienna">pt</span> (punkty).\r\nGrubość kroju określamy podając atrybut <span class="zmienna">font-weight</span>.\r\nJego wartościami mogą miedzy innymi być\r\n<span class="zmienna">normal</span> oraz <span class="zmienna">bold</span>\r\n(co oznacza włączenie i wyłączenie pogrubienia).\r\nWreszcie kursywę możemy włączyć\r\nstosując <span class="zmienna">font-style</span>. Poprawnymi\r\nwartościami są <span class="zmienna">italic</span> lub\r\n\r\n<span class="zmienna">normal</span>.</p>\r\n\r\n<p>Skrót <span class="zmienna">^BF</span> produkuje przykładowe wartości atrybutów,\r\nzaś <span class="zmienna">^NP</span>,\r\n<span class="zmienna">^N1</span>, <span class="zmienna">^N2</span>,\r\n<span class="zmienna">^NB</span> ułatwiają przygotowanie definicji.\r\nPo wykonaniu skrótów <span class="zmienna">^NP</span> oraz\r\n\r\n<span class="zmienna">^BF</span> otrzymamy następujące style:\r\nakapitu:</p>\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n    font-family : Verdana;\r\n    font-style  : normal;\r\n    font-weight : normal;\r\n    font-size   : 10pt;\r\n}</pre>\r\n\r\n<p>Dodajmy, że style określające czcionki możemy\r\ndefiniować niemal dla wszystkich elementów języka HTML z osobna.\r\nMożemy modyfikować czcionkę użytą w nagłówkach, akapicie,\r\nczy całym dokumencie\r\n(czcionki określone dla elementu <span class="zmienna">BODY</span>).</p>\r\n\r\n<h4 id="P11-2">11.2 Modyfikacja atrybutów akapitu</h4>\r\n\r\n<p>Atrybutami odnoszącymi się do akapitów\r\nsą wyrównanie, wielkość wcięcia oraz ozdobienie tekstu.\r\nAtrybut <span class="zmienna">text-align</span>\r\nustala wyrównanie tekstu. Jego wartościami mogą być:\r\n<span class="zmienna">left</span>,\r\n<span class="zmienna">center</span>,\r\n<span class="zmienna">right</span> oraz\r\n<span class="zmienna">justify</span>.</p>\r\n\r\n<p>Wcięcie akapitu określamy atrybutem\r\n<span class="zmienna">text-indent</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">text-indent: 2em;</pre>\r\n\r\n<p>Jednostka <span class="zmienna">em</span>,\r\njest jednostką względną, zależną od wielkości kroju czcionki.</p>\r\n\r\n<p>Wreszcie atrybut\r\n<span class="zmienna">text-decoration</span>\r\no wartościach\r\n<span class="zmienna">none</span>,\r\n<span class="zmienna">underline</span>,\r\n<span class="zmienna">overline</span>,\r\n<span class="zmienna">line-through</span> lub\r\n<span class="zmienna">blink</span>\r\nokreśla dodatkowe efekty dekoracyjne takie jak podkreślenie\r\nczy przekreślenie liter.</p>\r\n\r\n<p>I znowu, dodajmy, że powyższe atrybuty możemy definiować w stosunku do\r\nróżnych elementów HTML, nie tylko akapitu.\r\nMożemy wyrównywać do lewej akapity, obrazy czy nawet tabele i ich komórki.</p>\r\n\r\n<p>Skrót <span class="zmienna">^BT</span>\r\nwstawia domyślne wartości powyższych trzech atrybutów.\r\nPo naciśnięciu skrótów <span class="zmienna">^NB</span> oraz\r\n<span class="zmienna">^BT</span> otrzymamy style:</p>\r\n\r\n<pre class="syntax-highlight:xml">BODY {\r\n    text-indent     : 2em;\r\n    text-align      : justify;\r\n    text-decoration : none;\r\n}</pre>\r\n\r\n<h4 id="P11-3">11.3 Marginesy</h4>\r\n\r\n<p>Do definiowania marginesów służy atrybut\r\n<span class="zmienna">margin</span>, postaci:</p>\r\n\r\n<pre class="syntax-highlight:xml">margin : 100px;</pre>\r\n\r\n<p>Jeśli chcemy ustalić różne wartości marginesów lewego, prawego, górnego i dolnego,\r\nto stosujemy atrybuty\r\n<span class="zmienna">margin-left</span>,\r\n<span class="zmienna">margin-right</span>,\r\n<span class="zmienna">margin-top</span> oraz\r\n<span class="zmienna">margin-bottom</span>.</p>\r\n\r\n<p>Atrybuty te możemy stosować w odniesieniu do wszystkich niemal elementów HTML.\r\nSkróty ^BM oraz ^BN\r\nwstawiają predefiniowane wartości. Aktywacja skrótów\r\n<span class="zmienna">^N1</span> oraz\r\n\r\n<span class="zmienna">^BN</span> da w efekcie:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    margin-left   : 20pt;\r\n    margin-right  : 20pt;\r\n    margin-top    : 20pt;\r\n    margin-bottom : 20pt;\r\n}</pre>\r\n\r\n<h4 id="P11-4">11.4 Modyfikacja kolorów</h4>\r\n\r\n<p>Kolory modyfikujemy atrybutami\r\n<span class="zmienna">color</span> oraz <span class="zmienna">background</span>.\r\nWartościami kolorów są wartości RGB lub angielskie nazwy kolorów.</p>\r\n\r\n<p>Skrót <span class="zmienna">^BC</span> wstawia atrybuty\r\n<span class="zmienna">color</span> i <span class="zmienna">background</span>\r\no kolorach czarnym oraz białym.\r\nDo wizualnej modyfikacji kolorów służy w <span class="zmienna">NotHu</span>\r\nokienko kolorów.</p>\r\n\r\n<p>Po naciśnięci klawisza <span class="zmienna">F4</span>\r\npojawia się okno dialogowe.\r\nPodwójne kliknięcie dowolnego z kolorów, wstawia do dokumentu,\r\nw miejscu, w którym znajduje się kursor, kod RGB wybranego koloru.</p>\r\n\r\n<p>Prawe kliknięcie w dowolny z kolorowych kwadracików, wyświetla okno do zmiany\r\nkoloru wybranego kwadracika.\r\nStosując metodę ciągnij-upuść możemy kopiować kolory pomiędzy kwadratami.</p>\r\n\r\n<h5>Ćwiczenie 13</h5>\r\n\r\n<p>Przygotuj życiorys Jana Brzechwy w postaci strony.\r\nW dokumencie zmień atrybuty tekstu oraz akapitu.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-13.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 13.\r\nStyle dotyczące czcionki i wyrównania</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Otwieramy dokument z tekstem życiorysu,\r\nzaznaczamy wszystko i aktywujemy skrót <span class="zmienna">^SB</span>.\r\nDodajemy elementy <span class="zmienna">H1</span>\r\noraz <span class="zmienna">P</span> obejmujące\r\nnazwisko autora oraz tekst życiorysu.\r\nNastępnie przesuwamy kursor wewnątrz definicji stylów i\r\naktywujemy skrót <span class="zmienna">^NP</span>. Otrzymamy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STYLE type="text/css"&gt;\r\n&lt;!--\r\nP {\r\n\r\n}\r\n--&gt;\r\n&lt;/STYLE&gt;</pre>\r\n\r\n<p>Teraz aktywujemy skrót <span class="zmienna">^BF</span>.\r\nWewnątrz elementu <span class="zmienna">STYLE</span> otrzymamy\r\nnastępującą definicję:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STYLE type="text/css"&gt;\r\n&lt;!--\r\nP {\r\n    font-family : Verdana;\r\n    font-style  : normal;\r\n    font-weight : normal;\r\n    font-size   : 10pt;\r\n}\r\n--&gt;\r\n&lt;/STYLE&gt;</pre>\r\n\r\n<p>Korzystając ze skrótów\r\n<span class="zmienna">^BT</span> oraz\r\n<span class="zmienna">^BM</span> definiujemy atrybuty akapitu i marginesy.</p>\r\n\r\n<h5>Ćwiczenie 14</h5>\r\n\r\n<p>Przygotuj stronę WWW z życiorysem Juliusza Verne.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-14.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 14.\r\nStyle modyfikujące kolory</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Podobnie jak poprzednio,\r\notwieramy dokument tekstowy i aktywujemy skrót\r\n<span class="zmienna">^SB</span>.</p>\r\n\r\n<p>Dodajemy kod HTML, po czym przechodzimy do arkuszy stylów.\r\nWstawiamy kod stylów, dokument zapisujemy i korzystając\r\nz klawisza <span class="zmienna">F9</span>\r\noglądamy w przeglądarce.</p>\r\n\r\n<p>Jako dwa ostatnie ćwiczenia proponuję samodzielne wykonanie\r\nstron przedstawionych na rysunkach 15 oraz 16.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-15.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 15.\r\nOpowiadanie p.t. <span class="tytul">&bdquo;Zew krwi&rdquo;</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/03-16.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 16.\r\nWierszyk sformatowany przy użyciu stylów</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Nie ma co separować nauki CSS od HTML. Sądzę, że warto\r\nuczą się HTML od razu wzbogacać tworzone strony o style.\r\nPodobnie jak w przypadku HTML, korzystanie z walidatora\r\nudostępnianego przez organizację W3c:\r\n<a href="http://jigsaw.w3.org/css-validator/">http://jigsaw.w3.org/css-validator/</a>\r\nuchroni nas przed brnięciem w złym kierunku.</p>\r\n\r\n<p>Oczywiście ucząc się HTML i CSS możemy się posługiwać\r\ndowolnym edytorem plików tekstowych.\r\nNawet notatnikiem.\r\nJednak wówczas, pisanie znaczników będzie naprawdę katorżniczą pracą.</p>', 'html-cwiczenia-w-przygotowywaniu-dokumentow');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(4, 'Hiperłącza', 'Jednym z głównych powodów ogromnego zainteresowania Internetem\r\nu schyłku XX wieku była funkcjonalność hipertekstu.\r\nOto bez znajomości żadnych tajemniczych komend przeciętny użytkownik\r\nmógł wędrować po zasobach Internetu podążając ścieżką hiperłączy.\r\nW artykule przyjrzymy się nieco bliżej internetowym\r\nodnośnikom i przygotujemy kilka prostych witryn,\r\nwyjaśniających tworzenie hiperłączy.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Kartkowanie książek a surfowanie po sieci</a></li>\r\n<li><a href="#R2">2. Elementy składowe odsyłaczy</a></li>\r\n<li><a href="#R3">3. Hiperłącza - interaktywne odsyłacze</a></li>\r\n<li><a href="#R4">4. Hiperłącza wewnętrzne</a></li>\r\n<li><a href="#R5">5. Odwołania do stron w Internecie</a></li>\r\n<li><a href="#R6">6. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Kartkowanie książek a surfowanie po sieci</h3>\r\n\r\n<p>Hiperłącza, w żargonie internautów zwane linkami, kotwicami czy nawet - nieco żartobliwie - sznurkami,\r\nsą interaktywnymi odsyłaczami, znajdującymi się w treści dokumentu.\r\nSame odsyłacze nie są niczym nowym. Nowością jest ich interaktywność.</p>\r\n\r\n<p>W książkach i różnych innych publikacjach drukowanych\r\nmamy do czynienia z kilkoma rodzajami odsyłaczy.\r\nJednym z nich są zdania postaci:\r\n<em>dodatkowe informacje podano w rozdziale trzecim na stronie 234</em>.\r\nW celu podążenia za takim odsyłaczem, czytelnik\r\nmusi przekartkować książkę, by dotrzeć do podanej strony.</p>\r\n\r\n<p>Odsyłacze takie mogą się różnić dokładnością\r\nwskazania docelowej informacji (tytuł książki, strona, akapit),\r\numiejscowieniem w tekście (odsyłacze niekiedy są podawane w nawiasie i poprzedzone\r\nskrótem <em>por.</em>, a czasami w przypisach dolnych) oraz formatem.\r\nŁączą je natomiast następujące wspólne cechy:</p>\r\n\r\n<ul>\r\n<li>wskazują inne źródło informacji, do którego powinien odwołać się czytelnik,</li>\r\n\r\n<li>zawierają "adres" umożliwiający odnalezienie tegoż źródła.</li>\r\n</ul>\r\n\r\n<p>Główną cechą, jaka odróżnia hiperłącza internetowe od\r\nodsyłaczy książkowych jest to, że\r\nprzeniesienie do wskazywanych materiałów jest natychmiastowe.\r\nNie musimy nic szukać, ani przekartkowywać.\r\nWystarczy kliknąć myszą w taki odsyłacz, a bieżący dokument wyświetlany w przeglądarce\r\nzostanie zastąpiony dokumentem wskazywanym przez odsyłacz!\r\nKto wie, czy ta wygoda i prostota w przechodzeniu od dokumentu do dokumentu nie była\r\nnajistotniejszym czynnikiem warunkującym lawinowy wzrost popularności Internetu i WWW!</p>\r\n\r\n<h3 id="R2">2. Elementy składowe odsyłaczy</h3>\r\n\r\n<p>Spróbujmy przyjrzeć się elementom, z jakich składa się odsyłacz.\r\nW akapicie:</p>\r\n\r\n<pre class="syntax-highlight:xml">Metoda LoadFromFile odczytuje zawartość\r\npliku tekstowego o podanej nazwie\r\ni przypisuje kolejne wiersze elementom listy.\r\nPrzykłady użycia podano na stronie 123.</pre>\r\n\r\n<p>rolę odsyłacza pełni zdanie: <em>Przykłady użycia podano na stronie 123.</em>\r\nOdsyłacz ten kieruje uwagę czytelnika na stronę 123.\r\nMożemy powiedzieć, że "adresem" wskazywanym przez tenże odsyłacz jest strona 123 bieżącej książki.</p>\r\n\r\n<p>Drugą, nie mniej ważną, informacją podawaną przez odsyłacz jest tematyka\r\nwskazywanego dokumentu. W powyższym przykładzie rolę taką pełni początek zdania\r\n<em>Przykłady użycia</em>.</p>\r\n\r\n<p>Zatem odsyłacz zawiera dwie ważne informacje:</p>\r\n\r\n<ul>\r\n<li>"adres" określający jednoznacznie dokument, z którego należy skorzystać,</li>\r\n<li>tematykę poruszaną w podanym dokumencie.</li>\r\n</ul>\r\n\r\n<p>Innymi przykładami, które potwierdzają powyższe uwagi są indeksy,\r\numieszczane na końcach książek:</p>\r\n\r\n<pre class="syntax-highlight:xml">...\r\ntabela rekordów, 384\r\ntabele bazy danych, 403\r\ntestowanie serwera, 380\r\n...</pre>\r\n\r\n<p>Początkowe wyrazy, np. <em>tabela rekordów</em>, informują czytelnika o tematyce odsyłacza, zaś\r\nnumer strony stanowi adres.</p>\r\n\r\n<p>Umownie, odsyłacze możemy zapisać w postaci:</p>\r\n\r\n<pre class="syntax-highlight:xml">Odsyłacz\r\n  tematyka: <em>tabela rekordów</em>\r\n  adres:    <em>strona 384 bieżącej książki</em></pre>\r\n\r\n<p>czy</p>\r\n\r\n<pre class="syntax-highlight:xml">Odsyłacz\r\n  tematyka: <em>Przykłady użycia (funkcji LoadFromFile)</em>\r\n  adres:    <em>strona 123 bieżącej książki</em></pre>\r\n\r\n<h3 id="R3">3. Hiperłącza - interaktywne odsyłacze</h3>\r\n\r\n<p>Hiperłącza, które codziennie spotykamy wędrując po Internecie,\r\nodróżnia od tradycyjnych odsyłaczy interaktywność.\r\nOdsyłacze książkowe wymagają od czytelnika pewnego wysiłku:\r\nmusimy odnaleźć książkę, odpowiednią stronę oraz akapit.\r\nInteraktywność hiperłączy natomiast zwalnia nas z jakichkolwiek obowiązków związanych\r\nz odnajdywaniem wskazywanych informacji. W celu\r\ndotarcia do podanych źródeł informacji wystarczy\r\njedno kliknięcie.</p>\r\n\r\n<p>Poprzednie rozważania dotyczące budowy odsyłaczy pozostają prawdziwe\r\nrównież w stosunku do odnośników internetowych.\r\nHiperłącza również muszą zawierać "adres" wskazywanego\r\ndokumentu oraz informacje o jego zawartości.\r\nW ten sposób, nieco okrężną drogą dotarliśmy do elementu <span class="zmienna">A</span>\r\njęzyka HTML. Element ten ma postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="adres dokumentu"&gt;informacje o treści&lt;/A&gt;</pre>\r\n\r\n<p>Wartością atrybutu <span class="zmienna">href</span> (ang. <em>hypertext reference</em> -\r\nodwołanie hipertekstowe)\r\njest adres dokumentu, zaś zawartość elementu, umieszczana pomiędzy znacznikami\r\n<span class="zmienna">&lt;A ...&gt;</span> oraz\r\n<span class="zmienna">&lt;/A&gt;</span>, informuje o treści.</p>\r\n\r\n<p>W poniższych ćwiczeniach praktycznych należy zwrócić uwagę na fakt,\r\nże witryny zawierające hiperłącza zazwyczaj (choć nie zawsze!)\r\nskładają się z kilku osobnych plików.\r\nW celu uniknięcia zamieszania,\r\nnajlepiej każde z ćwiczeń wykonywać w osobnym folderze.</p>\r\n\r\n<h5>Ćwiczenie 1</h5>\r\n\r\n<p>Przygotuj dwie strony WWW. Strony te zatytułuj "Zielona" oraz "Czerwona" .\r\nNa stronie zielonej umieść hiperłącze odwołujące się do strony czerwonej.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/04-01.png" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nHiperłącze ze strony zielonej do czerwonej</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Pracę rozpocznijmy od dość oczywistej uwagi:\r\nna ćwiczenie to składają się dwa pliki.\r\nJeden z nich będzie zawierał stronę czerwoną, a drugi - zieloną.\r\nPliki te nazwiemy <span class="plik">zielona.html</span> oraz\r\n<span class="plik">czerwona.html</span>.</p>\r\n\r\n<p>Rozpoczynamy od wstawienia szablonu pustej strony\r\n(w programie <span class="program">NotH</span>, przedstawionym w poprzednim\r\nartykule dotyczącym języka HTML, aktywujemy skrót\r\n<span class="plik">Ctrl+S+A</span>), po czym\r\nw treści strony umieszczamy tytuł, dowolny tekst oraz\r\nmodyfikujemy kolor tła.\r\nUwagę swoją koncentrujemy na hiperłączu.</p>\r\n\r\n<p>Hiperłącze wstawiamy do dokumentu\r\n<span class="plik">zielona.html</span>,\r\nstosując skrót <span class="program">Ctrl+P+A</span>.</p>\r\n\r\n<p>Odwołanie to ma nas przenosić do strony czerwonej.\r\nZatem jako wartość parametru <span class="zmienna">href</span>\r\nnależy podać nazwę pliku zawierającego stronę czerwoną, czyli\r\n<span class="plik">czerwona.html</span>.</p>\r\n\r\n<p>Informacje o zawartości dokumentu, do którego przenosi nas hiperłącze\r\npodamy umieszczając na stronie tekst:</p>\r\n\r\n<pre class="syntax-highlight:xml">Dodatkowe informacje znajdziesz na stronie czerwonej.</pre>\r\n\r\n<p>Hiperłącze to będzie miało postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">Dodatkowe informacje znajdziesz na stronie &lt;A href="czerwona.html"&gt;czerwonej&lt;/A&gt;.</pre>\r\n\r\n<p>Jeśli teraz internauta odwiedzający tak przygotowaną stronę umieści wskaźnik myszy\r\nponad napisem <em>czerwonej</em>, wtedy kursor myszy przyjmie postać dłoni.\r\nKliknięcie myszą spowoduje wyświetlenie w oknie przeglądarki treści dokumentu\r\nzapisanego w pliku <span class="plik">czerwona.html</span>.</p>\r\n\r\n<p>Zwróćmy uwagę na zdanie informujące o hiperłączu <em>Dodatkowe...</em>.\r\nOczywiście w zdaniu tym zasięg elementu <span class="zmienna">A</span> może być inny.\r\nTreścią elementu <span class="zmienna">A</span> może być całe zdanie:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="czerwona.html"&gt;Dodatkowe informacje znajdziesz na stronie czerwonej&lt;/A&gt;.</pre>\r\n\r\n<p>jego fragment:</p>\r\n\r\n<pre class="syntax-highlight:xml">Dodatkowe informacje znajdziesz &lt;A href="czerwona.html"&gt;na stronie czerwonej&lt;/A&gt;.</pre>\r\n\r\n<p>lub tak jak to zrobiliśmy na początku - jedynie ostatni wyraz.\r\nMożemy również zmienić treść zdania, czy nawet zastąpić je lakonicznym\r\nkomunikatem postaci <em>Następna strona</em> czy <em>Dalej</em>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="czerwona.html"&gt;Dalej&lt;/A&gt;</pre>\r\n\r\n<p>Przyjmując jedno z powyższych rozwiązań, powinniśmy dążyć do tego, by\r\npodana informacja o odnośniku była jasna, zwięzła i czytelna.</p>\r\n\r\n<p>Dodajmy, że oba pliki, <span class="plik">zielona.html</span>\r\n\r\noraz <span class="plik">czerwona.html</span> należy umieścić w\r\ntym samym folderze.</p>\r\n\r\n<h5>Ćwiczenie 2</h5>\r\n\r\n<p>Przygotuj strony WWW prezentujące trzy wiersze Juliana Tuwima.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/04-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nStrona zawierająca hiperłącza do trzech podstron</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ćwiczenie to pokazuje, w jaki sposób wykonać spis treści zawierający hiperłącza.\r\nJak wynika z rysunku 2, mamy wykonać cztery dokumenty.\r\nPierwszy z nich to spis treści, a pozostałe trzy strony prezentują konkretne wierszyki.</p>\r\n\r\n<p>Najpierw przygotowujemy strony zawierające treść wierszy.\r\nPierwszą z nich, zawierającą wiersz pt. <em>Lokomotywa</em>, zapisujemy\r\nw pliku o nazwie <span class="plik">lokomotywa.html</span>.\r\nWiersz <em>Pan Hilary</em> umieszczamy w pliku <span class="plik">hilary.html</span>.\r\nWreszcie trzeci z wierszy, <em>Słoń Trąbalski</em>, zapisujemy w pliku\r\n\r\n<span class="plik">slon.html</span>.</p>\r\n\r\n<p>Strona główna ćwiczenia ma zawierać trzy hiperłącza.\r\nNazwijmy ją <span class="plik">wiersze.html</span>.\r\nSpis treści utworzymy umieszczając następujący kod HTML:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="lokomotywa.html"&gt;Lokomotywa&lt;/A&gt;&lt;BR&gt;\r\n&lt;A href="hilary.html"&gt;Pan Hilary&lt;/A&gt;&lt;BR&gt;\r\n&lt;A href="slon.html"&gt;Słoń Trąbalski&lt;/A&gt;&lt;BR&gt;</pre>\r\n\r\n<p>Jak widać, każde z powyższych hiperłączy\r\nzawiera tytuł wiersza.\r\nJeśli w tak przygotowanym spisie wierszy klikniemy dowolny tytuł,\r\nwówczas na ekranie pojawi się nowy dokument zawierający wybrany wiersz.\r\nNa przykład hiperłącze\r\n<span class="zmienna">&lt;A href="hilary.html"&gt;Pan Hilary&lt;/A&gt;</span>\r\npowoduje, że osoba odwiedzająca stronę zobaczy\r\nw oknie przeglądarki  napis <em>Pan Hilary</em>.\r\nNapis ten informuje o zawartości strony, do jakiej przenosi aktywacja hiperłącza.\r\nZ informacji widniejących na stronie powinno jasno wynikać, że chodzi o wiersz Juliana Tuwima\r\nzatytułowany <em>Pan Hilary</em>.\r\nAdresem dokumentu, który pojawi się na ekranie jest\r\nwartość atrybutu <span class="zmienna">href</span>,\r\nczyli <span class="plik">hilary.html</span>.\r\nHiperłącze to możemy traktować, jako polecenie dla przeglądarki:\r\n\r\n<em>jeśli internauta kliknie w napis <strong>Pan Hilary</strong>,\r\nwówczas wyświetl na ekranie stronę zapisaną w pliku o nazwie <strong>hilary.html</strong></em>.</p>\r\n\r\n<p>Kończąc ćwiczenie dodajmy, że kolejność, w jakiej tworzymy strony\r\nskładające się na to ćwiczenie nie jest istotna. Jako pierwszą, możemy\r\nutworzyć stronę ze spisem treści. W takim przypadku,\r\nnie powinien dziwić nas fakt, że pomimo utworzenia strony startowej,\r\nhiperłącza nie będą działały, aż do momentu przygotowania pozostałych plików.</p>\r\n\r\n<p>Również nazwy plików w ćwiczeniu odgrywają rolę drugoplanową.\r\nZamiast <span class="plik">wiersze.html</span> możemy użyć nazwy\r\n<span class="plik">glowna.html</span>, zaś wiersze możemy ponumerować:\r\n\r\n<span class="plik">1.html</span>,\r\n<span class="plik">2.html</span> oraz\r\n<span class="plik">3.html</span>.\r\nWażne jest, by wartościami atrybutów <span class="zmienna">href</span>\r\nbyły faktyczne nazwy plików.</p>\r\n\r\n<h5>Ćwiczenie 3</h5>\r\n\r\n<p>Przygotuj strony WWW prezentujące biografię oraz trzy wiersze\r\nCypriana Kamila Norwida.\r\nNa stronie głównej umieść spis treści, zaś na\r\npodstronach dodaj hiperłącza powrotne do strony głównej.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/04-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nStruktura serwisu z wierszami Cypriana Kamila Norwida</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Struktura serwisu jest przedstawiona na rysunku 3.\r\nStrona główna została oznaczona literą G, strona zawierająca bibliografię - literą B,\r\nzaś strony z wierszami - cyframi 1,2,3.\r\nStrzałki oznaczają połączenie stron hiperłączami, natomiast groty strzałek mówią o kierunku powiązania.\r\nStrzałki dwukierunkowe należy rozumieć jako powiązanie w obie strony: na stronie głównej\r\nznajduje się odnośnik do danej podstrony, zaś na podstronie jest umieszczony odnośnik\r\npowrotny do strony głównej.</p>\r\n\r\n<p>Omówienie ćwiczenia rozpocznijmy od ustalenia nazw plików.\r\nStronę główną nazwiemy <span class="plik">ckn.html</span> (od inicjałów poety),\r\nplik zawierający bibliografię - <span class="plik">bibliografia.html</span>,\r\na dokumenty przedstawiające wiersze\r\n<span class="plik">czulosc.html</span>,\r\n<span class="plik">modlitwa.html</span> oraz <span class="plik">mojpsalm.html</span>.\r\nJak widać, serwis tworzy pięć plików.</p>\r\n\r\n<p>Strona główna ma zawierać spis treści składający się z hiperłączy.\r\nOto kod, który należy umieścić w pliku <span class="plik">ckn.html</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H1&gt;Cyprian Kamil Norwid&lt;/H1&gt;\r\n&lt;P&gt;&lt;A href="biografia.html"&gt;Biografia&lt;/A&gt;&lt;/P&gt;\r\n&lt;H2&gt;Utwory&lt;/H2&gt;\r\n&lt;P&gt;\r\n  &lt;A href="modlitwa.html"&gt;MODLITWA&lt;/A&gt;&lt;BR&gt;\r\n  &lt;A href="mojpsalm.html"&gt;MÓJ PSALM&lt;/A&gt;&lt;BR&gt;\r\n  &lt;A href="czulosc.html"&gt;CZUŁOŚĆ&lt;/A&gt;&lt;BR&gt;\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Kod ten zawiera cztery odnośniki. Na stronie WWW widoczne będą napisy\r\n<em>Biografia</em>, <em>MODLITWA</em>,\r\n<em>MÓJ PSALM</em> oraz <em>CZUŁOŚĆ</em>.\r\nAktywacja powyższych hiperłączy będzie zastępowała stronę główną\r\njednym z plików tworzących serwis.</p>\r\n\r\n<p>Powrót do strony głównej wykonamy w następujący sposób:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="ckn.html"&gt;Powrót do strony głównej&lt;/A&gt;</pre>\r\n\r\n<h3 id="R4">4. Hiperłącza wewnętrzne</h3>\r\n\r\n<p>Nieco innym rodzajem hiperłączy są hiperłącza wewnętrzne.\r\nOdnoszą się one do konkretnego miejsca w dokumencie.\r\nWracając do analogii dotyczącej odnośników w tekstach drukowanych,\r\nmożemy porównać hiperłącze wewnętrzne do wskazania konkretnego miejsca w książce\r\n(np. pierwszego wyrazu w trzecim akapicie na stronie 14).\r\nNatomiast dotychczas omówione hiperłącza pełnią\r\nrolę odnośników wskazujących konkretną książkę.\r\nPo kliknięciu hiperłączy z ćwiczeń 1,2 lub 3\r\nwyświetlony zostanie początek dokumentu, tak jak byśmy otworzyli\r\nnową książkę na pierwszej stronie.</p>\r\n\r\n<p>Jeśli chcemy przeskoczyć do innego miejsca w tekście, to musimy to miejsce\r\nw jakiś sposób oznaczyć.\r\nW języku HTML istnieją dwie metody oznaczania fragmentów.\r\nJedna z nich, preferowana, wykorzystuje atrybut <span class="zmienna">id</span>.\r\nAtrybut ten możemy zdefiniować w odniesieniu do dowolnego elementu, na przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H1 id="wierzby"&gt;O czym szumią wierzby&lt;/H1&gt;</pre>\r\n\r\n<p>lub</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P id="wa"&gt;\r\nW moich snach,&lt;BR&gt;\r\nWciąż Warszawa,&lt;BR&gt;\r\nPełna ulic...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>W pierwszym przykładzie nagłówek <span class="zmienna">H1</span>,\r\nzawierający tytuł <em>O czym szumią wierzby</em>, został oznaczony\r\nidentyfikatorem <span class="zmienna">wierzby</span>.\r\nDrugi przykład przedstawia fragment piosenki zespołu\r\nLady Pank. Akapit z tekstem utworu\r\notrzymał identyfikator <span class="zmienna">wa</span>.</p>\r\n\r\n<p>Druga metoda identyfikowania fragmentu tekstu wykorzystuje element <span class="zmienna">A</span>.\r\nAtrybut <span class="zmienna">name</span>\r\n\r\nustala nazwę, za pomocą której możemy się odwołać do danego miejsca\r\nstrony WWW:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H1&gt;&lt;A name="wierzby"&gt;&lt;/A&gt;O czym szumią wierzby&lt;/H1&gt;</pre>\r\n\r\n<p>lub</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\n&lt;A name="wa"&gt;&lt;/A&gt;\r\nW moich snach,&lt;BR&gt;\r\nWciąż Warszawa,&lt;BR&gt;\r\nPełna ulic...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Zwróćmy uwagę, na zawartość elementów <span class="zmienna">A</span>.\r\nW dwóch powyższych przykładach. Ponieważ pomiędzy znacznikami\r\n<span class="zmienna">&lt;A href=""&gt;</span> oraz\r\n<span class="zmienna">&lt;/A&gt;</span>\r\nnie umieszczono żadnej treści, zatem na ekrenie nie będą one widoczne.\r\nTakie użycie elementu <span class="zmienna">A</span>\r\nsłuży jedynie identyfikacji miejsca, a nie tworzeniu hiperłączy.\r\nOczywiście element <span class="zmienna">A</span>\r\nmoże posiadać oba atrybuty:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A name="drama" href="shakespeare.html"&gt;Dramaty W. Szekspira&lt;/A&gt;</pre>\r\n\r\n<p>Wtedy jest on zarówno kotwicą jak i identyfikatorem miejsca.</p>\r\n\r\n<p>Pamiętajmy, by identyfikatory stosowane na jednej stronie\r\nbyły unikalne (atrybuty <span class="zmienna">id</span>\r\noraz <span class="zmienna">name</span>\r\n\r\nwspółdzielą przestrzeń nazewniczą!).</p>\r\n\r\n<p>Wiemy zatem, w jaki sposób zaznaczyć miejsce na stronie WWW. A jak się do niego odwołać?\r\nSłuży do tego znak # (hashmark). Umieszczamy go w adresie WWW po nazwie pliku a przed\r\nidentyfikatorem miejsca. Na przykład odnośnik:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="tv.html#dobranocka"&gt;Miś uszatek&lt;/A&gt;</pre>\r\n\r\n<p>wskazuje miejsce oznaczone identyfikatorem\r\n<span class="zmienna">dobranocka</span> w pliku <span class="zmienna">tv.html</span>.\r\nNa stronie <span class="plik">tv.html</span> powinien znajdować się\r\nidentyfikator:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P id="dobranocka"&gt;Na dobranoc, dobry wieczór, miś pluszowy...&lt;/P&gt;</pre>\r\n\r\n<p>(identyfikator ten może występować obok dowolnego znacznika, np.\r\n<span class="zmienna">H1</span>,\r\n<span class="zmienna">BR</span> czy <span class="zmienna">STRONG</span>).</p>\r\n\r\n<p>Aktywacja hiperłącza <em>Miś uszatek</em> spowoduje otwarcie\r\npliku <span class="plik">tv.html</span>, a następnie\r\nprzewinięcie dokumentu do miejsca, w którym pojawia się\r\nidentyfikator.</p>\r\n\r\n<h5>Ćwiczenie 4</h5>\r\n\r\n<p>Przygotuj stronę WWW przedstawiającą pięć wierszy Jana Brzechwy.\r\nWszystkie wiersze umieść w jednym pliku i poprzedź je\r\nspisem treści zawierającym hiperłącza wewnętrzne.\r\nRozwiązanie zapisz w pliku <span class="plik">brzechwa.html</span>.</p>\r\n\r\n<p>Tym razem zadanie polega na przygotowaniu jednego dokumentu HTML.\r\nWszystkie pięć wierszy mamy zapisać w jednym pliku, poprzedzając je\r\nspisem treści według następującego schematu:</p>\r\n\r\n<pre class="syntax-highlight:xml">spis treści\r\nwiersz pierwszy\r\nwiersz drugi\r\n...\r\nwiersz piąty</pre>\r\n\r\n<p>Każdy z wierszy umieszczamy na stronie stosując element <span class="zmienna">PRE</span>.\r\nTreść wiersza poprzedzamy tytułem umieszczonym wewnątrz elementu <span class="zmienna">H2</span>.\r\nKliknięcie tytułu wiersza w spisie treści ma nas przenosić do\r\ntekstu utworu. Musimy więc oznaczyć te fragmenty strony,\r\nod których rozpoczynają się wiersze.\r\nDobrym wyborem będzie umieszczenie identyfikatorów <span class="zmienna">id</span>\r\n\r\nw znacznikach zawierających tytuły wierszy.\r\nZatem wierszyk <em>Arbuz</em> otrzyma identyfikator <span class="zmienna">arbuz</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H2 id="arbuz"&gt;Arbuz&lt;/H2&gt;\r\n&lt;PRE&gt;\r\nW owocarni arbuz leży\r\nI złośliwie pestki szczerzy;\r\n...</pre>\r\n\r\n<p>Natomiast początek wierszyka pt. <em>Żuk</em>\r\nzaznaczymy identyfikatorem <span class="zmienna">zuk</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H2 id="zuk"&gt;Żuk&lt;/H2&gt;\r\n&lt;PRE&gt;\r\nDo biedronki przyszedł żuk,\r\nW okieneczko puk - puk - puk.\r\n...</pre>\r\n\r\n<p>Podobnie postępujemy w stosunku do pozostałych wierszy.</p>\r\n\r\n<p>Teraz wracamy na początek dokumentu i przystępujemy do\r\nprzygotowania spisu treści. W jaki sposób będą wyglądały\r\nadresy wskazujące początki wierszy?\r\nPrzyjrzyjmy się jak powstaje adres wiersza pt. <em>Arbuz</em>.\r\nPlik nazywa się <span class="plik">brzechwa.html</span>, stąd\r\natrybut <span class="zmienna">href</span> rozpocznie się\r\n<span class="zmienna">href="brzechwa.html</span>.\r\nPo nazwie pliku umieszczamy znak <span class="zmienna">#</span>,\r\npo którym następuje identyfikator fragmentu.\r\nW przypadku wiersza <em>Arbuz</em>,\r\nidentyfikatorem jest napis <span class="zmienna">arbuz</span>.\r\nCzyli atrybut <span class="zmienna">href</span> będzie miał postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">href="brzechwa.html#arbuz"</pre>\r\n\r\n<p>natomiast całe hiperłącze będzie następujące:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="brzechwa.html#arbuz"&gt;Arbuz&lt;/A&gt;</pre>\r\n\r\n<p>A zatem spis treści utworzymy umieszczając na początku strony\r\nponiższe pięć hiperłączy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H2&gt;&lt;A href="brzechwa.html#arbuz"&gt;Arbuz&lt;/A&gt;&lt;/H2&gt;\r\n&lt;H2&gt;&lt;A href="brzechwa.html#chrzaszcz"&gt;Chrząszcz&lt;/A&gt;&lt;/H2&gt;\r\n&lt;H2&gt;&lt;A href="brzechwa.html#foka"&gt;Foka&lt;/A&gt;&lt;/H2&gt;\r\n&lt;H2&gt;&lt;A href="brzechwa.html#zaba"&gt;Żaba&lt;/A&gt;&lt;/H2&gt;\r\n&lt;H2&gt;&lt;A href="brzechwa.html#zuk"&gt;Żuk&lt;/A&gt;&lt;/H2&gt;</pre>\r\n\r\n<p>Dodajmy, że z racji na to, iż hiperłącza dotyczą tego samego pliku,\r\nw którym się znajdują, użycie nazwy pliku nie jest konieczne.\r\nSpis treści w tym konkretnym przypadku możemy utworzyć z\r\nnieco krótszych hiperłączy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H2&gt;&lt;A href="#arbuz"&gt;Arbuz&lt;/A&gt;&lt;/H2&gt;</pre>\r\n\r\n<p>Jeśli chcielibyśmy po każdym wierszu umieścić odnośnik\r\nwskazujący spis treści, to należy ustalić identyfikator spisu treści:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H1 id="spis"&gt;Jan Brzechwa&lt;/H1&gt;</pre>\r\n\r\n<p>zaś wiersze zakończyć znacznikiem:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="brzechwa.html#spis"&gt;Spis treści&lt;/A&gt;</pre>\r\n\r\n<p>Rozwiązanie takie jest zapisanie w pliku <span class="plik">brzechwa2.html</span>.</p>\r\n\r\n<p>Internetowe odsyłacze mogą wskazywać pliki różnych formatów.\r\nNie jest wymagane, by plik, którego nazwę podajemy jako\r\nwartość atrybutu <span class="zmienna">href</span>, był\r\nstroną internetową.\r\nZarówno pliki tekstowe, spakowane, multimedialne\r\njak i dowolne inne mogą być wskazywane przez hiperłącze.\r\nAkcje podejmowane przez przeglądarkę\r\nsą różne dla różnych typów plików i\r\nzależą od\r\noprogramowania zainstalowanego na komputerze.</p>\r\n\r\n<h5>Ćwiczenie 5</h5>\r\n\r\n<p>Przygotuj stronę WWW publikującą informacje na temat\r\nalgorytmu MD5. Na stronie umieść hiperłącza do\r\npliku tekstowego <span class="plik">rfc1321.txt</span>\r\nzawierającego szczegółowy opis algorytmu oraz do archiwum\r\n<span class="plik">md5.zip</span>, w którym znajduje się program\r\n<span class="program">md5</span>.</p>\r\n\r\n<p>Rozwiązanie ćwiczenia składa się z jednego pliku <span class="zmienna">md5.html</span>.\r\nW pliku tym wpisujemy opis algorytmy, po czym dodajemy na końcu dwa odnośniki:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="rfc1321.txt"&gt;Opis algorytmu MD5&lt;/A&gt;\r\n&lt;A href="md5.zip"&gt;Program md5&lt;/A&gt;</pre>\r\n\r\n<h3 id="R5">5. Odwołania do stron w Internecie</h3>\r\n\r\n<p>Bardzo istotnym faktem jest to, że odnośnik hipertekstowy może wskazywać dowolny dokument znajdujący się\r\nw Internecie. Jako twórcy stron internetowych nie jesteśmy ograniczeni do\r\nplików przygotowanych własnoręcznie.\r\nKażda strona w Internecie może stanowić cel naszych odnośników.</p>\r\n\r\n<p>Na przykład firma Lego publikuje informacje dotyczące serii Bionicle\r\nna stronie\r\n<a href="http://www.bionicle.com">http://www.bionicle.com</a>.\r\nJeśli chcemy skierować pod ten adres gości naszej witryny, to wystarczy\r\nprzygotować następujący odnośnik:</p>\r\n\r\n<pre class="syntax-highlight:xml">Moje ulubione &lt;A href="http://www.bionicle.com"&gt;klocki&lt;/A&gt;.</pre>\r\n\r\n<p>Podobnie, na stronę Białej Gwiazdy, trafią wszyscy, którzy\r\nklikną odsyłacz:</p>\r\n\r\n<pre class="syntax-highlight:xml">Jazda! Jazda!\r\n&lt;A href="http://www.wisla.krakow.pl"&gt;Biała Gwiazda&lt;/A&gt;</pre>\r\n\r\n<p>Oczywiście w powyższych przykładach adres strony, do jakiej zostanie odesłana\r\nosoba klikająca hiperłącze, nie jest widoczny w oknie przeglądarki\r\n(widać go jedynie w wierszu stanu przeglądarki, w momencie najechania nad odnośnik kursorem myszy).\r\nW jaki sposób przygotować hiperłącze, które będzie zawierało informację o adresie?\r\nWystarczy w treści hiperłącza powtórzyć adres, na przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="http://www.onet.pl"&gt;http://www.onet.pl&lt;/A&gt;</pre>\r\n\r\n<p>lub</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="http://www.bionicle.com"&gt;http://www.bionicle.com&lt;/A&gt;</pre>\r\n\r\n<h5>Ćwiczenie 6</h5>\r\n\r\n<p>Przygotuj witrynę prezentującą odnośniki do trzech polskich wyszukiwarek\r\ninternetowych.</p>\r\n\r\n<p>Pierwsza porcja odnośników zawiera nazwy portali:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="http://www.onet.pl"&gt;Onet&lt;/A&gt;\r\n&lt;A href="http://www.wp.pl"&gt;Wirtualna Polska&lt;/A&gt;\r\n&lt;A href="http://www.interia.pl"&gt;Interia&lt;/A&gt;</pre>\r\n\r\n<p>Jeśli chcemy, by adresy serwisów były widoczne na stronie,\r\nto należy użyć hiperłączy następujących:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="http://www.onet.pl"&gt;http://www.onet.pl&lt;/A&gt;\r\n&lt;A href="http://www.wp.pl"&gt;http://www.wp.pl&lt;/A&gt;\r\n&lt;A href="http://www.interia.pl"&gt;http://www.interia.pl&lt;/A&gt;</pre>\r\n\r\n<p>Ostatnie z omawianych ćwiczeń prezentuje możliwość otwierania\r\nhiperłącza w nowym oknie przeglądarki.</p>\r\n\r\n<h5>Ćwiczenie 7</h5>\r\n\r\n<p>Przygotuj serwis poświęcony angielskim piosenkom dla dzieci.\r\nNa stronie umieść spis treści. Kliknięcie tytułu piosenki\r\nznajdującego się na spisie, ma powodować otworzenie nowego okna przeglądarki,\r\nzawierającego wybraną piosenkę.\r\nDane do ćwiczenia stanowią trzy pliki tekstowe <span class="plik">sixpence.txt</span>,\r\n<span class="plik">hush.txt</span> oraz <span class="plik">littlebopeep.txt</span>\r\n\r\nzawierające teksty piosenek.</p>\r\n\r\n<p>Rozwiązanie ćwiczenia polega na utworzeniu czterech plików w formacie html.\r\nPierwszy z nich nazwiemy <span class="plik">songs.html</span>.\r\nBędzie to strona główna zawierająca spis treści.\r\nPozostałe trzy pliki nazwiemy\r\n<span class="plik">sixpence.html</span>,\r\n<span class="plik">hush.html</span> i <span class="plik">littlebopeep.html</span>.</p>\r\n\r\n<p>Najpierw przygotowujemy trzy pliki z piosenkami. Na końcu każdego z nich\r\ndodajemy odnośnik do strony głównej:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="songs.html"&gt;back&lt;/A&gt;</pre>\r\n\r\n<p>Następnie przystępujemy do utworzenia strony głównej.\r\nHiperłącza spisu treści wzbogacamy o atrybut <span class="zmienna">target</span>.\r\nJeśli wartością tego atrybutu jest <span class="zmienna">_blank</span>,\r\nwtedy otwierany dokument pojawi się w nowym oknie przeglądarki.\r\nSpis treści przyjmie zatem postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="sixpence.html" target="_blank"&gt;Sing a song of sixpence&lt;/A&gt;\r\n&lt;A href="hush.html" target="_blank"&gt;Hush, little baby&lt;/A&gt;\r\n&lt;A href="littlebopeep.html" target="_blank"&gt;Little Bo Peep&lt;/A&gt;</pre>\r\n\r\n<p>Na końcu strony głównej dodajmy jeszcze odnośnik,\r\nktóry pomoże zainteresowanym osobom odnaleźć\r\nwiele innych angielskich piosenek dla dzieci:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\nYou will find many other songs at\r\n&lt;A href="http://www.zelo.com/family/nursery/index.asp"\r\ntarget="_blank"&gt;http://www.zelo.com/family/nursery/index.asp&lt;/A&gt;.\r\n&lt;/P&gt;</pre>\r\n\r\n<h3 id="R6">6. Podsumowanie</h3>\r\n\r\n<p>Hiperłącza sprawiają, że publikacje pojawiające się w Internecie stanowią w istocie\r\nnową jakość w stosunku do materiałów drukowanych.\r\nMedia elektroniczne umożliwiają tworzenie indeksów, bibliografii i odnośników\r\nw taki sposób, by czytelnik nie musiał tracić czasu na błądzenie między regałami i\r\nprzewracanie kartek.\r\nAż dziwnym wydaje się fakt, że wszystko\r\nto zawdzięczamy znacznikowi <span class="zmienna">A</span>,\r\nktóry przetrwał w niezmienionej postaci od początków hipertekstu.\r\nMam nadzieję, że dzisiejsza seria ćwiczeń pomoże\r\npoczątkującym webmasterom opanować umiejętności potrzebne do samodzielnego\r\nwykorzystywania hiperłączy.</p>', 'hiperlacza');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(5, 'Tabele HTML', 'Jednym z najważniejszych kroków nauki języka HTML jest opanowanie umiejętności tworzenia tabel. Wprowadzone do języka w celu ułatwienia prezentacji danych, tabele obecnie stanowią główne narzędzie do projektowania układu witryn.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Struktura tabeli HTML</a></li>\r\n<li><a href="#R2">2. Definiowanie stylu obramowania</a></li>\r\n<li><a href="#R3">3. Klasy znaczników</a></li>\r\n<li><a href="#R4">4. Atrybuty colspan oraz rowspan</a></li>\r\n<li><a href="#R5">5. Projekty witryn</a></li>\r\n<li><a href="#R6">6. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Struktura tabeli HTML</h3>\r\n\r\n<p>Tabela HTML składa się\r\nz wierszy podzielonych na komórki.\r\nCałą tabelę otaczamy znacznikami <span class="zmienna">&lt;TABLE&gt;</span>\r\noraz <span class="zmienna">&lt;/TABLE&gt;</span>, wewnątrz umieszczając\r\nwiersze.\r\nDo definiowania wierszy stosujemy znaczniki <span class="zmienna">&lt;TR&gt;</span>\r\ni <span class="zmienna">&lt;/TR&gt;</span>.\r\nNazwa znacznika <span class="zmienna">TR</span>\r\njest skrótem <span class="ang">Table Row</span> - wiersz tabeli.\r\n\r\nKomórki umieszczamy pomiędzy\r\n\r\n<span class="zmienna">&lt;TD&gt;</span> oraz <span class="zmienna">&lt;/TD&gt;</span>\r\n(ang. <span class="ang">Table Data</span> - dane tabeli).\r\nPrzystąpmy do wykonania pierwszej tabeli.</p>\r\n\r\n<h5>Ćwiczenie 1</h5>\r\n\r\n<p>Wykonaj tabelę widoczną na rysunku 1.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-01.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nTabela 2&times;2</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tabela ta składa się z dwóch wierszy oraz dwóch kolumn.\r\nPo umieszczeniu w treści strony\r\n(tj. pomiędzy znacznikami <span class="zmienna">BODY</span>)\r\nznaczników <span class="zmienna">TABLE</span> przechodzimy do ustalenia zawartości tabeli.\r\nZnacznikami <span class="zmienna">TR</span> definiujemy pierwszy wiersz,\r\nw którym umieszczamy dwie komórki. Komórki otaczamy znacznikami\r\n<span class="zmienna">&lt;TD&gt;</span> oraz\r\n<span class="zmienna">&lt;/TD&gt;</span>.\r\nW treści komórek wprowadzamy litery A oraz B.\r\nPoniżej pierwszego wiersza (tj. pod znacznikiem\r\n<span class="zmienna">&lt;/TR&gt;</span>, ale przed\r\nznacznikiem <span class="zmienna">&lt;/TABLE&gt;</span>)\r\numieszczamy kod drugiego wiersza tabeli. Kod drugiego wiersza różni się jedynie zawartością\r\nkomórek <span class="zmienna">TD</span>.\r\nOto kod, jaki powinniśmy otrzymać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE border="1"&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;A&lt;/TD&gt;\r\n    &lt;TD&gt;B&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;C&lt;/TD&gt;\r\n    &lt;TD&gt;D&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>Zauważmy, że znacznik otwierający tabelę posiada atrybut\r\n<span class="zmienna">border="1"</span>.\r\nAtrybut ten włącza widoczność krawędzi tabeli.\r\nJest on wygodny do sprawdzania poprawności kodu HTML.\r\nWłączając widoczność wszystkich krawędzi tabeli, widzimy czy komórki\r\ntworzą zaplanowany przez nas układ.</p>\r\n\r\n<p>Korzystając z programu <span class="program">NotH</span>\r\nnależy zapamiętać skróty podane w tabeli 1.</p>\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>lp.</th><th>Element</th><th>Kod HTML</th><th>Skrót</th><th>Zapis skrótu</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>lp.</th><th>Element</th><th>Kod HTML</th><th>Skrót</th><th>Zapis skrótu</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Tabela</td>\r\n\r\n<td><span class="zmienna">&lt;TABLE&gt;&lt;/TABLE&gt;</span></td>\r\n\r\n<td>Ctrl+W+T</td>\r\n\r\n<td>^WT</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Wiersz tabeli</td>\r\n\r\n<td><span class="zmienna">&lt;TR&gt;&lt;/TR&gt;</span></td>\r\n\r\n<td>Ctrl+W+R</td>\r\n\r\n<td>^WR</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Komórka tabeli</td>\r\n\r\n<td><span class="zmienna">&lt;TD&gt;&lt;/TD&gt;</span></td>\r\n\r\n<td>Ctrl+W+D</td>\r\n\r\n<td>^WD</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Komórka nagłówkowa</td>\r\n\r\n<td><span class="zmienna">&lt;TH&gt;&lt;/TH&gt;</span></td>\r\n\r\n<td>Ctrl+W+H</td>\r\n\r\n<td>^WH</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Podpis tabeli</td>\r\n\r\n<td><span class="zmienna">&lt;CAPTION&gt;&lt;/CAPTION&gt;</span></td>\r\n\r\n<td>Ctrl+W+C</td>\r\n\r\n<td>^WC</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nPodstawowe elementy HTML dotyczące tabel i ich skróty w programie <span class="program">NotH</span></p>\r\n</div>\r\n\r\n\r\n\r\n<h5>Ćwiczenie 2</h5>\r\n\r\n<p>Wykonaj tabelę o trzech wierszach i jednej kolumnie (3&times;1).\r\nW komórkach umieść litery X, Y, Z.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nTabela 3&times;1</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ponieważ tabela ma zawierać trzy wiersze, zatem musimy trzykrotnie użyć\r\nelementu <span class="zmienna">TR</span>.\r\nKażdy wiersz zawiera jedną komórkę, więc wewnątrz\r\nelementów <span class="zmienna">TR</span>\r\numieszczamy po jednym elemencie <span class="zmienna">TD</span>.\r\nOto wynikowy kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE border="1"&gt;\r\n  &lt;TR&gt;&lt;TD&gt;X&lt;/TD&gt;&lt;/TR&gt;\r\n  &lt;TR&gt;&lt;TD&gt;Y&lt;/TD&gt;&lt;/TR&gt;\r\n  &lt;TR&gt;&lt;TD&gt;Z&lt;/TD&gt;&lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<h5>Ćwiczenie 3</h5>\r\n\r\n<p>Wykonaj tabelę o dwóch wierszach i pięciu kolumnach (2&times;5).\r\nW komórkach umieść kolejne liczby naturalne.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nTabela 2&times;5</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Wewnątrz elementu <span class="zmienna">TABLE</span>\r\numieszczamy dwa elementy <span class="zmienna">TR</span>.\r\nKażdy z wierszy zawiera pięć elementów <span class="zmienna">TD</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE border="1"&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;1&lt;/TD&gt;\r\n    &lt;TD&gt;2&lt;/TD&gt;\r\n    &lt;TD&gt;3&lt;/TD&gt;\r\n    &lt;TD&gt;4&lt;/TD&gt;\r\n    &lt;TD&gt;5&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;6&lt;/TD&gt;\r\n    &lt;TD&gt;7&lt;/TD&gt;\r\n    &lt;TD&gt;8&lt;/TD&gt;\r\n    &lt;TD&gt;9&lt;/TD&gt;\r\n    &lt;TD&gt;10&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>Wspomniany atrybut <span class="zmienna">border</span>\r\nuwidacznia krawędzie tabeli. Dzięki temu możemy stwierdzić, czy\r\ntworzona tabela jest zgodna z oczekiwaniami.\r\nJednakże format krawędzi pozostawia wiele do życzenia.\r\nPrzejdźmy zatem do ustalenia stylów, nadających odpowiedni format krawędziom.</p>\r\n\r\n<h3 id="R2">2. Definiowanie stylu obramowania</h3>\r\n\r\n<p>Obramowanie tabeli definiujemy ustalając odpowiednie style.\r\nRozpocznijmy od zbadania formatu tabeli pozbawionej atrybutu <span class="zmienna">border</span>.</p>\r\n\r\n<h5>Ćwiczenie 4</h5>\r\n\r\n<p>Wykonaj tabelę prezentującą najdłuższe rzeki świata. W tabeli umieść\r\noprócz nazwy rzeki także jej długość oraz powierzchnię dorzecza.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-04.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nTabela z podpisem <span class="zmienna">CAPTION</span> i bez atrybutu <span class="zmienna">border</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>W pierwszym wierszu tabeli umieścimy nazwy kolumn, a w pozostałych informacje o rzekach.\r\nDane każdej rzeki znajdą się w osobnym wierszu tabeli.\r\nW ćwiczeniu tym wprowadzimy kolejny element języka HTML związany z tabelami.\r\nZnaczniki <span class="zmienna">&lt;CAPTION&gt;</span>\r\noraz <span class="zmienna">&lt;/CAPTION&gt;</span> wzbogacają tabelę o podpis.\r\nNależy pamiętać, by umieszczać je bezpośrednio po znaczniku\r\n<span class="zmienna">&lt;TABLE&gt;</span>\r\notwierającym tabelę.</p>\r\n\r\n<p>Wygląd tabeli został przedstawiony na rysunku 4, zaś listing 1\r\nprezentuje kilka pierwszych wierszy kodu HTML.</p>\r\n\r\n<p>Zauważmy, że domyślnie, krawędzie tabeli nie są widoczne.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;CAPTION&gt;\r\n    Najdłuższe rzeki świata\r\n  &lt;/CAPTION&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;Nazwa&lt;/TD&gt;\r\n    &lt;TD&gt;długość&lt;BR&gt; w km&lt;/TD&gt;\r\n    &lt;TD&gt;pow. dorzecza&lt;BR&gt;w tys. km &lt;SUP&gt;2&lt;/SUP&gt;&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;Nil&lt;/TD&gt;\r\n    &lt;TD&gt;6671&lt;/TD&gt;\r\n    &lt;TD&gt;2870&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;Missisipi (od żródeł Missouri)&lt;/TD&gt;\r\n    &lt;TD&gt;6418&lt;/TD&gt;\r\n    &lt;TD&gt;3275&lt;/TD&gt;\r\n  ...\r\n  (wiersze dotyczące kolejnych rzek)\r\n  ...\r\n&lt;/TABLE&gt;</pre>\r\n<p class="podpis">\r\nListing 1.\r\nTabela zawierająca zestawienie najdłuższych rzek.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>W jaki zatem sposób uwidocznić krawędzie tabeli? Należy dokument wzbogacić o\r\ndefinicję stylów, zmieniającą wartość atrybutu <span class="zmienna">border</span>\r\nznacznikom <span class="zmienna">TABLE</span>\r\noraz <span class="zmienna">TD</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">TABLE, TD {\r\n    border: solid black 2px;\r\n}</pre>\r\n\r\n<p>Selektorem powyższej definicji stylu są dwa znaczniki <span class="zmienna">TABLE</span>\r\ni <span class="zmienna">TD</span>. Decyduje o tym znak przecinka znajdujący się pomiędzy znacznikami.\r\nPodana definicja będzie się odnosiła do wszystkich elementów\r\n<span class="zmienna">TABLE</span> oraz <span class="zmienna">TD</span>, jakie występują w dokumencie.\r\nOczywiście definicję taką możemy również napisać w nieco dłuższej postaci:</p>\r\n\r\n<pre class="syntax-highlight:xml">TABLE {\r\n    border: solid black 2px;\r\n}\r\n\r\nTD {\r\n    border: solid black 2px;\r\n}</pre>\r\n\r\n<p>Jeszcze inny sposób zapisu podanych wartości polega na rozbiciu\r\natrybutu <span class="zmienna">border</span>\r\nna atrybuty <span class="zmienna">border-style</span>,\r\n<span class="zmienna">border-width</span> oraz\r\n<span class="zmienna">border-color</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">TABLE, TD {\r\n    border-style : solid;\r\n    border-width : 2px;\r\n    border-color : black;\r\n}</pre>\r\n\r\n<p>Atrybut <span class="zmienna">border-width</span> ustala oczywiście grubość krawędzi, zaś\r\n<span class="zmienna">border-color</span> - kolor.\r\nNatomiast atrybut\r\n<span class="zmienna">border-style</span> określa rodzaj linii.\r\nDopuszczalnymi wartościami są:\r\n\r\n<span class="zmienna">none</span>,\r\n<span class="zmienna">hidden</span>,\r\n<span class="zmienna">dotted</span>,\r\n<span class="zmienna">dashed</span>,\r\n<span class="zmienna">solid</span>,\r\n<span class="zmienna">double</span>,\r\n<span class="zmienna">groove</span>,\r\n<span class="zmienna">ridge</span>,\r\n<span class="zmienna">inset</span> oraz\r\n\r\n<span class="zmienna">outset</span>.</p>\r\n\r\n<p>Zwróćmy również uwagę na możliwość ustalania różnego\r\nformatu krawędzi lewej, prawej, dolnej i górnej z osobna.\r\nDo tego celu możemy użyć czterech atrybutów <span class="zmienna">border-left</span>,\r\n<span class="zmienna">border-right</span>,\r\n<span class="zmienna">border-top</span> i\r\n<span class="zmienna">border-bottom</span>\r\nlub dwunastu atrybutów postaci\r\n<span class="zmienna">border-right-style</span>,\r\n\r\n<span class="zmienna">border-right-width</span>,\r\n<span class="zmienna">border-right-color</span>\r\n(słowo <span class="zmienna">right</span>\r\nzastępujemy słowami <span class="zmienna">left</span>,\r\n<span class="zmienna">top</span> lub <span class="zmienna">bottom</span>).</p>\r\n\r\n<h5>Ćwiczenie 5</h5>\r\n\r\n<p>Przygotuj dwie tabele przedstawiające zestawienie jednostek względnych i bezwzględnych stosowanych\r\nw arkuszach stylów. Stronę wzbogać o style uwidaczniające\r\nkrawędzie tabeli, zaś komórki nagłówkowe napisz czcionką wytłuszczoną.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-05.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nKrawędzie tabeli zmodyfikowane stylami</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tabele, które mamy przygotować, są widoczne na rysunku 5.\r\nKażda z nich zawiera dwie kolumny. W pierwszej kolumnie umieszczamy nazwę jednostki, a w drugiej - jej opis.\r\nNazwę jednostki wytłuścimy stosując elementy <span class="zmienna">STRONG</span>.\r\nPierwsza z tabel będzie miała następujący kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;&lt;STRONG&gt;em&lt;/STRONG&gt;&lt;/TD&gt;\r\n    &lt;TD&gt;wielkość danej czcionki&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;&lt;STRONG&gt;ex&lt;/STRONG&gt;&lt;/TD&gt;\r\n    &lt;TD&gt;(x-height) wysokość danej czcionki&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;&lt;STRONG&gt;px&lt;/STRONG&gt;&lt;/TD&gt;\r\n    &lt;TD&gt;piksel danego monitora&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>Druga tabela różni się jedynie liczbą wierszy oraz danymi zawartymi w tabeli.\r\nDodając do dokumentu opisane wcześniej style otrzymamy witrynę przedstawioną\r\nna rysunku 5.</p>\r\n\r\n<p>Krawędzie widoczne na rysunku 5 są nieco dziwne.\r\nOtaczają całą tabelę oraz każdą komórkę, przy czym krawędzie sąsiadujących komórek\r\nnie łączą się.\r\nW celu złączenia krawędzi tabeli należy użyć atrybutu\r\n<span class="zmienna">border-collapse</span>.\r\nNadając mu wartość <span class="zmienna">collapse</span>\r\nwymusimy łączenie krawędzi sąsiadujących komórek.</p>\r\n\r\n<h5>Ćwiczenie 6</h5>\r\n\r\n<p>Przygotuj stronę z zestawieniem wielokrotności jednostek.\r\nTabelę sformatuj tak, jak na rysunku 6.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-06.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 6.\r\nTabela o "złączonych" krawędziach</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Najpierw przygotowujemy kod tabeli.\r\nTabela ta posiada trzy kolumny i szesnaście wierszy.\r\nPierwszy wiersz jest wierszem nagłówkowym, a pozostałe zawierają dane.\r\nFormat wszystkich wierszy z danymi jest identyczny, ale różni się od formatu wiersza nagłówkowego.\r\nW celu wprowadzenia innego formatu w pierwszym wierszu\r\nwykorzystamy element <span class="zmienna">TH</span> (ang. <span class="ang">Table Header</span> - nagłówek tabeli).\r\nKod dwóch początkowych wierszy tabeli jest następujący:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;TR&gt;\r\n    &lt;TH&gt;Przedrostek&lt;/TH&gt;\r\n    &lt;TH&gt;Oznaczenie&lt;/TH&gt;\r\n    &lt;TH&gt;Wielokrotność, podwielokrotność&lt;/TH&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;tera-&lt;/TD&gt;\r\n    &lt;TD&gt;T&lt;/TD&gt;\r\n    &lt;TD&gt;10&lt;SUP&gt;12&lt;/SUP&gt; = 1 000 000 000 000&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  ...\r\n&lt;TABLE&gt;</pre>\r\n\r\n<p>Dodając poniższe definicje stylów:</p>\r\n\r\n<pre class="syntax-highlight:xml">TABLE {\r\n    border-collapse : collapse;\r\n    border          : solid 2px black;\r\n}\r\n\r\nTD {\r\n    border  : solid 1px black;\r\n    padding : 5px;\r\n}\r\n\r\nTH {\r\n    border      : solid 1px black;\r\n    color       : white;\r\n    background  : black;\r\n    font-weight : bolder;\r\n    font-size   : 12pt;\r\n    padding     : 15px;\r\n}</pre>\r\n\r\n<p>otrzymamy witrynę przedstawioną na rysunku 6.\r\nTło komórek nagłówkowych zmienia wpis\r\n<span class="zmienna">background:   black;</span>, zaś atrybut <span class="zmienna">padding</span>\r\nzwiększa ilość miejsca otaczającego zawartość komórki.</p>\r\n\r\n<h3 id="R3">3. Klasy znaczników</h3>\r\n\r\n<p>W ćwiczeniu 6 spotkaliśmy się po raz pierwszy z sytuacją, w której pewne\r\nkomórki (tj. komórki nagłówka) mają mieć inny format od pozostałych.\r\nCo zrobić, gdy w tabeli pojawia się większa liczba tego typu komórek?\r\nProblem ten rozwiążemy stosując klasy znaczników.\r\nJest to metoda, pozwalająca niejako na zdefiniowanie nowych znaczników.\r\nWprowadzane znaczniki różnią się od istniejących formatem.</p>\r\n\r\n<p>Dokonujemy tego korzystając z atrybutu <span class="zmienna">class</span>.\r\nAtrybut ten możemy stosować w odniesieniu do każdego elementu języka HTML.\r\nJeśli chcemy wprowadzić nowy format dla pewnych elementów <span class="zmienna">TD</span>\r\nnależy nadać im klasę, np. <span class="zmienna">tytul</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD class="tytul"&gt;\r\nzawartość\r\n&lt;/TD&gt;</pre>\r\n\r\n<p>Format takiego elementu ustalamy stosując selektor <span class="zmienna">TD.tytul</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">TD.tytul {\r\n    definicje stylów...\r\n}</pre>\r\n\r\n\r\n<p>W podobny sposób możemy zdefiniować styl elementu <span class="zmienna">STRONG</span>\r\numieszczając w kodzie HTML klasę:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STRONG class="plik"&gt;php.ini&lt;/STRONG&gt;</pre>\r\n\r\n<p>zaś w arkuszach stylów ustalając format:</p>\r\n\r\n<pre class="syntax-highlight:xml">STRONG.plik {\r\n    ...style...\r\n}</pre>\r\n\r\n<p>W dokumencie może pojawić się dowolna liczba znaczników posiadających tę\r\nsamą nazwę klasy. Na przykład pięć znaczników <span class="zmienna">STRONG</span>\r\nwspomnianej klasy <span class="zmienna">plik</span>.\r\nDopuszczalne jest również stosowanie tej samej nazwy klasy w odniesieniu do\r\nróżnych znaczników. Kontynuując przykład klasy <span class="zmienna">plik</span>\r\n\r\nmoglibyśmy w dokumencie umieścić znaczniki:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;EM class="plik"&gt;ala&lt;/EM&gt;\r\n&lt;P class="plik"&gt;ma&lt;/P&gt;\r\n&lt;TABLE class="plik"&gt;kota&lt;/TABLE&gt;</pre>\r\n\r\n<p>Definiując style powyższych znaczników zastosujemy selektory:\r\n<span class="zmienna">EM.plik</span>,\r\n<span class="zmienna">P.plik</span> oraz\r\n<span class="zmienna">TABLE.plik</span>.\r\nMożemy również użyć selektora <span class="zmienna">.plik</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">.plik {\r\n    ...style...\r\n}</pre>\r\n\r\n<p>Selektor taki będzie modyfikował format wszystkich znaczników klasy <span class="zmienna">plik</span>.</p>\r\n\r\n<h5>Ćwiczenie 7</h5>\r\n\r\n<p>Przygotuj stronę pt. "Pies-Kot" zawierającą tabelę, o dwóch komórkach.\r\nKażdej komórce nadaj odmienny kolor tła.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-07.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 7.\r\nKomórki o różnych formatach</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tabela z rysunku 7 posiada dwa wiersze i jedną kolumnę.\r\nUstalmy nazwę klasy górnej komórki tabeli na <span class="zmienna">kot</span>,\r\nzaś dolnej na <span class="zmienna">pies</span>. Kod HTML tabeli będzie następujący:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;TR&gt;&lt;TD class="kot"&gt;KOT&lt;/TD&gt;&lt;/TR&gt;\r\n  &lt;TR&gt;&lt;TD class="pies"&gt;PIES&lt;/TD&gt;&lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>Teraz przechodzimy do definicji stylów. Zmieniamy kolor tła każdej komórki\r\nz osobna:</p>\r\n\r\n<pre class="syntax-highlight:xml">TD.kot {\r\n    background : lightgreen;\r\n}\r\n\r\nTD.pies {\r\n    background : yellow;\r\n}</pre>\r\n\r\n<h5>Ćwiczenie 8</h5>\r\n\r\n<p>Stosując klasy znaczników, przygotuj tabele o kolorystyce odpowiadającej flagom\r\nFrancji, Niemiec i Włoch.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-08.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 8.\r\nFlagi - modyfikacja tła i szerokości komórek</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Flagi są w istocie tabelami, które przedstawiają jedynie kolor tła.\r\nKomórki nie zawierają żadnych danych.\r\nW takim przypadku, wewnątrz komórek, należy umieścić spację <span class="zmienna">&amp;nbsp;</span>.\r\nW przeciwnym bowiem razie, tło komórki nie zostanie wyświetlone.\r\nPonadto należy zmodyfikować szerokość komórki\r\nstosując atrybut <span class="zmienna">width</span>.</p>\r\n\r\n<p>Każda z flag przedstawionych na rysunku jest w istocie tabelą o trzech wierszach i jednej kolumnie.\r\nOto kod flagi francuskiej:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;TR&gt;&lt;TD class="niebieski"&gt;&amp;nbsp;&lt;/TD&gt;&lt;/TR&gt;\r\n  &lt;TR&gt;&lt;TD class="bialy"&gt;&amp;nbsp;&lt;/TD&gt;&lt;/TR&gt;\r\n  &lt;TR&gt;&lt;TD class="czerwony"&gt;&amp;nbsp;&lt;/TD&gt;&lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>W stylach modyfikujemy szerokość wszystkich komórek tabeli\r\n(bez względu na klasę; także tych, bez przypisanej nazwy klasy):</p>\r\n\r\n<pre class="syntax-highlight:xml">TD {\r\n    width : 150px;\r\n}</pre>\r\n\r\n<p>a także dodajemy klasy\r\nmające na celu pokolorowanie flagi:</p>\r\n\r\n<pre class="syntax-highlight:xml">TD.niebieski {\r\n    color      : rgb(0,0,0);\r\n    background : rgb(59,66,215);\r\n}</pre>\r\n\r\n<p>Stosując przedstawione informacje możemy przystąpić do wykonania dwóch,\r\nnieco bardziej rozbudowanych ćwiczeń.</p>\r\n\r\n<h5>Ćwiczenie 9</h5>\r\n\r\n<p>Przygotuj witrynę prezentującą dane na temat kodu paskowego rezystorów\r\nwidoczną na rysunku 9.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-09.png" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 9.\r\nKod paskowy rezystorów</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h5>Ćwiczenie 10</h5>\r\n\r\n<p>Przygotuj witrynę prezentującą wyniki spotkań eliminacyjnych grupy 5\r\neliminacji mistrzostw świata przedstawioną na rysunku 10.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-10.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 10.\r\nEliminacje piłkarskich mistrzostw świata Korea i Japonia 2002</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R4">4. Atrybuty colspan oraz rowspan</h3>\r\n\r\n<p>Tabele omówione w ćwiczeniach od 1 do 10 charakteryzuje bardzo prosta struktura.\r\nKażdy wiersz zawiera identyczną liczbę komórek. Również każda z kolumn ma identyczną liczbę komórek.\r\nW przypadku, gdy tabela zawiera komórki rozciągające się na kilka wierszy lub kolumn,\r\nnależy użyć atrybutów <span class="zmienna">colspan</span>\r\n\r\noraz <span class="zmienna">rowspan</span>.\r\nAtrybuty te nadajemy komórkom <span class="zmienna">TD</span>\r\nlub <span class="zmienna">TH</span>.\r\nWartościami atrybutów są liczby całkowite, które określają liczbę wierszy lub kolumn,\r\nna jakie rozciąga się dana komórka.\r\nJeśli utworzymy komórkę:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD colspan="3"&gt;\r\n...\r\n&lt;/TD&gt;</pre>\r\n\r\n<p>to komórka ta będzie się rozciągała na trzy kolejne kolumny. Podobnie,\r\nkomórka:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD rowspan="5"&gt;\r\n...\r\n&lt;/TD&gt;</pre>\r\n\r\n<p>rozciąga się na pięć wierszy.</p>\r\n\r\n<h5>Ćwiczenie 11</h5>\r\n\r\n<p>Wykonaj tabelę przedstawioną na rysunku 11. W tabeli tej komórka o etykiecie\r\nA rozciąga się na dwie kolumny.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-11.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 11.\r\nKomórka A rozciąga się na dwie kolumny</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Przygotowujemy tabelę o dwóch wierszach i dwóch kolumnach.\r\nTabela taka była omówiona w ćwiczeniu 1.\r\nNastępnie pierwszej komórce w pierwszym wierszu dodajemy\r\natrybut <span class="zmienna">colspan</span>,\r\nzaś drugą komórkę z pierwszego wiersza usuwamy.\r\nOtrzymamy kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD colspan="2"&gt;A&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;B&lt;/TD&gt;\r\n    &lt;TD&gt;C&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>Zwróćmy uwagę na fakt, że w kodzie HTML występuje odpowiednio mniej\r\nkomórek.\r\nPierwsza komórka rozciąga się na dwie kolumny.\r\nStąd w kodzie pierwszego wiersza występuje o jedną komórkę mniej niż w kodzie wiersza drugiego.</p>\r\n\r\n<h5>Ćwiczenie 12</h5>\r\n\r\n<p>Wykonaj tabelę przedstawioną na rysunku 12. Komórki oznaczone XXX oraz YYY\r\nrozciągają się na dwie kolumny.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-12.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 12.\r\nKomórki XXX oraz YYY rozciągają się na dwie kolumny</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tabela z rysunku 12 ma trzy wiersze i dwie kolumny.\r\nW wierszu środkowym występują dwie komórki, zaś w wierszach pierwszym i trzecim -\r\ntylko jedna komórka o atrybucie <span class="zmienna">colspan="2"</span>.</p>\r\n\r\n<h5>Ćwiczenie 13</h5>\r\n\r\n<p>Wykonaj tabelę widoczną na rysunku 13.\r\nW tabeli tej komórka o etykiecie A rozciąga się na dwa wiersze.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-13.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 13.\r\nKomórka A rozciąga się na dwa wiersze</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Kod tabeli jest następujący:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TABLE&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD rowspan="2"&gt;A&lt;/TD&gt;\r\n    &lt;TD&gt;B&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n  &lt;TR&gt;\r\n    &lt;TD&gt;C&lt;/TD&gt;\r\n  &lt;/TR&gt;\r\n&lt;/TABLE&gt;</pre>\r\n\r\n<p>Tym razem pierwsza komórka pierwszego wiersza posiada atrybut\r\n<span class="zmienna">rowspan="2"</span>.\r\nTak jak i poprzednio w kodzie HTML tabeli "znika" jedna z komórek.\r\nTym razem jest to pierwsza komórka drugiego wiersza.</p>\r\n\r\n<h3 id="R5">5. Projekty witryn</h3>\r\n\r\n<p>Uważne wykonanie pierwszych trzynastu ćwiczeń\r\numożliwia rozpoczęcie projektowania układu witryny przy użyciu tabel.\r\nJedynym atrybutem, który okaże się konieczny, a nie został wprowadzony\r\nw ćwiczeniach poprzednich jest wyrównanie pionowe wiersza tabeli.</p>\r\n\r\n<p>Do ustalenia wyrównania pionowego służy atrybut\r\n<span class="zmienna">vertical-align</span>, którego poprawnymi wartościami są\r\nmiędzy innymi\r\n<span class="zmienna">top</span>,\r\n<span class="zmienna">bottom</span> oraz\r\n<span class="zmienna">middle</span>.</p>\r\n\r\n<h5>Ćwiczenie 14</h5>\r\n\r\n<p>Wykonaj witrynę zawierającą jedno menu z lewej strony.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-14-01.png" alt="" /><img src="artimg/05-14-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 14.\r\nUkład witryny WWW bez oraz po zastosowaniu stylów</p>\r\n</div>\r\n\r\n\r\n\r\n<h5>Ćwiczenie 15</h5>\r\n\r\n<p>Wykonaj witrynę zawierającą dwa menu z lewej strony.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/05-15-01.png" alt="" /><img src="artimg/05-15-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 15.\r\nDrugi przykład projektu układu witryny WWW</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R6">6. Podsumowanie</h3>\r\n\r\n<p>Mam nadzieję, że podana porcja ćwiczeń pozwoli na opanowanie\r\numiejętności posługiwania się tabelami w stopniu umożliwiającym\r\ntworzenie prostych witryn.\r\nDalsza nauka powinna dotyczyć techniki krojenia obrazków i umieszczania w tabeli.\r\nDzięki temu, będziemy mogli przygotowywać wygląd witryny w programach graficznych.</p>', 'tabele-html');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(6, 'Ilustrowanie witryn WWW', 'Niemal wszystkie współczesne witryny WWW\r\nzawierają elementy graficzne.\r\nIkony, tła, fragmenty obramowań,\r\nilustracje czy elementy tworzące menu to tylko niektóre z\r\nlicznych przykładów dekoracji pojawiających się na stronach\r\nWWW. Artykuł omawia podstawowe wiadomości dotyczące\r\numieszczania ilustracji na stronach WWW.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Pliki graficzne</a></li>\r\n<li><a href="#R2">2. Obrazy na stronach WWW</a></li>\r\n<li><a href="#R3">3. Element IMG</a></li>\r\n<li><a href="#R4">4. Najczęstsze błędy użycia elementu IMG</a></li>\r\n<li><a href="#R5">5. Umieszczanie zdjęć na stronach WWW</a></li>\r\n<li><a href="#R6">6. Tekst i ilustracje</a></li>\r\n<li><a href="#R7">7. Obrazy będące hiperłączami</a></li>\r\n<li><a href="#R8">8. Obrazy umieszczane w tabelach</a></li>\r\n<li><a href="#R9">9. Tabelki, obrazy i hiperłącza</a></li>\r\n<li><a href="#R10">10. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Pliki graficzne</h3>\r\n\r\n<p>Obrazy cyfrowe są zapisywane w wielu różnych formatach.\r\nNajbardziej popularnymi formatami są wprawdzie <span class="plik">JPEG</span>\r\noraz <span class="plik">GIF</span>, jednak w zależności od stosowanego oprogramowania\r\nw naszym systemie mogą pojawiać się dziesiątki innych formatów, takich jak\r\n<span class="plik">BMP</span>, <span class="zmienna">XCF</span>,\r\n<span class="zmienna">PSD</span>, <span class="plik">CDR</span>,\r\n<span class="plik">PNG</span> czy <span class="plik">TIFF</span>.\r\nFormat zapisu pliku graficznego możemy odgadnąć na podstawie rozszerzenie nazwy.</p>\r\n\r\n<p>Na stronach WWW możemy umieszczać trzy rodzaje plików graficznych:\r\n<span class="plik">.gif</span>,\r\n<span class="plik">.jpg</span> oraz <span class="plik">.png</span>.\r\nPozostałych plików nie należy stosować.</p>\r\n\r\n<p>Jeśli chcemy plik zapisany w innym formacie, na przykład <span class="plik">BMP</span>\r\n\r\numieścić na stronie WWW, należy go najpierw przekonwertować.\r\nNiemal wszystkie programy do obróbki plików graficznych umożliwiają dokonanie\r\nkonwersji formatu. Na przykład w <span class="program">Gimpie</span>\r\nwystarczy otworzyć plik <span class="plik">.bmp</span>,\r\npo czym wykonać operację <span class="opcja">Zapisz jako ...</span>.\r\nJeśli podamy nazwę zakończoną rozszerzeniem <span class="plik">.jpg</span>,\r\nwówczas plik zostanie zapisany w formacie <span class="plik">JPEG</span>.\r\nTaki obraz możemy umieścić na stronie WWW.</p>\r\n\r\n<h3 id="R2">2. Obrazy na stronach WWW</h3>\r\n\r\n<p>Umieszczenie ilustracji na stronie WWW rozpoczynamy oczywiście od przygotowania pliku\r\ngraficznego. Może to być zdjęcie lub rysunek, czy bardziej skomplikowana kompozycja\r\nstanowiąca połączenie kilku elementów wzbogaconych o efekty specjalne.\r\nGotową ilustrację zapisujemy w jednym z formatów <span class="plik">.jpg</span>,\r\n<span class="plik">.gif</span> lub <span class="plik">.png</span>.</p>\r\n\r\n<p>Gdy obraz jest gotowy, możemy przystąpić do umieszczenie go na stronie WWW.\r\nWitryna, na której umieścimy ilustrację będzie się składała z dwóch plików:\r\njednym z nich będzie plik <span class="plik">.html</span> zawierający opis strony\r\nw języku HTML, drugim - plik graficzny.</p>\r\n\r\n<p>Jeśli wykonamy stronę, na której umieścimy dziesięć ilustracji, wówczas\r\nwitryna taka będzie się składała z jedenastu plików: dziesięciu ilustracji oraz jednego\r\npliku <span class="plik">.html</span>.</p>\r\n\r\n<p>Po wykonaniu strony nie możemy usunąć plików graficznych. Do prawidłowego wyglądu strony potrzebne są\r\nzarówno plik o rozszerzeniu <span class="plik">.html</span> jak i pliki graficzne.\r\nPlik <span class="plik">.html</span> zawiera jedynie informacje, w którym miejscu należy umieścić\r\nilustrację. Sama ilustracja pochodzi z pliku graficznego.</p>\r\n\r\n<p>Strony WWW różnią się pod tym względem od wielu innych formatów.\r\nZarówno dokumenty edytora <span class="program">Word</span>, pliki\r\n<span class="plik">PDF</span> czy dokumenty tworzone w pakiecie <span class="program">Open Office</span>\r\nskładają się z pojedynczego pliku (nawet, jeśli zawierają ilustracje).\r\nW przypadku strony WWW musimy pamiętać, że strona zawierająca ilustracje wymaga\r\nosobnych plików graficznych. Nie istnieje metoda osadzenia plików\r\ngraficznych wewnątrz dokumentu HTML.</p>\r\n\r\n<h3 id="R3">3. Element IMG</h3>\r\n\r\n<p>Do umieszczania ilustracji na stronie WWW służy element <span class="zmienna">IMG</span>.\r\nElement ten posiada dwa obowiązkowe atrybuty: <span class="zmienna">src</span>\r\n\r\noraz <span class="zmienna">alt</span>.\r\nAtrybut <span class="zmienna">src</span> wskazuje plik graficzny, natomiast atrybut\r\n<span class="zmienna">alt</span> zawiera opis ilustracji. Opis ten jest\r\nskierowany do osób, które z jakichkolwiek powodów nie zobaczą ilustracji.\r\nPowodów, dla których oglądanie obrazów jest niemożliwe może być kilka:\r\ninternauta może być niewidomy, przeglądarka, jakiej używa może\r\nnie umożliwiać wyświetlania grafik, wreszcie oprogramowanie może\r\nignorować pliki graficzne z powodu ograniczeń transferu danych.\r\nPamiętajmy o dołączeniu do każdego pliku graficznego krótkiego opisu\r\nbędącego wartością atrybutu <span class="zmienna">alt</span>.\r\nW wielu przeglądarkach wartość atrybutu <span class="zmienna">alt</span>\r\njest wyświetlana po wskazaniu obrazu kursorem myszy.</p>\r\n\r\n<p>Jeśli zdjęcie, które chcemy umieścić na stronie WWW,\r\nprzedstawia kotka i jest zapisane w pliku <span class="plik">kot.jpg</span>,\r\nwówczas w odpowiednim miejscu strony umieszczamy kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="kot.jpg" alt="Zdjęcie kotka"&gt;</pre>\r\n\r\n<p>Zwróćmy uwagę na fakt, że element <span class="zmienna">IMG</span> jest\r\nelementem pustym. Oznacza to, że nie wolno go zamykać.\r\nNigdy w kodzie nie umieszczamy więc znacznika\r\n<span class="zmienna">&lt;/IMG&gt;</span>. Znacznik taki nie istnieje!</p>\r\n\r\n<p>W programie <span class="program">NotH</span> do wpisywania elementu\r\n<span class="zmienna">IMG</span> korzystamy ze skrótu <span class="shortcut">Ctrl+P+I</span>.</p>\r\n\r\n<h3 id="R4">4. Najczęstsze błędy użycia elementu IMG</h3>\r\n\r\n<p>Zanim przejdziemy do wykonania ćwiczeń, zatrzymajmy się na chwilę, by\r\nprzedyskutować ewentualne problemy, jakie mogą wystąpić.</p>\r\n\r\n<p>Pierwszym, często spotykanym błędem, jest literówka\r\n<span class="zmienna">scr</span>.\r\nAtrybut <span class="zmienna">src</span> jest skrótem angielskiego\r\nwyrazu <span class="ang">source</span> oznaczającego źródło.\r\nBłędu tego unikniemy stosując wspomniany skrót klawiszowy.</p>\r\n\r\n\r\n<p>Drugim zmartwieniem nękającym początkujących webmasterów\r\nsą nazwy plików. Problemy z nazwami plików są dość zdradliwe.\r\nUjawniają się zazwyczaj dopiero po przegraniu witryny na serwer.\r\nSkąd one wynikają? Z różnic pomiędzy systemami rodziny Windows, a systemami\r\nunixowymi. W systemie Windows nazwy plików mogą zawierać duże i małe litery.\r\nJednakże litery te nie są odróżniane.\r\nJeśli plik nazwiemy <span class="plik">Kot.jpg</span> (litera K jest duża),\r\nwtedy do pliku takiego możemy się odwoływać podając nazwę\r\n<span class="plik">kot.jpg</span>,\r\n<span class="plik">KOT.jpg</span>,\r\n<span class="plik">kot.JPG</span> czy jakąkolwiek inną kombinację\r\nliter dużych i małych.\r\nPowyższe stwierdzenie "odwoływać" dotyczy dowolnej aplikacji działającej w systemie nie tylko\r\nstron WWW i przeglądarki.\r\nW szczególności, na stronie WWW możemy umieścić podane zdjęcie stosując\r\ndowolny z poniższych zapisów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="Kot.jpg" alt="Zdjęcie kota"&gt;\r\n&lt;IMG src="KOT.jpg" alt="Zdjęcie kota"&gt;\r\n&lt;IMG src="kot.JPG" alt="Zdjęcie kota"&gt;</pre>\r\n\r\n<p>Dopóki pracujemy w systemie Windows, dopóty wszystko działa poprawnie.\r\nJeśli natomiast witrynę przekopiujemy na serwer pracujący w systemie rodziny unix, np. Linux,\r\nwtedy spośród powyższych odwołań poprawne będzie jedynie:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="Kot.jpg" alt="Zdjęcie kota"&gt;</pre>\r\n\r\n<p>Dzieje się tak dlatego, że w systemach unixowych wielkość liter występujących w nazwach plików\r\njest odróżniana. W jednym folderze możemy zapisać pliki\r\n\r\n<span class="plik">kot.jpg</span>,\r\n<span class="plik">Kot.jpg</span> oraz\r\n<span class="plik">KOT.jpg</span>.\r\nJeśli plik nazywa się <span class="plik">Kot.jpg</span>, to w kodzie HTML\r\nmusimy używać nazwy <span class="plik">Kot.jpg</span>.\r\nŻadna inna nazwa, np.:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="kot.jpg" alt="Zdjęcie kota"&gt;\r\n&lt;IMG src="KOT.jpg" alt="Zdjęcie kota"&gt;\r\n&lt;IMG src="kot.JPG" alt="Zdjęcie kota"&gt;</pre>\r\n\r\n<p>nie da oczekiwanego efektu!</p>\r\n\r\n\r\n<p>Jak się w tym wszystkim połapać? Czy musimy uczyć się nazw plików\r\ngraficznych występujących na stronie WWW na pamięć?\r\nOczywiście nie.\r\nWystarczy stosować jasne reguły nazywania plików.</p>\r\n\r\n<p>Pamiętajmy o tym, by w nazwach plików używać jedynie\r\nmałych liter alfabetu łacińskiego, cyfr, minusów oraz znaków podkreślenia.\r\nSzczególną uwagę należy zwrócić na unikanie polskich znaków, spacji\r\noraz wielkich liter.\r\nW ten sposób wyeliminujemy kłopoty dotyczące nazw plików.</p>\r\n\r\n<p>Przykładowymi nazwami, które spełniają powyższe reguły są:</p>\r\n\r\n<pre class="syntax-highlight:xml">kot.jpg\r\nzachod_slonca.jpg\r\ntrojkat-rownoboczny.png\r\nstrona_glowna_logo.gif\r\nfoto-034.jpg</pre>\r\n\r\n<p>Niestety, pracując w systemie Windows nie widzimy faktycznych liter występujących w nazwie pliku.\r\nJeśli plik nazwiemy <span class="plik">lis.JPG</span>,\r\nto eksplorator systemu Windows wyświetli tenże plik jako <span class="plik">lis.jpg</span>.\r\nWielkość liter występujących w nazwie możemy oczywiście zmienić\r\nwykonując operację <span class="opcja">Zmień nazwę</span>.\r\nNową nazwę pliku należy napisać małymi literami.</p>\r\n\r\n<p>Wielkość liter w nazwach plików możemy zobaczyć na przykład w programie\r\n<span class="program">WinSCP</span>. Program ten służy do przegrywania plików\r\nna serwer.</p>\r\n\r\n<p>A zatem po ukończeniu witryny kopiujemy pliki na serwer,\r\npo czym sprawdzamy wygląd.\r\nJeśli którykolwiek z plików graficznych nie pojawia się na stronie,\r\nwówczas należy się przyjrzeć wielkości liter w nazwie pliku,\r\noraz należy przeanalizować kod HTML,\r\nszczególnie atrybuty <span class="zmienna">src</span>\r\nelementów <span class="zmienna">IMG</span>.</p>\r\n\r\n<h3 id="R5">5. Umieszczanie zdjęć na stronach WWW</h3>\r\n\r\n<p>Pierwsze ćwiczenia pokazują, w jaki sposób umieścić na stronie\r\nWWW jedną lub więcej ilustracji. Każde z poniższych ćwiczeń należy\r\nwykonywać w osobnym folderze.</p>\r\n\r\n<h5>Ćwiczenie 1.1</h5>\r\n\r\n<p>Wykonaj stronę WWW, która przedstawia zdjęcie zapisane w pliku\r\n<span class="plik">zalew.jpg</span>.\r\nWitryna została przedstawiona na rysunku 1.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-01.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nZdjęcie Zalewu zemborzyckiego umieszczone na stronie WWW</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>W kodzie witryny umieszczamy nagłówek <span class="zmienna">H1</span>\r\nzawierający tytuł, a zaraz pod nim sekcję <span class="zmienna">DIV</span>.\r\nW sekcji tej umieszczamy element <span class="zmienna">IMG</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H1&gt;Zalew zemborzycki&lt;/H1&gt;\r\n&lt;DIV&gt;\r\n&lt;IMG src="zalew.jpg" alt="Zdjęcie zalewu zemborzyckiego"&gt;\r\n&lt;/DIV&gt;</pre>\r\n\r\n\r\n<p>Element <span class="zmienna">IMG</span> musi być umieszczony wewnątrz\r\nelementu blokowego, na przykład <span class="zmienna">DIV</span>,\r\n<span class="zmienna">P</span> lub <span class="zmienna">TD</span>.\r\nNie można umieszczać elementów <span class="zmienna">IMG</span>\r\nbezpośrednio w elemencie <span class="zmienna">BODY</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;BODY&gt;\r\n&lt;IMG src="zalew.jpg" alt="Zdjęcie..."&gt;\r\n&lt;/BODY&gt;</pre>\r\n\r\n<p>Gdy strona jest gotowa, zapisujemy ją w pliku <span class="plik">index.html</span>.\r\nOtrzymana witryna składa się z dwóch plików:\r\n<span class="plik">index.html</span> oraz <span class="plik">zalew.jpg</span>.\r\nPlik o rozszerzeniu <span class="plik">.html</span> zawiera opis wyglądu strony, zaś\r\nplik o rozszerzeniu <span class="plik">.jpg</span> zawiera zdjęcie, które zostało\r\numieszczone na stronie WWW elementem <span class="zmienna">IMG</span>.\r\nOba pliki muszą znajdować się w tym samym folderze.</p>\r\n\r\n<h5>Ćwiczenie 1.2</h5>\r\n\r\n<p>Przygotuj stronę WWW przedstawiającą\r\nrysunki zapisane w plikach\r\n<span class="plik">p1.png</span>\r\noraz <span class="plik">p2.png</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nRysunki w formacie png umieszczamy w identyczny sposób jak pliki jpg</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Umieszczanie na stronie WWW ilustracji w formacie <span class="plik">PNG</span>\r\nniczym nie różni się od umieszczania ilustracji <span class="plik">JPG</span>.\r\nW sekcji <span class="zmienna">DIV</span> wstawiamy dwa elementy <span class="zmienna">IMG</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="p1.png" alt="Rysunek przedstawiający ptaka"&gt;\r\n&lt;IMG src="p2.png" alt="Drugi rysunek przedstawiający ptaka"&gt;</pre>\r\n\r\n<p>W zależności od szerokości okna przeglądarki, rysunki będą\r\nznajdowały się obok siebie lub - w przypadku, gdy okno przeglądarki będzie zbyt wąskie - jedno\r\npod drugim.</p>\r\n\r\n<p>Gotowa witryna składa się tym razem z trzech plików:\r\n<span class="plik">index.html</span>, <span class="plik">p1.png</span>\r\n\r\noraz <span class="plik">p2.jpg</span>.\r\nWszystkie trzy pliki muszą znajdować się w tym samym folderze.</p>\r\n\r\n<h5>Ćwiczenie 1.3</h5>\r\n\r\n<p>Przygotuj stronę WWW prezentującą sześć modeli lokomotyw.\r\nZdjęcia są zapisane w plikach o nazwach\r\n<span class="plik">train1.jpg</span>, ...\r\n<span class="plik">train6.jpg</span>.</p>\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-03.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nStorna WWW może zawierać wiele ilustracji</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tym razem zdjęcia umieszczamy wewnątrz akapitu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\n&lt;IMG src="train1.jpg" alt="Model lokomotywy"&gt;\r\n...\r\n&lt;IMG src="train6.jpg" alt="Model lokomotywy"&gt;\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Podobnie jak w poprzednim przykładzie, ułożenie zdjęć zależy od\r\nszerokości okna przeglądarki.</p>\r\n\r\n<p>Tym razem rozwiązanie składa się aż z siedmiu plików: jednego pliku\r\n<span class="plik">.html</span> oraz z sześciu ilustracji.\r\nPodobnie jak poprzednio, wszystkie pliki muszą się znajdować w tym samym folderze.</p>\r\n\r\n<h3 id="R6">6. Tekst i ilustracje</h3>\r\n\r\n\r\n<p>Druga seria ćwiczeń pokazuje, w jaki sposób\r\ndodać ilustracje do dokumentów zawierających teksty.</p>\r\n\r\n<h5>Ćwiczenie 2.1</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą tekst i tabulaturę\r\npiosenki pt. <span class="ang">Hoochie Coochie Man</span>\r\noraz zdjęcia Muddy''ego Watersa.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-04.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nWitryna, na której tekst przeplata się z ilustracjami</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Stronę rozpoczynamy od nagłówka <span class="zmienna">H1</span>\r\nzawierającego napis  <span class="ang">Muddy Waters</span>.\r\nNastępnie umieszczamy akapit zawierający pierwsze ze zdjęć:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;&lt;IMG src="muddy1.jpg" alt="Fotografia Muddiego Watersa"&gt;&lt;/P&gt;</pre>\r\n\r\n<p>Pod fotografią umieszczamy nagłówek <span class="zmienna">H2</span>\r\nzawierający tytuł piosenki, po którym następuje element <span class="zmienna">PRE</span>\r\nzawierający tekst i tabulaturę piosenki.\r\nStronę kończymy drugim elementem <span class="zmienna">IMG</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;&lt;IMG src="muddy2.jpg" alt="Fotografia Muddiego Watersa"&gt;&lt;/P&gt;</pre>\r\n\r\n<h5>Ćwiczenie 2.2</h5>\r\n\r\n\r\n<p>Przygotuj witrynę na temat języka Logo.\r\nWykorzystaj ilustracje zapisane w plikach\r\n<span class="plik">fdrt.jpg</span>\r\noraz <span class="plik">turtle.jpg</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-05.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nWitryna na temat języka Logo</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>W kodzie strony umieszczamy, pod nagłówkiem, akapit:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\nJęzyk programowania Logo ...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Pod pierwszym akapitem umieszczamy sekcję <span class="zmienna">DIV</span>, która\r\nzawiera ilustrację:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DIV&gt;\r\n&lt;IMG src="fdrt.jpg" alt="Działanie komend FD oraz RT"&gt;\r\n&lt;/DIV&gt;</pre>\r\n\r\n<p>Następnie dodajemy drugi akapit, pod którym umieszczamy sekcję\r\n<span class="zmienna">DIV</span>\r\nprezentującą drugą z fotografii.</p>\r\n\r\n<h5>Ćwiczenie 2.3</h5>\r\n\r\n<p>Przygotuj artykuł na temat programu <span class="program">C.a.R</span>\r\n\r\nw postaci strony WWW. Artykuł jest zapisany w formacie tekstowym,\r\nzaś wszystkie ilustracje są zapisane w plikach <span class="plik">JPG</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-06-01.jpg" alt="" /><img src="artimg/06-06-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 6.\r\nIlustracje do zadań z geometrii opatrzone podpisem</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Przygotowanie artykułu wymaga dodania elementów\r\n<span class="zmienna">P</span> definiujących kolejne akapity\r\noraz nagłówków ustalających tytuł i kolejne części artykułu.\r\nGdy akapity i nagłówki są już dodane, umieszczamy w dokumencie ilustracje.\r\nPod akapitem omawiającym treść zadania pierwszego\r\numieszczamy następującą sekcję <span class="zmienna">DIV</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DIV&gt;\r\n&lt;IMG src="1_400.jpg" alt="Ilustracja do zadania pierwszego."&gt;\r\n&lt;P class="podpis"&gt;&lt;STRONG&gt;Rys. 1.&lt;/STRONG&gt; Konstrukcja kwadratu o zadanym boku.\r\n&lt;/P&gt;\r\n&lt;/DIV&gt;</pre>\r\n\r\n<p>Podobnie postępujemy z pozostałymi zadaniami.</p>\r\n\r\n<h3 id="R7">7. Obrazy będące hiperłączami</h3>\r\n\r\n<p>Kolejnym etapem są obrazy będące hiperłączami.\r\nKliknięcie obrazu powoduje otwarcie osobnego dokumentu.</p>\r\n\r\n<h5>Ćwiczenie 3.1</h5>\r\n\r\n<p>Przygotuj stronę przedstawiającą dwie miniaturowe ilustracje\r\nsieci energetycznej. Niech każda z ilustracji będzie\r\nhiperłączem do ilustracji o dużych rozmiarach.\r\nMiniaturowe ilustracje są zapisane w plikach\r\n<span class="zmienna">mini-linia1.jpg</span> oraz\r\n<span class="zmienna">mini-linia2.jpg</span>, natomiast duże obrazy\r\nnazywają się\r\n<span class="plik">linia1.jpg</span> i\r\n<span class="plik">linia2.jpg</span>.</p>\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-07.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 7.\r\nIlustracje będące hiperłączami</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>W celu umieszczenia na stronie WWW pierwszej miniaturki, stosujemy\r\nnastępujący element <span class="zmienna">IMG</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="mini-linia1.jpg" alt="Zdjęcie linii energetycznej."&gt;</pre>\r\n\r\n<p>Jeśli teraz ten element ma stać się hiperłączem, to musimy go otoczyć\r\nznacznikami <span class="zmienna">&lt;A href=""&gt;</span> oraz\r\n<span class="zmienna">&lt;/A&gt;</span>.\r\nPonieważ aktywacja hiperłącza ma przenosić internautę do pliku\r\nprzedstawiającego dużą fotografię, zatem kompletny kod hiperłącza będzie następujący:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="linia1.jpg"&gt;\r\n  &lt;IMG src="mini-linia1.jpg" alt="Zdjęcie linii energetycznej."&gt;\r\n&lt;/A&gt;</pre>\r\n\r\n<p>Drugie hiperłącze wykonujemy podobnie.\r\nSkończona witryna składa się z pięciu plików:\r\n<span class="plik">index.html</span>,\r\n<span class="zmienna">mini-linia1.jpg</span>,\r\n<span class="zmienna">mini-linia2.jpg</span>,\r\n\r\n<span class="plik">linia1.jpg</span> oraz\r\n<span class="plik">linia2.jpg</span>.\r\nWszystkie pliki muszą znajdować się w tym samym folderze.</p>\r\n\r\n<p>Zauważmy, że obrazy będące hiperłączami są otoczone niebieskim obramowaniem.</p>\r\n\r\n<h5>Ćwiczenie 3.2</h5>\r\n\r\n\r\n<p>Przygotuj artykuł na temat definiowania miejsc geometrycznych punktów\r\nw postaci strony WWW. Tekst artykułu jest zapisany w formacie tekstowym.\r\nIlustracje do zadań opisanych w artykule są zapisane w\r\nplikach graficznych o rozmiarach 400x300 pikseli oraz\r\n800x600. Pierwsza cyfra nazwy pliku mówi o numerze zadania.\r\nNa przykład ilustracje do zadania 3 zapisano w plikach\r\n\r\n<span class="plik">3_400.jpg</span> i\r\n<span class="plik">3_800.jpg</span>,\r\nnatomiast ilustracje do zadania 7 stanowią pliki\r\n<span class="plik">7_400.jpg</span> i\r\n<span class="plik">7_800.jpg</span>.</p>\r\n\r\n<p>Dokument przygotuj w takiej postaci, by\r\nw treści artykułu znajdowały się ilustracje o szerokości\r\n400 pikseli, będące hiperłączami do ilustracji o szerokości 800 pikseli.</p>\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-08.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 8.\r\nMiniaturowe ilustracje-hiperłącza zawarte w treści artykułu</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Pod odpowiednimi akapitami tekstu umieszczamy\r\nhiperłącza zawierające obrazy.\r\nPod akapitem opisującym zadanie pierwsze należy umieścić kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DIV&gt;\r\n&lt;A href="1_800.jpg"&gt;\r\n  &lt;IMG src="1_400.jpg" alt="Ilustracja do zadania pierwszego."&gt;\r\n&lt;/A&gt;\r\n&lt;/DIV&gt;</pre>\r\n\r\n<p>Podobnie jak poprzednio, tak i tym razem ilustracje będące hiperłączami\r\nsą otoczone niebieskim obramowaniem.</p>\r\n\r\n<h5>Ćwiczenie 3.3</h5>\r\n\r\n\r\n<p>Dane są pliki <span class="plik">p1.jpg</span>,\r\n<span class="plik">p2.jpg</span>, ..., <span class="plik">p10.jpg</span>.\r\nPrzygotuj "tunel" prezentujący wszystkie dziesięć ilustracji.\r\nKażda strona tunelu powinna prezentować pojedyncze zdjęcie będące hiperłączem\r\ndo kolejnej strony tunelu.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-09-01.jpg" alt="" /><img src="artimg/06-09-02.jpg" alt="" /><img src="artimg/06-09-03.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 9.\r\nTunel</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Wykonanie ćwiczenia wymaga przygotowania dziesięciu stron WWW. Na każdej z nich\r\numieścimy jeden obraz będący hiperłączem.\r\nNiech strony nazywają się kolejno <span class="zmienna">1.html</span>, <span class="plik">2.html</span>,\r\n..., <span class="plik">10.html</span>.\r\nNa stronie <span class="plik">1.html</span>\r\n\r\nmamy umieścić rysunek <span class="plik">p1.jpg</span>.\r\nW tym celu wprowadzamy na stronie kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="p1.jpg" alt="Wojna"&gt;</pre>\r\n\r\n<p>Obraz ten ma być hiperłączem do strony <span class="plik">2.html</span>.\r\nZatem dodajemy element <span class="zmienna">A</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="2.html"&gt;\r\n  &lt;IMG src="p1.jpg" alt="Wojna"&gt;\r\n&lt;/A&gt;</pre>\r\n\r\n<p>Powyższy element <span class="zmienna">A</span>\r\numieszczamy wewnątrz akapitu.\r\nWykonując strony z tego ćwiczenia zastosujmy zewnętrzne arkusze stylów.\r\nW nagłówku strony, poniżej znacznika <span class="zmienna">META</span>\r\n\r\nustalającego kodowanie strony wprowadźmy odwołanie do zewnętrznych arkuszy stylów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LINK rel="stylesheet" href="style.css" type="text/css"&gt;</pre>\r\n\r\n\r\n<p>W programie <span class="program">NotH</span> służy do tego skrót <span class="shortcut">Ctrl+S+Z</span>.</p>\r\n\r\n\r\n<p>Następnie utwórzmy plik o nazwie\r\n<span class="plik">style.css</span>, w którym umieszczamy następujące definicje stylów:</p>\r\n\r\n\r\n\r\n<pre class="syntax-highlight:xml">BODY {\r\n    text-align : center;\r\n    background : rgb(0,0,0);\r\n}\r\n\r\nIMG {\r\n    border : none;\r\n}</pre>\r\n\r\n<p>W ten sposób wszystkie strony będą miały czarne tło, a\r\nilustracje będą wycentrowane na stronie.\r\nPonadto obrazy będące hiperłączami stracą niebieskie obramowanie.</p>\r\n\r\n<p>Rozwiązanie tego ćwiczenia składa się z 21 plików: dziesięciu plików <span class="plik">.html</span>,\r\ndziesięciu plików <span class="plik">.jpg</span> oraz jednego pliku <span class="plik">.css</span>.</p>\r\n\r\n<h3 id="R8">8. Obrazy umieszczane w tabelach</h3>\r\n\r\n<p>Kolejnym zagadnieniem są tabele zawierające fotografie.\r\nDzięki tabelom możemy zaplanować układ fotografii na stronie WWW.</p>\r\n\r\n<h5>Ćwiczenie 4.1</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą cztery fotografie drzew.\r\nZdjęcia umieść w tabelce o wymiarach 2x2.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-10.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 10.\r\nTabelka zawierająca zdjęcia</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Po wykonaniu tabeli 2x2 w komórkach umieszczamy elementy <span class="zmienna">IMG</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt;\r\n  &lt;IMG src="buk.jpg" alt="Buk"&gt;\r\n  &lt;BR&gt;BUK\r\n&lt;/TD&gt;</pre>\r\n\r\n<p>Po każdym elemencie dodajemy znak złamania wiersza i podpis - nazwę drzewa.</p>\r\n\r\n<h5>Ćwiczenie 4.2</h5>\r\n\r\n<p>Przygotuj stronę WWW przedstawiającą chwyty gitarowe.\r\nCzternaście ilustracji zapisanych w plikach o nazwach\r\n<span class="plik">a-mol.jpg</span>, <span class="plik">a-dur.jpg</span>, ..., itd.\r\numieść w tabelce o wymiarach 4x4.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-11.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 11.\r\nW pustych komórkach umieszczamy twarde spacje</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Wykonanie ćwiczenia rozpoczynamy od przygotowania tabelki.\r\nNastępnie w pierwszych trzech wierszach umieszczamy\r\npodpisane fotografie stosując elementy <span class="zmienna">IMG</span>\r\noraz <span class="zmienna">BR</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt;\r\n  &lt;IMG src="a-dur.jpg" alt="A-dur"&gt;\r\n  &lt;BR&gt;A-dur\r\n&lt;/TD&gt;</pre>\r\n\r\n<p>Ponieważ dysponujemy czternastoma plikami, zaś tabela posiada\r\nszesnaście komórek, zatem dwie komórki musimy pozostawić puste.\r\nW komórkach tych umieszczamy twarde spacje:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt;&amp;nbsp;&lt;/TD&gt;</pre>\r\n\r\n<h5>Ćwiczenie 4.3</h5>\r\n\r\n<p>Przygotuj stronę WWW przedstawiającą pięć ilustracji do książki\r\n"O czym szumią wierzby".</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-12-01.jpg" alt="" /><img src="artimg/06-12-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 12.\r\nZagnieżdżone tabele ułatwiają rozkład ilustracji na stronie</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Ilustracji jest pięć. Ułożymy je stosując zagnieżdżone tabele.\r\nZewnętrzna tabela ma jeden wiersz i dwie kolumny (1x2).\r\nWewnątrz lewej komórki umieszczamy tabelę\r\no jednej kolumnie i dwóch wierszach (2x1).\r\nNatomiast w prawej komórce zewnętrznej tabeli\r\numieszczamy tabelę o trzech wierszach i jednej kolumnie (3x1).\r\nRysunek 12 przedstawia strukturę trzech przygotowanych tabel\r\noraz gotową witrynę.</p>\r\n\r\n<p>Ostatnim krokiem jest oczywiście umieszczenie w\r\nkomórkach wewnętrznych tabel ilustracji.</p>\r\n\r\n<h5>Ćwiczenie 4.4</h5>\r\n\r\n<p>Przygotuj stronę prezentującą tekst piosenki oraz zdjęcia z westernu\r\n"Rio Bravo".</p>\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-13-01.jpg" alt="" /><img src="artimg/06-13-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 13.\r\nDrugi przykład zagnieżdżania tabel</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Do rozłożenia tekstu i ilustracji ponownie wykorzystamy zagnieżdżone tabele.\r\nTabela zewnętrzna posiada jeden wiersz i dwie kolumny.\r\nW lewej komórce tabeli zewnętrznej umieszczamy tekst piosenki.\r\nNatomiast w komórce prawej zagnieżdżamy dodatkową tabelę.\r\nTabela ta posiada trzy wiersze i jedną kolumnę.\r\nW jej komórkach umieszczamy fotografie.</p>\r\n\r\n<h5>Ćwiczenie 4.5</h5>\r\n\r\n<p>Przygotuj stronę WWW przedstawiającą fotografie samochodów.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-14.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 14.\r\nKilka tabel umieszczonych jedna pod drugą</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Fotografie umieszczamy w tabelkach.\r\nOsiem fotografii samochodów marki Jeep wędruje do tabeli o wymiarach 2x4.\r\nNastępna tabela o czterech wierszach i trzech kolumnach zawiera zdjęcia\r\nsamochodów marki BMW.\r\nOstatnia z tabel zawiera piętnaście fotografii samochodów marki Chrysler.\r\nFotografie umieszczamy w tabeli o wymiarach 3x5.</p>\r\n\r\n\r\n<p>Zwróćmy uwagę na fotografie samochodów BMW.\r\nTło każdej fotografii samochodów BMW jest białe.\r\nW podobny sposób na stronach WWW umieszczamy między innymi ikony.\r\nBiałe tło strony płynnie przechodzi w białe tło samochodu i na stronie WWW widzimy\r\nsam samochód bez żadnego obramowania czy dodatkowych detali, jakie widać na przykład na\r\nfotografiach Jeepów.</p>\r\n\r\n<h3 id="R9">9. Tabelki, obrazy i hiperłącza</h3>\r\n\r\n<p>Ostatnia seria ćwiczeń łączy zagadnienia dotyczące umieszczanie fotografii w\r\ntabelach oraz tworzenie hiperłączy.</p>\r\n\r\n<h5>Ćwiczenie 5.1</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą rysunki maszyn.\r\nNiezbędne rysunki zapisano w plikach o rozszerzeniu <span class="plik">.gif</span>.\r\nKażdy rysunek jest zapisany w dwóch wymiarach.\r\nNa przykład miniaturowy rysunek koparki jest zapisany w pliku\r\n<span class="plik">kopara.gif</span>. Ten sam rysunek w większej rozdzielczości\r\nznajdziemy w pliku <span class="plik">kopara-duza.gif</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-15-01.jpg" alt="" /><img src="artimg/06-15-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 15.\r\nTabela zawierająca obrazy będące hiperłączami</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Najpierw przystępujemy do wykonania tabeli.\r\nStruktura tabeli została przedstawiona na rysunku 15.\r\nW tabeli o wymiarach 5x5, w komórkach oznaczonych literami\r\nX, Y oraz Z, umieszczamy miniaturowe ilustracje maszyn.\r\nDo umieszczenia miniaturowego rysunku koparki\r\nwykorzystamy kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="kopara.gif" alt="Koparka"&gt;</pre>\r\n\r\n<p>Rysunek miniaturowy ma być hiperłączem do rysunku o większych wymiarach.\r\nZatem powyższy znacznik <span class="zmienna">IMG</span>\r\nprzekształcamy w hiperłącze:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt;\r\n  &lt;A href="kopara_duza.gif"&gt;\r\n    &lt;IMG src="kopara.gif" alt="Koparka"&gt;\r\n  &lt;/A&gt;\r\n&lt;/TD&gt;</pre>\r\n\r\n\r\n<p>Podobnie postępujemy z pozostałymi rysunkami.\r\nRozwiązanie składa się z jedenastu plików: pięciu dużych rysunków,\r\npięciu miniatur oraz jednego pliku HTML.</p>\r\n\r\n<h5>Ćwiczenie 5.2</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą obrazy Cezanne''a.\r\nDziesięć obrazów jest zapisanych w folderze <span class="plik">cezanne</span>.\r\nMiniatury obrazów są natomiast zapisane w podfolderze o nazwie <span class="plik">100px</span>.\r\nNazwy miniatur są identyczne jak nazwy plików o większej rozdzielczości.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-16-01.jpg" alt="" /><img src="artimg/06-16-02.jpg" alt="" /><img src="artimg/06-16-03.jpg" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 16.\r\nObrazy Cezanne''a</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ćwiczenie to pokazuje, że pliki graficzne nie muszą znajdować się w tym samym folderze\r\nco pliki HTML.\r\nDziesięć miniatur umieszczamy w tabeli o dwóch wierszach i pięciu kolumnach.\r\nMiniatury pochodzą z folderu <span class="plik">cezanne/100px</span>,\r\nzatem w komórkach tabeli umieszczamy następujące elementy <span class="zmienna">IMG</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;IMG src="cezanne/100px/cezanne.drinker.jpg" alt="Miniaturka obrazu Cezanne''a"&gt;</pre>\r\n\r\n<p>Ponieważ miniaturowe ilustracje mają być hiperłączami do dużych\r\nplików, zatem znacznik <span class="zmienna">IMG</span> umieszczamy\r\nwewnątrz elementu <span class="zmienna">A</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;A href="cezanne/cezanne.drinker.jpg"&gt;\r\n  &lt;IMG ...&gt;\r\n&lt;/A&gt;</pre>\r\n\r\n<p>Poprawny wygląd witryny z obrazami Cezanne''a zależy od struktury folderów.\r\nRozwiązanie składa się z 21 plików: jednego pliku HTML, oraz dwudziestu obrazów.\r\nW folderze, w którym znajduje się plik HTML musi znajdować się folder <span class="zmienna">cezanne</span>.\r\nW folderze tym należy umieścić pliki graficzne o dużej rozdzielczości.\r\nNastępnie w folderze <span class="plik">cezanne</span> umieszczamy podfolder\r\no nazwie <span class="plik">100px</span>. W folderze tym należy umieścić miniaturki obrazów.</p>\r\n\r\n<h5>Ćwiczenie 5.3</h5>\r\n\r\n<p>Przygotuj stronę WWW przedstawiającą kolejne kroki instrukcji zestawu klocków Lego\r\nnr 8425.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-17.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 17.\r\nObrazy o identycznych wymiarach tworzą równomierną tabelę</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>W tabelce o wymiarach 3x3 umieszczamy ilustracje będące hiperłączmi.\r\nZ wróćmy uwagę na równomierne rozłożenie ilustracji widocznych na rysunku 17.\r\nTabela jest symetryczna, każda z komórek ma identyczny rozmiar.\r\nEfekt taki osiągniemy, gdy obrazy umieszczone w tabelce mają identyczne wymiary.\r\nW ćwiczeniach 1.3 (modele lokomotyw) oraz 5.2 (obrazy Cezanne''a) wyraźnie widać różnice w\r\nwymiarach obrazów. Różnice takie pojawiały się również w ćwiczeniach 3.3\r\n(rysunki wojenne) oraz 4.3 (ilustracje do książki "O czym szumią wierzby"). Jednakże\r\nrysunki zarówno w ćwiczeniu 3.3 jak i 4.3 różniły się jedynie wysokością.\r\nZatem umieszczenie ich na osobnych stronach (ćw. 3.3) lub\r\nw tej samej kolumnie tabeli (4.3) dawało dobry efekt.</p>\r\n\r\n<p>Najłatwiej przygotować stronę, gry ilustracje mają identyczne wymiary.\r\nW ćwiczeniach 4.1 (zdjęcia drzew), 4.2 (chwyty gitarowe), 4.5 (samochody)\r\noraz 5.3 (Lego 8425) komórki tabel mają identyczne wymiary,\r\ndzięki czemu strony wyglądają dość ładnie.</p>\r\n\r\n<p>Przygotowując ilustracje do umieszczenia na stronie WWW warto od początku\r\nmieć na uwadze wymiar tworzonych grafik. Czasami modyfikacja rozmiaru ilustracji\r\nsprowadza się do przeskalowania. Bywa jednak i tak, że musimy\r\nzmienić wymiar obrazu. Jeśli nie chcemy utracić proporcji, wówczas konieczne staje się\r\nucięcie fragmentu zdjęcia. Nie zawsze jest to proste.\r\nNa przykład przekształcenie ilustracji z ćwiczenia 1.3 (modele lokomotyw)\r\njest dość skomplikowane. Jeśli nie chcemy utracić ani proporcji ani fragmentów lokomotyw\r\nto musimy dorysować fragment tła.</p>\r\n\r\n<h5>Ćwiczenie 5.4</h5>\r\n\r\n<p>Przygotuj witrynę WWW przedstawiającą różne konfiguracje sieci ethernet.\r\nNiezbędne ilustracje są zapisane w dwóch folderach.\r\nFolder <span class="plik">100x75</span> zawiera miniatury o rozmiarach\r\n100x75 pikseli, natomiast w folderze <span class="plik">400x300</span>\r\nznajdują się ilustracje o rozmiarach 400x300 pikseli.\r\nNazwy plików w obu folderach są identyczne.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-18-01.jpg" alt="" /><img src="artimg/06-18-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 18.\r\nMenu składające się z tabeli miniaturowych obrazów</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ćwiczenie to jest nieco bardziej skomplikowane od poprzednich.\r\nWe wszystkich poprzednich ćwiczeniach hiperłącza wskazywały pliki graficzne.\r\nTym razem hiperłącza odwołują się od plików HTML.\r\nWykonanie ćwiczenia polega na przygotowaniu piętnastu plików\r\nHTML.\r\nKażdy z tych plików będzie zawierał z lewej strony menu ilustracji, a z prawej -\r\njeden z dużych plików graficznych.\r\nRysunek 18 pokazuje wygląd witryny po wybraniu z menu ilustracji pierwszej oraz siódmej.</p>\r\n\r\n<p>Przystąpmy do wykonania pierwszego pliku HTML. Plik ten nazwiemy <span class="plik">cw01.html</span>.\r\nW treści strony umieszczamy tabelę o wymiarach 1x2 (jeden wiersz, dwie kolumny).\r\nW lewej komórce umieścimy menu, a w prawej - wybraną dużą ilustrację.\r\nMenu składa się z tabeli o pięciu wierszach i trzech kolumnach.\r\nW komórkach tabeli menu umieszczamy\r\nminiaturowe ilustracje będące hiperłączami. Oto pierwszy wiersz tabeli menu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TR&gt;\r\n  &lt;TD&gt;&lt;A href="cw01.html"&gt;&lt;IMG src="100x75/cw01.jpg" alt="Ćwiczenie 1"&gt;&lt;/A&gt;&lt;/TD&gt;\r\n  &lt;TD&gt;&lt;A href="cw02.html"&gt;&lt;IMG src="100x75/cw02.jpg" alt="Ćwiczenie 2"&gt;&lt;/A&gt;&lt;/TD&gt;\r\n  &lt;TD&gt;&lt;A href="cw03.html"&gt;&lt;IMG src="100x75/cw03.jpg" alt="Ćwiczenie 3"&gt;&lt;/A&gt;&lt;/TD&gt;\r\n&lt;/TR&gt;</pre>\r\n\r\n<p>Miniaturki pochodzą z folderu <span class="plik">100x75</span>, zaś hiperłącza wskazują pliki\r\nHTML. Pozostałe wiersze tabeli menu wyglądają analogicznie.</p>\r\n\r\n<p>W prawej komórce dużej tabeli umieszczamy dużą ilustrację:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TD&gt;\r\n   &lt;IMG src="400x300/cw01.jpg" alt="Ćwiczenie 01"&gt;\r\n&lt;/TD&gt;</pre>\r\n\r\n\r\n<p>Na stronie <span class="plik">cw01.html</span> umieszczamy dużą ilustrację\r\n\r\n<span class="plik">cw01.jpg</span>.\r\nNa stronie <span class="plik">cw02.html</span> umieszczamy dużą ilustrację\r\n<span class="plik">cw02.jpg</span>. Podobnie postępujemy z pozostałymi plikami.\r\nPamiętajmy, że duże ilustracje znajdują się w folderze 400x300.\r\nAtrybut <span class="zmienna">src</span> musi zawierać nazwę folderu i nazwę pliku,\r\nnp. <span class="zmienna">src="400x300/cw01.jpg"</span>.</p>\r\n\r\n<p>Dodajmy, że menu (czyli tabela 5x3 zawierająca miniaturki-hiperłącza) jest identyczna na każdej\r\nz piętnastu stron WWW.</p>\r\n\r\n<p>W kodzie stron dodajmy jeszcze odwołanie do zewnętrznych arkuszy stylów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LINK rel="stylesheet" href="style.css" type="text/css"&gt;</pre>\r\n\r\n<p>i usuńmy niebieskie obramowanie miniatur wpisując w pliku <span class="plik">style.css</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">IMG {\r\n    border: none;\r\n}</pre>\r\n\r\n<p>Rozwiązanie ćwiczenia składa się z piętnastu plików HTML, jednego pliku CSS,\r\npiętnastu ilustracji miniaturowych zapisanych w folderze <span class="plik">100x75</span>\r\noraz piętnastu ilustracji dużych zapisanych w\r\nfolderze <span class="plik">400x300</span> (łącznie czterdzieści sześć plików).</p>\r\n\r\n<h5>Ćwiczenie 5.5</h5>\r\n\r\n\r\n<p>Przygotuj stronę WWW na temat bramek logicznych.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/06-19-01.jpg" alt="" /><img src="artimg/06-19-02.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 19.\r\nWitryna poświęcona bramkom logicznym</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Rozwiązanie ćwiczenia składa się z następujących plików:</p>\r\n\r\n<ul>\r\n\r\n<li>\r\n<span class="plik">index.html</span> - strona główna, która zawiera rysunki bramek zawartych w serwisie;\r\nkażdy z rysunków jest hiperłączem do strony na temat danej bramki.\r\n</li>\r\n\r\n<li>\r\n<span class="plik">nand.html</span>,\r\n<span class="plik">nor.html</span> oraz\r\n\r\n<span class="plik">xnor.html</span> - strony na temat konkretnych bramek;\r\nna każdej stronie znajduje się tabela wartości, rysunek bramki i hiperłącze do strony głównej.\r\n</li>\r\n\r\n<li>\r\n<span class="plik">nand.jpg</span>,\r\n<span class="plik">nor.jpg</span> oraz\r\n<span class="plik">xnor.jpg</span> - rysunki bramek.\r\n</li>\r\n\r\n<li>\r\n\r\n<span class="plik">style.css</span> - arkusze stylów.\r\n</li>\r\n</ul>\r\n\r\n<h3 id="R10">10. Podsumowanie</h3>\r\n\r\n<p>Kończąc ćwiczenia dotyczące ilustrowania witryn WWW chciałbym zwrócić\r\njeszcze uwagę na jeden drobiazg.\r\nElement <span class="zmienna">IMG</span> w starszych wersjach języka HTML\r\nposiadał atrybuty <span class="zmienna">width</span> oraz <span class="zmienna">height</span>.\r\nKorzystając z nich, lub z atrybutów <span class="zmienna">width</span> i\r\n\r\n<span class="zmienna">height</span> występujących w arkuszach stylów możemy zmienić szerokość\r\ni wysokość obrazu.\r\nNależy unikać takiej metody skalowania, gdyż ściągnięcie takiej "miniaturki"\r\ntrwa tyle samo, co ściągnięcie dużego obrazu.</p>\r\n\r\n\r\n<p>Atrybuty <span class="zmienna">width</span> i\r\n<span class="zmienna">height</span> pozwalają przeglądarce ustalić rozmiar obrazu\r\nprzed pobraniem go. Dzięki temu obraz, który jeszcze nie został pobrany\r\nzajmuje w oknie przeglądarki swój pełny rozmiar.\r\nPonadto, niekiedy obrazy nie posiadające atrybutów ustalających szerokość i wysokość\r\nsą urwane. Tendencje takie wykazuje głównie Internet Explorer.\r\nMożemy to zaobserwować klikając różne pozycje w menu strony z ćwiczenia 5.4.\r\nOdświeżenie strony usuwa wprawdzie błąd, jeśli jednak chcemy uniknąć\r\nkonieczności odświeżania, to należy użyć atrybutów <span class="zmienna">width</span>\r\ni <span class="zmienna">height</span>.</p>', 'ilustrowanie-witryn-www');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(7, 'Cytaty, wykazy oraz elementy DIV i SPAN', 'Omówieniem cytatów, wykazów oraz elementów DIV i SPAN\r\nzakończymy cykl artykułów poświęconych podstawom języka HTML.\r\nPodsumowujące zestawienie zawiera listę wszystkich opisanych elementów HTML.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Wykazy</a></li>\r\n<li><a href="#R2">2. Listy numerowane</a></li>\r\n<li><a href="#R3">3. Listy wypunktowane</a></li>\r\n<li><a href="#R4">4. Listy definicji</a></li>\r\n<li><a href="#R5">5. Listy zagnieżdżone</a></li>\r\n<li><a href="#R6">6. Cytaty</a></li>\r\n<li><a href="#R7">7. Elementy DIV i SPAN</a></li>\r\n<li><a href="#R8">8. Elementy blokowe i tekstowe</a></li>\r\n<li><a href="#R9">9. Jakie elementy języka HTML trzeba pamiętać?</a></li>\r\n<li><a href="#R10">10. Cechy każdego elementu HTML</a></li>\r\n<li><a href="#R11">11. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Wykazy</h3>\r\n\r\n<p>W języku HTML dostępne są trzy rodzaje wykazów: listy\r\nnumerowane, listy wypunktowane oraz listy definicji. Na\r\nliście numerowanej kolejne elementy są poprzedzone numerami.\r\nListy wypunktowane zawierają zestawiania poprzedzone\r\nidentycznym symbolem. Natomiast listy definicji\r\nsłużą do przygotowywania skorowidzów i słowników.\r\nKażda pozycja listy składa się z wyjaśnianego terminu oraz definicji.</p>\r\n\r\n<h3 id="R2">2. Listy numerowane</h3>\r\n\r\n<p>Listę numerowaną otaczamy znacznikami <span class="zmienna">&lt;OL&gt;</span>\r\noraz <span class="zmienna">&lt;/OL&gt;</span>\r\n(skrót <span class="zmienna">OL</span> pochodzi od angielskiego\r\nterminu <span class="ang">ordered list</span> - lista uporządkowana).\r\nKolejne pozycje listy definiujemy znacznikami\r\n\r\n<span class="zmienna">&lt;LI&gt;</span> i\r\n<span class="zmienna">&lt;/LI&gt;</span>\r\n(<span class="zmienna">LI</span> jest skrótem\r\n<span class="ang">list item</span> - element listy).</p>\r\n\r\n<h5>Ćwiczenie 1</h5>\r\n\r\n<p>Przygotuj stronę, która zawiera listę numerowaną przedstawiającą\r\nnajwiększe rzeki Polski.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-01.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nLista numerowana</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Kod listy, ograniczony do trzech pierwszych pozycji,\r\njest następujący:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;OL&gt;\r\n  &lt;LI&gt;Wisła (1047 km.)&lt;/LI&gt;\r\n  &lt;LI&gt;Odra (854 km.)&lt;/LI&gt;\r\n  &lt;LI&gt;Warta (808 km.)&lt;/LI&gt;\r\n  ...\r\n&lt;/OL&gt;</pre>\r\n\r\n<p>W programie <span class="program">NotH</span>\r\nelementy listy uzyskamy\r\nstosując skróty <span class="shortcut">Ctrl+L+O</span>\r\n\r\n(element <span class="zmienna">OL</span>)\r\noraz <span class="shortcut">Ctrl+L+I</span> (element <span class="zmienna">LI</span>).</p>\r\n\r\n<p>Do ustalenia rodzaju numeracji listy <span class="zmienna">OL</span>\r\nsłużył atrybut <span class="zmienna">type</span>.\r\nAtrybut ten został wycofany z języka HTML. W jego miejsce wprowadzono\r\natrybut CSS o nazwie <span class="zmienna">list-style-type</span>.\r\nJego poprawnymi wartościami są między innymi:\r\n\r\n<span class="zmienna">decimal</span>,\r\n<span class="zmienna">decimal-leading-zero</span>,\r\n<span class="zmienna">lower-roman</span>,\r\n<span class="zmienna">upper-roman</span>,\r\n<span class="zmienna">lower-alpha</span>,\r\n<span class="zmienna">upper-alpha</span>,\r\n<span class="zmienna">lower-latin</span>,\r\n<span class="zmienna">upper-latin</span>,\r\n<span class="zmienna">lower-greek</span> oraz\r\n\r\n<span class="zmienna">none</span>.\r\nNa przykład zmianę numeracji z arabskiej\r\n(domyślnej) na rzymską pisaną wielkimi literami\r\nosiągniemy stosując styl:</p>\r\n\r\n<pre class="syntax-highlight:xml">OL {\r\n    list-style-type : upper-roman;\r\n}</pre>\r\n\r\n<h3 id="R3">3. Listy wypunktowane</h3>\r\n\r\n<p>Drugim rodzajem wykazów są listy wypunktowane.\r\nListy wypunktowane definiujemy znacznikami\r\n<span class="zmienna">&lt;OL&gt;</span> oraz\r\n<span class="zmienna">&lt;/OL&gt;</span>.\r\nElementy listy, podobnie jak w przypadku list numerowanych,\r\nustalamy stosując znaczniki\r\n\r\n<span class="zmienna">&lt;LI&gt;</span> oraz\r\n<span class="zmienna">&lt;/LI&gt;</span>.</p>\r\n\r\n<h5>Ćwiczenie 2</h5>\r\n\r\n<p>Przygotuj wypunktowane zestawienie obrazujące podział administracyjny Polski\r\nna szesnaście województw.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nLista wypunktowana</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Kod listy zawiera jeden element <span class="zmienna">UL</span>\r\noraz serię elementów <span class="zmienna">LI</span>:</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">&lt;UL&gt;\r\n  &lt;LI&gt;dolnośląskie (stolica: Wrocław)&lt;/LI&gt;\r\n  &lt;LI&gt;kujawsko-pomorskie (stolica: Bydgoszcz)&lt;/LI&gt;\r\n  &lt;LI&gt;lubelskie (stolica: Lublin)&lt;/LI&gt;\r\n  ...\r\n&lt;/UL&gt;</pre>\r\n\r\n<p>Skrót <span class="zmienna">Ctrl+L+U</span> programu\r\n<span class="program">NotH</span> wstawia do dokumentu\r\nelement <span class="zmienna">UL</span>.</p>\r\n\r\n<p>Podobnie jak w przypadku listy <span class="zmienna">OL</span>,\r\natrybut <span class="zmienna">type</span> modyfikujący\r\nsymbol graficzny poprzedzający elementy listy został wycofany z języka\r\nHTML. Służy do tego\r\natrybut CSS <span class="zmienna">list-style-type</span>.\r\nPoprawnymi wartościami są\r\n<span class="zmienna">disc</span>,\r\n<span class="zmienna">circle</span>,\r\n<span class="zmienna">square</span> oraz\r\n\r\n<span class="zmienna">none</span>.\r\nZmiana domyślnego znaku wypunktowania z kółka na kwadrat\r\nsprowadza się do zastosowania stylu:</p>\r\n\r\n<pre class="syntax-highlight:xml">UL {\r\n    list-style-type : square;\r\n}</pre>\r\n\r\n<p>Możemy również zmienić znak wiodący na dowolny symbol graficzny.\r\nW tym celu należy przygotować plik graficzny <span class="plik">mojsymbol.png</span>\r\nprzedstawiający żądany symbol oraz ustalić wartość atrybutu\r\n<span class="zmienna">list-style-image</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">UL {\r\n    list-style-image : url(''mojsymbol.png'');\r\n}</pre>\r\n\r\n<p>W stosunku do list <span class="zmienna">OL</span> oraz\r\n<span class="zmienna">UL</span> możemy jeszcze\r\nzastosować atrybut <span class="zmienna">list-style-position</span>.\r\nAtrybut ten ustala położenie numeracji i symboli wypunktowania\r\nwzględem marginesów wykazu.\r\nPoprawnymi wartościami są <span class="zmienna">inside</span>\r\noraz <span class="zmienna">outside</span>.</p>\r\n\r\n<p>Jeśli chcemy wyspecyfikować kilka atrybutów listy, to możemy wykorzystać\r\ndo tego atrybut <span class="zmienna">list-style</span>,\r\nna przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">UL {\r\n    list-style : inside url(''mojsymbol.png'');\r\n}</pre>\r\n\r\n\r\n<p>W języku HTML istniały jeszcze dwa atrybuty,\r\nktóre czasami mogą być niezbędne przy stosowaniu wykazów numerowanych.\r\nElement <span class="zmienna">LI</span> posiadał\r\natrybut <span class="zmienna">value</span>\r\n\r\nustalający numer zadanej pozycji listy, natomiast\r\nelement <span class="zmienna">OL</span>\r\nposiadał atrybut <span class="zmienna">start</span>\r\nprzypisujący numer pierwszemu elementowi listy.\r\nAtrybuty te zostały wycofane, zaś w ich miejsce pojawiły się liczniki\r\nw arkuszach stylów (rozdział 12.5 specyfikacji CSS).\r\nNiestety liczniki arkuszy stylów nie są\r\npoprawnie interpretowane przez większość przeglądarek.\r\nNawet przykłady z dokumentacji CSS, bez żadnych modyfikacji,\r\nnie dają efektów, jakie, zdaniem autorów specyfikacji, dawać powinny.\r\nMamy zatem do wyboru albo zrezygnować z modyfikacji\r\nliczb pojawiających się na wykazie numerowanym albo zrezygnować\r\nz poprawności kodu HTML (w sensie języka HTML 4.01 strict).\r\nJeśli zdecydujemy się na stosowanie atrybutów <span class="zmienna">start</span>\r\noraz <span class="zmienna">value</span>, to ich użycie\r\nwygląda następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;OL start=&quot;7&quot;&gt;\r\n  &lt;LI&gt;BLACK&lt;/LI&gt;\r\n  &lt;LI&gt;YELLOW&lt;/LI&gt;\r\n  &lt;LI value=&quot;20&quot;&gt;BLUE&lt;/LI&gt;\r\n  &lt;LI&gt;GREEN&lt;/LI&gt;\r\n&lt;/OL&gt;</pre>\r\n\r\n<h3 id="R4">4. Listy definicji</h3>\r\n\r\n<p>Ostatnim rodzajem wykazów są listy definicji.</p>\r\n\r\n<h5>Ćwiczenie 3</h5>\r\n\r\n<p>Przygotuj stronę zawierającą słowniczek angielsko-polski.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nLista definicji</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Listę definicji otaczamy znacznikami <span class="zmienna">DL</span>\r\n\r\n(ang. <span class="ang">definition list</span>).\r\nSłuży do tego skrót <span class="shortcut">Ctrl+L+D</span>.\r\nKażdy element słownika posiada dwa składniki: termin angielski i\r\ntłumaczenie. Termin umieszczany na liście otaczamy\r\nznacznikami <span class="zmienna">&lt;DT&gt;...&lt;/DT&gt;</span>\r\n(ang. <span class="ang">definition term</span> - pojęcie definiowane;\r\nskrót <span class="shortcut">Ctrl+L+T</span>).\r\nNatomiast tłumaczenie umieszczamy wewnątrz elementu\r\n<span class="zmienna">DD</span> (skrót <span class="shortcut">Ctrl+L+F</span>).\r\nOto trzy pierwsze wpisy słownika:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DL&gt;\r\n  &lt;DT&gt;cat&lt;/DT&gt;   &lt;DD&gt;kot&lt;/DD&gt;\r\n  &lt;DT&gt;dog&lt;/DT&gt;   &lt;DD&gt;pies&lt;/DD&gt;\r\n  &lt;DT&gt;horse&lt;/DT&gt; &lt;DD&gt;koń&lt;/DD&gt;\r\n  ...\r\n&lt;/DL&gt;</pre>\r\n\r\n<h3 id="R5">5. Listy zagnieżdżone</h3>\r\n\r\n<p>Listy numerowane i wypunktowane możemy zagnieżdżać tworząc\r\nbardziej skomplikowane zestawienia.\r\nZagnieżdżaną listę umieszczamy wewnątrz elementu <span class="zmienna">LI</span>.\r\nNa przykład lista numerowana:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;OL&gt;\r\n&lt;LI&gt;Jeden&lt;/LI&gt;\r\n&lt;LI&gt;Dwa&lt;/LI&gt;\r\n&lt;LI&gt;Trzy&lt;/LI&gt;\r\n&lt;/OL&gt;</pre>\r\n\r\n<p>po dodaniu kolejnego poziomu w punkcie <em>Jeden</em>\r\nprzyjmie postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;OL&gt;\r\n&lt;LI&gt;\r\n  Jeden\r\n  &lt;OL&gt;\r\n    &lt;LI&gt;Jeden i ćwierć&lt;/LI&gt;\r\n    &lt;LI&gt;Jeden i pół&lt;/LI&gt;\r\n  &lt;/OL&gt;\r\n&lt;/LI&gt;\r\n&lt;LI&gt;Dwa&lt;/LI&gt;\r\n&lt;LI&gt;Trzy&lt;/LI&gt;\r\n&lt;/OL&gt;</pre>\r\n\r\n\r\n<h5>Ćwiczenie 4</h5>\r\n\r\n<p>Przygotuj zagnieżdżoną listę wypunktowaną\r\no dwóch poziomach. Na liście umieść informacje na temat\r\npodziału elementów języka HTML na blokowe i tekstowe.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-04.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nZagnieżdżona lista wypunktowana</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Lista składa się z dwóch poziomów. Najpierw przygotowujemy zestawienie\r\nz podziałem na dwie kategorie: elementy blokowe i tekstowe:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;UL&gt;\r\n  &lt;LI&gt;Elementy blokowe&lt;/LI&gt;\r\n  &lt;LI&gt;Elementy tekstowe&lt;/LI&gt;\r\n&lt;/UL&gt;</pre>\r\n\r\n<p>Następnie każdą z kategorii wzbogacamy o dodatkową listę wypunktowaną.\r\nW kategorii <em>Elementy blokowe</em>\r\ndodajemy następujący kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LI&gt;\r\n  Elementy blokowe\r\n  &lt;UL&gt;\r\n    &lt;LI&gt;akapit: P&lt;/LI&gt;\r\n    &lt;LI&gt;nagłówki: H1 H2 H3 H4 H5 H6&lt;/LI&gt;\r\n    ...\r\n  &lt;/UL&gt;\r\n&lt;/LI&gt;</pre>\r\n\r\n<p>W identyczny sposób rozbudowujemy kategorię <em>Elementy tekstowe</em>.\r\nSkończony przykład zawiera trzy listy <span class="zmienna">UL</span>.</p>\r\n\r\n<h5>Ćwiczenie 5</h5>\r\n\r\n<p>Przygotuj witrynę prezentującą w postaci list wypunktowanych i numerowanych\r\nplan przedmiotu <span class="tytul">&bdquo;Sieci komputerowe&rdquo;</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-05.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nDwustopniowe zagnieżdżenie wypunktowania i numerowania</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Najpierw definiujemy zewnętrzną listę numerowaną zawierającą główne zagadnienia:\r\n<em>Pojęcia wstępnie</em>, <em>Technologie sieci komputerowych</em>, itd.:</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">&lt;OL&gt;\r\n&lt;LI&gt;Pojęcia wstępne&lt;/LI&gt;\r\n&lt;LI&gt;Technologie sieci komputerowych&lt;/LI&gt;\r\n...\r\n&lt;/OL&gt;</pre>\r\n\r\n\r\n<p>Następnie każdą z kategorii głównych rozbudowujemy o wypunktowane\r\npodkategorie. W przypadku pozycji <em>Pojęcia wstępnie</em>,\r\nkod przybierze postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LI&gt;\r\n  Pojęcia wstępne\r\n  &lt;UL&gt;\r\n    &lt;LI&gt;komutacja łącza&lt;/LI&gt;\r\n    &lt;LI&gt;komutacja pakietów&lt;/LI&gt;\r\n    ...\r\n&lt;/UL&gt;\r\n&lt;/LI&gt;</pre>\r\n\r\n<p>Punkt zatytułowany <em>komutacja pakietów</em> posiada dalsze podkategorie.\r\nZatem dodajemy kolejną listę wypunktowaną:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LI&gt;\r\n  komutacja pakietów\r\n  &lt;UL&gt;\r\n    &lt;LI&gt;cyfrowy ...&lt;/LI&gt;\r\n    &lt;LI&gt;kontrola ...&lt;/LI&gt;\r\n  &lt;/UL&gt;\r\n&lt;/LI&gt;</pre>\r\n\r\n<p>W ten sposób zbudowaliśmy trzystopniowe zagnieżdżenie\r\nlist wypunktowanych i numerowanych.</p>\r\n\r\n<h5>Ćwiczenie 6</h5>\r\n\r\n<p>Stosując listy uporządkowane oraz nieuporządkowane\r\nprzygotuj zestawienie często stosowanych atrybutów CSS\r\npodzielone na kategorie.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-06.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 6.\r\nDwustopniowe zagnieżdżenie wypunktowania i numerowania</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R6">6. Cytaty</h3>\r\n\r\n\r\n<p>Elementy <span class="zmienna">Q</span> oraz <span class="zmienna">BLOCKQUOTE</span>\r\nsłużą do umieszczania w tekście cytatów. Element <span class="zmienna">Q</span>\r\njest elementem tekstowym, zaś element <span class="zmienna">BLOCKQUOTE</span>\r\n\r\nto element blokowy.</p>\r\n\r\n<h5>Ćwiczenie 7</h5>\r\n\r\n<p>Przygotuj stronę przedstawiającą cytaty z utworów\r\n<span class="tytul">&bdquo;Faraon&rdquo;</span>\r\noraz <span class="tytul">&bdquo;Tajemnicza wyspa&rdquo;</span>.</p>\r\n\r\n<p>Użycie elementu <span class="zmienna">BLOCKQUOTE</span>\r\n\r\nwygląda następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;BLOCKQUOTE&gt;\r\nW trzydziestym trzecim roku ...\r\n&lt;/BLOCKQUOTE&gt;</pre>\r\n\r\n<p>Natomiast element <span class="zmienna">Q</span> stosujemy\r\nzgodnie z poniższym przykładem:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\n... powiedział skromnie: &lt;Q&gt;Here is nitro-glycerine!&lt;/Q&gt; ...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Skróty <span class="shortcut">Ctrl+F+Q</span> i <span class="shortcut">Ctrl+F+B</span>\r\n\r\nułatwiają wprowadzanie elementów <span class="zmienna">Q</span>\r\ni <span class="zmienna">BLOCKQUOTE</span>.</p>\r\n\r\n<p>Ważnym elementem cytatu jest cudzysłów.\r\nZnak cudzysłowu dostępny na klawiaturze nie jest znakiem, jaki\r\nstosujemy w języku polskim.\r\nW języku polskim należy stosować znaki specjalne o kodach\r\n<span class="zmienna">&amp;bdquo;</span> oraz\r\n<span class="zmienna">&amp;rdquo;</span>.\r\nDają one następujący efekt: <span>&bdquo;Witaj!&rdquo;</span>\r\n\r\nZnaki te uzyskamy za pomocą skrótów\r\n<span class="shortcut">Ctrl+Q+O</span> oraz\r\n<span class="shortcut">Ctrl+Q+Z</span>.</p>\r\n\r\n<p>Specyfikacja języka CSS zawiera informacje (rozdział 12.4),\r\nże cudzysłów może być zdefiniowany\r\nza pomocą atrybutu <span class="zmienna">quotes</span>.\r\nWówczas odpowiednie znaki cudzysłowów byłyby wstawiane przez\r\nprzeglądarkę na podstawie stylu oraz języka dokumentu lub cytatu\r\n(definiowanego atrybutem HTML <span class="zmienna">lang</span>).\r\nNiestety, atrybuty te nie są interpretowane przez część przeglądarek.\r\nJeśli w dokumencie wymagane są polskie znaki cudzysłowów,\r\nmusimy je ręcznie umieszczać stosując znaki specjalne\r\n<span class="zmienna">&amp;bdquo;</span> oraz\r\n\r\n<span class="zmienna">&amp;rdquo;</span>.</p>\r\n\r\n<h3 id="R7">7. Elementy DIV i SPAN</h3>\r\n\r\n<p>W celu ułatwienia dostosowywania języka HTML\r\ndo indywidualnych potrzeb użytkowników Internetu,\r\ntwórcy języka wprowadzili elementy <span class="zmienna">DIV</span>\r\noraz <span class="zmienna">SPAN</span>.\r\nSą to elementy ogólne, nie posiadające żadnych konkretnych formatów.\r\nElement <span class="zmienna">DIV</span> jest elementem blokowym\r\n(skrót <span class="shortcut">Ctrl+P+D</span>),\r\nzaś element <span class="zmienna">SPAN</span>\r\n\r\n(skrót <span class="shortcut">Ctrl+P+S</span>) - tekstowym.</p>\r\n\r\n<p>Z elementu <span class="zmienna">DIV</span> korzystamy do\r\nzdefiniowania większego fragmentu witryny.\r\nNa przykład systemu menu, rozdziału artykułu czy spisu treści.\r\nNatomiast element <span class="zmienna">SPAN</span>\r\nznajduje zastosowanie do modyfikacji poszczególnych słów i fraz.</p>\r\n\r\n<p>Stosując elementy <span class="zmienna">DIV</span> i <span class="zmienna">SPAN</span>\r\n\r\nw połączeniu z klasami (atrybut <span class="zmienna">class</span>)\r\nmożemy jak gdyby wzbogacić język HTML o nowe elementy.</p>\r\n\r\n<h5>Ćwiczenie 8</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą życiorys i najbardziej znane książki Juliusza\r\nVerne. Tytuły książek sformatuj stosując element <span class="zmienna">SPAN</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-07.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 7.\r\nUżycie elementu <span class="zmienna">SPAN</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Tytuły utworów występujące w treści życiorysu\r\npisarza umieszczamy wewnątrz elementu <span class="zmienna">SPAN</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\n&lt;SPAN&gt;&quot;Dzieci kapitana Granta&quot;&lt;/SPAN&gt; 1868\r\n- tematem książki jest wyprawa ...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Dokument uzupełniamy stylami, które wytłuszczą i pochylą\r\ntekst otoczony znacznikami <span class="zmienna">SPAN</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">SPAN {\r\n    background  : rgb(232,211,181);\r\n    font-weight : bold;\r\n    font-style  : italic;\r\n}</pre>\r\n\r\n<p>Domyślne formatowanie elementu <span class="zmienna">SPAN</span>\r\nnie różny się niczym od formatu elementu nadrzędnego\r\n(w powyższym przykładzie elementem nadrzędnym jest\r\nakapit <span class="zmienna">P</span>).\r\nZatem bez definicji stylu elementu <span class="zmienna">SPAN</span>,\r\ntytuły książek nie będą odróżniały się od otaczającego je tekstu.</p>\r\n\r\n<h5>Ćwiczenie 9</h5>\r\n\r\n<p>Przygotuj witrynę z tekstem opowiadania <em>&bdquo;Zew krwi&rdquo;</em>.\r\nSpis treści, zawierający listę hiperłączy,\r\numieść w sekcji <span class="zmienna">DIV</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-08.png" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 8.\r\nElement <span class="zmienna">DIV</span> obejmujący listę numerowaną - spis treści</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>W górnej części dokumentu, tuż poniżej\r\ntytułu i autora umieszczamy\r\nsekcję <span class="zmienna">DIV</span>.\r\nW sekcji tej znajduje się akapit z podpisem spisu treści\r\noraz spis treści.\r\nSpis treści tworzymy korzystając z listy numerowanej.\r\nElementami listy są hiperłącza odnoszące się do\r\nnagłówków kolejnych rozdziałów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DIV&gt;\r\n&lt;P&gt;Contents&lt;/P&gt;\r\n&lt;OL&gt;\r\n  &lt;LI&gt;&lt;A href=&quot;#RI&quot;&gt;Into the Primitive&lt;/A&gt;\r\n  &lt;LI&gt;&lt;A href=&quot;#RII&quot;&gt;The Law of Club and Fang&lt;/A&gt;\r\n  ...\r\n&lt;/OL&gt;\r\n&lt;/DIV&gt;</pre>\r\n\r\n<p>Dokument wzbogacamy o style, które, między innymi,\r\nnadadzą sekcji <span class="zmienna">DIV</span>\r\nobramowanie i odpowiednie wymiary:</p>\r\n\r\n<pre class="syntax-highlight:xml">DIV {\r\n    text-align  : center;\r\n    font-weight : bold;\r\n    width       : 50%;\r\n    border      : solid 1px black;\r\n    padding     : 20px;\r\n    margin      : 10px;\r\n}</pre>\r\n\r\n<p>Na koniec, zgodnie z tekstem utworu, zmieniamy numerację\r\nlisty na liczby rzymskie. Stosujemy opisany atrybut\r\n<span class="zmienna">list-style-type</span>, nadając mu\r\nwartość <span class="zmienna">upper-roman</span>\r\n(duże liczby rzymskie):</p>\r\n\r\n<pre class="syntax-highlight:xml">OL {\r\n    list-style-type : upper-roman;\r\n}</pre>\r\n\r\n\r\n<h5>Ćwiczenie 10</h5>\r\n\r\n<p>Przygotuj elektroniczną edycję utworu\r\n<em>&bdquo;20000 mil podmorskiej żeglugi&rdquo;</em>.\r\nDo wykonania spisu treści wykorzystaj zagnieżdżone listy\r\nnumerowane oraz element <span class="zmienna">DIV</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/07-09.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 9.\r\nDwupoziomowy spis treści wewnątrz sekcji <span class="zmienna">DIV</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ćwiczenie to wykonujemy łącząc wiadomości omówione w\r\nćwiczeniu poprzednim z zagnieżdżaniem list przedstawionym w\r\nćwiczeniach 4 oraz 5.</p>\r\n\r\n<h3 id="R8">8. Elementy blokowe i tekstowe</h3>\r\n\r\n<p>Elementy języka HTML zostały podzielone na dwie kategorie:\r\nelementy blokowe i elementy tekstowe.\r\nElementy blokowe mogą zawierać wewnątrz inne elementy\r\nblokowe oraz elementy tekstowe.\r\nNatomiast poprawną zawartością elementów tekstowych stanowią\r\nwyłącznie elementy tekstowe.\r\nReguły te, choć dość ogólne, ułatwiają\r\nnaukę języka HTML.\r\nWynika z nich na przykład, że wewnątrz elementu <span class="zmienna">SPAN</span>\r\n\r\nnie mogą wystąpić ani nagłówki <span class="zmienna">Hx</span>,\r\nani akapity <span class="zmienna">P</span>.</p>\r\n\r\n<p>Tabele 1 oraz 2 zawierają elementy\r\nHTML 4.01 podzielone na dwie grupy.\r\nZauważmy, że niektóre elementy (na przykład\r\n<span class="zmienna">LI</span>,\r\n<span class="zmienna">DT</span>,\r\n<span class="zmienna">DD</span>,\r\n<span class="zmienna">TD</span>,\r\n\r\n<span class="zmienna">TH</span> oraz\r\n<span class="zmienna">TR</span>)\r\nnie zaliczają się do żadnej kategorii.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Rodzaje elementów</th><th>Elementy</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Rodzaje elementów</th><th>Elementy</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>Akapit</td>\r\n\r\n<td><span class="zmienna">P</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>Nagłówki</td>\r\n\r\n<td><span class="zmienna">H1</span>, <span class="zmienna">H2</span>, <span class="zmienna">H3</span>, <span class="zmienna">H4</span>, <span class="zmienna">H5</span>, <span class="zmienna">H6</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>Listy</td>\r\n\r\n<td><span class="zmienna">UL</span>, <span class="zmienna">OL</span>, <span class="zmienna">DL</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>Tekst preformatowany</td>\r\n\r\n<td><span class="zmienna">PRE</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>Inne</td>\r\n\r\n<td><span class="zmienna">DIV</span>, <span class="zmienna">TABLE</span>, <span class="zmienna">BLOCKQUOTE</span>, <span class="zmienna">HR</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nElementy blokowe języka HTML 4.01</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n\r\n<table>\r\n<thead>\r\n<tr><th>Rodzaje elementów</th><th>Elementy</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Rodzaje elementów</th><th>Elementy</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>Tekst</td>\r\n\r\n<td>może zawierać znaki specjalne (np. <span class="zmienna">&amp;lt;</span>, <span class="zmienna">&amp;copy;</span>, itd.)</td>\r\n\r\n</tr>\r\n\r\n<tr><td>Elementy frazowe</td>\r\n\r\n<td><span class="zmienna">EM</span>, <span class="zmienna">STRONG</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>Elementy specjalne</td>\r\n\r\n<td><span class="zmienna">A</span>, <span class="zmienna">IMG</span>, <span class="zmienna">BR</span>, <span class="zmienna">Q</span>, <span class="zmienna">SUB</span>, <span class="zmienna">SUP</span>, <span class="zmienna">SPAN</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 2.\r\nElementy tekstowe języka HTML 4.01</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R9">9. Jakie elementy języka HTML trzeba pamiętać?</h3>\r\n\r\n<p>Język HTML w wersji 4.01 strict zawiera 71 elementów.\r\nPierwszą grupa elementów, których znajomość jest konieczna,\r\nsą elementy definiujące strukturę dokumentu.\r\nNależą do niej elementy:\r\n\r\n<span class="zmienna">DOCTYPE</span>,\r\n<span class="zmienna">HTML</span>,\r\n<span class="zmienna">HEAD</span>,\r\n<span class="zmienna">TITLE</span>,\r\n<span class="zmienna">META</span>\r\n(konieczny jest co najmniej element ustalający kodowanie polskich znaków),\r\n<span class="zmienna">BODY</span>,\r\n<span class="zmienna">STYLE</span> oraz\r\n<span class="zmienna">LINK</span>.\r\nTworzenie strony WWW należy usprawnić, eliminując konieczność\r\nwypisywania powyższych elementów przy każdym nowym dokumencie.\r\nNa przykład w edytorze <span class="program">NotH</span>,\r\nskrót klawiszowy <span class="shortcut">Ctrl+S+A</span>\r\n\r\ntworzy nowy, pusty dokument HTML zawierający wszystkie\r\npowyższe elementy.\r\nWarianty pustej strony uzyskamy stosując skróty\r\n<span class="shortcut">Ctrl+S+B</span>, <span class="shortcut">Ctrl+S+C</span>,\r\nitd.\r\nStyle możemy dodać do dokumentu za pomocą skrótów\r\n<span class="shortcut">Ctrl+S+W</span> (style wewnętrzne) oraz\r\n<span class="shortcut">Ctrl+S+Z</span> (style zewnętrzne).\r\nNatomiast w razie konieczności zmiany kodowania polskich znaków\r\nz kodu ISO na kod stosowany przez firmę Microsoft należy użyć skrótów\r\n<span class="shortcut">Ctrl+P+M</span> i\r\n<span class="shortcut">Ctrl+P+N</span>.</p>\r\n\r\n\r\n\r\n<p>Druga grupa elementów HTML, jakie webmaster musi pamiętać\r\nzawiera te znaczniki, które pojawiają się w niemal każdym projekcie.\r\nNależą do nich:\r\n\r\nznaki specjalne <span class="zmienna">&amp;nbsp;</span>,\r\n<span class="zmienna">&amp;lt;</span>,\r\n<span class="zmienna">&amp;gt;</span>,\r\nnagłówki (od <span class="zmienna">H1</span> do <span class="zmienna">H6</span>),\r\nelementy dotyczące tekstu\r\n(<span class="zmienna">P</span>,\r\n\r\n<span class="zmienna">BR</span>,\r\n<span class="zmienna">EM</span>,\r\n<span class="zmienna">STRONG</span> i\r\n<span class="zmienna">PRE</span>),\r\nhiperłącza i obrazy\r\n(<span class="zmienna">A</span>, <span class="zmienna">IMG</span>),\r\ntabele (\r\n<span class="zmienna">TABLE</span>,\r\n<span class="zmienna">TR</span>,\r\n\r\n<span class="zmienna">TD</span>),\r\nlisty\r\n(<span class="zmienna">UL</span>,\r\n<span class="zmienna">OL</span>,\r\n<span class="zmienna">LI</span>),\r\nelementy ogólne\r\n(<span class="zmienna">DIV</span> i\r\n<span class="zmienna">SPAN</span>)\r\noraz pozioma kreska <span class="zmienna">HR</span>.</p>\r\n\r\n<p>Elementy te są tak często stosowane, że należy nauczyć się je wprowadzać\r\nbardzo szybko. Zastępując ręczne pisanie kodu\r\n<span class="zmienna">&lt;H1&gt; ... &lt;/H1&gt;</span>\r\njednym skrótem klawiszowym osiągniemy ogromy wzrost wydajności pracy.</p>\r\n\r\n\r\n<p>Trzecią grupę elementów, stanowią znaczniki nieco rzadziej wykorzystywane:\r\nznaki specjalne\r\n(<span class="zmienna">&amp;amp;</span>,\r\n<span class="zmienna">&amp;copy;</span>,\r\n\r\n<span class="zmienna">&amp;quot;</span>,\r\n<span class="zmienna">&amp;bdquo;</span> oraz <span class="zmienna">&amp;rdquo;</span>),\r\nlisty definicji\r\n(<span class="zmienna">DL</span>,\r\n<span class="zmienna">DT</span> i\r\n<span class="zmienna">DD</span>),\r\ncytaty\r\n(<span class="zmienna">BLOCKQUOTE</span> i\r\n\r\n<span class="zmienna">Q</span>),\r\nindeksy\r\n(<span class="zmienna">SUB</span> i <span class="zmienna">SUP</span>)\r\noraz komórki nagłówkowe tabel <span class="zmienna">TH</span>.</p>\r\n\r\n\r\n<p>Kolejną, czwartą grupę, stanowią elementy zbędne.\r\nIch użycie najelepiej wyeliminować i zastąpić stosowaniem\r\nelementu <span class="zmienna">SPAN</span> wzbogaconego o klasę:\r\n\r\n<span class="zmienna">DFN</span>,\r\n<span class="zmienna">CODE</span>,\r\n<span class="zmienna">SAMP</span>,\r\n<span class="zmienna">KBD</span>,\r\n<span class="zmienna">VAR</span>,\r\n<span class="zmienna">CITE</span>,\r\n<span class="zmienna">ABBR</span> i\r\n<span class="zmienna">ACRONYM</span>.</p>\r\n\r\n<p>Piąta grupa, to elementy niezalecane przez specyfikację języka\r\nHTML. <strong>Nie należy ich stosować!</strong>. Zamiast nich korzystamy z\r\nelementów <span class="zmienna">STRONG</span>,\r\n<span class="zmienna">EM</span> oraz\r\n<span class="zmienna">SPAN</span> z definicją stylu:\r\n<span class="zmienna">TT</span>,\r\n<span class="zmienna">I</span>,\r\n\r\n<span class="zmienna">B</span>,\r\n<span class="zmienna">BIG</span> i\r\n<span class="zmienna">SMALL</span>.</p>\r\n\r\n<p>Szóstą grupę stanowią elementy wycofane z języka.\r\n<strong>Elementów tych nie należy stosować!</strong>\r\nDo grupy tej należą:\r\n<span class="zmienna">FONT</span>,\r\n<span class="zmienna">BASEFONT</span>,\r\n\r\n<span class="zmienna">CENTER</span>,\r\n<span class="zmienna">U</span>,\r\n<span class="zmienna">S</span> oraz\r\n<span class="zmienna">STRIKE</span>.</p>\r\n\r\n\r\n<p>Ostatnia grupa elementów, to elementy,\r\no bardzo specyficznym zastosowaniu:\r\n<span class="zmienna">ADDRESS</span> (wskazanie adresu autora strony;\r\nelement ten zazwyczaj jest zastąpiony przez stopkę strony\r\nzawierającą informacje o autorze w postaci tekstu sformatowanego\r\nstandardowymi znacznikami),\r\n\r\n<span class="zmienna">INS</span>, <span class="zmienna">DEL</span>\r\n(elementy umożliwiające zaznaczanie zmian edytorskich w dokumencie),\r\n<span class="zmienna">CAPTION</span>,\r\n<span class="zmienna">THEAD</span>,\r\n<span class="zmienna">TFOOT</span>,\r\n<span class="zmienna">TBODY</span>,\r\n<span class="zmienna">COL</span>,\r\n<span class="zmienna">COLGROUP</span> (dodatkowe elementy dotyczące tabel),\r\n\r\n<span class="zmienna">BASE</span> (ustalenie bazowego adresu dla\r\nwzględnych hiperłączy definiowanych elementem <span class="zmienna">A</span>),\r\n<span class="zmienna">OBJECT</span>,\r\n<span class="zmienna">PARAM</span> (elementy służące do osadzania apletów w dokumencie),\r\n<span class="program">MAP</span>, <span class="program">AREA</span>\r\n(elementy służące do definiowania map obrazów) oraz\r\n<span class="zmienna">SCRIPT</span> i <span class="zmienna">NOSCRIPT</span>\r\n\r\n(elementy służące do osadzania skryptów interpretowanych przez przeglądarkę,\r\nm.in. w języku <span class="program">JavaScript</span>).</p>\r\n\r\n<p>Powyższe siedem grup zawiera zestawienie wszystkich elementów języka HTML\r\nz pominięciem formularzy oraz ramek.</p>\r\n\r\n<p>Dodajmy jeszcze, że bardzo popularne atrybuty\r\n<span class="zmienna">bgcolor</span> oraz\r\n<span class="zmienna">align</span>\r\nrównież zostały wycofane z języka HTML i w ich miejsce należy stosować style.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>lp.</th><th>Grupa</th><th>Elementy</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>lp.</th><th>Grupa</th><th>Elementy</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Elementy definiujące strukturę dokumentu</td>\r\n\r\n<td><span class="zmienna">DOCTYPE</span>,<br /><span class="zmienna">HTML</span>, <span class="zmienna">HEAD</span>, <span class="zmienna">TITLE</span>, <span class="zmienna">META</span>, <span class="zmienna">BODY</span>,<br /> <span class="zmienna">STYLE</span>, <span class="zmienna">LINK</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Najpopularniejsze elementy.</td>\r\n\r\n<td><span class="zmienna">&amp;nbsp;</span>, <span class="zmienna">&amp;lt;</span>, <span class="zmienna">&amp;gt;</span>,<br /><span class="zmienna">H1</span>, ..., <span class="zmienna">H6</span>,<br /><span class="zmienna">P</span>, <span class="zmienna">BR</span>, <span class="zmienna">PRE</span>, <span class="zmienna">HR</span>,<br /><span class="zmienna">EM</span>, <span class="zmienna">STRONG</span>,<br /><span class="zmienna">A</span>, <span class="zmienna">IMG</span>,<br /><span class="zmienna">TABLE</span>, <span class="zmienna">TR</span>, <span class="zmienna">TD</span>,<br /><span class="zmienna">UL</span>, <span class="zmienna">OL</span>, <span class="zmienna">LI</span>,<br /><span class="zmienna">DIV</span>, <span class="zmienna">SPAN</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Elementy rzadziej stosowane.</td>\r\n\r\n<td><span class="zmienna">&amp;amp;</span>, <span class="zmienna">&amp;copy;</span>, <span class="zmienna">&amp;quot;</span>, <span class="zmienna">&amp;bdquo;</span>, <span class="zmienna">&amp;rdquo;</span>,<br /><span class="zmienna">DL</span>, <span class="zmienna">DT</span>, <span class="zmienna">DD</span>,<br /><span class="zmienna">BLOCKQUOTE</span>, <span class="zmienna">Q</span>,<br /><span class="zmienna">SUB</span>, <span class="zmienna">SUP</span>,<br /><span class="zmienna">TH</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Elementy zbędne.</td>\r\n\r\n<td><span class="zmienna">DFN</span>, <span class="zmienna">CODE</span>, <span class="zmienna">SAMP</span>, <span class="zmienna">KBD</span>, <span class="zmienna">VAR</span>, <span class="zmienna">CITE</span>, <span class="zmienna">ABBR</span>, <span class="zmienna">ACRONYM</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Elementy niezalecane.</td>\r\n\r\n<td><span class="zmienna">TT</span>, <span class="zmienna">I</span>, <span class="zmienna">B</span>, <span class="zmienna">BIG</span>, <span class="zmienna">SMALL</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>6.</td>\r\n\r\n<td>Elementy wycofane z języka.</td>\r\n\r\n<td><span class="zmienna">FONT</span>, <span class="zmienna">BASEFONT</span>, <span class="zmienna">CENTER</span>, <span class="zmienna">U</span>, <span class="zmienna">S</span>, <span class="zmienna">STRIKE</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td>7.</td>\r\n\r\n<td>Elementy specyficzne.</td>\r\n\r\n<td><span class="zmienna">ADDRESS</span>,<br /><span class="zmienna">INS</span>, <span class="zmienna">DEL</span>,<br /><span class="zmienna">CAPTION</span>, <span class="zmienna">THEAD</span>, <span class="zmienna">TFOOT</span>, <span class="zmienna">TBODY</span>, <span class="zmienna">COL</span>, <span class="zmienna">COLGROUP</span>,<br /><span class="zmienna">BASE</span>,<br /><span class="zmienna">OBJECT</span>, <span class="zmienna">PARAM</span>,<br /><span class="zmienna">MAP</span>, <span class="zmienna">AREA</span>,<br /><span class="zmienna">SCRIPT</span>, <span class="zmienna">NOSCRIPT</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 3.\r\nPodział elementów, ułatwiający naukę języka HTML</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Spośród siedmiu zawartych w tabeli 3 pamiętać trzeba jedynie\r\nelementy zawarte w grupach drugiej i trzeciej.\r\nWażną natomiast umiejętnością jest szybkie wprowadzanie do dokumentu\r\nzarówno szkieletu pustej strony jak i elementów z grup 2 oraz 3.\r\nTworzenie stron WWW w języku HTML w edytorze nie zawierającym żadnych\r\nułatwień wstawiania kodu znaczników to katorga.\r\nMyślę, że najlepszym sposobem zrażenia przyszłych webmasterów do\r\ntworzenia witryn w języku HTML jest próba nauczenia ich\r\ntworzenia witryn w standardowym notatniku Windows!</p>\r\n\r\n<h3 id="R10">10. Cechy każdego elementu HTML</h3>\r\n\r\n<p>Po opanowaniu znaczników zawartych w wierszach 2 i 3 tabeli 3\r\nnależy nauczyć się reguł zagnieżdżania poznanych elementów.\r\nKażdy elementem HTML możemy scharakteryzować opisując jego:</p>\r\n\r\n<ul>\r\n<li>typ (tekstowy, blokowy lub inny),</li>\r\n<li>dozwoloną zawartość,</li>\r\n<li>elementy, w których może on wystąpić,</li>\r\n<li>zastosowania,</li>\r\n<li>przykład użycia,</li>\r\n<li>style, które go dotyczą,</li>\r\n\r\n<li>oraz sposób wprowadzania do dokumentu\r\n(np. skrót klawiszowy w programie <span class="program">NotH</span>).</li>\r\n</ul>\r\n\r\n<p>Doświadczenie jest najlepszym nauczycielem\r\nzarówno reguł zagnieżdżania jak i\r\nzastosowań poszczególnych elementów HTML.\r\nWykonując kolejne ćwiczenia, pamiętajmy o sprawdzeniu poprawności\r\nzarówno kodu HTML jak i CSS.\r\nNa stronach organizacji W3C znajdziemy serwis walidujący kod HTML\r\n(<a href="http://validator.w3.org">http://validator.w3.org</a>)\r\njak i CSS (<a href="http://jigsaw.w3.org/css-validator/">http://jigsaw.w3.org/css-validator/</a>);\r\nNatomiast pod adresem <a href="http://www.htmlvalidator.com/lite/">http://www.htmlvalidator.com/lite/</a>\r\nznajdziemy jeden z ciekawszych programów sprawdzających poprawność\r\nkodu witryn WWW, który działa off-line.</p>\r\n\r\n<h3 id="R11">11. Podsumowanie</h3>\r\n\r\n<p>Pierwszym aspektem nauki języka HTML,\r\nna który chciałbym zwrócić dodatkową uwagę jest wygląd dokumentu.\r\nUcząc się języka HTML <strong>należy od początku</strong> (równolegle)\r\nrozpocząć naukę CSS.\r\nDopóki nie potrafimy pewnego efektu osiągnąć stosując style,\r\nnależy z tego efektu zrezygnować. W przeciwnym razie czeka nas podwójna praca:\r\nnauka rozwiązań ciekawych graficznie, lecz niepoprawnych w sensie standardów\r\nustalanych przez W3C, po czym próby &bdquo;naprawienia&rdquo;\r\nbłędnego dokumentu bez utraty jego atrakcyjności.\r\nProcedura taka jest zwykłą stratą czasu i nie ma żadnego sensu.</p>\r\n\r\n<p>Drugą sprawą, sygnalizowaną niejednokrotnie, jest sposób wprowadzania\r\nkodu HTML do dokumentu.\r\nJeśli pisząc stronę WWW zechcemy ręcznie wprowadzać\r\nkod znaczników, na przykład\r\n<span class="zmienna">&lt;STRONG&gt; ... &lt;/STRONG&gt; </span>,\r\nto wydajność takiej pracy będzie mizerna.\r\n\r\n<strong>Kod znaczników musi być wstawiany przez edytor.</strong></p>\r\n\r\n<p>Większość edytorów HTML zawiera różnego rodzaju udogodnienia.\r\nSkróty klawiszowe, zastosowane w programie <span class="zmienna">NotH</span>,\r\nmają tę przewagę nad rozwiązaniami stosującymi przyciski,\r\nże wstawienie, usunięcie lub zmiana kodu znacznika nie\r\nwymaga odrywania palców od klawiatury.\r\nW ten sposób, pisząc dziesięcioma palcami na klawiaturze,\r\nmożemy w płynny sposób przeplatać tekst z elementami HTML.\r\nAktywacja skrótu klawiszowego (np. <span class="shortcut">Ctrl+F+S</span>)\r\nwstawia do dokumentu kod znacznika\r\n(czyli np. napis <span class="zmienna">&lt;STRONG&gt;&lt;/STRONG&gt;</span>).\r\nJeśli przed wykonaniem skrótu pewien fragment tekstu był zaznaczony,\r\nwówczas tekst ten zostanie umieszczony wewnątrz elementu.\r\nNatomiast po zaznaczeniu całego elementu HTML klawisze\r\n<span class="shortcut">Ctrl+Delete</span> usuną kod znaczników\r\notwierającego i zamykającego, pozostawiając zawartość\r\n(po zaznaczeniu tekstu <span class="zmienna">&lt;EM&gt;KOT&lt;/EM&gt;</span>\r\n\r\ni naciśnięciu <span class="shortcut">Ctrl+Delete</span>\r\notrzymamy tekst <span class="zmienna">KOT</span>).</p>\r\n\r\n<p>Oczywiście minusem korzystania ze skrótów klawiszowych\r\njest konieczność nauczenia się ich.\r\nJednak sądzę, że wysiłek włożony w opanowanie skrótów do\r\nelementów z grup 2 i 3 tabeli 3\r\n(oraz skrótu <span class="shortcut">Ctrl+S+A</span>\r\n- kodu pustej strony)\r\njest niewielki w stosunku do korzyści, jakie osiągniemy.\r\nTabela 4 przedstawia skróty klawiszowe najważniejszych elementów HTML.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Skrót</th><th>Opis</th><th>Kod HTML</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Skrót</th><th>Opis</th><th>Kod HTML</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">SA</span></td>\r\n\r\n<td>pusta strona</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">SZ</span></td>\r\n\r\n<td>style zewnętrzne</td>\r\n\r\n<td><span class="zmienna">&lt;LINK rel="..." ...&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">SW</span></td>\r\n\r\n<td>style wewnętrzne</td>\r\n\r\n<td><span class="zmienna">&lt;STYLE type="text/css"&gt;...</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PK</span></td>\r\n\r\n<td>komentarz HTML</td>\r\n\r\n<td><span class="zmienna">&lt;!-- ... --&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">P1-P6</span></td>\r\n\r\n<td>nagłówki</td>\r\n\r\n<td><span class="zmienna">&lt;H1&gt;...&lt;/H1&gt; - &lt;H6&gt;...&lt;/H6&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PP</span></td>\r\n\r\n<td>akapit</td>\r\n\r\n<td><span class="zmienna">&lt;P&gt;...&lt;/P&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PR</span></td>\r\n\r\n<td>złamanie wiersza</td>\r\n\r\n<td><span class="zmienna">&lt;BR&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">LH</span></td>\r\n\r\n<td>linia pozioma</td>\r\n\r\n<td><span class="zmienna">&lt;HR&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">FS</span></td>\r\n\r\n<td>uwypuklenie tekstu</td>\r\n\r\n<td><span class="zmienna">&lt;STRONG&gt;...&lt;/STRONG&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">FE</span></td>\r\n\r\n<td>uwypuklenie tekstu</td>\r\n\r\n<td><span class="zmienna">&lt;EM&gt;...&lt;/EM&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">FP</span></td>\r\n\r\n<td>tekst preformatowany</td>\r\n\r\n<td><span class="zmienna">&lt;PRE&gt;...&lt;/PRE&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">QA</span></td>\r\n\r\n<td>znak <span class="zmienna">&amp;</span></td>\r\n\r\n<td><span class="zmienna">&amp;amp;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">QS</span></td>\r\n\r\n<td>znak spacja</td>\r\n\r\n<td><span class="zmienna">&amp;nbsp;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">QL</span></td>\r\n\r\n<td>znak <span class="zmienna">&lt;</span></td>\r\n\r\n<td><span class="zmienna">&amp;lt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">QG</span></td>\r\n\r\n<td>znak <span class="zmienna">&gt;</span></td>\r\n\r\n<td><span class="zmienna">&amp;gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PA</span></td>\r\n\r\n<td>hiperłącze</td>\r\n\r\n<td><span class="zmienna">&lt;A href="..."&gt;...&lt;/A&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PI</span></td>\r\n\r\n<td>obraz</td>\r\n\r\n<td><span class="zmienna">&lt;IMG src="..." alt="..."&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">WT</span></td>\r\n\r\n<td>tabela</td>\r\n\r\n<td><span class="zmienna">&lt;TABLE&gt;...&lt;/TABLE&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">WR</span></td>\r\n\r\n<td>wiersz tabeli</td>\r\n\r\n<td><span class="zmienna">&lt;TR&gt;...&lt;/TR&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">WD</span></td>\r\n\r\n<td>komórka tabeli</td>\r\n\r\n<td><span class="zmienna">&lt;TD&gt;...&lt;/TD&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">WH</span></td>\r\n\r\n<td>komórka nagłówkowa tabeli</td>\r\n\r\n<td><span class="zmienna">&lt;TH&gt;...&lt;/TH&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">LU</span></td>\r\n\r\n<td>lista wypunktowana</td>\r\n\r\n<td><span class="zmienna">&lt;UL&gt;...&lt;/UL&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">LO</span></td>\r\n\r\n<td>lista numerowana</td>\r\n\r\n<td><span class="zmienna">&lt;OL&gt;...&lt;/OL&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">LI</span></td>\r\n\r\n<td>element listy</td>\r\n\r\n<td><span class="zmienna">&lt;LI&gt;...&lt;/LI&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PD</span></td>\r\n\r\n<td>element <span class="zmienna">DIV</span></td>\r\n\r\n<td><span class="zmienna">&lt;DIV&gt;...&lt;/DIV&gt;</span></td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">PS</span></td>\r\n\r\n<td>element <span class="zmienna">SPAN</span></td>\r\n\r\n<td><span class="zmienna">&lt;SPAN&gt;...&lt;/SPAN&gt;</span></td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 4.\r\nSkróty klawiszowe programu <span class="program">NotH</span></p>\r\n</div>', 'cytaty-wykazy-oraz-elementy-div-i-span');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(8, 'CSS - kaskadowe arkusze stylów', 'Kaskadowe arkusze stylów dołączane do witryn WWW zawierają\r\ndefinicje formatów poszczególnych elementów HTML.\r\nArtykuł zawiera przegląd najważniejszych informacji dotyczących\r\njęzyka CSS.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Struktura a wygląd dokumentów HTML</a></li>\r\n<li><a href="#R2">2. Dołączanie stylów do dokumentu</a></li>\r\n<li><a href="#R3">3. Atrybut style</a></li>\r\n<li><a href="#R4">4. Wielkość liter, białe znaki i komentarze</a></li>\r\n<li><a href="#R5">5. Składnia stylu CSS</a></li>\r\n<li><a href="#R6">6. Skrócony i rozszerzony zapis kilku stylów</a></li>\r\n<li><a href="#R7">7. Selektor grupowy</a></li>\r\n<li><a href="#R8">8. Klasy i identyfikatory</a></li>\r\n<li><a href="#R9">9. Elementy DIV i SPAN oraz atrybut class</a></li>\r\n<li><a href="#R10">10. Jednostki długość</a></li>\r\n<li><a href="#R11">11. Kolory stosowane na stronach WWW</a></li>\r\n<li><a href="#R12">12. Zestawienie najczęściej stosowanych atrybutów</a></li>\r\n<li><a href="#R13">13. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Struktura a wygląd dokumentów HTML</h3>\r\n\r\n<p>Wygląd witryn WWW zależy od dwóch czynników:\r\nkodu strony (napisanego zazwyczaj w języku HTML) oraz formatu nadawanego\r\nprzez przeglądarkę różnym elementom HTML.\r\n\r\nZawartość i strukturę dokumentu opisujemy korzystając z elementów HTML:\r\nakapitów (<span class="zmienna">P</span>),\r\nnagłówków  (<span class="zmienna">H1</span>, <span class="zmienna">H2</span>),\r\ntabel (<span class="zmienna">TABLE</span>,\r\n<span class="zmienna">TD</span>,\r\n<span class="zmienna">TR</span>),\r\nsekcji (<span class="zmienna">DIV</span>), itd.\r\nNatomiast format elementów definiujemy w języku CSS\r\n(ang. <span class="ang">Casscading Style Sheets</span> - kaskadowe arkusze stylów).</p>\r\n\r\n<p>Zatem tworząc witrynę WWW musimy opisać:</p>\r\n\r\n<ul>\r\n<li>zawartość i strukturę strony (w języku HTML);</li>\r\n<li>format elementów (w języku CSS).</li>\r\n</ul>\r\n\r\n<p>W przypadku braku opisu stylów, przeglądarka zastosuje style\r\ndomyślne, które zazwyczaj są dość ubogie.</p>\r\n\r\n<p>Oddzielając definicję formatu elementów od samej zawartości strony\r\notrzymamy dokument, którego format jest niezależny od kodu HTML.\r\nGłówną korzyścią takiego rozwiązania jest to,\r\nże wygląd dokumentu możemy modyfikować nie zmieniając jego treści\r\nani kodu HTML.</p>\r\n\r\n<h3 id="R2">2. Dołączanie stylów do dokumentu</h3>\r\n\r\n<p>Definicję stylów możemy dołączyć do dokumentu na dwa sposoby:</p>\r\n\r\n<ul>\r\n<li>jako style wewnętrzne,</li>\r\n<li>jako style zewnętrzne.</li>\r\n</ul>\r\n\r\n<p>W obydwu przypadkach, informację o stylach\r\numieszczamy w nagłówku strony WWW\r\n(a więc pomiędzy znacznikami\r\n<span class="zmienna">&lt;HEAD&gt;</span>\r\noraz\r\n<span class="zmienna">&lt;/HEAD&gt;</span>).</p>\r\n\r\n<p>Stosując style wewnętrzne korzystamy z elementu\r\n<span class="zmienna">STYLE</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;STYLE type=&quot;text/css&quot;&gt;\r\n&lt;!--\r\n...\r\ntutaj definicja stylów\r\n...\r\n--&gt;\r\n&lt;/STYLE&gt;</pre>\r\n\r\n<p>Definicja stylów znajduje się wewnątrz komentarza HTML\r\n(czyli pomiędzy <span class="zmienna">&lt;!--</span>\r\noraz\r\n<span class="zmienna">--&gt;</span>).\r\nNie jest to konieczne, ale\r\nw przypadku przeglądarki, która nie potrafi interpretować stylów,\r\nzawartość elementu <span class="zmienna">STYLE</span>\r\n\r\npojawi się w treści strony\r\n(przeglądarka po napotkaniu nieznanego elementu, powinna go zignorować,\r\npozostawiając jedynie jego zawartość).\r\nZastosowanie komentarza HTML usuwa style z treści strony wyświetlanej przez\r\nprzeglądarkę, która nie potrafi interpretować stylów.</p>\r\n\r\n<p>Wewnątrz komentarza umieszczamy opis stylów.</p>\r\n\r\n<p>Element <span class="zmienna">STYLE</span> posiada dwa atrybuty:\r\n<span class="zmienna">type</span> oraz <span class="zmienna">media</span>.\r\nAtrybut <span class="zmienna">type</span> ustala język stosowany do opisu stylów.\r\nW przypadku stosowania języka CSS atrybutowi\r\n\r\n<span class="zmienna">type</span> należy nadać wartość <span class="zmienna">text/css</span>.</p>\r\n\r\n<p>Atrybut <span class="zmienna">media</span> może przyjmować\r\nmiędzy innymi wartości <span class="zmienna">screen</span> oraz\r\n<span class="zmienna">print</span>.\r\nWartością domyślną jest <span class="zmienna">screen</span>.\r\nStosowanie atrybutu <span class="zmienna">media</span>\r\n\r\njest jednym ze sposobów przygotowania\r\ndwóch różnych formatów strony: jednego przeznaczonego do wyświetlenia\r\nna ekranie oraz drugiego - przeznaczonego do wydruku.</p>\r\n\r\n<p>Style zewnętrzne zapisujemy w osobnym pliku.\r\nJeśli stosujemy język CSS, to plikowi nadajemy\r\nrozszerzenie <span class="plik">.css</span>.\r\nTak zdefiniowane style dołączmy do dokumentu HTML\r\nstosując element <span class="zmienna">LINK</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LINK rel=&quot;stylesheet&quot; href=&quot;nazwapliku.css&quot; type=&quot;text/css&quot;&gt;</pre>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/08-01.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nWitryna stanowiąca treść ćwiczeń 1 oraz 2</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h5>Ćwiczenie 1</h5>\r\n\r\n<p>Przygotuj witrynę <em>Witaj przybyszu!</em>\r\nprzedstawioną na rysunku 1, zawierającą style wewnętrzne.</p>\r\n\r\n<p>Cała witryna, zarówno style jak i kod HTML, są zapisane w jednym pliku.\r\nW nagłówku strony jest umieszczony element <span class="zmienna">STYLE</span>,\r\nktóry definiuje format elementów <span class="zmienna">BODY</span>,\r\n<span class="zmienna">H1</span> oraz <span class="zmienna">DIV</span>.\r\nKod witryny został przedstawiony na listingu 1.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01//EN&quot;\r\n          &quot;http://www.w3.org/TR/html4/strict.dtd&quot;&gt;\r\n&lt;HTML&gt;\r\n  &lt;HEAD&gt;\r\n    &lt;TITLE&gt;Style wewnętrzne&lt;/TITLE&gt;\r\n    &lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;\r\n    &lt;STYLE type=&quot;text/css&quot;&gt;\r\n    &lt;!--\r\n    BODY {\r\n        background : rgb(215,251,226);\r\n        text-align : center;\r\n        margin     : 50px;\r\n    }\r\n\r\n    DIV {\r\n        background : rgb(0,128,255);\r\n        width      : 400px;\r\n        border     : 3px black solid;\r\n    }\r\n\r\n    H1 {\r\n        margin     : 20px;\r\n        border     : 1px solid black;\r\n        background : rgb(255,255,155);\r\n    }\r\n    --&gt;\r\n    &lt;/STYLE&gt;\r\n  &lt;/HEAD&gt;\r\n&lt;BODY&gt;\r\n&lt;DIV&gt;&lt;H1&gt;WITAJ PRZYBYSZU!&lt;/H1&gt;&lt;/DIV&gt;\r\n&lt;/BODY&gt;\r\n&lt;/HTML&gt;</pre>\r\n<p class="podpis">\r\nListing 1.\r\nWitryna stosująca style wewnętrzne</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h5>Ćwiczenie 2</h5>\r\n\r\n<p>Przygotuj witrynę z ćwiczenia pierwszego, umieszczając style w osobnym pliku.</p>\r\n\r\n<p>Tym razem rozwiązanie składa się z dwóch plików: pliku HTML oraz pliku CSS.\r\nW nagłówku pliku HTML znajduję się element <span class="zmienna">LINK</span>\r\ndołączający do strony style zapisane w pliku CSS.\r\nPlik HTML jest przedstawiony na listingu 2, a plik CSS - na listingu 3.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01//EN&quot;\r\n          &quot;http://www.w3.org/TR/html4/strict.dtd&quot;&gt;\r\n&lt;HTML&gt;\r\n  &lt;HEAD&gt;\r\n    &lt;TITLE&gt;Style zewnętrzne&lt;/TITLE&gt;\r\n    &lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;\r\n    &lt;LINK rel=&quot;stylesheet&quot; href=&quot;nowestyle.css&quot; type=&quot;text/css&quot;&gt;\r\n  &lt;/HEAD&gt;\r\n&lt;BODY&gt;\r\n&lt;DIV&gt;&lt;H1&gt;WITAJ PRZYBYSZU!&lt;/H1&gt;&lt;/DIV&gt;\r\n&lt;/BODY&gt;\r\n&lt;/HTML&gt;</pre>\r\n<p class="podpis">\r\n\r\nListing 2.\r\nWitryna wykorzystująca style zewnętrzne zapisane w pliku <span class="plik">nowestyle.css</span></p>\r\n</div>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">\r\nBODY {\r\n    background : rgb(215,251,226);\r\n    text-align : center;\r\n    margin     : 50px;\r\n}\r\n\r\nDIV {\r\n    color      : rgb(0,0,0);\r\n    background : rgb(0,128,255);\r\n    width      : 400px;\r\n    border     : 3px black solid;\r\n}\r\n\r\nH1 {\r\n    margin     : 20px;\r\n    border     : 1px solid black;\r\n    background : rgb(255,255,155);\r\n}</pre>\r\n<p class="podpis">\r\nListing 3.\r\nPlik <span class="plik">nowestyle.css</span> zawierający definicje stylów</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Jak widać różnica pomiędzy obydwoma rozwiązaniami jest niewielka.\r\nSprowadza się do rozbicia pliku przygotowanego w ćwiczeniu pierwszym na dwa pliki,\r\nusunięciu elementu <span class="zmienna">STYLE</span> oraz dodaniu elementu\r\n<span class="zmienna">LINK</span>.\r\nZatem które z rozwiązań jest lepsze i w jaki sposób objawiają się jego zalety?</p>\r\n\r\n<p>Głównym czynnikiem oceny jest liczba plików <span class="plik">.html</span>\r\n\r\ntworzących witrynę. Jeśli przygotowujemy pojedynczy plik HTML, wówczas możemy\r\nrozważać stosowanie stylów wewnętrznych. W przeciwnym razie (tj. jeśli witryna składa się\r\nz dwóch lub większej liczby plików HTML), stosowanie stylów wewnętrznych nie ma sensu.\r\nNależy użyć stylów zewnętrznych.</p>\r\n\r\n<p>Jeśli zastosujemy style wewnętrzne wówczas prosta operacja\r\n<span class="opcja">Widok/Źródło</span> wykonana w przeglądarce,\r\npozwoli na analizę zarówno kodu HTML jak i stylów.\r\nDrugą sytuacją, w której stosowanie stylów wewnętrznych\r\nbędzie miało zalety, jest podglądanie spakowanego archiwum.\r\nJeśli po otworzeniu spakowanego archiwum zawierającego pliki HTML\r\nprogramem kompresującym (np. <span class="program">WinZip</span>)\r\npodwójnie klikniemy jeden z plików html, wówczas przeglądarka wyświetli\r\npoprawnie (tj. uwzględniając wszystkie formaty) jedynie\r\nstronę zawierającą style wewnętrzne.</p>\r\n\r\n<p>Style wewnętrzne znajdują zastosowanie głównie przy tworzeniu witryn\r\ninstruktażowych z ćwiczeniami. Podglądanie rozwiązania jest wówczas nieco prostsze niż w\r\nprzypadku stosowania stylów zewnętrznych.</p>\r\n\r\n<p>Za stylami zewnętrznymi przemawiają wszystkie pozostałe czynniki.\r\nRozmiar witryny tworzonej przy użyciu stylów zewnętrznych jest mniejszy.\r\nJeśli witryna składa się z wielu plików, wówczas tylko podczas pobierania\r\npierwszego pliku pobierane będą również style.\r\nPrzy wizycie na drugiej stronie witryny style będą pochodziły z\r\npamięci podręcznej przeglądarki (ang. <span class="ang">cache</span>).</p>\r\n\r\n<p>Modyfikowalność stylów zewnętrznych to chyba najbardziej wyraźna różnica.\r\nZmiany dokonywane w jednym pliku wpływają na całą witrynę i wszystkie jej podstrony.\r\nJeśli zastosujemy style wewnętrzne, zmiana stylów będzie wymagała\r\nmodyfikacji każdego pliku, który zawiera style wewnętrzne!</p>\r\n\r\n<h3 id="R3">3. Atrybut style</h3>\r\n\r\n<p>Jednym ze sposobów ustalania stylów elementu jest zastosowanie atrybutu\r\n<span class="zmienna">style</span>. Atrybut ten może towarzyszyć niemal każdemu\r\nelementowi HTML.</p>\r\n\r\n<p>Zmiana formatu akapitu ma postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P style=&quot;font-size: 12pt; color: red; font-family: Arial; text-align: right&quot;&gt;witaj&lt;/P&gt;</pre>\r\n\r\n<p>Metoda ta nie jest wygodna i nie powinna być nadużywana.\r\nJej ewidentną wadą jest rozmiar otrzymywanego kodu: każdy element\r\n<span class="zmienna">P</span> będzie zawierał komplet informacji o stylu.\r\nNiemniej jednak, w niektórych sytuacja powyższe rozwiązanie może być korzystne.</p>\r\n\r\n<h5>Ćwiczenie 3</h5>\r\n\r\n<p>Przygotuj witrynę z ćwiczenia pierwszego,\r\nstosując jedynie atrybuty <span class="zmienna">style</span>.</p>\r\n\r\n<p>Oczywiście rozwiązanie składa się z jednego pliku.\r\nJego kod został przedstawiony na listingu 4.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01//EN&quot;\r\n          &quot;http://www.w3.org/TR/html4/strict.dtd&quot;&gt;\r\n&lt;HTML&gt;\r\n  &lt;HEAD&gt;\r\n    &lt;TITLE&gt;Style wewnętrzne&lt;/TITLE&gt;\r\n    &lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;\r\n    &lt;META http-equiv=&quot;Content-Style-Type&quot; content=&quot;text/css&quot;&gt;\r\n  &lt;/HEAD&gt;\r\n&lt;BODY style=&quot;background: rgb(215,251,226); text-align: center; margin: 50px;&quot;&gt;\r\n&lt;DIV style=&quot;background: rgb(0,128,255); width: 400px; border: 3px black solid;&quot;&gt;\r\n&lt;H1 style=&quot;margin: 20px; border: 1px solid black; background: rgb(255,255,155);&quot;&gt;\r\nWITAJ PRZYBYSZU!\r\n&lt;/H1&gt;\r\n&lt;/DIV&gt;\r\n&lt;/BODY&gt;\r\n&lt;/HTML&gt;</pre>\r\n<p class="podpis">\r\nListing 4.\r\nUżycie atrybutu <span class="zmienna">style</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Zwróćmy jednak uwagę na fakt, że rozwiązanie z ćwiczenia 3 nie zawiera nigdzie\r\ninformacji na temat języka opisu stylów.\r\nStosując elementy <span class="zmienna">STYLE</span> oraz\r\n<span class="zmienna">LINK</span> podawaliśmy informację o języku\r\nCSS. Informacja ta była zawarta w napisie <span class="zmienna">text/css</span>.</p>\r\n\r\n\r\n<p>Jeśli w dokumencie nie pojawia się informacja na temat języka stylów,\r\na stosowane są atrybuty <span class="zmienna">style</span>,\r\nwówczas koniecznym jest umieszczenie w dokumencie\r\nelementu <span class="zmienna">META</span> ustalającego domyślny język stylów\r\n(por. dokumentacja HTML 4.01, rozdział 14.2.1):</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Style-Type&quot; content=&quot;text/css&quot;&gt;</pre>\r\n\r\n<h3 id="R4">4. Wielkość liter, białe znaki i komentarze</h3>\r\n\r\n<p>Język CSS dopuszcza stosowanie zarówno dużych jak i małych liter.\r\nDefinicję stylu:</p>\r\n\r\n<pre class="syntax-highlight:xml">BODY {\r\n    color      : brown;\r\n    background : beige;\r\n    margin     : 200px;\r\n    border     : blck 5px solid;\r\n}</pre>\r\n\r\n<p>możemy zapisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">body {\r\n    COLOR      : BROWN;\r\n    backGROUND : BEIGE;\r\n    Margin     : 200PX;\r\n    BOrdER     : blcK 5PX soLID;\r\n}</pre>\r\n\r\n<p>Nazwy atrybutów możemy pisać dużymi jak i małymi literami.\r\nPoprawnymi nazwami atrybutu są\r\n<span class="zmienna">background</span>,\r\n<span class="zmienna">backGROUND</span> oraz\r\n<span class="zmienna">BACKground</span>.</p>\r\n\r\n<p>Również wartości atrybutów możemy pisać literami dowolnej wielkości:\r\n\r\n<span class="zmienna">solid</span>,\r\n<span class="zmienna">SOLID</span> czy\r\n<span class="zmienna">Solid</span>.</p>\r\n\r\n<p>Wielkość liter jest istotna w adresach URL, w nazwach krojów czcionek\r\noraz w nazwach atrybutów <span class="zmienna">id</span> i <span class="zmienna">class</span>.</p>\r\n\r\n<p>Białe znaki są traktowane jedynie jako separatory.\r\nTam gdzie może wystąpić jeden jakikolwiek biały znak, tam może wystąpić dowolna ich liczba.\r\nNa przykład definicję:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    font-weight : bold;\r\n}</pre>\r\n\r\n<p>możemy zapisać</p>\r\n\r\n<pre class="syntax-highlight:xml">H1{font-weight:bold;}</pre>\r\n\r\n<p>oraz</p>\r\n\r\n<pre class="syntax-highlight:xml">H1\r\n  {\r\n    font-weight:bold;\r\n  }</pre>\r\n\r\n<p>Nie wszystkie białe znaki możemy pominąć. Styl:</p>\r\n\r\n<pre class="syntax-highlight:xml">border : blck 5px solid;</pre>\r\n\r\n<p>nie może być zapisany jako:</p>\r\n\r\n<pre class="syntax-highlight:xml">border:blck5pxsolid;</pre>\r\n\r\n<p>Komentarze w języku CSS oznaczamy\r\nnapisami <span class="zmienna">/*</span> oraz <span class="zmienna">*/</span>.\r\nKomentarz taki może rozciągać się na dowolną liczbę linii.\r\nKomentarzy nie możemy zagnieżdżać.</p>\r\n\r\n<h3 id="R5">5. Składnia stylu CSS</h3>\r\n\r\n<p>Pojedynczy opis stylu w języku CSS składa się z\r\n<em>selektora</em> oraz\r\n<em>definicji</em>.\r\nSelektor decyduje o tym, którym elementom HTML występującym na stronie\r\nWWW zostanie przypisany styl. Natomiast definicja,\r\nujęta w nawiasy klamrowe, ustala format.</p>\r\n\r\n<p>Na przykład w zapisie:</p>\r\n\r\n<pre class="syntax-highlight:xml">SPAN {\r\n    text-decoration : underline;\r\n}</pre>\r\n\r\n<p>selektorem jest napis <span class="zmienna">SPAN</span>,\r\nzaś definicja (objęta nawiasami klamrowymi)\r\nzawiera jeden wpis: <span class="zmienna">text-decoration : underline;</span>.</p>\r\n\r\n<p>Styl taki zostanie zinterpretowany następująco: wszystkie elementy\r\n<span class="zmienna">SPAN</span> występujące na stronie WWW\r\nzostaną podkreślone.</p>\r\n\r\n<p>Definicja stylu, otoczona nawiasami klamrowymi, może zawierać\r\ndowolną liczbę wpisów postaci:</p>\r\n\r\n<pre class="syntax-highlight:xml">atrybut : wartość;</pre>\r\n\r\n<p>Obramowanie wszystkich elementów <span class="zmienna">DIV</span>\r\nosiągniemy stosując styl:</p>\r\n\r\n<pre class="syntax-highlight:xml">DIV {\r\n    border-style : solid;\r\n    border-width : 5px;\r\n    border-color : black;\r\n}</pre>\r\n\r\n<p>Selektorem w powyższym przykładzie jest napis <span class="zmienna">DIV</span>.\r\nSelektor taki powoduje zastosowanie stylu do wszystkich elementów\r\n<span class="zmienna">DIV</span> występujących na stronie.\r\nNatomiast definicja stylu zawiera opis trzech atrybutów:\r\n<span class="zmienna">border-style</span>,\r\n<span class="zmienna">border-width</span> oraz\r\n<span class="zmienna">border-color</span>.\r\nAtrybuty te nadają czarne (<span class="zmienna">black</span>),\r\npięciopikselowe (<span class="zmienna">5px</span>),\r\nciągłe (<span class="zmienna">solid</span>) obramowanie.</p>\r\n\r\n<h3 id="R6">6. Skrócony i rozszerzony zapis kilku stylów</h3>\r\n\r\n<p>Jeśli danemu selektorowi chcemy nadać kilka stylów,\r\nto możemy to uczynić na dwa sposoby.\r\nPierwszy z nich zawiera kilka osobnych stylów dotyczących tego samego selektora,\r\nna przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 { font-weight  : bold }\r\nH1 { font-size    : 12pt }\r\nH1 { font-family  : Helvetica }</pre>\r\n\r\n<p>Drugi, wygodniejszy, stosuje pojedynczy selektor.\r\nW definicji wymieniamy kilka atrybutów:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n  font-weight : bold;\r\n  font-size   : 12pt;\r\n  font-family : Helvetica;\r\n}</pre>\r\n\r\n<p>Obydwa powyższe zapisy są równoważne.</p>\r\n\r\n<p>Ponadto zapis niektórych atrybutów,\r\nna przykład <span class="zmienna">border</span>,\r\n<span class="zmienna">font</span>\r\nczy <span class="zmienna">background</span>,\r\nmożemy skracać stosując jeden wpis zawierający\r\nkilka wartości:</p>\r\n\r\n<pre class="syntax-highlight:xml">atrybut : wartość1 wartość2 wartość3;</pre>\r\n\r\n<p>W skróconym zapisie, serię wartości atrybutów umieszczamy po\r\nnazwie atrybutu, oddzielając je białymi znakami:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    border: solid black 1px;\r\n}</pre>\r\n\r\n<p>Powyższy zapis ma takie samo znaczenie jak</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    border : solid;\r\n    border : 5px;\r\n    border : black;\r\n}</pre>\r\n\r\n\r\n<p>oraz</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    border-style : solid;\r\n    border-width : 5px;\r\n    border-color : black;\r\n}</pre>\r\n\r\n\r\n\r\n<h3 id="R7">7. Selektor grupowy</h3>\r\n\r\n<p>Jeśli identyczne style chcemy przypisać kilku elementom HTML,\r\nwtedy wygodnie jest użyć selektora grupowego.</p>\r\n\r\n<p>Zamiast pisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    text-align : center;\r\n}\r\n\r\nH2 {\r\n    text-align : center;\r\n}\r\n\r\nH3 {\r\n    text-align : center;\r\n}</pre>\r\n\r\n\r\n<p>wymieniamy elementy <span class="zmienna">H1</span>,\r\n<span class="zmienna">H2</span> oraz\r\n<span class="zmienna">H3</span> oddzielając je przecinkami:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1, H2, H3 {\r\n    text-align : center;\r\n}</pre>\r\n\r\n\r\n<h3 id="R8">8. Klasy i identyfikatory</h3>\r\n\r\n<p>Poznaliśmy pierwszy rodzaj selektorów: selektory typu.\r\nSelektory takie umożliwiają nadanie odpowiedniego formatu wszystkim elementom\r\nwybranego rodzaju (typu), które występując na stronie.\r\nNa przykład, zmianę czcionki wszystkich elementów <span class="zmienna">H1</span>\r\nosiągniemy stosując style:</p>\r\n\r\n<pre class="syntax-highlight:xml">H1 {\r\n    font-family : Verdana;\r\n}</pre>\r\n\r\n<p>Jeśli zechcemy wszystkie akapity wyjustować, wówczas wystarczy\r\nna stronie umieścić styl:</p>\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n    text-align : justify;\r\n}</pre>\r\n\r\n\r\n<p>Jednakże takie rozwiązanie będzie wystarczające jedynie w bardzo prostych przypadkach.\r\nCo zrobić, jeśli na stronie pojawi się akapit, który powinien być wyrównany do prawej strony?\r\nNie możemy zmienić definicji stylu elementu <span class="zmienna">P</span> na\r\n<span class="zmienna">text-align: right;</span>, gdyż wówczas wszystkie akapity\r\nzostaną wyrównane do prawej.</p>\r\n\r\n<p>Podobnie, co zrobić, jeżeli w tabeli chcemy kilka wybranych komórek\r\n<span class="zmienna">TD</span> wyróżnić innym kolorem?</p>\r\n\r\n<p>W celu zmiany formatu jednego lub kilku elementów występujących na stronie\r\nmożemy użyć klas oraz identyfikatorów.\r\nKlasy i identyfikatory przypisujemy elementom HTML\r\nkorzystając z atrybutów <span class="zmienna">id</span> oraz\r\n<span class="zmienna">class</span>.\r\nAtrybuty te należą do grupy <span class="zmienna">coreattrs</span> i\r\nmogą towarzyszyć każdemu elementowi HTML.</p>\r\n\r\n<p>Poprawnymi wartościami atrybutów\r\n<span class="zmienna">class</span> oraz\r\n\r\n<span class="zmienna">id</span>\r\nsą napisy rozpoczynające się od litery i zawierające litery,\r\ncyfry oraz znak myślnika.\r\nWielkość liter jest rozróżniana.</p>\r\n\r\n<p>W kodzie HTML witryny WWW stosujemy atrybut <span class="zmienna">class</span>.\r\nNa przykład akapit zawierający artykuł może wyglądać następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P class=&quot;wprowadzenie&quot;&gt;\r\n... treść wprowadzenie ...\r\n&lt;/P&gt;\r\n\r\n&lt;P&gt;\r\n... treść artykułu ...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Definiując style do powyższego kodu możemy zastosować selektory\r\n<span class="zmienna">P</span> oraz\r\n<span class="zmienna">P.wprowadzenie</span>,\r\n<span class="zmienna">*.wprowadzenie</span> oraz\r\n\r\n<span class="zmienna">.wprowadzenie</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n...\r\n}\r\n\r\nP.wprowadzenie {\r\n...\r\n}\r\n\r\n*.wprowadzenie {\r\n...\r\n}\r\n\r\n.wprowadzenie {\r\n...\r\n}</pre>\r\n\r\n<p>Selektor <span class="zmienna">P</span>  dotyczy wszystkich elementów\r\n<span class="zmienna">P</span> występujących na stronie (także tych, które posiadają\r\natrybut <span class="zmienna">class</span>).\r\nSelektor <span class="zmienna">P.wprowadzenie</span> odnosi się wyłącznie do\r\ntych akapitów (elementów <span class="zmienna">P</span>),\r\nktóre posiadają atrybut <span class="zmienna">class</span>\r\n\r\no wartości <span class="zmienna">wprowadzenie</span>.\r\nNatomiast selektory <span class="zmienna">*.wprowadzenie</span> oraz\r\n<span class="zmienna">.wprowadzenie</span> są równoważne i odnoszą się\r\ndo wszystkich elementów (nie tylko akapitów,\r\nale również nagłówków, tabel czy sekcji),\r\nktóre posiadają atrybut <span class="zmienna">class</span>\r\no wartości <span class="zmienna">wprowadzenie</span>.</p>\r\n\r\n\r\n<h5>Ćwiczenie 4</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą nowelę p.t. <em>Janko Muzykant</em>.\r\nZwróć uwagę na akapit zawierający w treści jedynie znak\r\n<span class="zmienna">*</span>.\r\nAkapit ten należy wyśrodkować.</p>\r\n\r\n\r\n<p>Treść utworu składa się z akapitów tekstu.\r\nKolejne akapity otaczamy znacznikami\r\n<span class="zmienna">&lt;P&gt;</span>\r\noraz\r\n\r\n<span class="zmienna">&lt;/P&gt;</span>.\r\nNatomiast akapit, który składa się z pojedynczego znaku <span class="zmienna">*</span>,\r\numieszczamy w akapicie klasy <span class="zmienna">srodek</span>.\r\nOto fragment kodu HTML strony z nowelą:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;Pokój ci, Janku!&lt;/P&gt;\r\n&lt;P class=&quot;srodek&quot;&gt;*&lt;/P&gt;\r\n&lt;P&gt;Nazajutrz powrócili państwo ... &lt;/P&gt;</pre>\r\n\r\n<p>Definiując style do powyższego fragmentu, korzystamy z\r\nselektorów <span class="zmienna">P</span> oraz\r\n<span class="zmienna">P.srodek</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n    text-indent : 2em;\r\n    text-align  : justify;\r\n}\r\n\r\nP.srodek {\r\n    text-align : center\r\n}</pre>\r\n\r\n\r\n\r\n<p>W podobny sposób jak z klas znaczników korzystamy z identyfikatorów.\r\nW kodzie HTML stosujemy atrybut <span class="zmienna">id</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DIV id=&quot;menu&quot;&gt;\r\n...kod HTML menu...\r\n&lt;/DIV&gt;</pre>\r\n\r\n<p>Natomiast w stylach stosujemy selektory:\r\n<span class="zmienna">DIV</span>,\r\n<span class="zmienna">DIV#menu</span>,\r\n<span class="zmienna">*#menu</span> oraz\r\n<span class="zmienna">#menu</span>:</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">DIV {\r\n...style...\r\n}\r\n\r\nDIV#menu {\r\n...style...\r\n}\r\n\r\n*#menu {\r\n...style...\r\n}\r\n\r\n#menu {\r\n...style...\r\n}</pre>\r\n\r\n<p>Selektor <span class="zmienna">DIV</span> odnosi się do wszystkich elementów\r\n<span class="zmienna">DIV</span>, <span class="zmienna">DIV#menu</span> -\r\ndo elementu <span class="zmienna">DIV</span> o identyfikatorze\r\n<span class="zmienna">menu</span>. Selektory\r\n\r\n<span class="zmienna">*#menu</span> i\r\n<span class="zmienna">#menu</span>\r\nsą równoważne i dotyczą dowolnych elementów HTML\r\no identyfikatorze <span class="zmienna">menu</span>.</p>\r\n\r\n<h5>Ćwiczenie 5</h5>\r\n\r\n<p>Przygotuj witrynę przedstawiającą opowiadanie\r\n<em>The Call of The Wild</em>.\r\nAkapit zawierający trzy gwiazdki sformatuj stosując identyfikator.</p>\r\n\r\n\r\n<p>Wszystkie akapity tekstu umieszczamy wewnątrz akapitów <span class="zmienna">P</span>.\r\nAkapit zawierający gwiazdki otrzymuje identyfikator\r\n<span class="zmienna">gwiazdki</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;Then an old wolf ...&lt;/P&gt;\r\n&lt;P id=&quot;gwiazdki&quot;&gt;* * *&lt;/P&gt;\r\n&lt;P&gt;And here may well end the story of Buck ...&lt;/P&gt;</pre>\r\n\r\n<p>Dokument wzbogacamy o style:</p>\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n    text-indent : 2em;\r\n    text-align  : justify;\r\n    font-size   : 12pt;\r\n}\r\n\r\n#gwiazdki {\r\n    text-align : center;\r\n}</pre>\r\n\r\n<p>Zasadnicza różnica pomiędzy klasami i identyfikatorami polega na tym,\r\nże wartości przypisane identyfikatorom muszą być unikalne.\r\nNie możemy użyć dwukrotnie w tym samym dokumencie identycznej\r\nwartości atrybutu <span class="zmienna">id</span>.\r\nNatomiast nazwa klasy może zostać wykorzystana w dokumencie dowolną liczbę razy.</p>\r\n\r\n<h5>Ćwiczenie 6</h5>\r\n\r\n<p>Przygotuj stronę WWW z tekstem powieści\r\n<em>W osiemdziesiąt dni dookoła świata</em>.</p>\r\n\r\n<p>W utworze tym autor umieścił na początku każdego rozdziału zdanie\r\npodsumowujące zawartość.\r\nZdanie to sformatujemy stosując element\r\n<span class="zmienna">P</span> klasy <span class="zmienna">opis</span>.\r\nWszystkie pozostałe akapity teksu będą otoczone znacznikami\r\n\r\n<span class="zmienna">&lt;P&gt;</span>\r\ni\r\n<span class="zmienna">&lt;/P&gt;</span>\r\npozbawionymi jakichkolwiek atrybutów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;H2&gt;Chapter I&lt;/H2&gt;\r\n&lt;P class=&quot;opis&quot;&gt;IN WHICH PHILEAS FOGG AND PASSEPARTOUT ...&lt;/P&gt;\r\n&lt;P&gt;Mr. Phileas Fogg lived, in 1872 ...&lt;/P&gt;\r\n&lt;P&gt;Certainly an Englishman ...&lt;/P&gt;\r\n&lt;H2&gt;Chapter II&lt;/H2&gt;\r\n&lt;P class=&quot;opis&quot;&gt;IN WHICH PASSEPARTOUT IS CONVINCED ...&lt;/P&gt;\r\n&lt;P&gt;&quot;Faith,&quot; muttered Passepartout ...&lt;/P&gt;\r\n&lt;P&gt;Madame Tussaud&#39;s ...&lt;/P&gt;</pre>\r\n\r\n\r\n<h5>Ćwiczenie 7</h5>\r\n\r\n<p>Przygotuj stronę WWW z tekstem powieści\r\n<em>Ozma of Oz </em>.</p>\r\n\r\n<p>Tym razem mamy do czynienia z trzema różnymi rodzajami akapitów.\r\nAkapity z tekstem utworu sformatujemy stosując element <span class="zmienna">P</span>\r\npozbawiony klas.\r\nNa początku utworu znajduje się tekst skierowany przez autora do czytelników.\r\nTekst ten ma nieco większe marginesy. Zostanie on sformatowany\r\nelementem <span class="zmienna">P</span> klasy <span class="zmienna">wstep</span>.\r\nNatomiast podpis, który różni się sposobem wyrównania,\r\numieścimy w akapitach klasy <span class="zmienna">autor</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P class=&quot;wstep&quot;&gt;My friends ...&lt;/P&gt;\r\n&lt;P class=&quot;wstep&quot;&gt;Well, here is ...&lt;/P&gt;\r\n&lt;P class=&quot;wstep&quot;&gt;If this judgment ...&lt;/P&gt;\r\n&lt;P class=&quot;autor&quot;&gt;L.  FRANK BAUM.&lt;/P&gt;\r\n&lt;P class=&quot;autor&quot;&gt;MACATAWA, 1907.&lt;/P&gt;</pre>\r\n\r\n<h3 id="R9">9. Elementy DIV i SPAN oraz atrybut class</h3>\r\n\r\n<p>Elementy <span class="zmienna">DIV</span> oraz <span class="zmienna">SPAN</span>\r\n\r\nw połączeniu atrybutem <span class="zmienna">class</span>\r\numożliwiają jak gdyby definiowanie nowych elementów języka HTML.</p>\r\n\r\n<p>Jeśli element <span class="zmienna">SPAN</span> wzbogacimy o klasę\r\n<span class="plik">program</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SPAN class=&quot;program&quot;&gt;Adobe Photoshop&lt;/SPAN&gt;</pre>\r\n\r\n<p>wówczas element taki może pojawić się na stronie WWW dowolną liczbę razy,\r\nzaś style jego definiujemy stosując selektor:</p>\r\n\r\n<pre class="syntax-highlight:xml">SPAN.program {\r\n...style...\r\n}</pre>\r\n\r\n<p>Ilekroć w treści artykułu używamy nazwy jakiegoś programu, warto zastosować\r\nelement <span class="zmienna">SPAN</span> klasy <span class="zmienna">program</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SPAN class=&quot;program&quot;&gt;Microsoft Word&lt;/SPAN&gt;\r\n&lt;SPAN class=&quot;program&quot;&gt;Gimp&lt;/SPAN&gt;</pre>\r\n\r\n<p>Podobnie, jeśli przygotowujemy tekst dotyczący matematyki, to zmienne możemy umieścić\r\nw elementach <span class="zmienna">SPAN</span> klasy <span class="zmienna">geometria</span>.\r\nWszystkie symbole oznaczające nazwy obiektów geometrycznych\r\nformatujemy następująco</p>\r\n\r\n<pre class="syntax-highlight:xml">prosta &lt;SPAN class=&quot;geometria&quot;&gt;l&lt;/SPAN&gt;\r\npunkt &lt;SPAN class=&quot;geometria&quot;&gt;A&lt;/SPAN&gt;</pre>\r\n\r\n<p>Decyzję o tym, jakie klasy znajdą zastosowanie w konkretnym przypadku,\r\nnależy podjąć po przeanalizowaniu treści artykułu.\r\nPrzykładami są:</p>\r\n\r\n<ul>\r\n<li>nazwy plików,</li>\r\n<li>opcje programów,</li>\r\n<li>nazwy programów,</li>\r\n<li>nazwy zmiennych (ogólnie: fragmenty kodu),</li>\r\n<li>cytaty z języka obcego.</li>\r\n</ul>\r\n\r\n<p>Przykłady użycia elementów SPAN powyższych klas są następujące:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SPAN class=&quot;plik&quot;&gt;php.ini&lt;/SPAN&gt;\r\n&lt;SPAN class=&quot;program&quot;&gt;Corel Draw&lt;/SPAN&gt;\r\n&lt;SPAN class=&quot;opcja&quot;&gt;Plik/Otwórz&lt;/SPAN&gt;\r\n&lt;SPAN class=&quot;zmienna&quot;&gt;$_GET[&#39;id&#39;]&lt;/SPAN&gt;\r\n&lt;SPAN class=&quot;ang&quot;&gt;Casscading Style Sheets&lt;/SPAN&gt;</pre>\r\n\r\n<p>Element <span class="zmienna">DIV</span> wzbogacony o nazwę klasy możemy\r\nwykorzystać do definiowania większych fragmentów stron: spisów treści,\r\nsystemu menu, oraz ilustracji i listingów zawierających podpis.</p>\r\n\r\n<h5>Ćwiczenie 8</h5>\r\n\r\n<p>Sformatuj artykuł na temat programu <span class="program">C.a.R</span> stosując\r\ndo nazw plików, programów, opcji programów oraz obiektów matematycznych\r\nelement <span class="zmienna">SPAN</span> odpowiedniej klasy.</p>\r\n\r\n<h3 id="R10">10. Jednostki długość</h3>\r\n\r\n<p>Wartościami części atrybutów są długości.\r\nDługości te mogą być wyrażone w kilku różnych jednostkach.\r\nJednostkami względnymi są:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">em</span> - zależna od wielkości czcionki</li>\r\n<li><span class="zmienna">ex</span> - (x-height) zależna od wysokości czcionki</li>\r\n<li><span class="zmienna">px</span> - piksel monitora lub drukarki</li>\r\n\r\n<li><span class="zmienna">%</span>  - procenty</li>\r\n</ul>\r\n\r\n<p>Natomiast jednostkami bezwzględnymi:</p>\r\n\r\n<ul>\r\n<li><span class="zmienna">in</span> - cal</li>\r\n<li><span class="zmienna">cm</span> - centymetr</li>\r\n\r\n<li><span class="zmienna">mm</span> - milimetr</li>\r\n<li><span class="zmienna">pt</span> = 1/72 cala</li>\r\n<li><span class="zmienna">pc</span> = 12pt</li>\r\n</ul>\r\n\r\n\r\n<p>Pamiętajmy, by po każdej liczbie umieścić jednostkę.\r\nNa przykład ustalając wielkość marginesu strony\r\nnależy napisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">BODY {\r\n    margin : 100px;\r\n}</pre>\r\n\r\n<p>a nie</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\nBODY {\r\n    margin : 100;\r\n}</pre>\r\n\r\n<h3 id="R11">11. Kolory stosowane na stronach WWW</h3>\r\n\r\n<p>Do ustalenia koloru oraz tła elementu stosujemy atrybuty\r\n<span class="zmienna">color</span> oraz <span class="zmienna">background</span>.\r\nAtrybuty te odnoszą się niemalże do wszystkich znaczników.\r\nTakie ujednolicenie jest to bardzo wygodne.\r\nBez względu na to czy zmieniamy kolor akapitu, czy komórki tabeli\r\nstosujemy atrybuty <span class="zmienna">color</span> oraz\r\n<span class="zmienna">background</span>:</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">P {\r\n    color      : blue;\r\n    background : red;\r\n}\r\n\r\nTD {\r\n    color      : white;\r\n    background : brown\r\n}</pre>\r\n\r\n\r\n<p>Kolory występujące w arkuszach stylów możemy\r\nustalać na kilka sposobów.</p>\r\n\r\n<p>Po pierwsze specyfikacja języka HTML\r\ndefiniuje nazwy szesnastu podstawowych barw.\r\nNazwy te zostały przedstawione na rysunku 2.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/08-02.png" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nSzesnaście kolorów podstawowych</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Jeśli zechcemy użyć koloru nie występującego w tabeli szesnastu barw podstawowych,\r\nwówczas należy skorzystać kodu RGB. Skrót pochodzi od nazw kolorów\r\nR - red (czerwony), G - green (zielony), B - blue (niebieski).\r\nNatężenia kolorów są liczbami całkowitymi jednobajtowymi\r\nz zakresu od 0 do 255 i mogą być podane w systemie dziesiętnym bądź szesnastkowym.\r\nNasycenie barw możemy również wyrazić w procentach.\r\nW takim przypadku możemy użyć liczb rzeczywistych (tj. zawierających część ułamkową).\r\nOto przykłady definicji kolorów:</p>\r\n\r\n<pre class="syntax-highlight:xml">color : rgb(10,0,255);\r\ncolor : #0A00FF;\r\ncolor : #0a00ff;\r\ncolor : rgb(3.921%, 0%, 100%);</pre>\r\n\r\n<p>Wszystkie trzy podane style stosują tę samą barwę.\r\nNasycenie koloru czerwonego wynosi 10 (w systemie szesnastkowym\r\n<span class="zmienna">0A</span> lub <span class="zmienna">0a</span>).\r\nProcentowo nasycenie 10 wynosi 10/255 = 3.921 %.\r\nNasycenie koloru zielonego jest równe 0.\r\nKolor niebieski ma maksymalne nasycenie równe 255\r\n(szesnastkowo FF lub ff; 100%).</p>\r\n\r\n<p>Kody dziesiętne i procentowe podajemy jako parametry\r\n"funkcji" <span class="zmienna">rgb</span>.\r\nNatomiast kody szesnastkowe (pisane literami dowolnej wielkości)\r\npoprzedzamy znakiem <span class="zmienna">#</span>.</p>\r\n\r\n<p>Ponieważ RGB jest zapisany na trzech bajtach (każdy kolor na osobnym bajcie),\r\nzatem mówimy, że takie kodowanie posiada 24 bitową (8 bitów/bajt * 3 bajty = 24 bity)\r\n<em>głębię kolorów</em>.</p>\r\n\r\n<p>Nie wszystkie przeglądarki umożliwiają stosowanie aż tak bogatej gamy kolorów.\r\nNa przykład w przypadku starych monitorów VGA dostępnych jest 16 lub 256 barw.\r\nZatem stosowanie barw stwarza pewne problemy.\r\nCo się stanie, jeśli komputer, na którym oglądamy stronę nie umożliwia wyświetlania\r\nużytych kolorów?</p>\r\n\r\n<p>W celu zmniejszenia tego typu problemów zdefiniowano paletę\r\n216 barw nazwaną bezpiecznymi kolorami WWW.\r\nPaleta ta zawiera barwy powstałe przez równomierne podzielenie\r\nsześcianu barw RGB.\r\nKażdą z trzech barw składowych dzielimy na sześć natężeń o wartościach dziesiętnych:\r\n0, 51, 102, 153, 204, 255.\r\nStąd ilość otrzymanych barw wynosi 6*6*6 = 216.\r\nW szesnastkowych kodach barw bezpiecznych pojawiają się jedynie\r\ncyfry 00, 33, 66, 99, CC oraz FF.</p>\r\n\r\n<p>Rysunek 3 przedstawia wszystkie bezpieczne kolory WWW.\r\nNatomiast rysunek 4 przedstawia kolory bezpieczne\r\nułożone w sześcian barw (część barw jest zasłonięta).</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/08-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\n216 kolorów bezpiecznych</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/08-04.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nKolory bezpieczne ułożone w sześcian barw</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ostatnim sposobem kodowania kolorów jest zastosowanie palety 140 barw nazwanych.\r\nBarwy te nie pokrywają się (poza drobnymi wyjątkami) z kolorami bezpiecznymi.\r\nPierwszych 15 barw przedstawiono na rysunku 5.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/08-05.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nPierwszych piętnaście kolorów palety 140 kolorów nazwanych</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Paleta szesnastu barw podstawowych została pierwotnie opisana\r\nw specyfikacji języka HTML 4.01.\r\nInformacje na temat kolorów bezpiecznych znajdziemy\r\nw przewodniku CSS pod adresem <a href="http://www.w3.org/markup/guide/style">http://www.w3.org/MarkUp/Guide/Style</a>.\r\nNatomiast paletę 140 barw nazwanych znajdziemy pod adresem:\r\n\r\n<a href="http://www.w3.org/tr/css3-color/">http://www.w3.org/TR/css3-color/</a>\r\nWarto zwrócić uwagę, że w nadchodzącej, trzeciej wersji języka\r\nCSS pojawiają się, oprócz kodów RGB, również kody\r\nRGBA zawierające przezroczystość oraz kody HLS i HLSA.</p>\r\n\r\n<h3 id="R12">12. Zestawienie najczęściej stosowanych atrybutów</h3>\r\n\r\n<p>Efektywne wykorzystanie arkuszy stylów do formatowania dokumentów HTML\r\nwymaga znajomości podstawowych atrybutów i ich dopuszczalnych wartości.\r\nTabele od 1 do 6 zawierają najważniejsze atrybuty CSS pogrupowane\r\nkategoriami, zaś listing 5 prezentuje sposoby użycia części atrybutów.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>text-align</td>\r\n\r\n<td>justify, left, right, center</td>\r\n\r\n<td>wyrównanie poziome</td>\r\n\r\n</tr>\r\n\r\n<tr><td>vertical-align</td>\r\n\r\n<td>baseline, sub, super, top, text-top, middle, bottom, text-bottom, długość</td>\r\n\r\n<td>wyrównanie pionowe</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\n\r\nTabela 1.\r\nWyrównanie pionowe i poziome</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>width</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>szerokość</td>\r\n\r\n</tr>\r\n\r\n<tr><td>height</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>wysokość</td>\r\n\r\n</tr>\r\n\r\n<tr><td>max-width</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>maksymalna szerokość</td>\r\n\r\n</tr>\r\n\r\n<tr><td>max-height</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>maksymalna wysokość</td>\r\n\r\n</tr>\r\n\r\n<tr><td>min-width</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>minimalna szerokość</td>\r\n\r\n</tr>\r\n\r\n<tr><td>min-height</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>minimalna wysokość</td>\r\n\r\n</tr>\r\n\r\n<tr><td>margin</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>marginesy (wszystkie cztery)</td>\r\n\r\n</tr>\r\n\r\n<tr><td>margin-left, margin-right, margin-top, margin-bottom</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>marginesy lewy, prawy, górny i dolny</td>\r\n\r\n</tr>\r\n\r\n<tr><td>padding</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>otaczanie (z czterech stron)</td>\r\n\r\n</tr>\r\n\r\n<tr><td>padding-left, padding-right, padding-top, padding-bottom</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>otaczanie z lewej, prawej, górne i dolne</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 2.\r\nWysokość, szerokość, marginesy i otaczanie</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>font-family</td>\r\n\r\n<td>nazwa kroju czcionki,<br />np. Courier, Verdana, Arial, Serif</td>\r\n\r\n<td>nazwa kroju czcionki</td>\r\n\r\n</tr>\r\n\r\n<tr><td>font-size</td>\r\n\r\n<td>długość, larger, smaller</td>\r\n\r\n<td>wielkość czcionki</td>\r\n\r\n</tr>\r\n\r\n<tr><td>font-weight</td>\r\n\r\n<td>normal, bold, bolder, lighter,<br />100, 200, 300, 400, 500, 600, 700, 800, 900</td>\r\n\r\n<td>grubość kroju</td>\r\n\r\n</tr>\r\n\r\n<tr><td>font-style</td>\r\n\r\n<td>normal, italic, oblique</td>\r\n\r\n<td>kursywa</td>\r\n\r\n</tr>\r\n\r\n<tr><td>font-variant</td>\r\n\r\n<td>normal, small-caps</td>\r\n\r\n<td>kapitaliki</td>\r\n\r\n</tr>\r\n\r\n<tr><td>font-stretch</td>\r\n\r\n<td>normal, wider, narrower,<br />ultra-condensed, extra-condensed, condensed, semi-condensed,<br />semi-expanded, expanded, extra-expanded, ultra-expanded</td>\r\n\r\n<td>rozstrzelenie liter</td>\r\n\r\n</tr>\r\n\r\n<tr><td>font</td>\r\n\r\n<td>kombinacja powyższych wartości oddzielonych białymi znakami</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 3.\r\nCzcionki</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>text-indent</td>\r\n\r\n<td>długość</td>\r\n\r\n<td>wielkość wcięcia akapitu</td>\r\n\r\n</tr>\r\n\r\n<tr><td>text-decoration</td>\r\n\r\n<td>none, underline, overline, line-through, blink</td>\r\n\r\n<td>dekoracja tekstu</td>\r\n\r\n</tr>\r\n\r\n<tr><td>text-transform</td>\r\n\r\n<td>capitalize, uppercase, lowercase, none</td>\r\n\r\n<td>przekształcanie tekstu</td>\r\n\r\n</tr>\r\n\r\n<tr><td>word-spacing</td>\r\n\r\n<td>normal, długość</td>\r\n\r\n<td>odstępy między słowami</td>\r\n\r\n</tr>\r\n\r\n<tr><td>white-space</td>\r\n\r\n<td>normal, pre, nowrap</td>\r\n\r\n<td>interpretacja białych znaków</td>\r\n\r\n</tr>\r\n\r\n<tr><td>letter-spacing</td>\r\n\r\n<td>normal, długość</td>\r\n\r\n<td>odstępy między literami</td>\r\n\r\n</tr>\r\n\r\n<tr><td>line-height</td>\r\n\r\n<td>normal, długość</td>\r\n\r\n<td>wysokość linii</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 4.\r\nTekst</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n\r\n<table>\r\n<thead>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>border-style</td>\r\n\r\n<td>none, hidden, dotted, dashed,<br />solid, double, groove ridge, inset, outset</td>\r\n\r\n<td>rodzaj obramowania (linia ciągła, przerywana, itd.)</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-style-left,<br />border-style-right,<br />border-style-top,<br />border-style-bottom</td>\r\n\r\n<td>takie jak border-style</td>\r\n\r\n<td>rodzaj obramowania każdej krawędzi z osobna</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-width</td>\r\n\r\n<td>thin, medium, thick, długość</td>\r\n\r\n<td>grubość obramowania</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-left-width,<br />border-right-width,<br />border-top-width,<br />border-bottom-width</td>\r\n\r\n<td>takie jak border-width</td>\r\n\r\n<td>grubość obramowania każdej krawędzi z osobna</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-color</td>\r\n\r\n<td>kolor</td>\r\n\r\n<td>kolor obramowania</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-left-color,<br />border-right-color,<br />border-top-color,<br />border-bottom-color</td>\r\n\r\n<td>kolor</td>\r\n\r\n<td>kolor obramowania każdej krawędzi z osobna</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-collapse</td>\r\n\r\n<td>collapse, separate</td>\r\n\r\n<td>złączanie krawędzi sąsiadujących komórek tabeli</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border</td>\r\n\r\n<td>kombinacja wszystkich właściwości<br />oddzielonych białymi znakami</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td>border-left,<br />border-right,<br />border-top,<br />border-bottom</td>\r\n\r\n<td>kombinacja wszystkich właściwości<br />oddzielonych białymi znakami<br />w stosunku do każdej krawędzi<br />z osobna</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 5.\r\nObramowanie</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n\r\n<thead>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Atrybut</th><th>Poprawne wartości</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>list-style-type</td>\r\n\r\n<td>disc, circle, square,<br />decimal, decimal-leading-zero, lower-roman, upper-roman,<br />lower-greek, lower-alpha, lower-latin, upper-alpha,<br />upper-latin, hebrew, armenian, georgian,<br />cjk-ideographic, hiragana, katakana,<br />hiragana-iroha, katakana-iroha, none</td>\r\n\r\n<td>styl numerowanie i wypunktowania</td>\r\n\r\n</tr>\r\n\r\n<tr><td>list-style-position</td>\r\n\r\n<td>inside, outside</td>\r\n\r\n<td>położenie numeracji względem tekstu</td>\r\n\r\n</tr>\r\n\r\n<tr><td>list-style-image</td>\r\n\r\n<td>adres uri obrazu</td>\r\n\r\n<td>ikona wypunktowania</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 6.\r\nWypunktowanie i numerowanie</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">P {\r\n    text-align : justify;\r\n}\r\n\r\nTR {\r\n    vertical-align : top;\r\n}\r\n\r\nDIV {\r\n    width      : 100px;\r\n    height     : 75px;\r\n    max-width  : 55px;\r\n    max-height : 66%;\r\n}\r\n\r\nBODY {\r\n    margin        : 5px;\r\n    margin-right  : -40px;\r\n    margin-top    : 50%;\r\n    margin-bottom : -5%;\r\n}\r\n\r\nTD {\r\n    padding     : 5%;\r\n    padding-top : 7px;\r\n}\r\n\r\nP {\r\n    font-family : Courier;\r\n    font-size   : 8pt;\r\n    font-weight : bold;\r\n    font-style  : italic;\r\n}\r\n\r\nDIV {\r\n    font-family : Verdana;\r\n    font-size   : 150%;\r\n    font-weight : 900;\r\n}\r\n\r\nTD {\r\n    font-family : Arial;\r\n    font-size   : larger;\r\n    font-weight : lighter;\r\n}\r\n\r\nSPAN {\r\n    font : Arial 10pt bold italic;\r\n}\r\n\r\nSTRONG {\r\n    font : Verdana 200% 900 small-caps wider;\r\n}</pre>\r\n<p class="podpis">\r\nListing 5.\r\nPrzykłady użycia atrybutów z tabel 1-6</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R13">13. Podsumowanie</h3>\r\n\r\n<p>Arkusze stylów istotnie zmieniły podejście do projektowania witryn WWW.\r\nWprawdzie wiele serwisów stosuje jeszcze przestarzałe elementy HTML nadające format\r\n(np.<span class="zmienna">CENTER</span>, <span class="zmienna">FONT</span>)\r\noraz wycofane właściwości (np. <span class="zmienna">bgcolor</span>),\r\njednakże coraz częściej można napotkać strony zawierające\r\nbannery\r\n<em>"Poprawny kod HTML"</em> oraz\r\n\r\n<em>"Poprawny kod CSS"</em>.\r\nRównież publikacje traktujące o webmasteringu\r\ncoraz częściej podkreślają rolę standardów publikowanych przez\r\norganizację W3C i zachęcają do ich przestrzegania.</p>\r\n\r\n<p>Sądzę, że naukę języka HTML należy od początku\r\nłączyć z poznawaniem stylów CSS.\r\nO zaletach stosowania arkuszy stylów przekonamy się\r\nanalizując ostatnie trzy przykłady zawarte w tabeli 7.\r\nPomimo, że przedstawione witryny składają się\r\nz od kilku do kilkuset plików (!), to ich wygląd możemy modyfikować\r\nzmieniając definicje stylów zawarte w jednym pliku!\r\nNa zakończenie proponuję wykonanie\r\nćwiczeń polegających na zmianie wyglądu serwisów przedstawiających\r\npiosenki zespołu The Beatles, opowiadania Franka Bauma oraz\r\nutwory Juliusza Verne''a.</p>', 'css-kaskadowe-arkusze-stylow');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(9, 'Kontrolki formularzy', 'Formularze dostępne na stronach WWW\r\nzawierają szereg różnych kontrolek\r\nsłużących do wprowadzania danych.\r\nArtykuł szczegółowo omawia wszystkie\r\nelementy języka HTML dotyczące formularzy\r\ni wyjaśnia rolę oraz sposób wykorzystania\r\nposzczególnych atrybutów.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Elementy języka HTML dotyczące formularzy</a></li>\r\n<li><a href="#R2">2. Atrybuty formularza</a></li>\r\n<li><a href="#R3">3. Kontrolki formularza</a></li>\r\n<li><a href="#R4">4. Atrybuty ogólne kontrolek formularza</a></li>\r\n<li><a href="#R5">5. Zdarzenia dotyczące kontrolek</a></li>\r\n<li><a href="#R6">6. Elementy INPUT</a>\r\n    <ol>\r\n        <li><a href="#P6-1">6.1 Przyciski zatwierdzające i resetujące formularz</a></li>\r\n        <li><a href="#P6-2">6.2 Wiersz wprowadzania danych</a></li>\r\n        <li><a href="#P6-3">6.3 Pole hasła</a></li>\r\n        <li><a href="#P6-4">6.4 Pola wyboru</a></li>\r\n        <li><a href="#P6-5">6.5 Wykluczające pola wyboru</a></li>\r\n        <li><a href="#P6-6">6.6 Kontrolki ukryte</a></li>\r\n        <li><a href="#P6-7">6.7 Przyciski</a></li>\r\n        <li><a href="#P6-8">6.8 Kontrolka wyboru pliku</a></li>\r\n        <li><a href="#P6-9">6.9 Obraz</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R7">7. Element BUTTON</a></li>\r\n<li><a href="#R8">8. Listy</a></li>\r\n<li><a href="#R9">9. Pole tekstowe</a></li>\r\n<li><a href="#R10">10. Grupowanie i podpisywanie kontrolek formularza</a></li>\r\n<li><a href="#R11">11. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Elementy języka HTML dotyczące formularzy</h3>\r\n\r\n<p>Formularz w języku HTML definiujemy stosując element <span class="zmienna">FORM</span>.\r\nElement ten należy do grupy elementów blokowych.\r\nWewnątrz, pomiędzy znacznikami\r\n<span class="zmienna">&lt;FORM&gt;</span> oraz\r\n<span class="zmienna">&lt;/FORM&gt;</span>\r\numieszczamy zawartość formularza, na którą składają\r\nsię głownie elementy\r\n<span class="zmienna">INPUT</span>,\r\n<span class="zmienna">BUTTON</span>,\r\n<span class="zmienna">SELECT</span>,\r\n<span class="zmienna">OPTGROUP</span>,\r\n\r\n<span class="zmienna">OPTION</span>,\r\n<span class="zmienna">TEXTAREA</span>,\r\n<span class="zmienna">LABEL</span>,\r\n<span class="zmienna">FIELDSET</span> oraz\r\n<span class="zmienna">LEGEND</span>.\r\nKontrolki te układamy wewnątrz formularza stosując akapity, tabele\r\noraz sekcje <span class="zmienna">DIV</span>.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\nNajwygodniejszym sposobem rozmieszczania kontrolek\r\nformularza jest zastosowanie tabeli.\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Zwróćmy uwagę na fakt, że kontrolki formularza są elementami tekstowymi i nie mogą znajdować się\r\nbezpośrednio w elemencie <span class="zmienna">FORM</span>.\r\nPoprawną zawartością formularza jest co najmniej jeden element blokowy\r\nz wykluczeniem samego formularza (formularzy nie można zagnieżdżać!).\r\nZatem pomiędzy znacznikami <span class="zmienna">&lt;FORM ...&gt;</span>\r\noraz <span class="zmienna">&lt;/FORM&gt;</span>\r\numieszczamy tabele, akapity czy sekcje, zaś dopiero wewnątrz elementów blokowych\r\nwłaściwe kontrolki formularza.\r\nKod:</p>\r\n\r\n<pre class="syntax-highlight:xml"><strong>PRZYKŁAD NIEPOPRAWNY</strong>\r\n&lt;FORM ...&gt;\r\nLogin: &lt;INPUT name=&quot;login&quot;&gt;&lt;BR&gt;\r\nHasło: &lt;INPUT type=&quot;password&quot; name=&quot;haslo&quot;&gt;&lt;BR&gt;\r\n&lt;INPUT type=&quot;submit&quot; value=&quot;Loguj&quot;&gt;\r\n&lt;/FORM&gt;</pre>\r\n\r\n<p>jest niepoprawny. Należy go zapisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;FORM ...&gt;\r\n&lt;P&gt;\r\nLogin: &lt;INPUT name=&quot;login&quot;&gt;&lt;BR&gt;\r\nHasło: &lt;INPUT type=&quot;password&quot; name=&quot;haslo&quot;&gt;&lt;BR&gt;\r\n&lt;INPUT type=&quot;submit&quot; value=&quot;Loguj&quot;&gt;\r\n&lt;/P&gt;\r\n&lt;/FORM&gt;</pre>\r\n\r\n<p>lub stosując tabelę:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;FORM ...&gt;\r\n&lt;TABLE&gt;\r\n&lt;TR&gt;\r\n&lt;TD&gt;Login:&lt;/TD&gt;\r\n&lt;TD&gt;&lt;INPUT name=&quot;login&quot;&gt;&lt;BR&gt;&lt;/TD&gt;\r\n&lt;/TR&gt;\r\n...\r\n&lt;/TABLE&gt;\r\n&lt;/FORM&gt;</pre>\r\n\r\n<p>Rysunek 1 przedstawia dwa przykładowe formularze,\r\nstosujące do rozłożenia kontrolek akapit oraz tabelę.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-01-01.png" alt="" /><img src="artimg/09-01-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nKontrolki formularza rozmieszczone wewnątrz akapitu oraz tabeli.</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Tabela 1 zawiera zestawienie wszystkich elementów języka HTML,\r\ndotyczących formularzy.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<tr><th>Element</th><th>Znaczenie</th><th>Poprawna zawartość</th></tr>\r\n\r\n\r\n<tr><td><span class="zmienna">FORM</span></td>\r\n\r\n<td>Formularz.</td>\r\n\r\n<td>Elementy blokowe z wykluczeniem elementu <span class="zmienna">FORM</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">INPUT</span></td>\r\n\r\n<td>Wiersz wprowadzania danych, przycisk, pole wyboru, wykluczające pole wyboru.</td>\r\n\r\n<td>Element pusty.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">BUTTON</span></td>\r\n\r\n<td>Przycisk.</td>\r\n\r\n<td>Element blokowy lub tekstowy z wyjątkiem <span class="zmienna">A</span>, <span class="zmienna">FORM</span>, <span class="zmienna">FIELDSET</span> oraz kontrolek formularzy <span class="zmienna">INPUT</span>, <span class="zmienna">SELECT</span>, <span class="zmienna">TEXTAREA</span>, <span class="zmienna">LABEL</span> oraz <span class="zmienna">BUTTON</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">SELECT</span></td>\r\n\r\n<td>Lista opcji.</td>\r\n\r\n<td>Wyłącznie elementy <span class="zmienna">OPTGROUP</span> oraz <span class="zmienna">OPTION</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">OPTGROUP</span></td>\r\n\r\n<td>Grupa opcji.</td>\r\n\r\n<td>Element <span class="zmienna">OPTION</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">OPTION</span></td>\r\n\r\n<td>Pojedyncza opcja.</td>\r\n\r\n<td>Tekst pozbawiony znaczników.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">TEXTAREA</span></td>\r\n\r\n<td>Pole tekstowe.</td>\r\n\r\n<td>Tekst pozbawiony znaczników.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">LABEL</span></td>\r\n\r\n<td>Etykieta kontrolki formularza.</td>\r\n\r\n<td>Elementy tekstowe.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">FIELDSET</span></td>\r\n\r\n<td>Grupa kontrolek formularza.</td>\r\n\r\n<td>Tekst pozbawiony znaczników, <span class="zmienna">LEGEND</span> oraz elementy blokowe lub tekstowe.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">LEGEND</span></td>\r\n\r\n<td>Etykieta grupy kontrolek.</td>\r\n\r\n<td>Elementy tekstowe (w tym: kontrolki formularzy <span class="zmienna">INPUT</span>, <span class="zmienna">SELECT</span>, <span class="zmienna">TEXTAREA</span>, <span class="zmienna">LABEL</span> oraz <span class="zmienna">BUTTON</span>).</td>\r\n\r\n</tr>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nElementy języka HTML, które dotyczą formularzy.</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R2">2. Atrybuty formularza</h3>\r\n\r\n<p>Element <span class="zmienna">FORM</span>\r\nposiada - oprócz standardowych atrybutów\r\ngrupy <span class="zmienna">coreattrs</span> (czyli m.in.\r\n\r\n<span class="zmienna">id</span>,\r\n<span class="zmienna">class</span>,\r\n<span class="zmienna">title</span>,\r\n<span class="zmienna">style</span>,\r\n<span class="zmienna">lang</span> oraz standardowych zdarzeń) -\r\nwłasne atrybuty charakterystyczne:\r\n<span class="zmienna">action</span>,\r\n<span class="zmienna">method</span>,\r\n<span class="zmienna">enctype</span>,\r\n\r\n<span class="zmienna">accept</span>,\r\n<span class="zmienna">name</span>,\r\n<span class="zmienna">onsubmit</span>,\r\n<span class="zmienna">onreset</span> oraz\r\n<span class="zmienna">accept-charset</span>.</p>\r\n\r\n<p>Najważniejszym z nich jest obowiązkowy atrybut <span class="zmienna">action</span>.\r\nUstala on adres URL skryptu, który będzie wywołany\r\npo zatwierdzeniu formularza przyciskiem <span class="opcja">Wyślij</span>.\r\nDane wprowadzone do formularza zostaną przekazane do podanego skryptu.</p>\r\n\r\n<p>Drugim ważnym atrybutem formularza jest atrybut <span class="zmienna">method</span>.\r\nJego wartością jest nazwa metody protokołu HTTP. Dopuszczalnymi wartościami\r\nsą <span class="zmienna">GET</span> oraz <span class="zmienna">POST</span>.\r\nWprawdzie wartością domyślną jest <span class="zmienna">GET</span>, jednakże\r\nzaleca się - głównie z powodów bezpieczeństwa -\r\nstosowanie metody <span class="zmienna">POST</span>.</p>\r\n\r\n<p>Atrybut <span class="zmienna">enctype</span> ustala sposób zakodowania\r\ndanych dołączonych do zapytania.\r\nMa on znaczenie jedynie, gdy formularz przekazujemy metodą\r\n<span class="zmienna">POST</span>\r\n(w przypadku metody <span class="zmienna">GET</span>\r\nzawsze stosowane jest kodowanie\r\n<span class="zmienna">application/x-www-form-urlencoded</span>).\r\nDomyślnie, wartością tego atrybutu jest typ\r\n<span class="zmienna">application/x-www-form-urlencoded</span>.\r\nW przypadku przekazywania pliku na serwer, należy\r\nustalić wartość tego atrybutu na <span class="zmienna">multipart/form-data</span>.</p>\r\n\r\n<p>Z atrybutu <span class="zmienna">enctype</span> korzystamy na dwa sposoby.\r\nJeśli formularz służy do przekazywania pliku na serwer,\r\nwówczas należy nadać atrybutowi\r\n<span class="zmienna">enctype</span> wartość\r\n<span class="zmienna">enctype="multipart/form-data"</span>.\r\nW przeciwnym razie (czyli w przypadku zwykłego formularza zawierającego\r\nkilka kontrolek) atrybut <span class="zmienna">enctype</span> pomijamy.\r\nPrzyjmie on wówczas wartość domyślną.</p>\r\n\r\n<p>Atrybut <span class="zmienna">accept</span> nie jest wykorzystywany.\r\nMiał on umożliwiać wskazanie typów plików, jakie mogą być wysłane formularzem na serwer.\r\nJednakże współczesne przeglądarki ignorują jego wartość.</p>\r\n\r\n<p>Wreszcie zdarzenia <span class="zmienna">onsubmit</span> oraz\r\n<span class="zmienna">onreset</span> umożliwiają wykonanie skryptów\r\npo zatwierdzeniu oraz zresetowaniu formularza.</p>\r\n\r\n<p>Tabela 2 zawiera sumaryczne zestawienie wszystkich specyficznych\r\natrybutów formularza.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<tr><th>Atrybut</th><th>Znaczenie</th><th>Wartość domyślna</th><th>Uwagi</th></tr>\r\n\r\n\r\n\r\n<tr><td><span class="zmienna">action</span></td>\r\n\r\n<td>Adres URL skryptu przetwarzającego formularz.</td>\r\n\r\n<td>brak</td>\r\n\r\n<td>Wymagany.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">method</span></td>\r\n\r\n<td><span class="zmienna">GET</span> lub <span class="zmienna">POST</span>: metoda protokołu HTTP, użyta do przekazania wprowadzonych danych.</td>\r\n\r\n<td><span class="zmienna">GET</span></td>\r\n\r\n<td>Zalecane jest stosowanie metody <span class="zmienna">POST</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">enctype</span></td>\r\n\r\n<td>Sposób kodowania danych zawartych w formularzu.</td>\r\n\r\n<td><span class="zmienna">application/x-www-form-urlencoded</span></td>\r\n\r\n<td>W przypadku zwykłego formularza należy stosować metodę <span class="zmienna">POST</span> i domyślną wartość atrybutu <span class="zmienna">enctype</span> (pomijamy atrybut <span class="zmienna">enctype</span> w znaczniku <span class="zmienna">&lt;FORM ...&gt;</span>). W przypadku formularza, który przesyła na serwer plik stosujemy metodę <span class="zmienna">POST</span> i <span class="zmienna">enctype="multipart/form-data"</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">accept</span></td>\r\n\r\n<td>Typ plików, jakie można przesłać na serwer.</td>\r\n\r\n<td>-</td>\r\n\r\n<td>Atrybut ignorowany przez przeglądarki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">name</span></td>\r\n\r\n<td>Nazwa identyfikująca formularz.</td>\r\n\r\n<td>-</td>\r\n\r\n<td>Użycie tego atrybutu jest odradzane. W jego miejsce należy stosować atrybut <span class="zmienna">id</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">onsubmit</span></td>\r\n\r\n<td>Skrypt wykonywany po zatwierdzeniu formularza, przed wysłaniem zapytania HTTP.</td>\r\n\r\n<td>-</td>\r\n\r\n<td>Obsługa zdarzenia może być wykorzystana do walidacji formularza. Jeśli skrypt zwraca wartość <span class="zmienna">false</span>, wówczas formularz nie zostaje wysłany.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">onreset</span></td>\r\n\r\n<td>Skrypt wykonywany po zresetowaniu formularza.</td>\r\n\r\n<td>-</td>\r\n\r\n<td>Umożliwia inicjalizację pól formularza wartościami domyślnymi.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">accept-charset</span></td>\r\n\r\n<td>Kodowanie znaków.</td>\r\n\r\n<td>-</td>\r\n\r\n<td>Kodowanie znaków stosowane w formularzu.</td>\r\n\r\n</tr>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 2.\r\nAtrybuty specyficzne elementu <span class="zmienna">FORM</span>.</p>\r\n</div>\r\n\r\n\r\n<h3 id="R3">3. Kontrolki formularza</h3>\r\n\r\n<p>Formularz może zawierać kilka rodzajów kontrolek.\r\nNależą do nich:</p>\r\n\r\n<ul>\r\n<li>wiersze wprowadzania danych,</li>\r\n<li>wiersze wprowadzania haseł,</li>\r\n<li>przyciski,</li>\r\n<li>przyciski wyboru (<span class="ang">ang. checkbox</span>),</li>\r\n\r\n<li>wykluczające się przyciski wyboru (<span class="ang">ang. radio buttons</span>),</li>\r\n<li>listy rozwijane,</li>\r\n<li>listy wyboru,</li>\r\n<li>pola tekstowe,</li>\r\n<li>pola ukryte oraz</li>\r\n<li>przyciski umożliwiające wybór pliku.</li>\r\n</ul>\r\n\r\n<p>Kontrolki te umieszczamy wewnątrz formularza stosując\r\nelementy\r\n<span class="zmienna">INPUT</span>,\r\n<span class="zmienna">BUTTON</span>,\r\n<span class="zmienna">SELECT</span>,\r\n<span class="zmienna">OPTGROUP</span>,\r\n<span class="zmienna">OPTION</span>  i\r\n<span class="zmienna">TEXTAREA</span>.\r\n\r\nDodatkowo, elementy\r\n<span class="zmienna">LABEL</span>,\r\n<span class="zmienna">FIELDSET</span> i\r\n\r\n<span class="zmienna">LEGEND</span> umożliwiają\r\npogrupowanie kontrolek oraz ustalenie etykiet.</p>\r\n\r\n<h3 id="R4">4. Atrybuty ogólne kontrolek formularza</h3>\r\n\r\n<p>Większość kontrolek zawartych w formularzu posiada atrybut <span class="zmienna">name</span>\r\n(wyjątkami są przyciski zatwierdzające i resetujące formularz,\r\nopcje i grupy opcji <span class="zmienna">OPTION</span> oraz <span class="zmienna">OPTGROUP</span>,\r\njak również elementy\r\n\r\n<span class="zmienna">FIELDSET</span>,\r\n<span class="zmienna">LEGEND</span> i <span class="zmienna">LABEL</span>).\r\nAtrybut ten ustala nazwę kontrolki, jaka zostanie przekazana do skryptu.\r\nJeśli wewnątrz następującej kontrolki <span class="zmienna">INPUT</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT name=&quot;email&quot;&gt;</pre>\r\n\r\n<p>wprowadzimy napis <span class="zmienna">diabel@pieklo.com</span>,\r\nwówczas do skryptu zostanie przekazana zmienna:</p>\r\n\r\n<pre class="syntax-highlight:xml">email=diabel@pieklo.com</pre>\r\n\r\n<p>W języku php, powyższa zmienna będzie dostępna w jednej z tablic\r\n<span class="zmienna">$_POST</span> lub <span class="zmienna">$_GET</span>,\r\nnp.:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[''email''] === ''diabel@pieklo.com''</pre>\r\n\r\n<p>Warto zwrócić uwagę na pewne ułatwienia występujące w języku php i dotyczące\r\nprzetwarzania wielu pól formularza.\r\nJeśli wartość atrybutów <span class="zmienna">name</span>\r\nkilku kontrolek zakończymy nawiasami kwadratowymi, np.</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT name=&quot;kolor[]&quot;&gt;</pre>\r\n\r\n<p>wówczas dane pochodzące z tychże kontrolek formularza zostaną zawarte\r\nw tablicy <span class="zmienna">$_POST[''kolor'']</span>.\r\nW ten sposób zamiast wielu osobnych zmiennych otrzymamy jedną\r\ntablicę zawierającą wiele wartości.\r\nJest to szczególnie wygodne w przypadku pól wyboru\r\n(kontrolki <span class="zmienna">INPUT</span> typu\r\n<span class="zmienna">checkbox</span>)\r\noraz list wielokrotnego wyboru\r\n(kontrolki <span class="zmienna">SELECT</span> z atrybutem <span class="zmienna">multiselect</span>).</p>\r\n\r\n<p>Kolejnym atrybutem, jaki stosujemy w odniesieniu do większości kontrolek jest atrybut\r\n<span class="zmienna">value</span>. W zależności od kontrolki, atrybut ten ustala bieżącą wartość\r\nzmiennej lub etykietę kontrolki.</p>\r\n\r\n<p>Również atrybuty\r\n<span class="zmienna">readonly</span>,\r\n<span class="zmienna">disabled</span>,\r\n<span class="zmienna">accesskey</span> oraz\r\n<span class="zmienna">tabindex</span>\r\n\r\nznajdują zastosowanie w odniesieniu do wielu kontrolek umieszczanych w formularzu.\r\nAtrybuty <span class="zmienna">readonly</span> oraz\r\n<span class="zmienna">disabled</span> są atrybutami logicznymi.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Wartości logiczne atrybutów możemy ustalić na dwa\r\nsposoby. Skrócony zapis ma postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT name=&quot;imie&quot; readonly&gt;</pre>\r\n\r\n<p>Natomiast w rozszerzonej formie, powyższy element będzie wyglądał następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT name=&quot;imie&quot; readonly=&quot;readonly&quot;&gt;</pre>\r\n\r\n<p>Dokumentacja języka HTML przestrzega,\r\nże część przeglądarek rozpoznaje jedynie postać skróconą\r\n(patrz: specyfikacja języka HTML 4.01, strona 36).</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Atrybut <span class="zmienna">readonly</span> uniemożliwia modyfikację\r\nwartości kontrolki. Kontrolka taka jest widoczna i\r\nmoże stać się aktywna (tj. możemy, korzystając na przykład z klawisza tabulacji,\r\numieścić kursor wewnątrz kontrolki).\r\nNie możemy jednak zmieniać jej wartości.\r\nPo zatwierdzeniu formularza, kontrolka taka jest przesyłana\r\ndo skryptu przetwarzającego formularz.</p>\r\n\r\n<p>Kontrolki posiadające atrybut <span class="zmienna">disabled</span> są niedostępne.\r\nNie możemy zmieniać wartości takich kontrolek ani uczynić ich aktywnymi.\r\nCo więcej, po przesłaniu formularza, wartości kontrolek posiadających atrybut\r\n<span class="zmienna">disabled</span> nie są przesyłane do skryptu.</p>\r\n\r\n<p>Jedynym sposobem odblokowania kontrolek\r\n<span class="zmienna">readonly</span> oraz\r\n<span class="zmienna">disabled</span>\r\n\r\njest odpowiednie oprogramowanie zdarzeń formularza lub kontrolek\r\nw jednym z języków skryptowych, np. JavaScript.\r\nW przeciwnym razie, kontrolki takie będą przez cały czas niedostępne.</p>\r\n\r\n<p>Atrybut <span class="zmienna">accesskey</span> ustala skrót klawiszowy dla danej kontrolki.\r\nW systemie <span class="program">Windows</span>,\r\nskrót aktywujemy przytrzymując lewy klawisz <span class="zmienna">Alt</span>.\r\nJeśli na przykład kontrolka <span class="zmienna">INPUT</span> posiada atrybut\r\n<span class="zmienna">accesskey="K"</span>,\r\nwówczas po naciśnięciu klawiszy <span class="shortcut">Alt+K</span>,\r\nkursor zostanie umieszczony wewnątrz kontrolki.\r\nNiestety, żadna spośród popularnych przeglądarek nie\r\nwyróżnia skrótów klawiszowych (na przykład przez podkreślenie odpowiedniej litery w tekście etykiety).\r\nJeśli chcemy poinformować użytkownika o dostępnych skrótach klawiszowych,\r\nto musimy wpisać w formularzu odpowiedni tekst.\r\nDodatkowym problemem jest fakt, że przeglądarki\r\nposiadają predefiniowane skróty klawiszowe,\r\nprzy czym każda z nich może posiadać inne, specyficzne dla siebie skróty.\r\nTrudno jest ustalić skróty klawiszowe, które nie są zdublowane przez żadną z\r\npopularnych przeglądarek.\r\nZachowanie w przypadku zdublowania skrótu klawiszowego\r\nmoże być różne w przypadku różnych przeglądarek.</p>\r\n\r\n<p>Ostatni z atrybutów ogólnych, <span class="zmienna">tabindex</span>,\r\numożliwia ustalenie kolejności, w jakiej kontrolki formularza będą aktywowane klawiszem tabulacji.\r\nWartością atrybutu jest liczba całkowita ustalająca pozycję kontrolki na liście.</p>\r\n\r\n<h3 id="R5">5. Zdarzenia dotyczące kontrolek</h3>\r\n\r\n<p>W odniesieniu do kontrolek formularza możemy oprogramować kilka zdarzeń,\r\njakie występują podczas wypełniania formularza.\r\nZdarzeniami tymi są\r\n<span class="zmienna">onfocus</span> (występuje ono wtedy, gdy kontrolka staje się aktywna,\r\ntj. gdy kursor zostaje umieszczony wewnątrz kontrolki),\r\n<span class="zmienna">onblur</span> (występuje ono wtedy, gdy kursor opuszcza kontrolkę)\r\n\r\n<span class="zmienna">onselect</span> (występuje wówczas, gdy w polu tekstowym\r\nzostaje zaznaczony pewien tekst; dotyczy ono tylko pól tekstowych) oraz\r\n<span class="zmienna">onchange</span> (występuje wówczas, gdy kontrolka\r\nzmienia wartość).</p>\r\n\r\n<p>Zdarzenia takie możemy oprogramować w językach skryptowych,\r\nna przykład JavaScript, VB czy tcl.</p>\r\n\r\n<h3 id="R6">6. Elementy INPUT</h3>\r\n\r\n<p>Element <span class="zmienna">INPUT</span> służy do umieszczania w formularzu\r\nkilku różnych rodzajów kontrolek, m.in. wierszy wprowadzania danych,\r\npól wyboru oraz wykluczających pól wyboru.\r\nPosiada on atrybut <span class="zmienna">type</span>, który decyduje o typie kontrolki.\r\nWartością domyślną atrybutu <span class="zmienna">type</span> jest <span class="zmienna">text</span>.\r\nKontrolka <span class="zmienna">INPUT</span>\r\n\r\ntypu <span class="zmienna">text</span> służy do wprowadzenia jednej linii tekstu.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<tr><th>Typ kontrolki</th><th>Zastosowanie</th></tr>\r\n\r\n\r\n\r\n<tr><td><span class="zmienna">submit</span></td>\r\n\r\n<td>Przycisk do wysyłania formularza.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">reset</span></td>\r\n\r\n<td>Przycisk do zresetowania wprowadzonych danych.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">text</span></td>\r\n\r\n<td>Pojedyncza linia tekstu.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">password</span></td>\r\n\r\n<td>Pojedyncza linia tekstu. Wprowadzane znaki nie są widoczne.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">checkbox</span></td>\r\n\r\n<td>Pole wyboru.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">radio</span></td>\r\n\r\n<td>Wykluczające pole wyboru.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">hidden</span></td>\r\n\r\n<td>Przycisk niewidoczny służący do dołączania dodatkowych zmiennych do formularza.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">button</span></td>\r\n\r\n<td>Przycisk.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">file</span></td>\r\n\r\n<td>Przycisk umożliwiający wybranie pliku.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">image</span></td>\r\n\r\n<td>Obraz. Po kliknięciu obrazu do skryptu zostaną przesłane współrzędne klikniętego piksela.</td>\r\n\r\n</tr>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 3.\r\nTypy elementu <span class="zmienna">INPUT</span>.</p>\r\n</div>\r\n\r\n\r\n<p>Lista atrybutów elementu <span class="zmienna">INPUT</span> jest dość pokaźna.\r\nPełne zestawienie jest zawarte w tabeli 4.\r\nAtrybuty elementu <span class="zmienna">INPUT</span>\r\nmają różne znaczenie w zależności\r\nod typu kontrolki\r\n(czyli wartości atrybutu <span class="zmienna">type</span>).</p>\r\n\r\n\r\n\r\n<div>\r\n\r\n<table>\r\n<tr><th>Atrybut</th><th>Znaczenie</th></tr>\r\n\r\n\r\n\r\n<tr><td><span class="zmienna">type</span></td>\r\n\r\n<td>Typ kontrolki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">name</span></td>\r\n\r\n<td>Nazwa kontrolki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">value</span></td>\r\n\r\n<td>Etykieta lub wartość.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">checked</span></td>\r\n\r\n<td>Wybrana/niewybrana.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">disabled</span></td>\r\n\r\n<td>Dostępna/niedostępna.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">readonly</span></td>\r\n\r\n<td>Tylko do odczytu.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">size</span></td>\r\n\r\n<td>Rozmiar kontrolki mierzony znakami.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">maxlength</span></td>\r\n\r\n<td>Maksymalna liczba znaków mieszczących się w kontrolce.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">src</span></td>\r\n\r\n<td>Adres URL obrazu.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">alt</span></td>\r\n\r\n<td>Objaśnienie obrazu.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">usemap</span></td>\r\n\r\n<td>Mapa.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">ismap</span></td>\r\n\r\n<td>Czy kontrolka jest mapą?</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">tabindex</span></td>\r\n\r\n<td>Kolejność kontrolki przy naciskaniu klawisza tabulacji.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">accesskey</span></td>\r\n\r\n<td>Skrót klawiszowy.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">onfocus</span></td>\r\n\r\n<td>Obsługa zdarzenia uaktywnienia kontrolki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">onblur</span></td>\r\n\r\n<td>Obsługa zdarzenia deaktywacji kontrolki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">onselect</span></td>\r\n\r\n<td>Obsługa zdarzenia zaznaczania tekstu.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">onchange</span></td>\r\n\r\n<td>Obsługa zdarzenia modyfikacji kontrolki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">accept</span></td>\r\n\r\n<td>Rodzaj plików, jakie mogą być wybrane przy przesyłaniu pliku na serwer.</td>\r\n\r\n</tr>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 4.\r\nAtrybuty kontrolki <span class="zmienna">INPUT</span>.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h4 id="P6-1">6.1 Przyciski zatwierdzające i resetujące formularz</h4>\r\n\r\n<p>Niemal każdy formularz posiada przycisk zatwierdzający.\r\nPrzycisk taki tworzymy stosując kontrolkę\r\n<span class="zmienna">INPUT</span> typu <span class="zmienna">submit</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;submit&quot; value=&quot;Submit&quot;&gt;</pre>\r\n\r\n<p>Atrybut <span class="zmienna">value</span> ustala etykietę przycisku.\r\nEtykietą może być dowolny napis, na przykład <span class="opcja">OK</span>\r\nlub <span class="opcja">Wyślij</span>.</p>\r\n\r\n<p>Jeden formularz może posiadać kilka przycisków zatwierdzających wysłanie.\r\nWówczas przyciski powinny posiadać atrybut <span class="zmienna">name</span>,\r\numożliwiający stwierdzenie,\r\nktóry z nich został naciśnięty.</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;submit&quot; value=&quot;Zaloguj&quot; name=&quot;login&quot;&gt;\r\n&lt;INPUT type=&quot;submit&quot; value=&quot;Wyloguj&quot; name=&quot;login&quot;&gt;\r\n&lt;INPUT type=&quot;submit&quot; value=&quot;Zmień hasło&quot; name=&quot;passwd&quot;&gt;</pre>\r\n\r\n<p>Po naciśnięciu jednego z przycisków, formularz zostanie wysłany\r\nna serwer. W tablicy <span class="zmienna">$_POST</span> będzie dostępna zmienna\r\no indeksie ustalonym na podstawie atrybutu <span class="zmienna">name</span> i wartości\r\nrównej atrybutowi <span class="zmienna">value</span> naciśniętego przycisku.\r\nNa przykład po naciśnięciu przycisku o etykiecie <span class="opcja">Wyloguj</span>,\r\notrzymamy:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[&#39;login&#39;] === &#39;Wyloguj&#39;</pre>\r\n\r\n<p>Przycisk do resetowania formularza posiada typ\r\n<span class="zmienna">reset</span>. Podobnie jak w przypadku\r\nprzycisku wysyłającego formularz, atrybut\r\n<span class="zmienna">value</span> stanowi etykietę przycisku:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;reset&quot; value=&quot;Resetuj&quot;&gt;</pre>\r\n\r\n<h4 id="P6-2">6.2 Wiersz wprowadzania danych</h4>\r\n\r\n<p>Najczęściej stosowaną kontrolką formularzy jest wiersz wprowadzania danych.\r\nKontrolkę taka tworzymy stosując element\r\n<span class="zmienna">INPUT</span> typu <span class="zmienna">text</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;text&quot; name=&quot;imie&quot;&gt;</pre>\r\n\r\n<p>Ponieważ wartość <span class="zmienna">text</span> jest wartością domyślną, zatem powyższą\r\nkontrolkę można w równoważny sposób zapisać jako:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT name=&quot;imie&quot;&gt;</pre>\r\n\r\n<p>W stosunku do wiersza wprowadzania danych zastosowanie\r\nznajdują wspomniane już atrybuty ogólne\r\n<span class="zmienna">name</span>,\r\n<span class="zmienna">value</span>,\r\n<span class="zmienna">readonly</span>,\r\n<span class="zmienna">disabled</span>,\r\n\r\n<span class="zmienna">accesskey</span> oraz\r\n<span class="zmienna">tabindex</span>\r\njak również\r\n<span class="zmienna">size</span> i\r\n<span class="zmienna">maxlength</span>.</p>\r\n\r\n<p>Atrybut <span class="zmienna">size</span> ustala szerokość pola mierzony\r\nliczbą znaków. Natomiast wartość <span class="zmienna">maxlength</span>\r\n\r\nogranicza liczbę znaków, jaką kontrolka pomieści.</p>\r\n\r\n<h4 id="P6-3">6.3 Pole hasła</h4>\r\n\r\n<p>Pole <span class="zmienna">INPUT</span> typu <span class="zmienna">password</span>\r\nsłuży do wprowadzania hasła. Napis wprowadzany do kontrolki nie jest widoczny na ekranie.\r\nKontrolka taka ma postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;password&quot; name=&quot;haslo&quot;&gt;</pre>\r\n\r\n<p>Należy pamiętać, że hasło wprowadzone do formularza nie podlega żadnej ochronie.\r\nJest ono przekazywane w zapytaniu HTTP jako zwykły, niezaszyfrowany tekst.\r\nJedyną ochroną, jaką zapewnia pole typu <span class="zmienna">password</span> jest\r\nuniemożliwienie podejrzenia hasła na ekranie.</p>\r\n\r\n<p>Dla pola tekstowego typu <span class="zmienna">password</span>\r\n\r\nznaczenie atrybutów jest identyczne, jak w przypadku\r\nzwykłego pola tekstowego typu <span class="zmienna">text</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nStandardowe pole tekstowe oraz pole typu <span class="zmienna">password</span>.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Ustalanie szerokości kontrolek <span class="zmienna">INPUT</span> możemy\r\nzrealizować stosując atrybut <span class="zmienna">size</span>, jak również wykorzystując arkusze stylów.\r\nW formularzu z rysunku 2,\r\nkontroli <span class="zmienna">INPUT</span>\r\nposiadają szerokość 100 pikseli ustaloną stylem:</p>\r\n\r\n<pre class="syntax-highlight:xml">INPUT {\r\n    width : 100px;\r\n}</pre>\r\n\r\n<h4 id="P6-4">6.4 Pola wyboru</h4>\r\n\r\n<p>Element <span class="zmienna">INPUT</span> typu <span class="zmienna">checkbox</span>\r\nstanowi pole wyboru, które możemy zaznaczyć lub odznaczyć.\r\nW najprostszej postaci pole wygląda następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;checkbox&quot; name=&quot;win95&quot;&gt;</pre>\r\n\r\n<p>Po przesłaniu formularza zawierającego powyższe pole, w skrypcie dostępna\r\nbędzie zmienna <span class="zmienna">$_POST[''win95'']</span> o wartości <span class="zmienna">on</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[&#39;win95&#39;] === ''on''</pre>\r\n\r\n<p>Jeśli pole posiada atrybut <span class="zmienna">value</span>, np.:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;checkbox&quot; name=&quot;dos&quot; value=&quot;MSDOS&quot;&gt;</pre>\r\n\r\n<p>to zmienna dostępna w skrypcie przyjmie wartość\r\nustaloną atrybutem <span class="zmienna">value</span>.\r\nW powyższym przykładzie będzie to:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[&#39;dos&#39;] === ''MSDOS''</pre>\r\n\r\n<p>Dodatkowo, atrybut <span class="zmienna">checked</span> może być wykorzystany do\r\ninicjalizacji pól wyboru. Pola nie posiadające atrybutu <span class="zmienna">checked</span>\r\n\r\nsą domyślnie odznaczone, zaś pola z podanym atrybutem <span class="zmienna">checked</span>\r\nsą zaznaczone. Dowolna liczba pól wyboru może być równocześnie zaznaczona.</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;checkbox&quot; name=&quot;win98&quot; checked=&quot;checked&quot;&gt;</pre>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nPola wyboru.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Zwróćmy uwagę, że wszystkie pola wyboru posiadają własne\r\nwartości atrybutów <span class="zmienna">name</span>.\r\nSą one wówczas przekazywane jako niezależne zmienne do skryptu.</p>\r\n\r\n<p>Jak już wspomnieliśmy, w języku php możliwe jest również przekazanie\r\npowiązanych ze sobą opcji wyboru w\r\npostaci tablicy.\r\nW tym celu należy wszystkim powiązanym ze sobą znaczeniowo polom wyboru nadać\r\nidentyczną nazwę, zakończoną nawiasami kwadratowymi:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;checkbox&quot; name=&quot;system[]&quot; value=&quot;Linux&quot;&gt;\r\n&lt;INPUT type=&quot;checkbox&quot; name=&quot;system[]&quot; value=&quot;FreeBSD&quot;&gt;\r\n...</pre>\r\n\r\n<p>Każda z opcji musi posiadać atrybut <span class="zmienna">value</span>.\r\nW takim przypadku, po zatwierdzeniu formularza, w skrypcie w php\r\nw tablicy <span class="zmienna">$_POST</span> pod indeksem\r\n<span class="zmienna">system</span>\r\n(jest to wartość atrybutu <span class="zmienna">name</span>) dostępna będzie tablica\r\nzawierająca wartości atrybutów <span class="zmienna">value</span> wszystkich zaznaczonych pól wyboru\r\no wartości atrybutu <span class="zmienna">name="system[]"</span>.</p>\r\n\r\n<h4 id="P6-5">6.5 Wykluczające pola wyboru</h4>\r\n\r\n<p>Drugim rodzajem pól wyboru są pola wzajemnie się wykluczające.\r\nW odróżnieniu do pól wyboru typu <span class="zmienna">checkbox</span>,\r\ntylko jedno spośród kilku pól <span class="zmienna">INPUT</span>\r\ntypu <span class="zmienna">radio</span> może być zaznaczone.</p>\r\n\r\n<pre class="syntax-highlight:xml">POLSKA: &lt;INPUT type=&quot;radio&quot; name=&quot;kraj&quot; value=&quot;PL&quot;&gt;\r\nNIEMCY: &lt;INPUT type=&quot;radio&quot; name=&quot;kraj&quot; value=&quot;DE&quot;&gt;</pre>\r\n\r\n<p>Wszystkie powiązane ze sobą pola muszą posiadać identyczną wartość\r\natrybutu <span class="zmienna">name</span>. W powyższym przykładzie wartością tą\r\njest napis <span class="zmienna">kraj</span>.\r\nPonadto każde pole wyboru musi posiadać wartość ustaloną\r\natrybutem <span class="zmienna">value</span>.\r\nPo zatwierdzeniu formularza, tablica <span class="zmienna">$_POST</span>\r\nbędzie zawierała element o indeksie\r\nrównym atrybutowi <span class="zmienna">name</span> i wartości równej atrybutowi\r\n<span class="zmienna">value</span> wybranego pola, na przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[''kraj''] === ''PL''</pre>\r\n\r\n<p>Kontrolki możemy zainicjować stosując - podobnie jak w przypadku pól typu\r\n<span class="zmienna">checkbox</span> - atrybut <span class="zmienna">checked</span>.\r\nTym razem jednak, zaznaczyć możemy co najwyżej jedno pole.</p>\r\n\r\n<p>Dodajmy, że formularz może zawierać kilka niezależnych grup kontrolek\r\n\r\n<span class="zmienna">radio</span>. Na przykład wybór kraju oraz dyscypliny sportu.\r\nOba wybory są niezależne. W ramach każdej kategorii zaznaczyć możemy jedynie jeden element.\r\nW takim przypadku, obie grupy kontrolek są odróżniane na podstawie\r\natrybutu <span class="zmienna">name</span>. Kontrolki z każdej grupy współdzielą unikalną nazwę.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-04.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nWykluczające się wzajemnie pola wyboru.</p>\r\n</div>\r\n\r\n\r\n\r\n<h4 id="P6-6">6.6 Kontrolki ukryte</h4>\r\n\r\n<p>Kolejnym typem kontrolek <span class="zmienna">INPUT</span> są kontrolki ukryte.\r\nKontrolki takie są niewidoczne i służą do przekazania dodatkowych\r\nzmiennych.\r\nPonieważ nie są one widoczne, nie można zmieniać ich wartości\r\nza pomocą myszy czy klawiatury.\r\nOto przykładowe kontrolki ukryte:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;hidden&quot; name=&quot;cena&quot; value=&quot;123456&quot;&gt;\r\n&lt;INPUT type=&quot;hidden&quot; name=&quot;valuta&quot; value=&quot;EURO&quot;&gt;</pre>\r\n\r\n<p>Możemy je wykorzystać na przykład do podpisywania formularza.\r\nUmieszczając w formularzu pole ukryte zawierające pewną, wygenerowaną przez\r\nskrypt, trudną do odgadnięcia, wartość możemy upewnić się, że\r\ndane przesłane po zatwierdzeniu skryptu pochodzą faktycznie z formularza.</p>\r\n\r\n<p>Należy mieć świadomość, że kontrolki ukryte nie są w żaden sposób zaszyfrowane\r\nani ukryte przed użytkownikiem. Zaglądając do źródła strony, ujrzymy wszystkie\r\nukryte kontrolki zawarte w formularzu.\r\nDane przekazywane w postaci kontrolek ukrytych warto zaszyfrować.</p>\r\n\r\n<p>Ponieważ kontrolki te nie są w ogóle wyświetlane przez przeglądarkę, zatem\r\nw odniesieniu do nich nie ma sensu stosowanie dodatkowych atrybutów.</p>\r\n\r\n<h4 id="P6-7">6.7 Przyciski</h4>\r\n\r\n<p>Kontrolka\r\n<span class="zmienna">INPUT</span> typu <span class="zmienna">button</span>\r\njest przyciskiem.\r\nPrzyciski takie, po naciśnięciu,\r\nnie powodują żadnej predefiniowanej akcji ze strony przeglądarki.\r\nAni nie resetują zawartości, ani nie wysyłają formularza.\r\nW celu wykorzystania takiego przycisku, należy oprogramować\r\nobsługę zdarzeń.</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;button&quot; value=&quot;Pierwszy&quot;&gt;\r\n&lt;INPUT type=&quot;button&quot; value=&quot;Drugi&quot;&gt;\r\n&lt;INPUT type=&quot;submit&quot; value=&quot;Wyślij&quot;&gt;</pre>\r\n\r\n<h4 id="P6-8">6.8 Kontrolka wyboru pliku</h4>\r\n\r\n<p>Pole <span class="zmienna">INPUT</span>\r\ntypu <span class="zmienna">file</span> służy do przekazywania\r\nza pomocą formularza pliku na serwer.\r\nKontrolka taka jest przedstawiana w formularzu w postaci\r\nprzycisku z napisem <span class="opcja">Przeglądaj...</span>.\r\nPo naciśnięciu przycisku, przeglądarka wyświetla okno dialogowe,\r\nktóre umożliwia wybór pliku.\r\nPo dokonaniu wyboru i zatwierdzeniu formularza,\r\nna serwer zostaje przekazany wybrany plik.</p>\r\n\r\n<p>Kontrolka taka posiada dwa istotne atrybuty:\r\n<span class="zmienna">type</span> oraz <span class="zmienna">name</span>.\r\nAtrybut <span class="zmienna">name</span> ustala nazwę zmiennej przekazanej do skryptu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;file&quot; name=&quot;plik&quot;&gt;</pre>\r\n\r\n<p>Formularz zawierający kontrolki typu <span class="zmienna">file</span> musi\r\nbyć przekazywany metodą <span class="zmienna">POST</span>.\r\nPonadto należy ustalić sposób kodowania danych pochodzących z formularza\r\njako <span class="zmienna">enctype="multipart/form-data"</span>.</p>\r\n\r\n<p>W jaki sposób odczytać zawartość plików przekazanych na serwer w języku php?\r\nW odróżnieniu do innych kontrolek, pliki przekazane na serwer nie są zawarte\r\nw tablicy <span class="zmienna">$_POST</span>,\r\na w tablicy <span class="zmienna">$_FILES</span>.\r\nTablica <span class="zmienna">$_FILES</span>\r\n\r\njest tablicą wielowymiarową.\r\nJeśli kontrolka <span class="zmienna">INPUT</span> posiada atrybut\r\n<span class="zmienna">name="plik"</span>, wówczas\r\ninformacje na temat pliku przekazanego na serwer są zawarte w\r\nnastępujących polach tablicy <span class="zmienna">$_FILES</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_FILES[&#39;plik&#39;][&#39;name&#39;]\r\n$_FILES[&#39;plik&#39;][&#39;type&#39;]\r\n$_FILES[&#39;plik&#39;][&#39;tmp_name&#39;]\r\n$_FILES[&#39;plik&#39;][&#39;error&#39;]\r\n$_FILES[&#39;plik&#39;][&#39;size&#39;]</pre>\r\n\r\n<p>Tablica <span class="zmienna">$_FILES</span> zawiera informacje na temat\r\nprzekazanego pliku, nie zawiera natomiast samego pliku.\r\nPlik jest zapisany na dysku pod\r\nnazwą <span class="zmienna">$_FILES[''plik''][''tmp_name'']</span>.\r\nJeśli chcemy przeczytać jego zawartość, to możemy do tego wykorzystać\r\nnastępującą instrukcję:</p>\r\n\r\n<pre class="syntax-highlight:xml">$rob = file_get_contents($_FILES[&#39;plik&#39;][&#39;tmp_name&#39;]);</pre>\r\n\r\n<p>Należy pamiętać, że plik ten zostanie usunięty automatycznie\r\npo zakończeniu przetwarzania skryptu.\r\nNależy albo go przetworzyć, korzystając z powyższej instrukcji,\r\nalbo przenieść do innego folderu stosując funkcję\r\n<span class="zmienna">move_uploaded_file()</span>.</p>\r\n\r\n<p>W formularzu warto umieścić (przed kontrolką typu <span class="zmienna">file</span>)\r\nukryte pole\r\nustalające wartość zmiennej <span class="zmienna">MAX_FILE_SIZE</span>.\r\nWartość taka ogranicza wielkość pliku, jaki możemy przekazać za pomocą formularza.\r\nNie jest to zabezpieczenie przed złośliwymi użytkownikami, gdyż łatwo je ominąć\r\n(na przykład przygotowując własny formularz; do zabezpieczenia\r\nprzed złośliwymi użytkownikami należy stosować opcje konfiguracyjne php:\r\n<span class="zmienna">file_uploads</span>,\r\n<span class="zmienna">upload_max_filesize</span> oraz\r\n\r\n<span class="zmienna">upload_tmp_dir</span>).\r\nJednak dzięki zawarciu w formularzu informacji o maksymalnym rozmiarze pliku,\r\nunikniemy sytuacji, w której użytkownik czeka dłuższy odcinek czasu\r\ntylko po to, by zobaczyć komunikat (pochodzący ze skryptu php) informujący o tym,\r\nże wybrany plik jest zbyt duży.\r\nJeśli informacja o maksymalnym rozmiarze jest zawarta w formularzu,\r\nto przeglądarka nie wysyła na serwer zbyt dużych plików.</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;hidden&quot; name=&quot;MAX_FILE_SIZE&quot; value=&quot;3000&quot;&gt;</pre>\r\n\r\n<p>Podana wielkość jest mierzona w bajtach.</p>\r\n\r\n<h4 id="P6-9">6.9 Obraz</h4>\r\n\r\n<p>Ostatnim typem kontrolek\r\n<span class="zmienna">INPUT</span> jest typ <span class="zmienna">image</span>.\r\nKontrolka taka służy do umieszczenia w formularzu obrazu.\r\nPo kliknięciu obrazu, formularz zostaje przesłany,\r\nzaś do skryptu przekazywane są współrzędne klikniętego piksela.</p>\r\n\r\n<p>Obowiązkowymi atrybutami są <span class="zmienna">type</span>,\r\n\r\n<span class="zmienna">name</span>,\r\n<span class="zmienna">src</span> oraz\r\n<span class="zmienna">alt</span>.\r\nAtrybut <span class="zmienna">src</span> ustala adres URL wyświetlanego obrazu,\r\nnatomiast <span class="zmienna">alt</span> zawiera tekst alternatywny.\r\n(Rola obydwu atrybutów jest analogiczna jak w przypadku elementu <span class="zmienna">IMG</span>.)</p>\r\n\r\n<p>Oto kod przykładowej kontrolki tego typu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;image&quot; name=&quot;obraz&quot; src=&quot;z.jpg&quot; alt=&quot;Przykład kontrolki INPUT typu image.&quot;&gt;</pre>\r\n\r\n<p>W wyniku kliknięcia obrazu, do skryptu zostaną przekazane zmienne\r\n<span class="zmienna">obraz_x</span> oraz <span class="zmienna">obraz_y</span>\r\nzawierające współrzędne klikniętego piksela obrazu:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[&#39;obraz_x&#39;] === ''83''\r\n$_POST[&#39;obraz_y&#39;] === ''178''</pre>\r\n\r\n<p>Nazwy zmiennych <span class="zmienna">obraz_x</span> oraz <span class="zmienna">obraz_y</span>\r\npowstają przez dodanie odpowiednich przyrostków do nazwy kontrolki\r\nustalonej atrybutem <span class="zmienna">name</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-05.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nKontrolka <span class="zmienna">INPUT</span> typu <span class="zmienna">image</span>.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R7">7. Element BUTTON</h3>\r\n\r\n<p>Kolejnym elementem służącym do tworzenia kontrolek formularzy\r\njest element <span class="zmienna">BUTTON</span>.\r\nElement ten służy do tworzenia przycisków.\r\nAtrybut <span class="zmienna">type</span>, o poprawnych wartościach\r\n<span class="zmienna">submit</span>,\r\n<span class="zmienna">reset</span> oraz <span class="zmienna">button</span>,\r\nustala rodzaj przycisku.</p>\r\n\r\n<p>Przycisk wykonany z wykorzystaniem elementu <span class="zmienna">BUTTON</span> ma następujący kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;BUTTON type=&quot;submit&quot; name=&quot;p1&quot;&gt;\r\nWyślij\r\n&lt;/BUTTON&gt;</pre>\r\n\r\n<p>Jego działanie jest identyczne jak w przypadku przycisku:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;INPUT type=&quot;submit&quot; name=&quot;p1&quot;&gt;</pre>\r\n\r\n<p>Podobnie, przycisk <span class="zmienna">BUTTON</span> typu <span class="zmienna">reset</span>\r\n\r\nodpowiada przyciskowi <span class="zmienna">INPUT</span> typu\r\n<span class="zmienna">reset</span>,\r\nzaś <span class="zmienna">BUTTON</span> typu\r\n<span class="zmienna">button</span> - przyciskowi\r\n<span class="zmienna">INPUT</span> typu <span class="zmienna">button</span>.</p>\r\n\r\n<p>Jedyna różnica pomiędzy guzikami tworzonymi elementami\r\n<span class="zmienna">BUTTON</span> i <span class="zmienna">INPUT</span>\r\npolega na tym, że przyciski <span class="zmienna">BUTTON</span> posiadają\r\nznaczniki otwierający i zamykający.\r\nDzięki temu mogą posiadać zawartość.\r\nJako zawartość przycisku możemy podać element <span class="zmienna">IMG</span>.\r\nPodany obraz zostanie umieszczony na przycisku.</p>\r\n\r\n<p>Kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;BUTTON name=&quot;wyslanie&quot; type=&quot;submit&quot;&gt;\r\n    &lt;IMG src=&quot;otworz.png&quot; alt=&quot;Wysyłanie formularza&quot;&gt;\r\n&lt;/BUTTON&gt;</pre>\r\n\r\n<p>tworzy przycisk przedstawiony na rysunku 6.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-06.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 6.\r\nPrzycisk z ikoną.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R8">8. Listy</h3>\r\n\r\n<p>Elementy <span class="zmienna">SELECT</span>,\r\n<span class="zmienna">OPTION</span> oraz\r\n<span class="zmienna">OPTGROUP</span> służą do tworzenia list.</p>\r\n\r\n<p>Wewnątrz elementu <span class="zmienna">SELECT</span> umieszczamy poszczególne elementy listy\r\ndefiniowane elementem <span class="zmienna">OPTION</span>.\r\nDodatkowo, opcje listy mogą być pogrupowane elementami <span class="zmienna">OPTGROUP</span>.\r\nPoprawną zawartością elementu <span class="zmienna">SELECT</span> są wyłącznie elementy\r\n<span class="zmienna">OPTION</span> oraz <span class="zmienna">OPTGROUP</span>.</p>\r\n\r\n<p>W najprostszym przypadku, lista składa się z\r\nelementu <span class="zmienna">SELECT</span> zawierającego kilka opcji <span class="zmienna">OPTION</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SELECT name=&quot;dzien&quot;&gt;\r\n&lt;OPTION&gt;Poniedziałek&lt;/OPTION&gt;\r\n&lt;OPTION&gt;Wtorek&lt;/OPTION&gt;\r\n&lt;OPTION&gt;Środa&lt;/OPTION&gt;\r\n...\r\n&lt;/SELECT&gt;</pre>\r\n\r\n<p>Po wybraniu pierwszego elementu listy i zatwierdzeniu formularza,\r\nw skrypcie będzie dostępna zmienna:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[''dzien''] === ''Poniedziałek''</pre>\r\n\r\n<p>Opcje <span class="zmienna">OPTION</span> mogą posiadać dodatkowo atrybuty\r\n<span class="zmienna">value</span> oraz <span class="zmienna">selected</span>.\r\nAtrybut <span class="zmienna">value</span> ustala wartość zmiennej przekazanej do skryptu.\r\nPo wybraniu z poniższej listy opcji <span class="opcja">Wtorek</span>\r\n\r\ni zatwierdzeniu formularza:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SELECT name=&quot;dzien&quot;&gt;\r\n&lt;OPTION&gt;Poniedziałek&lt;/OPTION&gt;\r\n&lt;OPTION value=&quot;2&quot;&gt;Wtorek&lt;/OPTION&gt;\r\n...\r\n&lt;/SELECT&gt;</pre>\r\n\r\n<p>do skryptu zostanie przekazana zmienna:</p>\r\n\r\n<pre class="syntax-highlight:xml">$_POST[''dzien''] === ''2''</pre>\r\n\r\n<p>Natomiast atrybut <span class="zmienna">selected</span> służy do wskazania\r\nelementu listy, który powinien być początkowo wybrany.</p>\r\n\r\n<p>Domyślnie, listy wyboru są wyświetlane w postaci list rozwijanych,\r\nktóre umożliwiają wybranie tylko jednego elementu.\r\nWłaściwości listy możemy zmienić stosując atrybuty\r\n<span class="zmienna">size</span> oraz <span class="zmienna">multiple</span>\r\nelementu <span class="zmienna">SELECT</span>.</p>\r\n\r\n<p>Atrybut <span class="zmienna">size</span> ustala liczbę elementów listy, które będą widoczne na ekranie\r\n(wartością domyślną jest 1 - lista rozwijana).\r\nLista:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SELECT name=&quot;dzien&quot; size=&quot;3&quot;&gt;\r\n&lt;OPTION&gt;Poniedziałek&lt;/OPTION&gt;\r\n&lt;OPTION&gt;Wtorek&lt;/OPTION&gt;\r\n&lt;OPTION&gt;Środa&lt;/OPTION&gt;\r\n&lt;OPTION&gt;Czwartek&lt;/OPTION&gt;\r\n...\r\n&lt;/SELECT&gt;</pre>\r\n\r\n<p>będzie wyświetlana w postaci prostokąta zawierającego trzy wiersze i wyposażonego w suwak.</p>\r\n\r\n<p>Natomiast atrybut <span class="zmienna">multiple</span>,\r\njest atrybutem logicznym, który umożliwia zaznaczanie na liście kilku\r\nelementów.\r\nZwróćmy uwagę, że w przypadku stosowania list wielokrotnego wyboru\r\nwygodnym jest - podobnie jak w przypadku pól wyboru - stosowanie\r\nnazwy zakończonej nawiasami kwadratowymi:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SELECT name=&quot;dzien[]&quot; size=&quot;7&quot; multiple=&quot;multiple&quot;&gt;</pre>\r\n\r\n<p>Wówczas, tablica <span class="zmienna">$_POST</span> będzie zawierała element o\r\nindeksie <span class="zmienna">dzien</span>. Element ten będzie tablicą zawierającą wartości\r\nwszystkich elementów wybranych na liście wielokrotnego wyboru.</p>\r\n\r\n<p>Rysunek 7 przedstawia trzy omówione listy wyboru.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-07-01.png" alt="" /><img src="artimg/09-07-02.png" alt="" /><img src="artimg/09-07-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 7.\r\nListy wyboru.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Stosując element <span class="zmienna">OPTGROUP</span> mamy możliwość nadania liście struktury.\r\nOpcje ograniczone znacznikami\r\n<span class="zmienna">OPTGROUP</span>\r\n\r\nstanowią podmenu niższego poziomu.\r\nAtrybut <span class="zmienna">label</span> elementu <span class="zmienna">OPTGROUP</span>\r\nustala etykietę grupy opcji:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SELECT name=&quot;auto&quot;&gt;\r\n&lt;OPTGROUP label=&quot;Fiat&quot;&gt;\r\n&lt;OPTION value=&quot;fiatalabea&quot;&gt;Alabea&lt;/OPTION&gt;\r\n&lt;OPTION value=&quot;fiatmultipla&quot;&gt;Multipla&lt;/OPTION&gt;\r\n...\r\n&lt;/OPTGROUP&gt;\r\n&lt;OPTGROUP label=&quot;Ford&quot;&gt;\r\n&lt;OPTION value=&quot;fordEscort&quot;&gt;Escort&lt;/OPTION&gt;\r\n&lt;OPTION value=&quot;fordfiesta&quot;&gt;Fiesta&lt;/OPTION&gt;\r\n...\r\n&lt;/OPTGROUP&gt;\r\n...\r\n&lt;/SELECT&gt;</pre>\r\n\r\n<p>Etykieta taka jest wytłuszczona na liście i nie można jej\r\nzaznaczyć.\r\nLista stosująca elementy <span class="zmienna">OPTGROUP</span> została zilustrowana na rysunku 8.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-08.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 8.\r\nLista z opcjami pogrupowanymi elementami <span class="zmienna">OPTGROUP</span>.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R9">9. Pole tekstowe</h3>\r\n\r\n<p>Ostatnim rodzajem kontrolek dostępnych w języku HTML,\r\nktóre umożliwiają wprowadzanie danych,\r\nsą pola tekstowe.\r\nPole takie definiujemy elementem <span class="zmienna">TEXTAREA</span>.\r\nAtrybuty <span class="zmienna">rows</span> oraz\r\n<span class="zmienna">cols</span> ustalają wymiar pola tekstowego mierzony\r\nliczbą wierszy i kolumn tekstu.</p>\r\n\r\n<p>Poniższe pole tekstowe liczy pięć wierszy testu.\r\nW każdym wierszu możemy umieścić 10 znaków:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TEXTAREA name=&quot;list&quot; rows=&quot;5&quot; cols=&quot;10&quot;&gt;\r\nKto?\r\nGdzie?\r\nKiedy?\r\n&lt;/TEXTAREA&gt;</pre>\r\n\r\n<p>Po wprowadzeniu większej liczby wierszy tekstu,\r\nsuwak pionowy kontrolki stanie się aktywny.\r\nNatomiast szerokość kontrolki nie podlega zmianie nawet po wprowadzeniu\r\ndługiego tekstu. Suwak poziomy również się nie pojawia - zbyt długi tekst zostaje zawinięty.</p>\r\n\r\n<p>Początkowa zawartość kontrolki jest umieszczana\r\npomiędzy znacznikami <span class="zmienna">TEXTAREA</span>.</p>\r\n\r\n<h3 id="R10">10. Grupowanie i podpisywanie kontrolek formularza</h3>\r\n\r\n<p>Dodatkowymi elementami, jakie możemy umieścić w formularzu są\r\netykiety <span class="zmienna">LABEL</span>,\r\nelementy grupujące <span class="zmienna">FIELDSET</span>\r\noraz podpisy grup <span class="zmienna">LEGEND</span>.\r\nElementy te nie umożliwiają wprowadzania danych do formularza.\r\nModyfikują jedynie wygląd oraz strukturę formularza,\r\ndzięki czemu formularz staje się bardziej czytelny.</p>\r\n\r\n<p>Etykiety <span class="zmienna">LABEL</span> służą do podpisania kontrolek.\r\nUmieszczamy je w formularzu na dwa sposoby.\r\nPo pierwsze możemy podpisywaną kontrolkę umieścić wewnątrz etykiety:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P&gt;\r\n&lt;LABEL&gt;\r\nImię:\r\n&lt;INPUT name=&quot;imie&quot;&gt;\r\n&lt;/LABEL&gt;\r\n&lt;/P&gt;</pre>\r\n\r\n<p>W powyższym przykładzie tekst <span class="opcja">Imię</span> jest podpisem\r\npola <span class="zmienna">INPUT</span>\r\n(pamiętajmy, że element <span class="zmienna">LABEL</span> nie może\r\nwystępować bezpośrednio w formularzu;\r\nkonieczne jest użycie elementu blokowego, na przykład akapitu).</p>\r\n\r\n<p>Po drugie możemy wykorzystać atrybut <span class="zmienna">for</span>\r\nelementu <span class="zmienna">LABEL</span>.\r\nAtrybut ten zawiera identyfikator kontrolki, z którą związana jest etykieta:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TR&gt;\r\n&lt;TD&gt;&lt;LABEL for=&quot;fimie&quot;&gt;Imię:&lt;/LABEL&gt;&lt;/TD&gt;\r\n&lt;TD&gt;&lt;INPUT name=&quot;imie&quot; id=&quot;fimie&quot;&gt;&lt;/TD&gt;\r\n&lt;/TR&gt;</pre>\r\n\r\n<p>Drugą z podanych metod możemy wykorzystać także w przypadku\r\nstosowania tabel do ułożenia kontrolek formularza.</p>\r\n\r\n<p>W odniesieniu do standardowych przeglądarek,\r\n<span class="program">Internet Explorer</span>,\r\n<span class="program">FireFox</span>,\r\n<span class="program">Opera</span> czy\r\n<span class="program">Netscape</span>,\r\nstosowanie etykiet <span class="zmienna">LABEL</span> nie niesie żadnych korzyści.\r\nPowyższe dwa przykłady wyglądałyby zupełnie identycznie bez zastosowania etykiet.\r\nSytuacja zmienia się w przypadku nietypowych przeglądarek\r\n(na przykład przeglądarek przeznaczonych dla osób niewidomych),\r\nPrzeglądarki takie, mogą wykorzystać powiązanie etykiet z kontrolkami\r\ndo poinformowania użytkownika o roli kontrolki.</p>\r\n\r\n<p>Etykiety, podobnie jak i inne kontrolki formularzy, mogą posiadać skrót klawiszowy.\r\nW przypadku przeniesienia kursora do etykiety (poprzez aktywację skrótu klawiszowego lub\r\nkliknięcie w etykietę; kliknięcie w etykietę działa poprawnie -\r\nw <span class="program">Internet Explorerze</span> -\r\njedynie wtedy, gdy stosujemy etykiety\r\nwykorzystujące atrybut <span class="zmienna">for</span>),\r\nkursor zostanie faktycznie umieszczony w kontrolce skojarzonej z etykietą.</p>\r\n\r\n<p>Kontrolki dotyczące podobnej tematyki możemy zgrupować stosując\r\nelement <span class="zmienna">FIELDSET</span>.\r\nElement ten należy do grupy elementów blokowych i może\r\nwystępować bezpośrednio pomiędzy znacznikami formularza.\r\nKontrolki umieszczone wewnątrz elementu <span class="zmienna">FIELDSET</span>\r\nzostaną otoczone obramowaniem.\r\nRamkę możemy wzbogacić o podpis stosując element <span class="zmienna">LEGEND</span>.\r\nJedynymi atrybutami elementu <span class="zmienna">FIELDSET</span>\r\nsą atrybuty grupy <span class="zmienna">attrs</span>, natomiast\r\nelement <span class="zmienna">LEGEND</span> posiada ponadto\r\natrybut <span class="zmienna">accesskey</span>.</p>\r\n\r\n<p>Rysunek 9 przedstawia formularz zawierający dwie grupy kontrolek podpisane\r\n<span class="opcja">&bdquo;Kto wygra mistrzostwa świata w piłce nożnej w 2006 roku?&rdquo;</span>\r\noraz\r\n<span class="opcja">&bdquo;Którzy polscy zawodnicy zostaną powołani do kadry?&rdquo;</span>\r\nPierwsza z grup jest zdefiniowana następującym kodem HTML:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;FIELDSET&gt;\r\n&lt;LEGEND&gt;\r\nKto wygra mistrzostwa świata w piłce nożnej w 2006 roku?\r\n&lt;/LEGEND&gt;\r\n&lt;INPUT type=&quot;radio&quot; name=&quot;wygrany&quot; value=&quot;DE&quot;&gt; Niemcy&lt;BR&gt;\r\n&lt;INPUT type=&quot;radio&quot; name=&quot;wygrany&quot; value=&quot;PL&quot;&gt; Polska&lt;BR&gt;\r\n&lt;INPUT type=&quot;radio&quot; name=&quot;wygrany&quot; value=&quot;FR&quot;&gt; Francja&lt;BR&gt;\r\n&lt;INPUT type=&quot;radio&quot; name=&quot;wygrany&quot; value=&quot;IT&quot;&gt; Włochy\r\n&lt;/FIELDSET&gt;</pre>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/09-09.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 9.\r\nPola wyboru pogrupowane elementami <span class="zmienna">FIELDSET</span>. Obie grupy podpisano stosując elementy <span class="zmienna">LEGEND</span>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R11">11. Podsumowanie</h3>\r\n\r\n<p>Dziesięć omówionych elementów języka HTML (patrz tabela 1)\r\npozwala na tworzenie witryn WWW zawierających elektroniczne formularze.\r\nFormularze takie znajdziemy w Internecie na każdym niemal kroku,\r\nwystarczy wspomnieć strony wyszukiwarek czy\r\naplikacje służących do odbierania poczty elektronicznej.\r\nJeśli planujemy wzbogacenie witryny o elementy interaktywne\r\nwykonane z wykorzystaniem formularzy, wówczas znajomość\r\nopisanych elementów i ich atrybutów będzie nieodzowna.</p>\r\n\r\n<p>Na zakończenie zwróćmy uwagę, że formularze stanowią niejako pomost\r\nłączący trzy rodzaje języków:\r\njęzyk znaczników,\r\njęzyk przetwarzania po stronie serwera (<span class="ang">ang. server-side</span>) i\r\njęzyk przetwarzania po stronie klienta (<span class="ang">ang. client-side</span>).\r\n\r\nSam formularz jest przygotowany w języku HTML,\r\nkod przetwarzający dane wprowadzone w formularzu\r\npiszemy w języku <span class="ang">server-side</span>\r\n\r\n(np. PHP czy Perl),\r\nnatomiast obsługę zdarzeń dotyczących formularza i jego kontrolek -\r\nw językach <span class="ang">client-side</span>\r\n(np. JavaScript czy VB).</p>\r\n\r\n<p>Wykorzystywanie formularzy w sposób pełny wymaga zatem znajomości aż trzech języków!</p>', 'kontrolki-formularzy');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(10, 'Element META &mdash; dodatkowe informacje na temat witryny', 'Witryny internetowe są często wzbogacone o dane nazywane metainformacjami.\r\nInformacje te, ustalane elementami <span class="zmienna">META</span>,\r\nsłużą między innymi do identyfikacji autora,\r\nklasyfikacji zawartości oraz zwiększają możliwości wyszukiwania informacji\r\nw Internecie.\r\nW artykule przeanalizujemy wszystkie popularne elementy <span class="zmienna">META</span>\r\n\r\nopisując ich rolę oraz celowość użycia.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Metainformacje</a></li>\r\n<li><a href="#R2">2. Składnia elementu META</a></li>\r\n<li><a href="#R3">3. Znaczenie elementu META</a></li>\r\n<li><a href="#R4">4. Dwa rodzaje elementów META</a></li>\r\n<li><a href="#R5">5. Jakie metainformacje umieszczać na witrynach?</a>\r\n    <ol>\r\n        <li><a href="#P5-1">5.1 Kodowanie znaków</a></li>\r\n        <li><a href="#P5-2">5.2 Język, w jakim przygotowano dokument</a></li>\r\n        <li><a href="#P5-3">5.3 Autor, prawa autorskie i firma</a></li>\r\n        <li><a href="#P5-4">5.4 Tytuł, słowa kluczowe i opis</a></li>\r\n        <li><a href="#P5-5">5.5 Roboty</a></li>\r\n        <li><a href="#P5-6">5.6 Data powstania i ważności dokumentu</a></li>\r\n        <li><a href="#P5-7">5.7 Przechowywanie stron WWW przez pośredników</a></li>\r\n        <li><a href="#P5-8">5.8 Skrypty i style &mdash; domyślny język</a></li>\r\n        <li><a href="#P5-9">5.9 Metainformacje w kilku językach</a></li>\r\n        <li><a href="#P5-10">5.10 Przekierowania</a></li>\r\n        <li><a href="#P5-11">5.11 Różności</a></li>\r\n    </ol>\r\n</li>\r\n<li><a href="#R6">6. Standaryzacja</a></li>\r\n<li><a href="#R7">7. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Metainformacje</h3>\r\n\r\n<p>Elementy <span class="zmienna">META</span> występują w nagłówku stron WWW, czyli pomiędzy znacznikami\r\n<span class="zmienna">&lt;HEAD&gt;</span> oraz <span class="zmienna">&lt;/HEAD&gt;</span>.\r\nIch zadaniem jest dostarczenie dodatkowych informacji na temat witryny WWW.\r\nDane ustalane elementami <span class="zmienna">META</span> są nazywane <em>metainformacjami</em>.</p>\r\n\r\n<p>Listing 1 przedstawia kod przykładowej witryny\r\nwzbogaconej o trzy elementy <span class="zmienna">META</span>.\r\nMetainformacje zawarte na tej stronie ustalają kodowanie znaków,\r\nnazwisko autora oraz prawa autorskie.\r\nElementy <span class="zmienna">META</span> mogą występować w kodzie\r\n<span class="jezyk">HTML</span> w dowolnej kolejności, zarówno w stosunku do siebie jak\r\ni pozostałych elementów nagłówka strony.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n\r\n<pre class="syntax-highlight:xml">&lt;!DOCTYPE HTML PUBLIC &quot;-//W3C//DTD HTML 4.01//EN&quot;\r\n          &quot;http://www.w3.org/TR/html4/strict.dtd&quot;&gt;\r\n&lt;HTML&gt;\r\n  &lt;HEAD&gt;\r\n    &lt;TITLE&gt;Strona o niczym&lt;/TITLE&gt;\r\n    &lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;\r\n    &lt;META name=&quot;author&quot; content=&quot;Włodzimierz Gaja&quot;&gt;\r\n    &lt;META name=&quot;copyright&quot; content=&quot;(c) 2005 gajdaw&quot;&gt;\r\n  &lt;/HEAD&gt;\r\n&lt;BODY&gt;\r\n...\r\n&lt;/BODY&gt;\r\n&lt;/HTML&gt;</pre>\r\n<p class="podpis">\r\nListing 1.\r\nWitryna zawierająca przykładowe metainformacje</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Metainformacje nie są wyświetlane przez przeglądarki podczas wizyty na stronie.\r\nIch zadanie polega na dostarczeniu dodatkowych danych na temat dokumentu HTML.\r\nDane te odgrywają następują rolę:</p>\r\n\r\n<ul>\r\n\r\n<li>\r\nustalają kodowanie znaków, język opisu stylów oraz język przetwarzania skryptów,\r\n</li>\r\n\r\n<li>wskazują języki, w jakich dany dokument został przygotowany,</li>\r\n\r\n<li>\r\n\r\nzawierają nazwisko autora, nazwę wydawcy oraz inne dane identyfikujące twórców dokumentu,\r\n</li>\r\n\r\n<li>\r\nzwiększają możliwości wyszukiwania informacji w sieci,\r\n</li>\r\n\r\n<li>\r\npozwalają wprowadzić klasyfikację dokumentów w Internecie,\r\n</li>\r\n\r\n<li>\r\nustalają czas ważności dokumentu i zezwalają\r\nbądź blokują zapisywanie dokumentu w pamięci podręcznej (<span class="ang">ang. cache</span>).\r\n</li>\r\n\r\n</ul>\r\n\r\n<p>Metainformacje są związane z konkretną witryną i należy je\r\nzawrzeć w kodzie HTML.\r\nJeśli witryna składa się z wielu podstron, wtedy metainformacje dołączamy do każdej podstrony\r\nz osobna.</p>\r\n\r\n\r\n<h3 id="R2">2. Składnia elementu META</h3>\r\n\r\n<p>Element <span class="zmienna">META</span> należy &mdash; wraz z elementami\r\n\r\n<span class="zmienna">SCRIPT</span>,\r\n<span class="zmienna">STYLE</span>,\r\n<span class="zmienna">LINK</span> oraz\r\n<span class="zmienna">OBJECT</span> &mdash;\r\ndo grupy elementów nagłówka zdefiniowanych w specyfikacji języka\r\n<span class="jezyk">HTML</span> 4.01 makrem\r\n<span class="zmienna">head.misc</span>.\r\nJest to element pusty o atrybutach przedstawionych w tabeli 1.\r\nJedynym miejscem gdzie element ten może wystąpić jest nagłówek,\r\nprzy czym, jak widzieliśmy na listingu 1, na jednej stronie możemy zawrzeć\r\ndowolną liczbę elementów <span class="zmienna">META</span>.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Lp.</th><th>Atrybut</th><th>Opis</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Lp.</th><th>Atrybut</th><th>Opis</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td><span class="zmienna">lang</span>, <span class="zmienna">dir</span></td>\r\n\r\n<td>Atrybuty ustalające język i kierunek przetwarzania tekstu</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td><span class="zmienna">name</span></td>\r\n\r\n<td>Identyfikuje rodzaj metainformacji</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td><span class="zmienna">http-equiv</span></td>\r\n\r\n<td>Identyfikator metainformacji używany zamiennie w stosunku do atrybutu <span class="zmienna">name</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td><span class="zmienna">content</span></td>\r\n\r\n<td>Atrybut wymagany, zawierający metainformacje.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td><span class="zmienna">scheme</span></td>\r\n\r\n<td>Nazwa profilu metainformacji ustalonego atrybutem <span class="zmienna">profile</span> elementu <span class="zmienna">HEAD</span>.</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nAtrybuty elementu <span class="zmienna">META</span></p>\r\n</div>\r\n\r\n\r\n\r\n<p>Jeśli strona jest wykonana w języku <span class="jezyk">HTML</span>,\r\nwówczas &mdash; stosując konwencje specyfikacji języka <span class="jezyk">HTML</span> &mdash;\r\nelement <span class="zmienna">META</span> zapisujemy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;keywords&quot; content=&quot;lis, kot, pies&quot;&gt;</pre>\r\n\r\n<p>Natomiast w języku <span class="jezyk">XHTML</span> stosujemy małe litery i poprzedzamy\r\nkońcowy znak <span class="zmienna">&gt;</span> znakiem ukośnika:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;meta name=&quot;keywords&quot; content=&quot;lis, kot, pies&quot; /&gt;</pre>\r\n\r\n<h3 id="R3">3. Znaczenie elementu META</h3>\r\n\r\n<p>Każda z metainformacji definiowanych elementami <span class="zmienna">META</span>\r\nma postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">nazwa=wartość</pre>\r\n\r\n<p>Do ustalenia nazwy służą atrybuty <span class="zmienna">name</span> oraz\r\n<span class="zmienna">http-equiv</span>, zaś do ustalenia wartości &mdash;\r\n\r\nobowiązkowy atrybut <span class="zmienna">content</span>:</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;imie&quot; content=&quot;Jan&quot;&gt;\r\n&lt;META http-equiv=&quot;nazwisko&quot; content=&quot;Nowak&quot;&gt;</pre>\r\n\r\n<p>Powyższy kod ustala dwie metainformacje.\r\nPierwsza z nich ma nazwę <span class="zmienna">imie</span> i wartość\r\n<span class="zmienna">Jan</span>, zaś druga &mdash; nazwę <span class="zmienna">nazwisko</span> i\r\nwartość <span class="zmienna">Nowak</span>.</p>\r\n\r\n<p>Specyfikacja języka HTML nie definiuje zbioru dopuszczalnych wartości\r\natrybutu <span class="zmienna">name</span>, ani tym bardziej\r\n<span class="zmienna">content</span>. Ustala jedynie składnię\r\nznacznika <span class="zmienna">&lt;META ...&gt;</span>.</p>\r\n\r\n<h3 id="R4">4. Dwa rodzaje elementów META</h3>\r\n\r\n<p>Z racji na to, że nazwa elementu <span class="zmienna">META</span> może być określona\r\natrybutem <span class="zmienna">name</span> lub\r\n\r\n<span class="zmienna">http-equiv</span>,\r\nw istocie mamy do czynienia z dwoma rodzajami\r\nelementów <span class="zmienna">META</span>.\r\nPierwszy z nich posługuje się atrybutem <span class="zmienna">name</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;Generator&quot; content=&quot;Netscape Composer&quot;&gt;</pre>\r\n\r\n<p>zaś drugi &mdash; atrybutem <span class="zmienna">http-equiv</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;</pre>\r\n\r\n<p>Elementy stosujące element <span class="zmienna">http-equiv</span> są interpretowane przez oprogramowanie\r\njako nagłówki protokołu HTTP.\r\nZatem w odniesieniu do elementów <span class="zmienna">META</span> stosujących atrybut\r\n<span class="zmienna">http-equiv</span> listę wszystkich dopuszczalnych\r\npoprawnych metainformacji znajdziemy w specyfikacji języka HTTP (patrz RFC 2616).</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Elementy META przyjmują jedna z dwóch postaci:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;&quot; content=&quot;&quot;&gt;</pre>\r\n\r\n\r\n<p>lub</p>\r\n\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;&quot; content=&quot;&quot;&gt;</pre>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>W zależności od konfiguracji oprogramowania, elementy <span class="zmienna">META</span>\r\nz atrybutem <span class="zmienna">http-equiv</span> mogą,\r\nale nie muszą, być interpretowane jako faktyczne nagłówki protokołu HTTP.\r\nDziałaniem takim cechuje się przeglądarka <span class="program">FireFox</span>\r\n\r\nwraz z zainstalowanym dodatkiem\r\n<span class="program">LiveHTTPHeaders</span> w wersji 0.10.\r\nJak widać na rysunku 1, metainformacje:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;imie&quot; content=&quot;Jan&quot;&gt;\r\n&lt;META http-equiv=&quot;nazwisko&quot; content=&quot;Nowak&quot;&gt;</pre>\r\n\r\n<p>są interpretowane jako nagłówki protokołu HTTP:</p>\r\n\r\n<pre class="syntax-highlight:xml">imie: Jan\r\nnazwisko: Nowak</pre>\r\n\r\n<p>Faktycznie odebrane nagłówki HTTP nie zawierają powyższych wpisów,\r\nczego dowodzi przykład 2-2.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/10-01.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nNagłówki odpowiedzi HTTP wyświetlane w przeglądarce FireFox</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Porównując przykłady 2-3 oraz 2-4 stwierdzimy, że\r\nnagłówki wysyłane w języku <span class="jezyk">PHP</span>\r\nfunkcją <span class="zmienna">header()</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">header(&quot;Content-type: text/csv&quot;);\r\nheader(&#39;Content-Disposition: inline; filename=beatles.csv&#39;);</pre>\r\n\r\n<p>nie mogą być zastąpione przez elementy <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/csv&quot;&gt;\r\n&lt;META http-equiv=&quot;Content-Disposition&quot;\r\n    content=&quot;inline; filename=beatles.csv&quot;&gt;</pre>\r\n\r\n<p>Jeśli korzystamy z języka <span class="jezyk">PHP</span>,\r\nto nagłówki HTTP należy przekazywać przy użyciu\r\nfunkcji <span class="zmienna">header()</span>,\r\na nie elementem <span class="zmienna">META</span>.</p>\r\n\r\n<p>W stosunku do elementu <span class="zmienna">META</span> z atrybutem <span class="zmienna">name</span>\r\nspecyfikacja <span class="jezyk">HTML</span> mówi, że w przypadku, gdy atrybut\r\n<span class="zmienna">content</span> zawiera adres URI:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;DC.identifier&quot; content=&quot;http://www.ietf.org/rfc/rfc1866.txt&quot;&gt;</pre>\r\n\r\n<p>wówczas element <span class="zmienna">META</span> możemy zastąpić równoważnym elementem\r\n<span class="zmienna">LINK</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LINK rel=&quot;DC.identifier&quot; type=&quot;text/plain&quot;\r\n    href=&quot;http://www.ietf.org/rfc/rfc1866.txt&quot;&gt;</pre>\r\n\r\n<p>Stwierdzenie odwrotne nie jest prawdą. Elementy <span class="zmienna">LINK</span>\r\n\r\nnie mogą być zastąpione elementami <span class="zmienna">META</span>\r\n(patrz przykład 3-2).</p>\r\n\r\n<h3 id="R5">5. Jakie metainformacje umieszczać na witrynach?</h3>\r\n\r\n<p>Znając składnię oraz ogólne znaczenie elementu <span class="zmienna">META</span>\r\nprzejdźmy do zagadnień praktycznych.\r\nKolejno omówimy metainformacje dotyczące:</p>\r\n\r\n<ul>\r\n\r\n<li>kodowania znaków,</li>\r\n<li>języka dokumentu,</li>\r\n<li>identyfikacji autora dokumentu,</li>\r\n<li>opisu zawartości dokumentu,</li>\r\n<li>indeksacji dokumentu przez roboty wyszukiwarek internetowych,</li>\r\n<li>ustalania daty powstania oraz daty ważności dokumentu,</li>\r\n<li>przechowywania dokumentu przez serwery pośredniczące,</li>\r\n<li>domyślnego języka stylów i skryptów,</li>\r\n<li>zagadnień nietypowych.</li>\r\n\r\n</ul>\r\n\r\n<h4 id="P5-1">5.1 Kodowanie znaków</h4>\r\n\r\n<p>Metainformacja o kodowaniu pozwala przeglądarce poprawnie wyświetlić dokument.\r\nBrak takiej informacji powoduje, że polskie znaki diakrytyczne wyglądają błędnie\r\nu części użytkowników. Wprawdzie przeglądarki posiadają opcję\r\n<span class="opcja">Widok &rarr; Kodowanie znaków</span>,\r\numożliwiającą wybór kodowania znaków, jednak witryna\r\npowinna wyglądać poprawnie bez żadnej akcji ze strony użytkownika.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\nElement <span class="zmienna">META</span> określający kodowanie znaków jest bardzo ważny i powinien się\r\nznaleźć na każdej witrynie.\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Kodowanie witryny wykonanej w języku polskim ustalamy elementem:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;</pre>\r\n\r\n<p>W języku <span class="jezyk">XHTML</span>\r\nkodowanie znaków ustalamy w dwóch miejscach:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;?xml version=&quot;1.0&quot; encoding=&quot;iso-8859-2&quot;?&gt;\r\n&lt;meta http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot; /&gt;</pre>\r\n\r\n<p>Kodowanie określane jako <span class="zmienna">iso-8859-2</span>\r\njest obowiązującą normą\r\nPN-93 T-42118\r\nzatwierdzoną\r\nzarówno przez Polski Komitet Normalizacyjny\r\n(<a href="http://www.pkn.pl">http://www.pkn.pl</a>)\r\njak i organizację ISO (<a href="http://www.iso.org">http://www.iso.org</a>).\r\nProdukty firmy Microsoft stosują inny rodzaj kodowania polskich znaków.\r\nKorzystając z produktów Microsoftu, polskie znaki są kodowane\r\nw standardzie <span class="zmienna">windows-1250</span>.\r\nElement <span class="zmienna">META</span> ma\r\nwówczas &mdash; w języku <span class="jezyk">HTML</span> &mdash; postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=windows-1250&quot;&gt;</pre>\r\n\r\n<p>zaś w <span class="jezyk">XHTML</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;?xml version=&quot;1.0&quot; encoding=&quot;windows-1250&quot;?&gt;\r\n&lt;meta http-equiv=&quot;Content-Type&quot;\r\n    content=&quot;text/html; charset=windows-1250&quot; /&gt;</pre>\r\n\r\n<p>Specyfikacja języka <span class="jezyk">HTML</span> radzi,\r\nby element ustalający kodowanie znaków był pierwszym elementem nagłówka,\r\nszczególnie wtedy, gdy pozostałe elementy stosują znaki specyficzne danego kodowania.\r\nZatem strony zawierające ogonki w tytule należałoby zapisać:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HEAD&gt;\r\n  &lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=iso-8859-2&quot;&gt;\r\n  &lt;TITLE&gt;Żółw&lt;/TITLE&gt;\r\n  ...\r\n&lt;/HEAD&gt;</pre>\r\n\r\n<p>jednakże nie ma to istotnego wpływu ani na wygląd, ani na\r\npoprawność dokumentu ocenianą walidatorem W3C.</p>\r\n\r\n<p>Więcej informacji na temat kodowania polskich znaków diakrytycznych\r\nznajdziemy na znanej\r\n\r\n<span class="tytul">&bdquo;Polskiej Stronie Ogonkowej&rdquo;</span> pod adresem:\r\n<a href="http://www.ogonki.agh.edu.pl/">http://www.ogonki.agh.edu.pl/</a>.</p>\r\n\r\n<p>Napis definiujący kodowanie, czyli <span class="zmienna">iso-8859-2</span> lub\r\n<span class="zmienna">windows-1250</span> może być pisany literami dowolnej wielkości\r\n(np. <span class="zmienna">ISO-8850-2</span>).\r\nLista wszystkich zarejestrowanych kodów jest zawarta w pliku\r\n\r\n<span class="plik">character-sets.txt</span>\r\n(tabela 6).</p>\r\n\r\n<p>Strony w języku angielskim, niemieckim oraz francuskim stosują kodowanie\r\n<span class="zmienna">iso-8859-1</span>,\r\nzaś strony rosyjskie - <span class="zmienna">windows-1251</span>.</p>\r\n\r\n<p>Zwróćmy uwagę na fakt, że definicja kodowania znaków dotyczy całego dokumentu.\r\nA zatem jeśli na stronie zechcemy umieścić teksty w kilku językach to\r\npojawi się problem, jakiego kodowania użyć, by wszystkie teksty\r\nbyły wyświetlane poprawnie.\r\nW takim przypadku należy użyć kodowania <span class="zmienna">utf-8</span>, zaś\r\nwszystkie teksty konwertować na unikod.</p>\r\n\r\n<p>Do konwersji kodowania znaków możemy użyć funkcji <span class="zmienna">iconv()</span>\r\n(dostępnej po zainstalowaniu biblioteki <span class="program">iconv</span>).\r\nJeśli zmienne\r\n<span class="zmienna">$ru</span>,\r\n<span class="zmienna">$de</span>,\r\n<span class="zmienna">$pl</span>\r\nzawierają teksty w językach rosyjskim (kodowanie <span class="zmienna">windows-1251</span>),\r\nniemieckim (kodowanie <span class="zmienna">iso-8859-1</span>)\r\noraz polskim (kodowanie <span class="zmienna">iso-8859-2</span>)\r\nto konwersji na unikod dokonamy w następujący sposób:</p>\r\n\r\n<pre class="syntax-highlight:xml">$ru = iconv(&quot;windows-1251&quot;, &quot;utf-8&quot;, $ru);\r\n$pl = iconv(&quot;iso-8859-2&quot;,   &quot;utf-8&quot;, $pl);\r\n$de = iconv(&quot;iso-8859-1&quot;,   &quot;utf-8&quot;, $de);</pre>\r\n\r\n<p>Strony napisane w unikodzie powinny posiadać element <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Type&quot; content=&quot;text/html; charset=utf-8&quot;&gt;</pre>\r\n\r\n\r\n\r\n<h4 id="P5-2">5.2 Język, w jakim przygotowano dokument</h4>\r\n\r\n<p>Informacje na temat języka,\r\nw jakim wykonana jest strona służą do\r\nklasyfikacji dokumentów między innymi przez wyszukiwarki\r\noraz umożliwiają inteligentne przetwarzanie tekstu (np. sprawdzanie pisowni zależne\r\nod stosowanego języka).\r\nInformację na temat języka dokumentu dostarczamy\r\nna dwa sposoby: korzystając z atrybutów <span class="zmienna">lang</span> oraz\r\numieszczając w nagłówku odpowiedni element <span class="zmienna">META</span>.\r\nPonieważ każde z rozwiązań pełni inną rolę,\r\nzatem w dokumentach należy stosować oba rozwiązania na raz.</p>\r\n\r\n<p>Atrybut <span class="zmienna">lang</span>\r\n\r\nustala jednoznacznie język stosowany wewnątrz konkretnego elementu.\r\nNadając wartość atrybutowi <span class="zmienna">lang</span> elementu\r\n<span class="zmienna">HTML</span> definiujemy język\r\ncałej strony:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HTML lang=&quot;pl&quot;&gt;</pre>\r\n\r\n<p>Jeśli dokument zawiera wstawki obcojęzyczne, wówczas\r\nkorzystamy z atrybutu <span class="zmienna">lang</span> w stosunku do\r\nużytych elementów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HTML lang=&quot;pl&quot;&gt;\r\n...\r\n&lt;H1&gt;Witamy!&lt;/H1&gt;\r\n...\r\n&lt;P lang=&quot;en&quot;&gt;\r\nQuoting a well known French proverb: &lt;EM lang=&quot;fr&quot;&gt;C&#39;est la vie&lt;/EM&gt;...\r\n&lt;/P&gt;\r\n&lt;/HTML&gt;</pre>\r\n\r\n<p>lub w przypadku braku elementów tekstowych korzystamy\r\nz elementu <span class="zmienna">SPAN</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P lang=&quot;en&quot;&gt;\r\nQuoting a well known French proverb: &lt;SPAN lang=&quot;fr&quot;&gt;C&#39;est la vie&lt;/SPAN&gt;...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>Stosując język <span class="jezyk">XHTML</span> przekazywany z nagłówkiem\r\nMIME postaci <span class="zmienna">text/html</span>\r\nstosujemy podwójny atrybut <span class="zmienna">lang</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;span xml:lang=&quot;pl&quot; lang=&quot;pl&quot;&gt;koń&lt;/span&gt;</pre>\r\n\r\n<p>Natomiast w kodzie <span class="jezyk">XHTML</span> przekazywanym jako\r\n<span class="zmienna">application/xhtml+xml</span>\r\n\r\nstosujemy składnię:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;span xml:lang=&quot;pl&quot;&gt;koń&lt;/span&gt;</pre>\r\n\r\n<p>Definicje języka ustalane za pomocą atrybutu <span class="zmienna">lang</span>\r\njednoznacznie określają język pewnego fragmentu tekstu wewnątrz strony.\r\nDzięki temu możliwe jest kontekstowe sprawdzanie pisowni zależne od użytego języka\r\nczy wybór odpowiedniego procesora tekstu w przypadku przeglądarki czytającej zawartość strony.</p>\r\n\r\n<p>Nieco inną rolę pełni definicja języka\r\ndokumentu ustalana elementem <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Language&quot; content=&quot;pl,en,fr&quot;&gt;</pre>\r\n\r\n<p>Powyższa informacja ustala potencjalne grono czytelników witryny.\r\nWitryna zawiera teksty przeznaczone dla osób znających język polski, angielski\r\nlub francuski.\r\nJak widać, w przeciwieństwie do atrybutu <span class="zmienna">lang</span>,\r\nelement <span class="zmienna">META</span> może wskazywać na więcej niż jeden język.</p>\r\n\r\n<p>Kody języków możemy pisać literami dowolnej wielkości.\r\nPełny zestaw kodów jest zawarty w dokumentach\r\npublikowanych przez IANA, ISO oraz W3C\r\n(patrz tabela 6).</p>\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Witryny WWW powinny posiadać elementy i atrybuty\r\nokreślające języki, w jakim przygotowana została witryna.\r\nDo tego celu stosujemy atrybut <span class="zmienna">lang</span>\r\nelementu <span class="zmienna">HTML</span> oraz\r\natrybuty <span class="zmienna">lang</span> elementów zawierających teksty w\r\njęzykach różnych od języka podanego w elemencie <span class="zmienna">HTML</span>.\r\nPonadto definiujemy potencjalne grono czytelników stosując element <span class="zmienna">META</span>.</p>\r\n\r\n<p>Jeśli strona jest w całości przygotowana w języku polskim, wówczas stosujemy\r\nelementy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;HTML lang=&quot;pl&quot;&gt;\r\n&lt;META http-equiv=&quot;Content-Language&quot; content=&quot;pl&quot;&gt;</pre>\r\n\r\n</div>\r\n\r\n\r\n\r\n<h4 id="P5-3">5.3 Autor, prawa autorskie i firma</h4>\r\n\r\n<p>Metainformacje służą również do identyfikacji autora witryny,\r\nfirmy oraz wydawcy, właściciela praw autorskich,\r\noprogramowania użytego do wykonania witryny jak również dostarczenia\r\nadresu poczty elektronicznej do kontaktu z osoba odpowiedzialną za utrzymanie witryny.\r\nInformacje takie podajemy stosując następujące elementy <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;author&quot;    content=&quot;Jan Nowak&quot;&gt;\r\n&lt;META name=&quot;copyright&quot; content=&quot;(c)2005 Jan Nowak&quot;&gt;\r\n&lt;META name=&quot;generator&quot; content=&quot;vim&quot;&gt;\r\n&lt;META name=&quot;reply-to&quot;  content=&quot;janek@nowak.com&quot;&gt;\r\n&lt;META name=&quot;publisher&quot; content=&quot;Nowak Publishing House&quot;&gt;\r\n&lt;META name=&quot;company&quot;   content=&quot;NowakSoft&quot;&gt;</pre>\r\n\r\n<p>Atrybuty elementu <span class="zmienna">META</span> mogą zawierać znaki specjalne.\r\nWiele osób oznacza prawa autorskie stosując\r\nsymbol <span class="zmienna">&amp;copy;</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;copyright&quot; content=&quot;&amp;copy;2005 Jan Nowak&quot;&gt;</pre>\r\n\r\n<p>Pamiętajmy, że adresy opublikowane na stronie WWW są dostępne dla\r\nwszystkich, także tych, którzy rozsyłają niechciane listy email określane jako spam.</p>\r\n\r\n<h4 id="P5-4">5.4 Tytuł, słowa kluczowe i opis</h4>\r\n\r\n<p>Tytuł strony WWW, tradycyjnie umieszczany wewnątrz\r\nelementu <span class="zmienna">TITLE</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;TITLE&gt;Tytuł strony WWW&lt;/TITLE&gt;</pre>\r\n\r\n<p>bywa również przedstawiony elementem <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;title&quot; content=&quot;Tytuł strony WWW&quot;&gt;</pre>\r\n\r\n<p>Jeśli zdecydujemy się na stosowanie elementu <span class="zmienna">META</span>\r\ndo podania tytułu strony,\r\nto i tak nie powinniśmy rezygnować\r\nz elementu <span class="zmienna">TITLE</span>.\r\nStosujemy wtedy oba elementy na raz.</p>\r\n\r\n<p>Element <span class="zmienna">META</span> o atrybucie\r\n<span class="zmienna">name="description"</span> dostarcza opis zawartości dokumentu.\r\nOpis ten powinien liczyć pomiędzy 100 a 200 znaków i powinien w sposób jasny informować\r\no zawartości witryny:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;description&quot;\r\n  content=&quot;Opis zawartości witryny liczący około 100-200 znaków.&quot;&gt;</pre>\r\n\r\n<p>Podany opis witryny jest wyświetlany przez wyszukiwarki internetowe\r\nna liście znalezionych wyników.\r\nRysunek 2 pokazuje wyniki wyszukiwania frazy ''Magazyn Internet'' w wyszukiwarce <span class="program">Google</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/10-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nOpis strony wyświetlany przez wyszukiwarki</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Przedstawiony opis jest ustalony elementem:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;meta name=&quot;Description&quot; content=&quot;Magazyn INTERNET - jedyny w Polsce ...&quot;&gt;</pre>\r\n\r\n<p>Natomiast następujący element <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;keywords&quot; content=&quot;kot, pies, lis&quot;&gt;</pre>\r\n\r\n<p>definiuje listę słów kluczowych, jakich dotyczy strona.\r\nLista ta powinna liczyć od kilkunastu do kilkudziesięciu słów\r\n(podobnie jak poprzednio około 100-200 znaków).\r\nKolejne słowa oddzielamy przecinkami lub spacjami.\r\nSpotykanymi formatami są:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;keywords&quot; content=&quot;kot, pies, lis&quot;&gt;\r\n&lt;META name=&quot;keywords&quot; content=&quot;kot,pies,lis&quot;&gt;\r\n&lt;META name=&quot;keywords&quot; content=&quot;kot pies lis&quot;&gt;</pre>\r\n\r\n<p>Ustalenie tytułu, słów kluczowych oraz opisu strony może wpłynąć na wyniki wyszukiwania\r\nwybranych fraz w niektórych wyszukiwarkach.\r\nPonieważ mechanizm ten bywa nadużywany do sztucznego promowania\r\nwitryn w Internecie, wyszukiwarki coraz mniej poważnie traktują metainformacje\r\nmówiące o zawartości strony.\r\nNa pewno nie wolno stosować sztuczek polegających na\r\numieszczeniu w słowach kluczowych wiele razy tego samego słowa.\r\nDo niedawna, jedną z technik poprawy pozycjonowania strony\r\nbyło umieszczenie na liście słów kluczowych kilkadziesiąt razy\r\ntego samego słowa, co podnosiło rangę witryny w wybranej kategorii.\r\nW ramach walki z tym negatywnym zjawiskiem\r\nwyszukiwarki często blokują witryny stosujące takie triki.</p>\r\n\r\n<p>Najlepszą receptą dotyczącą stosowania słów kluczowych, opisu oraz tytułu strony\r\njest:</p>\r\n\r\n<ul>\r\n<li>\r\nużycie rozsądnej liczby znaków w każdym z elementów,\r\n</li>\r\n\r\n<li>\r\nstosowanie unikalnych słów w ramach jednego elementu,\r\n\r\n</li>\r\n\r\n<li>\r\npowtórzenie kilku wybranych słów kluczowych zarówno w tytule, w opisie jak\r\ni na liście słów kluczowych,\r\n</li>\r\n\r\n<li>\r\nkilkukrotne użycie słów kluczowych w treści witryny,\r\n</li>\r\n\r\n<li>\r\nstosowanie słów kluczowych w atrybutach niewidocznych takich jak\r\n<span class="zmienna">alt</span> czy <span class="zmienna">title</span>.\r\n\r\n</li>\r\n\r\n</ul>\r\n\r\n<p>Na przykład przygotowując witrynę poświęconą bajce\r\n<span class="tytul">&bdquo;Wilk i zając&rdquo;</span>\r\nwybieramy słowa kluczowe: wilk, zając, bajka oraz rosyjska.\r\nNastępnie przygotowujemy tytuł strony oraz opis w taki sposób,\r\nby zawierały one podane wyrazy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;title&quot; content=&quot;Wilk i zając - moja ulubiona rosyjska bajka&quot;&gt;\r\n&lt;META name=&quot;description&quot;\r\n  content=&quot;Witryna poświęcona rosyjskiej bajce p.t. Wilk i zając.&quot;&gt;\r\n&lt;META name=&quot;keywords&quot;\r\n  content=&quot;wilk, zając, bajka, bajeczka, rosyjska, animowana&quot;&gt;</pre>\r\n\r\n<p>Oprócz tego, wyrazy te koniecznie umieszczamy kilkukrotnie w treści\r\nwitryny i umieszczamy w niewidocznych atrybutach:</p>\r\n\r\n<pre class="syntax-highlight:xml">Wilk i zając ...\r\n&lt;IMG src=&quot;wilk.jpg&quot; alt=&quot;Wilk - postać z rosyjskiej bajki animowanej.&quot;&gt;\r\n...\r\n&lt;IMG src=&quot;zajac.jpg&quot; alt=&quot;Zając - postać z rosyjskiej bajki animowanej.&quot;&gt;\r\n...</pre>\r\n\r\n<p>Dbamy o to, by lista wybranych słów nie była ani zbyt długa, ani zbyt krótka.\r\nNa liście słów kluczowych umieszczamy kilkanaście wyrazów, zaś te najważniejsze z nich\r\npowtarzamy w opisie dokumentu, w tytule oraz kilkukrotnie w\r\ntreści strony.</p>\r\n\r\n<p>Wspomniana technika sztucznego powielania słów bywa stosowana w odniesieniu\r\ndo treści strony.\r\nMożemy na przykład wybrane słowo kluczowe umieścić w\r\ntreści witryny kilkaset razy na niewidzialnym obszarze przez modyfikację koloru tła i czcionki,\r\npołożenia (tj. przesunąć poza widoczny obszar przeglądarki),\r\nwidzialności elementu (atrybut <span class="zmienna">display</span>)\r\nczy stosując elementy i atrybuty niewyświetlane na stronie\r\n(np. komentarze, <span class="zmienna">alt</span> lub <span class="zmienna">title</span>).\r\nZ takimi technikami należy uważać, gdyż przeglądarki eliminują wykrytych nieuczciwych graczy.</p>\r\n\r\n<p>Z racji na nieuczciwe promowanie witryn waga elementów <span class="zmienna">META</span>\r\nodnośnie pozycjonowania witryn w wyszukiwarkach stale maleje\r\ni &mdash; zdaniem niektórych &mdash;\r\nstosowanie elementów <span class="zmienna">META</span> definiujących słowa\r\nkluczowe nie ma żadnego znaczenia.\r\nSłowa kluczowe dokumentu są ustalane na podstawie jego zawartości.</p>\r\n\r\n\r\n\r\n<p>Czasami spotkamy w Internecie również metaelement <span class="zmienna">abstract</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;abstract&quot; content=&quot;Witryna dotyczy...&quot;&gt;</pre>\r\n\r\n<p>Atrybut ten definiuje abstrakt, czyli streszczenie dokumentu.\r\nJego rola jest marginalna.</p>\r\n\r\n<h4 id="P5-5">5.5 Roboty</h4>\r\n\r\n<p>Roboty internetowe to programy, które pobierają witryny\r\nw sposób automatyczny w celu umieszczenia\r\nodpowiednich informacji w bazie danych wyszukiwarki.\r\nRobot pobiera kod HTML witryny,\r\nanalizuje go, po czym indeksuje witrynę.\r\nIndeksacja polega na wprowadzeniu do bazy danych wyszukiwarki informacji,\r\numożliwiających znalezienie witryny.</p>\r\n\r\n<p>Stosując element <span class="zmienna">META</span> możemy wpływać\r\nna zachowanie robotów indeksujących strony WWW.\r\nMetainformacje o atrybucie <span class="zmienna">name="robots"</span>\r\ndotyczą robotów i zezwalają na indeksację strony oraz\r\nprzeszukanie witryn podanych w odnośnikach danej strony.</p>\r\n\r\n<p>W celu zaindeksowania bieżącego dokumentu i przeanalizowaniu\r\nwszystkich jego podstron stosujemy jeden z dwóch równoważnych zapisów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;robots&quot; content=&quot;all&quot;&gt;\r\n&lt;META name=&quot;robots&quot; content=&quot;index,follow&quot;&gt;</pre>\r\n\r\n<p>Jeżeli indeksacja  i przeszukiwanie ma być zabronione, wówczas stosujemy\r\nelementy:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;robots&quot; content=&quot;none&quot;&gt;\r\n&lt;META name=&quot;robots&quot; content=&quot;noindex,nofollow&quot;&gt;</pre>\r\n\r\n<p>Poprawnymi są również rozwiązania mieszane:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;robots&quot; content=&quot;noindex,follow&quot;&gt;\r\n&lt;META name=&quot;robots&quot; content=&quot;index,nofollow&quot;&gt;</pre>\r\n\r\n<p>Szczegółową dokumentację elementów <span class="zmienna">META</span> dotyczących wyszukiwarek\r\ni robotów znajdziemy na stronach <a href="http://www.robotstxt.org/wc/robots.html">http://www.robotstxt.org/wc/robots.html</a>.</p>\r\n\r\n<p>Jeśli chcemy wymusić na robocie ponowną indeksację po zadanym odcinku czasu,\r\nto służy do tego element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;revisit-after&quot; content=&quot;5 Days&quot;&gt;</pre>\r\n\r\n<p>jednak opinie, na temat wagi powyższego elementu są podzielone.\r\nW wielu artykułach dostępnych w Internecie element ten to tylko\r\narchaiczna pozostałość nie mająca zupełnie żadnego wpływu na proces indeksacji\r\nprzez jakąkolwiek z liczących się wyszukiwarek.\r\nZa stosowaniem metainformacji <span class="zmienna">revisit-after</span> przemawia\r\njej obecność na tak znanych witrynach jak na przykład\r\n<a href="http://www.alistapart.com">http://www.alistapart.com</a>.</p>\r\n\r\n\r\n\r\n<p>Poszczególne roboty mogą także stosować\r\nwłasne, niestandardowe rozwiązania.\r\nPrzykładem jest wyszukiwarka <span class="program">Google</span>, która przechowuje\r\nkopie zaindeksowanych witryn.\r\nJeśli nie chcemy, by wyszukiwarka <span class="program">Google</span> tworzyła kopię\r\nstrony, wtedy stosujemy element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;googlebot&quot; content=&quot;noarchive&quot;&gt;</pre>\r\n\r\n<p>Zaś element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;googlebot&quot; content=&quot;nosnippet&quot;&gt;</pre>\r\n\r\n<p>powoduje, że wyniki wyszukiwania zwracane przez\r\n<span class="program">Google</span> nie będą zawierały\r\nfragmentu strony WWW z zaznaczonymi wyszukiwanymi wyrazami\r\n(patrz rysunek 3).</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/10-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nWyniki wyszukiwania wyrazów <span class="zmienna">HTML W3C</span>. Wydruk <span class="program">Google</span> zawiera wytłuszczone wyrazy <span class="zmienna">HTML</span> oraz <span class="zmienna">W3C</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Więcej szczegółów na temat metainformacji zdefiniowanych na\r\npotrzeby <span class="program">Google</span> znajdziemy pod adresami:\r\n<a href="http://www.google.com/bot.html">http://www.google.com/bot.html</a>\r\noraz\r\n<a href="http://www.google.com/webmasters/faq.html">http://www.google.com/webmasters/faq.html</a>.</p>\r\n\r\n\r\n\r\n<h4 id="P5-6">5.6 Data powstania i ważności dokumentu</h4>\r\n\r\n<p>Do oznaczenia daty powstania dokumentu stosujemy element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;date&quot; content=&quot;Wed, 25 May 2005 10:05:32 GMT&quot;&gt;</pre>\r\n\r\n<p>zaś do oznaczenia terminu ważności:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Expires&quot; content=&quot;Wed, 01 Jun 2005 10:05:32 GMT&quot;&gt;</pre>\r\n\r\n<p>Specyfikacja protokołu HTTP 1.1 ustala, że data i czas winny być zapisane\r\nw formacie opisanym w dokumencie RFC 1123.\r\nFormat ten składa się z\r\ndnia tygodnia oddzielonego przecinkiem od daty, godziny oraz napisu GMT:</p>\r\n\r\n<pre class="syntax-highlight:xml">wkday &quot;,&quot; SP date SP time SP "GMT"</pre>\r\n\r\n<p>gdzie <span class="zmienna">SP</span> oznacza spację,\r\n<span class="zmienna">wkday</span> &mdash; dzień tygodnia\r\n(tj. jedno z\r\n\r\n<span class="zmienna">Mon</span>,\r\n<span class="zmienna">Tue</span>,\r\n<span class="zmienna">Wed</span>,\r\n<span class="zmienna">Thu</span>,\r\n<span class="zmienna">Fri</span>,\r\n<span class="zmienna">Sat</span>,\r\n<span class="zmienna">Sun</span>),\r\nzaś <span class="zmienna">date</span> i <span class="zmienna">time</span> &mdash;\r\n\r\ngodzinę i datę. Przykładami dat zgodnymi z powyższym formatem są:</p>\r\n\r\n<pre class="syntax-highlight:xml">Wed, 01 Jun 2005 10:05:32 GMT\r\nMon, 05 Apr 2004 11:44:55 GMT\r\nThu, 31 May 2005 22:00:00 GMT</pre>\r\n\r\n<p>Data jest opisana przez numer dnia (dwie cyfry z ewentualnymi zerami z przodu),\r\nnazwę miesiąca (angielski skrót\r\n<span class="zmienna">Jan</span>,\r\n<span class="zmienna">Feb</span>,\r\n<span class="zmienna">Mar</span>,\r\n<span class="zmienna">Apr</span>,\r\n\r\n<span class="zmienna">May</span>,\r\n<span class="zmienna">Jun</span>,\r\n<span class="zmienna">Jul</span>,\r\n<span class="zmienna">Aug</span>,\r\n<span class="zmienna">Sep</span>,\r\n<span class="zmienna">Oct</span>,\r\n<span class="zmienna">Nov</span> lub\r\n<span class="zmienna">Dec</span>) oraz czterocyfrowy numer roku.\r\nNatomiast godzina jest zapisana w formacie:</p>\r\n\r\n<pre class="syntax-highlight:xml">gg:mm:ss</pre>\r\n\r\n<p>gdzie <span class="zmienna">gg</span>,\r\n<span class="zmienna">mm</span> oraz\r\n<span class="zmienna">ss</span> są liczbami dwucyfrowymi oznaczającymi\r\ngodzinę, minuty i sekundy.\r\nPoprawny numer godziny jest zawarty pomiędzy wartościami:\r\n00:00:00 i 23:59:59.</p>\r\n\r\n<p>Do wygenerowania daty w opisanym formacie możemy użyć w języku PHP\r\nfunkcji <span class="zmienna">date()</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">$strDzis = date(&quot;D, d M Y G:i:s&quot;) . &quot; GMT&quot;;</pre>\r\n\r\n<p>Jeśli data ma wskazywać dzień lub godzinę inną od bieżącej,\r\nstosujemy połączenie funkcji\r\n<span class="zmienna">mktime()</span> oraz <span class="zmienna">date()</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">$jutro_ts = mktime(date(&quot;G&quot;), date(&quot;i&quot;), date(&quot;s&quot;),\r\n                   date(&quot;m&quot;), date(&quot;d&quot;) + 1, date(&quot;Y&quot;));\r\n$strJutro = date(&quot;D, d M Y G:i:s&quot;, $jutro_ts) . &quot; GMT&quot;;</pre>\r\n\r\n<p>Czasami w Internecie można znaleźć dokumenty, w których\r\nuaktualnienia są oznaczane w poniższy sposób:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;revised&quot; content=&quot;Jan Nowak, 20.05.2005&quot;&gt;</pre>\r\n\r\n<h4 id="P5-7">5.7 Przechowywanie stron WWW przez pośredników</h4>\r\n\r\n<p>Strony WWW mogą być przechowywane przez systemy pośredniczące w transakcji\r\npomiędzy klientem a serwerem. Przykładami są serwery proxy, które\r\nzazwyczaj zapisują kopie pobieranych witryn w celu przyspieszenia\r\nkolejnych transakcji.\r\nJeśli witryna nie powinna być zapisywana przez systemy pośredniczące, należy użyć\r\njednego z dwóch równoważnych elementów <span class="zmienna">META</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Cache-Control&quot; content=&quot;no-cache&quot;&gt;\r\n&lt;META http-equiv=&quot;Pragma&quot; content=&quot;no-cache&quot;&gt;</pre>\r\n\r\n<h4 id="P5-8">5.8 Skrypty i style &mdash; domyślny język</h4>\r\n\r\n<p>Style osadzone w dokumencie\r\nzazwyczaj zawierają informacje na temat zastosowanego języka.\r\nDo tego celu służy atrybut <span class="zmienna">type</span> elementów\r\n<span class="zmienna">LINK</span> oraz\r\n<span class="zmienna">STYLE</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LINK rel=&quot;stylesheet&quot; href=&quot;style.css&quot; type=&quot;text/css&quot;&gt;\r\n&lt;STYLE type=&quot;text/css&quot;&gt;...&lt;/STYLE&gt;</pre>\r\n\r\n<p>Jeżeli jednak na stronie pojawiają się style definiowane atrybutem\r\n<span class="zmienna">style</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;P style=&quot;color: red&quot;&gt;\r\n...\r\n&lt;/P&gt;</pre>\r\n\r\n<p>wtedy konieczne jest ustalenie domyślnego języka stylów.\r\nDo tego celu służy element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Style-Type&quot; content=&quot;text/css&quot;&gt;</pre>\r\n\r\n<p>Podobnie sprawa wygląda w przypadku skryptów.\r\nElement <span class="zmienna">SCRIPT</span> posiada atrybut <span class="zmienna">type</span>\r\n\r\ndefiniujący język dołączanego skryptu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;SCRIPT type=&quot;text/javascript&quot; src=&quot;&quot;&gt;&lt;/SCRIPT&gt;</pre>\r\n\r\n<p>Jeśli jednak stosujemy skrypty w obsłudze zdarzeń:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;DIV onmouseover=&quot;this.style.color = &#39;red&#39;;&quot;&gt;\r\nXXXXXX\r\n&lt;/DIV&gt;</pre>\r\n\r\n<p>wówczas w dokumencie należy umieścić\r\nelement ustalający domyślny język skryptów:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Content-Script-Type&quot; content=&quot;text/javascript&quot;&gt;</pre>\r\n\r\n<p>Większość stron w Internecie nie stosuje elementów <span class="zmienna">META</span> definiujących\r\ndomyślne języki stylów oraz skryptów.\r\nDopóki stosujemy języki <span class="jezyk">CSS</span> oraz\r\n<span class="jezyk">JavaScript</span> strony będą interpretowane poprawnie\r\nnawet wówczas, gdy nie zawierają powyższych elementów.</p>\r\n\r\n<p>W przypadku, gdy dokument jest wyposażony w kilka arkuszy stylów,\r\npowinniśmy wskazać style domyślne.\r\nJeśli jednym z arkuszy jest arkusz zatytułowany <span class="zmienna">compact</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;LINK href=&quot;compact.css&quot; title=&quot;compact&quot; rel=&quot;stylesheet&quot; type=&quot;text/css&quot;&gt;</pre>\r\n\r\n<p>do ustalenia stylu domyślnego stosujemy element:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Default-Style&quot; content=&quot;compact&quot;&gt;</pre>\r\n\r\n<h4 id="P5-9">5.9 Metainformacje w kilku językach</h4>\r\n\r\n<p>Jak wynika z tabeli 1, element <span class="zmienna">META</span> może zawierać atrybut\r\n<span class="zmienna">lang</span>.\r\nPoprawnymi elementami zatem są:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;Author&quot; lang=&quot;fr&quot; content=&quot;Arnaud Le Hors&quot;&gt;</pre>\r\n\r\n<p>oraz</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;keywords&quot; lang=&quot;en&quot;\r\n         content=&quot;holiday, Greece, sunshine&quot;&gt;\r\n\r\n&lt;META name=&quot;keywords&quot; lang=&quot;fr&quot;\r\n         content=&quot;vacances, Gr&amp;egrave;ce, soleil&quot;&gt;</pre>\r\n\r\n<p>Tego typu rozwiązania są jednak niezmiernie rzadkie\r\nw Internecie. Wynika to głównie z faktu, iż witryny są zazwyczaj przygotowywane\r\nw jednym konkretnym języku, zaś ewentualne tłumaczenia\r\nsą osobnymi stronami WWW.\r\nGdy cały dokument jest przygotowany w jednym języku,\r\nwówczas stosujemy atrybuty <span class="zmienna">lang</span> w\r\nodniesieniu do elementu <span class="zmienna">HTML</span>.</p>\r\n\r\n\r\n<h4 id="P5-10">5.10 Przekierowania</h4>\r\n\r\n<p>Wśród niewymienionych dotychczas elementów <span class="zmienna">META</span> ważną rolę odgrywa\r\nprzekierowanie.\r\nElement:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Refresh&quot; content=&quot;5 url=http://www.gajdaw.pl&quot;&gt;</pre>\r\n\r\n<p>spowoduje po upłynięciu pięciu sekund pobranie dokumentu o\r\nadresie <a href="http://www.gajdaw.pl">http://www.gajdaw.pl</a>.\r\nSeparatorem liczby sekund i adresu URL bywa także średnik:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Refresh&quot; content=&quot;5;url=http://www.w3schools.com&quot;&gt;</pre>\r\n\r\n<p>We współczesnych wersjach przeglądarek poprawne są oba zapisy.\r\nW starszych wersjach niestety nie ma takiej zgodności, na przykład\r\n<span class="program">Netscape 4</span>\r\npoprawnie interpretuje wyłącznie element, w którym separatorem jest średnik.</p>\r\n\r\n<p>Rozwiązanie takie jest stosowane przez archiwa oprogramowania,\r\nna przykład <span class="program">SourceForge</span>.\r\nPobieranie biblioteki <span class="program">gtk</span> ze strony\r\n<a href="http://gimp-win.sourceforge.net/stable.html">http://gimp-win.sourceforge.net/stable.html</a>\r\nzakończy się przekierowaniem:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;refresh&quot; content=&quot;5;\r\nURL=http://mesh.dl.sourceforge.net/sourceforge/gimp-win/gtk+-2.6.7-setup-1.zip&quot;&gt;</pre>\r\n\r\n<h4 id="P5-11">5.11 Różności</h4>\r\n\r\n<p>Wielu producentów oprogramowania wprowadziło w swoich produktach\r\nwłasne, specyficzne rozwiązania dotyczące metainformacji.\r\nSpośród setek dostępnych elementów\r\n(patrz <a href="http://vancouver-webpages.com/meta/">http://vancouver-webpages.com/META/</a>)\r\nwspomnijmy o wyłączeniu interpretacji znaczników typu <span class="zmienna">SmartTag</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;MSSmartTagsPreventParsing&quot; content=&quot;true&quot;&gt;</pre>\r\n\r\n<p>wyłączeniu menu wyświetlanego przez przeglądarkę IE,\r\npo umieszczeniu kursora nad obrazem (patrz rysunek 3):</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;imagetoolbar&quot; content=&quot;no&quot;&gt;</pre>\r\n\r\n<p>ustaleniu ciasteczek:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;Set-Cookie&quot; content=&quot;cookievalue=xxx;expires=Friday, 31-Dec-99 23:59:59 GMT; path=/&quot;&gt;</pre>\r\n\r\n<p>czy klasyfikacji zawartości dokumentu:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;rating&quot;        content=&quot;general&quot;&gt;\r\n&lt;META name=&quot;rating&quot;        content=&quot;all&quot;&gt;\r\n&lt;META name=&quot;doc-class&quot;     content=&quot;Living Document&quot;&gt;\r\n&lt;META name=&quot;distribution&quot;  content=&quot;global&quot;&gt;\r\n&lt;META name=&quot;resource-type&quot; content=&quot;document&quot;&gt;\r\n&lt;META name=&quot;page-topic&quot;    content=&quot;Internet&quot;&gt;\r\n&lt;META name=&quot;page-type&quot;     content=&quot;Instruction&quot;&gt;\r\n&lt;META name=&quot;audience&quot;      content=&quot;General&quot;&gt;\r\n&lt;META name=&quot;pagename&quot;      content=&quot;Jeszcze jeden tytuł strony...&quot;&gt;</pre>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p><span class="zmienna">SmartTags</span> to rozwiązanie\r\nwprowadzone przez <span class="program">MicroSoft</span>\r\nw narzędziach pakietu <span class="program">Office</span>,\r\nw tym także przeglądarce <span class="program">IE</span>.\r\nPozwala ono na modyfikowanie zawartości strony WWW przez przeglądarkę.\r\nWyrazy znajdujące się w tekście są zamieniane na hiperłącza do\r\nzewnętrznych stron. Ponieważ proces ten odbywa się bez żadnego udziału\r\ntwórcy strony, jest on traktowany w środowisku twórców witryn jako add-ware.\r\nWięcej szczegółów pod adresem:</p>\r\n\r\n\r\n<p><a href="http://www.unwantedlinks.com/smarttagsarticle.htm">http://www.unwantedlinks.com/SmartTagsArticle.htm</a>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/10-04.jpg" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nMenu wyświetlane przez przeglądarkę <span class="program">IE</span> po umieszczeniu kursora myszki nad obrazem</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<p>Przeszukując Internet znajdziemy jeszcze z pewnością dziesiątki\r\ninnych elementów <span class="zmienna">META</span>,\r\nktórych składnia będzie zgodna z elementem:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META name=&quot;nazwa&quot; content=&quot;wartość&quot;&gt;</pre>\r\n\r\n<p>W przypadku elementu</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;META http-equiv=&quot;nazwa-nagłówka-http&quot; content=&quot;wartość&quot;&gt;</pre>\r\n\r\n<p>lista poprawnych elementów jest zdefiniowana przez protokół HTTP.</p>\r\n\r\n<h3 id="R6">6. Standaryzacja</h3>\r\n\r\n<p>Elementy <span class="zmienna">META</span> przeżywały tę samą chorobę,\r\nktóra nękała kilka lat temu język <span class="jezyk">HTML</span>.\r\nKażdy twórca oprogramowania wprowadzał własne rozwiązania\r\nmające na celu wyprzedzenie konkurencji i podbój Internetu.\r\nNiestety metainformacje nie doczekały się jeszcze\r\nprocesu standaryzacji, który byłby zaakceptowany przez\r\nszeroko rozumiane środowisko twórców witryn.</p>\r\n\r\n<p>Dane na temat metainformacji zdobywamy na podstawie\r\nspecyfikacji języka <span class="jezyk">HTML</span> i protokołu HTTP,\r\nprzeglądając liczne zestawienia dostępne w Internecie\r\n(publikowane przez niezależnych autorów) oraz\r\nprzeglądając źródła stron tworzonych przez osoby uznane\r\nza autorytety w dziedzinie webdesignu.</p>\r\n\r\n<p>Informacje na temat procesu standaryzacji metainformacji znajdziemy na witrynie\r\n<a href="http://dublincore.org/">http://dublincore.org/</a>.</p>\r\n\r\n<h3 id="R7">7. Podsumowanie</h3>\r\n\r\n<p>Jedynym elementem, który musi znaleźć się na każdej witrynie\r\njest definicja kodowania znaków.\r\nWszystkie pozostałe elementy są opcjonalne.\r\nDo najczęściej stosowanych należą\r\n<span class="zmienna">description</span>,\r\n<span class="zmienna">author</span>,\r\n<span class="zmienna">keywords</span> oraz\r\n<span class="zmienna">robots</span>.\r\nOrganizacja W3C zaleca definiowanie\r\ndomyślnego języka stylów i skryptów oraz\r\njęzyków etnicznych, w jakich witryna została wykonana.\r\nTabele 2, 3 oraz 4 zawierają sumaryczne zestawienie elementów\r\n<span class="zmienna">META</span>.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Lp.</th><th>Metainformacja</th><th>Atrybut<br /><span class="zmienna">name</span></th><th>Atrybut<br /><span class="zmienna">http-equiv</span></th><th>Uwagi</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Lp.</th><th>Metainformacja</th><th>Atrybut<br /><span class="zmienna">name</span></th><th>Atrybut<br /><span class="zmienna">http-equiv</span></th><th>Uwagi</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Kodowanie znaków</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Content-Type</span></td>\r\n\r\n<td>Dokumentacja <span class="jezyk">HTML</span> radzi, by kodowanie znaków było pierwszym elementem strony (przed elementem <span class="zmienna">TITLE</span>).</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 2.\r\nMetainformacje, jakie muszą się znaleźć na każdej stronie</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n\r\n<table>\r\n<thead>\r\n<tr><th>Lp.</th><th>Metainformacja</th><th>Atrybut<br /><span class="zmienna">name</span></th><th>Atrybut<br /><span class="zmienna">http-equiv</span></th><th>Uwagi</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Lp.</th><th>Metainformacja</th><th>Atrybut<br /><span class="zmienna">name</span></th><th>Atrybut<br /><span class="zmienna">http-equiv</span></th><th>Uwagi</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Definicja grona czytelniczego</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Content-Language</span></td>\r\n\r\n<td>Element ten stosujemy równocześnie z atrybutem <span class="zmienna">lang</span> elementu <span class="zmienna">HTML</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Identyfikacja autora</td>\r\n\r\n<td><span class="zmienna">author</span>, <span class="zmienna">copyright</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Opis</td>\r\n\r\n<td><span class="zmienna">description</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>Opis powinien zawierać od 100 do 200 znaków.<br />Podana wartość powinna odpowiadać treści witryny.<br />Należy w opisie zawrzeć kilka najistotniejszych słów kluczowych.<br />Nie należy powielać słów kluczowych.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Słowa kluczowe</td>\r\n\r\n<td><span class="zmienna">keywords</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>Lista słów kluczowych powinna liczyć od 100 do 200 znaków.<br />Wybrane słowa powinny odpowiadać treści witryny.<br />Nie należy powielać słów kluczowych.<br />Do oddzielenia słów kluczowych stosujemy przecinek lub spację.<br />Słowa kluczowe piszemy tylko małymi literami.<br />Zazwyczaj nie odmieniamy ich.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Roboty</td>\r\n\r\n<td><span class="zmienna">robots</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 3.\r\nMetainformacje, jakie warto umieścić na witrynie</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Lp.</th><th>Metainformacja</th><th>Atrybut<br /><span class="zmienna">name</span></th><th>Atrybut<br /><span class="zmienna">http-equiv</span></th><th>Uwagi</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Lp.</th><th>Metainformacja</th><th>Atrybut<br /><span class="zmienna">name</span></th><th>Atrybut<br /><span class="zmienna">http-equiv</span></th><th>Uwagi</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td>1.</td>\r\n\r\n<td>Identyfikacja autora &mdash; c.d.</td>\r\n\r\n<td><span class="zmienna">generator</span>,<br /><span class="zmienna">reply-to</span>,<br /><span class="zmienna">publisher</span>,<br /><span class="zmienna">company</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>Podany adres email jest dostępny dla spamerów.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>2.</td>\r\n\r\n<td>Tytuł dokumentu</td>\r\n\r\n<td><span class="zmienna">title</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>Nigdy nie wolno zrezygnować z elementu <span class="zmienna">TITLE</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>3.</td>\r\n\r\n<td>Abstrakt</td>\r\n\r\n<td><span class="zmienna">abstract</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td>4.</td>\r\n\r\n<td>Wymuszenie rewizyty robotów</td>\r\n\r\n<td><span class="zmienna">revisit-after</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td>5.</td>\r\n\r\n<td>Archiwizacja przez wyszukiwarkę <span class="program">Google</span></td>\r\n\r\n<td><span class="zmienna">googlebot</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td>6.</td>\r\n\r\n<td>Data dokumentu</td>\r\n\r\n<td><span class="zmienna">date</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td>7.</td>\r\n\r\n<td>Czas wygaśnięcia dokumentu</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Expires</span></td>\r\n\r\n<td>W połączeniu z <span class="zmienna">Cache-Control</span> lub <span class="zmienna">Pragma</span> jest stosowany w odniesieniu do formularzy oraz stron wymagających uwierzytelniania.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>8.</td>\r\n\r\n<td>Sterowanie przechowywaniem dokumentu przez serwery proxy</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Cache-Control</span>, <span class="zmienna">Pragma</span></td>\r\n\r\n<td>W połączeniu z <span class="zmienna">Expires</span> są stosowane w odniesieniu do formularzy oraz stron wymagających uwierzytelniania.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>9.</td>\r\n\r\n<td>Domyślny język stylów</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Content-Style-Type</span></td>\r\n\r\n<td>Opcjonalny, jeśli stosujemy <span class="jezyk">CSS</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>10.</td>\r\n\r\n<td>Domyślny język skryptów</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Content-Script-Type</span></td>\r\n\r\n<td>Opcjonalny, jeśli stosujemy <span class="jezyk">JavaScript</span>.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>11.</td>\r\n\r\n<td>Przekierowanie</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">Refresh</span></td>\r\n\r\n<td>Nie należy tego mechanizmu stosować do trwałych przekierowań. Do tego celu służy nagłówek HTTP:<br /><span class="zmienna">Location: adres-url</span>.<br />Bywa wykorzystywany do automatycznego rozpoczynania pobierania pliku.</td>\r\n\r\n</tr>\r\n\r\n<tr><td>12.</td>\r\n\r\n<td>Wyłączenie SmartTagów</td>\r\n\r\n<td><span class="zmienna">MS-<br />SmartTags-<br />Prevent-<br />Parsing</span></td>\r\n\r\n<td>-</td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n\r\n<tr><td>13.</td>\r\n\r\n<td>Wyłączenie menu kontekstowego obrazów w IE</td>\r\n\r\n<td>-</td>\r\n\r\n<td><span class="zmienna">image-<br />toolbar</span></td>\r\n\r\n<td>-</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 4.\r\nMetainformacje opcjonalne i stosowane w specyficznych sytuacjach</p>\r\n</div>', 'element-meta-mdash-dodatkowe-informacje-na-temat');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(11, 'Projekt układu strony w oparciu o elementy div oraz arkusze stylów', 'Projektowanie układu witryny z wykorzystaniem arkuszy stylów\r\noraz sekcji <span class="zmienna">div</span> staje się coraz\r\nbardziej popularne. Coraz częściej firmy zajmujące się\r\ntworzeniem witryn zaznaczają w swojej ofercie, że układ jest przygotowany\r\nw oparciu o style i w sposób zgodny ze standardami.\r\nZ racji na różnice w interpretacji stylów pomiędzy różnymi przeglądarkami\r\npoczątkowe etapy rezygnacji z tradycyjnych układów tabelkowych mogą być kłopotliwe.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Technika pracy nad układem strony</a></li>\r\n<li><a href="#R2">2. Gdy układ się rozjeżdża</a></li>\r\n<li><a href="#R3">3. Powody rozjeżdżania układu</a></li>\r\n<li><a href="#R4">4. Pudełko</a></li>\r\n<li><a href="#R5">5. Pudełka ściśle przylegające</a></li>\r\n<li><a href="#R6">6. Różnice w interpretacji CSS</a></li>\r\n<li><a href="#R7">7. Witryna dla przeglądarek nie interpretujących stylów</a></li>\r\n<li><a href="#R8">8. Białe znaki</a></li>\r\n<li><a href="#R9">9. Selektor potomek</a></li>\r\n<li><a href="#R10">10. Menu wykonane listami wypunktowanymi</a></li>\r\n<li><a href="#R11">11. Sprawdzanie poprawności dokumentu</a></li>\r\n<li><a href="#R12">12. Struktura dokumentu</a></li>\r\n<li><a href="#R13">13. Podsumowanie</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Technika pracy nad układem strony</h3>\r\n\r\n<p>Zanim przystąpimy do pisania kodu <span class="jezyk">HTML</span> oraz <span class="jezyk">CSS</span>,\r\nwarto poznać kilka sztuczek, które zwiększą wydajność\r\ni jakość dalszej pracy.</p>\r\n\r\n<p>Po pierwsze tworzenie układu krok po kroku,\r\nze sprawdzeniem poprawności przy każdej zmianie jest o wiele łatwiejsze niż\r\nszukanie błędu po wprowadzeniu wielu zmian na raz.\r\nOd pierwszych do ostatnich chwil należy testować\r\nstronę zarówno pod względem wyglądu w przeglądarce\r\njak i poprawności kodu <span class="jezyk">HTML</span> i <span class="jezyk">CSS</span>.</p>\r\n\r\n<p>Po drugie, z racji na różnice w interpretacji\r\nstylów nawet przez najnowsze przeglądarki,\r\ntesty powinniśmy przeprowadzać w kilku przeglądarkach na raz.\r\nDobrym wyborem jest używanie bieżących wersji\r\n<span class="program">Internet Explorera</span>,\r\n<span class="program">Firefoxa</span>,\r\n<span class="program">Opery</span> oraz\r\n<span class="program">Netscape</span>.</p>\r\n\r\n<p>Kolejnym trikiem jest podglądanie\r\nzarówno układu jak i faktycznych rozmiarów\r\nsekcji <span class="zmienna">div</span>.\r\nModyfikując na chwilę tło elementu <span class="zmienna">div</span>\r\n\r\nna dowolny, ale wyróżniający się kolor,\r\nujrzymy wyraźnie jego położenie i wielkość.\r\nZmiana koloru tła jest o wiele lepszą metodą niż wyświetlenie krawędzi\r\n(atrybut <span class="zmienna">border</span>).\r\nWyświetlenie krawędzi elementu powoduje powiększenie rozmiaru,\r\nco często jest powodem &bdquo;rozjeżdżania&rdquo; się całości.</p>\r\n\r\n<p>Zwróćmy uwagę, że metoda debugowania witryny polegająca na modyfikacji\r\nkoloru tła jest niezależna od przeglądarki i umożliwia\r\nsprawdzenie położenia i wielkości elementu w każdej z przeglądarek.</p>\r\n\r\n<p>Podsumowując, nad układem strony pracujemy:</p>\r\n\r\n<ul>\r\n\r\n<li>krok po kroku, testując witrynę po wprowadzeniu jakiejkolwiek zmiany,</li>\r\n<li>sprawdzamy poprawność kodu <span class="jezyk">HTML</span>, <span class="jezyk">CSS</span> oraz wygląd w przeglądarkach,</li>\r\n<li>wygląd witryny sprawdzamy w czterech najnowszych przeglądarkach,</li>\r\n<li>położenie i wielkość elementów <span class="zmienna">div</span> sprawdzamy\r\nzmieniając na chwilę wypełnienie tła na charakterystyczny kolor (atrybut <span class="zmienna">background</span>).\r\n\r\n</li>\r\n</ul>\r\n\r\n<h3 id="R2">2. Gdy układ się rozjeżdża</h3>\r\n\r\n<p>Największą trudnością jest wyłapywanie błędów, które powodują rozjeżdżanie układu strony.\r\nBłędy takie powstają zazwyczaj wtedy, gdy szerokość elementu <span class="zmienna">div</span>\r\nprzekroczy ilość dostępnego miejsca.\r\nW celu zbadania położenia elementu stosujemy wspomniana już właściwość <span class="zmienna">background</span>.\r\nNatomiast w jaki sposób sprawdzić faktyczny rozmiar elementu na stronie?\r\nMetod rozwiązania tego problemu jest kilka.</p>\r\n\r\n<p>Możemy skorzystać z programu <span class="program">Gimp</span> (lub innego edytora graficznego posiadającego\r\nnarzędzie <span class="opcja">Miarka</span>). Wykonujemy zrzut ekranu (naciskamy klawisze <span class="shortcut">Alt+PrintScreen</span>),\r\nnastępnie obraz wklejamy w edytorze graficznym (w <span class="program">Gimpie</span> wykonujemy operację\r\n\r\n<span class="opcja">Plik &rarr; Pobierz &rarr; From Clipboard</span>).\r\nWklejony obraz mierzymy stosując linijki, prowadnice i miarkę.\r\nPrzykładowy pomiar szerokości sekcji <span class="zmienna">div</span>\r\no czarnym tle wykonany w programie <span class="program">Gimp</span> jest przedstawiony na rysunku 1.\r\nOczywiście stosując podaną metodę możemy badać strony wyświetlane w dowolnej przeglądarce.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/11-01.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nPomiar szerokości sekcji <span class="zmienna">div</span> wykonany w <span class="program">Gimpie</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Przeglądarka <span class="program">Firefox</span> posiada wtyczkę\r\n<span class="program">Web Developer Toolbar</span>.\r\nWtyczka ta, dostępna pod adresem <a href="http://chrispederick.com/work/firefox/webdeveloper/">http://chrispederick.com/work/firefox/webdeveloper/</a>,\r\nzawiera między innymi narzędzie\r\n<span class="opcja">Information &rarr; Display Block Size</span>,\r\nktóre wyświetla rozmiary wszystkich sekcji\r\n<span class="zmienna">div</span> na stronie.\r\nWynik pomiaru jest przedstawiany w postaci niewielkiego prostokąta\r\nwidocznego w lewym górnym narożniku sekcji <span class="zmienna">div</span> (rysunek 2).\r\nMetoda ta, choć bardzo wygodna, może być zastosowana wyłącznie wtedy, gdy korzystamy z przeglądarki\r\n\r\n<span class="program">Firefox</span>.  Jeśli układ strony wygląda dobrze w <span class="program">Firefoxie</span>, a\r\nrozjeżdża się w <span class="program">Internet Explorerze</span> (to jest najczęstsza sytuacja),\r\nniestety metoda ta jest bezużyteczna.\r\nDodatkowym minusem wtyczki jest to, że prostokąty zawierające wymiary\r\nczasami zachodzą na siebie i są nie czytelne. Dzieje się tak wtedy, gdy\r\nelementy <span class="zmienna">div</span> pokrywają się.\r\n(Wtyczka\r\n<span class="program">Web Developer Toolbar</span> posiada drugą opcję\r\nprzydatną przy badaniu układu strony. Jest nią\r\n<span class="opcja">Outline &rarr; Block level elements</span>.\r\nWłączenie opcji powoduje wyświetlenie obramowania wszystkich elementów blokowych\r\nwystępujących w kodzie witryny.\r\nPoszczególne elementy <span class="jezyk">HTML</span> różnią się kolorem obramowania, zaś na uwagę zasługuje fakt,\r\nże wyświetlane krawędzie nie zmieniają rozmiaru elementów.)</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/11-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nWymiary sekcji <span class="zmienna">div</span> wyświetlane w <span class="program">Firefoxie</span> (wtyczka <span class="program">Web Developer Toolbar</span>)</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Wadą pierwszej z podanych metod jest stopień skomplikowania.\r\nKażdy pomiar wymaga kilkunastu kliknięć i zajmuje dużo czasu.\r\nWadą drugiej to, że znajduje zastosowanie tylko w jednej z przeglądarek.\r\nNatomiast program <span class="program">Miarka</span> (tabela 3)\r\njest wygodnym narzędziem, które możemy stosować w odniesieniu do dowolnej aplikacji.\r\nPo wskazaniu kursorem wybranego piksela, program wyświetla rozmiar\r\nprostokąta, zawierającego piksele identycznego koloru.\r\nWynik pomiaru elementu <span class="zmienna">div</span>\r\nw przeglądarce <span class="program">Opera</span> został przedstawiony na rysunku 3.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/11-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nPomiar wymiarów sekcji <span class="zmienna">div</span> wykonany programem <span class="program">Miarka</span></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R3">3. Powody rozjeżdżania układu</h3>\r\n\r\n<p>Szukając przyczyn błędów w układzie strony należy\r\nrozważyć następujące zagadnienia:</p>\r\n\r\n<ul>\r\n<li>użyte style <span class="jezyk">CSS</span> nie są poprawnie interpretowane\r\n(np. selektor elementu jest niepoprawny lub style są przesłonięte przez późniejsze definicje),</li>\r\n\r\n<li>cechy (błędy? &mdash; patrz ramka) przeglądarki (tj. przeglądarka nie interpretuje pewnego atrybutu <span class="jezyk">CSS</span>\r\nlub interpretuje go w sposób odmienny niż inne przeglądarki),</li>\r\n<li>kod <span class="jezyk">HTML</span> strony, w szczególności\r\n<ul>\r\n<li>zawartość elementów <span class="jezyk">HTML</span> (zbyt duża zawartość spowoduje rozjeżdżanie elementów nadrzędnych),</li>\r\n\r\n<li>białe znaki w kodzie <span class="jezyk">HTML</span>,</li>\r\n<li>kolejność i ilość elementów <span class="zmienna">div</span>,</li>\r\n</ul>\r\n</li>\r\n<li>rozmiar okna przeglądarki.</li>\r\n</ul>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>W odniesieniu do oprogramowania zawierającego błędy popularny był swego czasu żart\r\n<q>&bdquo;It''s not a bug, it''s a feature!&rdquo;</q> &mdash;\r\n<q>&bdquo;To nie błąd, to cecha tego programu!&rdquo;</q></p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Szukając przyczyny konkretnego błędu, badamy wszystkie powyższe czynniki, dążąc\r\n&mdash; jak zawsze podczas szukania błędów &mdash; do wyizolowania problemu.</p>\r\n\r\n<p>W pierwszym kroku upewniamy się, że definicje stylów są poprawnie stosowane do wybranego elementu.\r\nModyfikacja tła upewnia nas co do tego, że selektor jest poprawny, zaś przeniesienie stylów\r\nna koniec pliku <span class="jezyk">CSS</span> gwarantuje, że style nie są przysłonięte (o ile nie stosujemy kilku plików\r\nze stylami, stylów wewnętrznych czy atrybutu <span class="zmienna">style</span> w kodzie <span class="jezyk">HTML</span>).</p>\r\n\r\n<p>Jeśli style są częściowo stosowane przez przeglądarkę (np. zmienia się tło\r\nelementu <span class="zmienna">div</span> zaś nie zmienia się jego szerokość), to próbujemy ustalić, czy\r\nbłędy nie wynikają z powodu złej interpretacji stylów przez przeglądarkę.\r\nPewne różnice w interpretacji stylów oraz kodu <span class="jezyk">HTML</span> znajdziemy prawdopodobnie\r\npomiędzy wszystkimi przeglądarkami. Stąd tak ważne testowanie w kilku przeglądarkach na raz.\r\nPrzykładem są właściwości z przedrostkami\r\n\r\n<span class="zmienna">min-</span> oraz <span class="zmienna">max-</span>\r\n(np. <span class="zmienna">min-height</span> czy <span class="zmienna">max-height</span>).\r\nWłaściwości te nie są interpretowane przez <span class="program">Internet Explorera</span>.\r\nJeśli przygotujemy duży projekt oparty o atrybuty\r\n<span class="zmienna">min-</span> i <span class="zmienna">max-</span>,\r\ntestując jego wygląd w <span class="program">Firefoxie</span>,\r\nto jego wygląd w <span class="program">Internet Explorerze</span> będzie najprawdopodobniej błędny.</p>\r\n\r\n<p>Interpretację wybranych atrybutów w konkretnej przeglądarce najlepiej sprawdzać na\r\nmalutkich przykładach, wykorzystujących wyłącznie badany atrybut.</p>\r\n\r\n<p>Kolejnym powodem, który często powoduje problemy jest zbyt duży rozmiar zawartości elementu.\r\nZdarza się na przykład (ponownie w przeglądarce\r\n<span class="program">IE</span>), że akapity występujące\r\nw elementach <span class="zmienna">div</span> mają zbyt dużą szerokość.\r\nTutaj z pomocą przychodzi ustalenie rozmiaru elementów\r\nzawartych w sekcji <span class="zmienna">div</span>\r\n(do stwierdzenia istnienia tego problemu stosujemy omówioną już metodę modyfikacji tła elementu\r\ni pomiaru jego wielkości).</p>\r\n\r\n<p>Nieco mniej oczywistym powodem zwiększenia szerokości elementów\r\nzawartych wewnątrz sekcji <span class="zmienna">div</span> może być\r\nobecność białych znaków. Ten problem dotyczy wszystkich przeglądarek.\r\nNa przykład opcje menu wykonanego za pomocą list wypunktowanych <span class="zmienna">ul</span>\r\nbędą odsunięte od siebie o kilka pikseli, chyba, że usuniemy białe znaki otaczające elementy\r\n<span class="zmienna">li</span> oraz <span class="zmienna">ul</span>\r\ni zapiszemy kod całej listy w jednej linii:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;ul&gt;&lt;li&gt;ala&lt;/li&gt;&lt;li&gt;ma&lt;/li&gt;&lt;li&gt;kota&lt;/li&gt;&lt;/ul&gt;</pre>\r\n\r\n<p>Zdarza się również, że na układ witryny ma wpływ kolejność oraz obecność dodatkowych\r\nelementów <span class="zmienna">div</span>.\r\nPrzykładem takiej sytuacji jest kod:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;lewo1&quot;&gt;A&lt;/div&gt;\r\n&lt;div id=&quot;lewo2&quot;&gt;B&lt;/div&gt;\r\n&lt;div id=&quot;prawo1&quot;&gt;C&lt;/div&gt;\r\n&lt;div id=&quot;prawo2&quot;&gt;D&lt;/div&gt;</pre>\r\n\r\n<p>Dosunięcie elementów o identyfikatorach\r\n<span class="zmienna">lewo1</span>, <span class="zmienna">lewo2</span>\r\ndo lewej krawędzi (styl <span class="zmienna">float: left</span>)\r\noraz elementów <span class="zmienna">prawo1</span>, <span class="zmienna">prawo2</span>\r\n\r\ndo prawej krawędzi (styl <span class="zmienna">float: right</span>)\r\nnie da pożądanych efektów w przeglądarce <span class="program">Firefox</span>.\r\nNatomiast dodając dodatkowe pojemniki\r\n<span class="zmienna">lewy</span> i <span class="zmienna">prawy</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;lewy&quot;&gt;\r\n  &lt;div id=&quot;lewo1&quot;&gt;A&lt;/div&gt;\r\n  &lt;div id=&quot;lewo2&quot;&gt;B&lt;/div&gt;\r\n&lt;/div&gt;\r\n&lt;div id=&quot;prawy&quot;&gt;\r\n  &lt;div id=&quot;prawo1&quot;&gt;C&lt;/div&gt;\r\n  &lt;div id=&quot;prawo2&quot;&gt;D&lt;/div&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>pozbędziemy się problemu.</p>\r\n\r\n<p>Ostatnim z czynników, jaki czasami warunkuje poprawność wyglądu strony,\r\nbywa szerokość okna przeglądarki.</p>\r\n\r\n<h3 id="R4">4. Pudełko</h3>\r\n\r\n<p>Kluczowym pojęciem przy tworzeniu układu strony jest pojęcie pudełka\r\nomówione szczegółowo w rozdziale 8 specyfikacji <span class="jezyk">CSS</span>\r\nzatytułowanym <span class="tytul">&bdquo;Box model&rdquo;</span> .\r\nPudełko to prostokąt zajmowany przez element <span class="jezyk">HTML</span>.\r\nKażdy element <span class="jezyk">HTML</span> użyty w kodzie strony poza elementami nagłówka\r\nposiada swoje pudełko.\r\nPrzykładami są nie tylko sekcje <span class="zmienna">div</span>,\r\nale również akapity <span class="zmienna">p</span>,\r\nelementy <span class="zmienna">strong</span>, <span class="zmienna">em</span>,\r\ntabelki, ich wiersze i komórki czy listy wypunktowane.</p>\r\n\r\n<p>Wysokość i szerokość pudełka jest ustalana przez przeglądarkę na podstawie\r\nstylu oraz zawartości elementu.\r\nPudełko składa się z następujących czterech obszarów: zawartości,\r\nwyrównania (<span class="ang">ang. padding</span>),\r\nobramowania (<span class="ang">ang. border</span>)\r\noraz marginesu.\r\nRysunek 4 przedstawia pudełko z napisem <span class="zmienna">ALA</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/11-04.png" alt="" />\r\n\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nPoszczególne obszary pudełka i ich wpływ na szerokość całego elementu</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Poszczególne obszary zostały na rysunku oznaczone:\r\n<span class="zmienna">M</span> - margines,\r\n<span class="zmienna">B</span> - obramowanie,\r\n\r\n<span class="zmienna">P</span> - wyrównanie oraz\r\n<span class="zmienna">Z</span> - zawartość.\r\nMargines, obramowanie i wyrównanie otaczają zawartość z czterech stron\r\nnazywanych top (góra), bottom (dół), left (lewa) oraz right (prawa).\r\nAtrybuty te możemy stosować do wszystkich czterech krawędzi na raz\r\npisząc:</p>\r\n\r\n<pre class="syntax-highlight:xml">padding : 15px;\r\nmargin  : 30px;</pre>\r\n\r\n<p>oraz do każdej krawędzi z osobna stosując przyrostki\r\n<span class="zmienna">-top</span>,\r\n<span class="zmienna">-bottom</span>,\r\n\r\n<span class="zmienna">-left</span> oraz\r\n<span class="zmienna">-right</span>, na przykład:</p>\r\n\r\n<pre class="syntax-highlight:xml">border-left : 1px solid blue;\r\nmargin-top  : 100px;</pre>\r\n\r\n<p>Szerokość całego elementu wynika z szerokości poszczególnych\r\nobszarów i jest równa ich sumie:</p>\r\n\r\n<pre class="syntax-highlight:xml">lewy margines + lewe obramowanie + lewe wyrównanie +\r\nzawartość +\r\nprawe wyrównanie + prawe obramowanie + prawy margines</pre>\r\n\r\n<p>lub, w przypadku elementów symetrycznych w pionie:</p>\r\n\r\n<pre class="syntax-highlight:xml">2 * margines + 2 * obramowanie + zawartość</pre>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p>Warto zapamiętać, że szerokość elementu ustalana atrybutem <span class="zmienna">width</span>\r\n\r\nokreśla wyłącznie szerokość przeznaczoną na treść.\r\nW celu wyliczenia szerokości zajmowanej przez cały element należy\r\ndo podanej wartości dodać marginesy, obramowanie i wyrównanie.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>Jeśli chcemy otrzymać pudełko o szerokości 100 pikseli\r\ni posiadające jednopikselowe obramowanie wówczas\r\npodajemy marginesy równe 0, obramowanie równe 1, wyrównanie równe 0\r\noraz zawartość równą 98, według wzoru:</p>\r\n\r\n<pre class="syntax-highlight:xml">0 + 1 + 0 + 98 + 0 + 1 + 0</pre>\r\n\r\n<p>Style mają postać:</p>\r\n\r\n<pre class="syntax-highlight:xml">div {\r\n    margin  : 0px;\r\n    border  : 1px solid black;\r\n    padding : 0px;\r\n    width   : 98px;\r\n}</pre>\r\n\r\n<p>Jeśli zechcemy, by cały element miał 150 pikseli szerokości, był otoczony 5-cio\r\npikselowym marginesem, posiadał trzypikselowe obramowanie, zaś jego zawartość\r\nbyła odsunięta od krawędzi o 10 pikseli to należy użyć stylów:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#mala {\r\n    margin  : 5px;\r\n    border  : 3px solid red;\r\n    padding : 10px;\r\n    width   : 114px;\r\n}</pre>\r\n\r\n<p>gdyż</p>\r\n\r\n<pre class="syntax-highlight:xml">2 * 5 + 2 * 3 + 2 * 10 + 114 = 150</pre>\r\n\r\n<p>Po umieszczeniu powyższej sekcji wewnątrz sekcji o identyfikatorze\r\n<span class="zmienna">duza</span> o szerokości 160 pikseli\r\n(150 na zawartość, 10 na obramowanie):</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;duza&quot;&gt;\r\n    &lt;div id=&quot;mala&quot;&gt;X&lt;/div&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>i nadaniu odmiennego tła, możemy dokładnie zmierzyć rozmiary wszystkich\r\nelementów układu, stosując wcześniej opisane metody.\r\nSzerokość i obramowanie sekcji nadrzędnej definiujemy następująco:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#duza {\r\n    border : 5px gray solid;\r\n    width  : 150px;\r\n}</pre>\r\n\r\n<p>W celu uniknięcia zamieszania, najlepiej w pliku <span class="jezyk">CSS</span> uporządkować\r\nkolejność wpisów dotyczących poszczególnych selektorów.\r\nDobrą metodą jest umieszczanie atrybutów dotyczących pudełka\r\nprzed wszelkimi innymi wpisami (np. kolorami lub czcionkami).\r\nDodatkowo, atrybuty pudełka umieszczamy w kolejności:</p>\r\n\r\n<pre class="syntax-highlight:xml">margin\r\nborder\r\npadding\r\nwidth</pre>\r\n\r\n<p>(czyli w kolejności od najbardziej zewnętrznych do najbardziej wewnętrznych), po nich umieszczamy\r\ndodatkowe atrybuty dotyczące pudełka takie jak <span class="zmienna">float</span> czy\r\n<span class="zmienna">clear</span>,\r\na na końcu czcionki, kolory czy wyrównanie.\r\nDodatkowo, atrybuty z przyrostkami (np. <span class="zmienna">left</span>)\r\npiszemy w kolejności\r\n<span class="zmienna">-top</span>,\r\n\r\n<span class="zmienna">-right</span>,\r\n<span class="zmienna">-bottom</span> i\r\n<span class="zmienna">-left</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">p {\r\n    margin      : 10px;\r\n    border      : none;\r\n    border-top  : 2px dashed blue;\r\n    border-left : 1px solid red;\r\n    padding     : 15px;\r\n    width       : 100px;\r\n\r\n    float       : left;\r\n    clear       : left;\r\n\r\n    font-family : verdana, helvetica, sans-serif;\r\n    font-size   : 10pt;\r\n\r\n    color       : blue;\r\n    background  : yellow;\r\n}</pre>\r\n\r\n<p>Pamiętajmy, że włączenie widoczności krawędzi elementu zwiększa jego\r\nrozmiar o podwójną grubość obramowania.\r\nJeśli na stronie mamy element <span class="zmienna">div</span> o szerokość 100 pikseli:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#str {\r\n    margin  : 0px;\r\n    border  : 0px;\r\n    padding : 10px;\r\n    width   : 80px;\r\n}</pre>\r\n\r\n<p>i w celu sprawdzenia jego położenia wyświetlimy krawędzie:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#str {\r\n    margin  : 0px;\r\n    border  : 1px solid red;\r\n    padding : 10px;\r\n    width   : 80px;\r\n}</pre>\r\n\r\n<p>to element ten ma teraz szerokość 102 piksele. Może to mieć\r\nwpływ na inne elementy znajdujące się na stronie!</p>\r\n\r\n<p>Znacznie lepiej jest zmodyfikować tło elementu:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#str {\r\n    margin     : 0px;\r\n    border     : 0px;\r\n    padding    : 10px;\r\n    width      : 80px;\r\n    background : red;\r\n}</pre>\r\n\r\n<p>gdyż taka zmiana nie wpływa na jego rozmiar.</p>\r\n\r\n<h3 id="R5">5. Pudełka ściśle przylegające</h3>\r\n\r\n<p>Do podzielenia obszaru strony na kilka mniejszych,\r\nściśle przylegających obszarów,\r\nnależy użyć pudełek, o marginesie, obramowaniu i wyrównaniu wynoszącym 0.\r\nNa przykład podział strony na dwie kolumny pionowe o szerokościach\r\n250 oraz 500 pikseli wykonamy\r\ntrzema sekcjami <span class="zmienna">div</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;strona&quot;&gt;\r\n  &lt;div id=&quot;lewa&quot;&gt;X&lt;/div&gt;\r\n  &lt;div id=&quot;prawa&quot;&gt;Y&lt;/div&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>Sekcja zewnętrzna (identyfikator <span class="zmienna">strona</span>)\r\nposiada szerokość 750 pikseli, nie posiada obramowania,\r\nzaś wyrównanie wynosi 0, dzięki czemu zawartość będzie się rozciągała do samej krawędzi obszaru.</p>\r\n\r\n<pre class="syntax-highlight:xml">#strona {\r\n    margin  : auto;\r\n    border  : none;\r\n    padding : 0px;\r\n    width   : 750px;\r\n}</pre>\r\n\r\n<p>Margines o wartości <span class="zmienna">auto</span> powoduje wyśrodkowanie elementu na stronie.</p>\r\n\r\n<p>Elementy lewy i prawy nie posiadają marginesu\r\nani obramowania,\r\ndzięki czemu przylegają do elementu nadrzędnego.\r\nNatomiast ich wyrównanie nie musi być równe zero:</p>\r\n\r\n<pre class="syntax-highlight:xml">#lewa {\r\n    margin  : 0px;\r\n    border  : none;\r\n    padding : 10px;\r\n    width   : 230px;\r\n    float   : left;\r\n}\r\n\r\n#prawa {\r\n    margin  : 0px;\r\n    border  : none;\r\n    padding : 20px;\r\n    width   : 460px;\r\n    float   : right;\r\n}</pre>\r\n\r\n<p>Szerokość (przeznaczona na zawartość, nie uwzględniająca marginesu) elementu nadrzędnego wynosi\r\n750 pikseli. Natomiast szerokość elementów lewego i prawego:</p>\r\n\r\n<pre class="syntax-highlight:xml">lewa   = 2 * 10 + 230 = 250\r\nprawa  = 2 * 20 + 460 = 500\r\ncałość = lewa + prawa = 250 + 500 = 750</pre>\r\n\r\n<p>Jeśli nieopatrznie zwiększymy szerokość któregokolwiek z elementów wewnętrznych\r\n(na przykład dodając mu obramowanie bez równoczesnego zmniejszenie\r\nszerokości przeznaczonej na zawartość),\r\nto układ zacznie się rozjeżdżać.</p>\r\n\r\n<p>W celu dodania jednopikselowego obramowania całości oraz\r\npionowej, jednopikselowej krawędzi oddzielającej sekcje lewą i prawą,\r\nnależy odpowiednio zmniejszyć niektóre wartości.\r\nZakładając, że celem nadrzędnym jest to, by cały układ zajmował &mdash;\r\npodobnie jak poprzednio &mdash; 750 pikseli musimy zmienić\r\nrozmiar przeznaczony na zawartość.</p>\r\n\r\n<p>Obramowanie zewnętrznego elementu <span class="zmienna">div</span>\r\n\r\nzmniejsza szerokość jego zawartości do 748 pikseli:</p>\r\n\r\n<pre class="syntax-highlight:xml">#strona {\r\n    margin  : auto;\r\n    border  : 1px solid blue;\r\n    padding : 0px;\r\n    width   : 748px;\r\n}</pre>\r\n\r\n\r\n<p>Na elementy lewy i prawy przeznaczamy tym razem 248 oraz 500 pikseli odpowiednio.</p>\r\n\r\n<p>Pionową kreskę pomiędzy elementami lewym i prawym dodajemy jako lewe obramowanie\r\nelementu o identyfikatorze <span class="zmienna">prawy</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">#lewy {\r\n    margin  : 0px;\r\n    border  : none;\r\n    padding : 10px;\r\n    width   : 228px;\r\n    float   : left;\r\n}\r\n\r\n#prawy {\r\n    margin      : 0px;\r\n    border      : none;\r\n    border-left : 1px solid blue;\r\n    padding     : 20px;\r\n    width       : 459px;\r\n    float       : right;\r\n}</pre>\r\n\r\n<p>Szerokości kolumn wynoszą teraz:</p>\r\n\r\n<pre class="syntax-highlight:xml">lewa   = 2 * 10 + 228     = 248\r\nprawa  = 1 + 2 * 20 + 459 = 500\r\ncałość = 2 + 248 + 500    = 750</pre>\r\n\r\n<p>Zwróćmy jeszcze uwagę na fakt, że kolejność kolumn lewej i prawej w kodzie <span class="jezyk">HTML</span>\r\n\r\nmożemy zmieniać. Nie ma to wpływu na wygląd witryny.\r\nKod strony może być zapisany jako:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;strona&quot;&gt;\r\n  &lt;div id=&quot;lewa&quot;&gt;X&lt;/div&gt;\r\n  &lt;div id=&quot;prawa&quot;&gt;Y&lt;/div&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>lub</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;strona&quot;&gt;\r\n  &lt;div id=&quot;prawa&quot;&gt;Y&lt;/div&gt;\r\n  &lt;div id=&quot;lewa&quot;&gt;X&lt;/div&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>Ma to znaczenie dla przeglądarek nie stosujących stylów.\r\nKolejność elementów na stronie ustalamy tak,\r\nbez stosowania stylów, pierwszym elementem było menu strony, a nie treść.</p>\r\n\r\n<h3 id="R6">6. Różnice w interpretacji CSS</h3>\r\n\r\n<p>Pomiędzy przeglądarkami istnieją różnice w interpretacji stylów.\r\nJednym z przykładów\r\nsą atrybuty z przedrostkiem <span class="zmienna">min-</span> lub <span class="zmienna">max-</span>.\r\nAtrybuty te nie są poprawnie interpretowane przez <span class="program">Internet Explorera</span>.\r\nDo walki z problemem niezgodności możemy przygotować witrynę, która\r\nprzesyła arkusze stylów przeznaczone dla konkretnej przeglądarki:</p>\r\n\r\n<pre class="syntax-highlight:xml">$ua = $_SERVER[&#39;HTTP_USER_AGENT&#39;]\r\nif (ereg(&#39;Firefox/[0-9]\\.[0-9]&#39;, $ua)) {\r\n    $style = &#39;firefox.css&#39;;\r\n} else {\r\n    $style = &#39;style.css&#39;;\r\n}</pre>\r\n\r\n\r\n<p>Również kod <span class="jezyk">HTML</span> możemy przygotowywać dla każdego klienta z osobna.</p>\r\n\r\n<p>Jest to jednak rozwiązanie wzbudzające znaczne kontrowersje: wszak po to\r\ntworzymy układ strony zgodnie ze standardami i w oparciu o sekcje i style,\r\nby jedna wersja witryny była przeznaczona dla wszystkich klientów.</p>\r\n\r\n<p>W tym konkretnym przypadku, a więc w odniesieniu do atrybutów\r\n<span class="zmienna">min-</span> i <span class="zmienna">max-</span>, lepsze rozwiązanie\r\nwykorzystuje drugi z błędów <span class="program">Internet Explorera</span>,\r\na mianowicie brak\r\ninterpretacji selektora &bdquo;dziecko&rdquo; (znak <span class="zmienna">&gt;</span>).</p>\r\n\r\n<p>Selektor &bdquo;dziecko&rdquo; dotyczy elementów bezpośrednio zawartych wewnątrz danego elementu.\r\nNa przykład w akapicie:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;p&gt;czarny, &lt;em&gt;czerwony&lt;/em&gt;, niebieski&lt;/p&gt;</pre>\r\n\r\n<p>element <span class="zmienna">em</span> jest bezpośrednio zawarty\r\nw elemencie <span class="zmienna">p</span>.\r\nDo modyfikacji elementów <span class="zmienna">em</span> zawartych bezpośrednio w\r\n<span class="zmienna">p</span> służy selektor:</p>\r\n\r\n<pre class="syntax-highlight:xml">p&gt;em {\r\n    ...\r\n}</pre>\r\n\r\n<p>Natomiast w przykładzie:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;menu&quot;&gt;\r\n    &lt;em&gt;black&lt;/em&gt;\r\n    &lt;p&gt;czarny, &lt;em&gt;czerwony&lt;/em&gt;, niebieski&lt;/p&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>możemy użyć selektora:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#menu&gt;p&gt;em {\r\n    ...\r\n}</pre>\r\n\r\n<p>Selektor ten odnosi się wyłącznie do elementu <span class="zmienna">em</span> o treści czerwony\r\n(pierwszy z elementów <span class="zmienna">em</span>, ten o treści black, nie zostanie zmodyfikowany).</p>\r\n\r\n<p>Jednakże <span class="program">Internet Explorer</span>,\r\njak już powiedzieliśmy, takich selektorów nie interpretuje.\r\nJeśli chcemy nadać minimalną wysokość elementowi o identyfikatorze\r\n\r\n<span class="zmienna">prawa</span> zawartemu w sekcji <span class="zmienna">strona</span>,\r\nwtedy najpierw podajemy błędne style:</p>\r\n\r\n<pre class="syntax-highlight:xml">#prawa {\r\n    height : 400px;\r\n}</pre>\r\n\r\n<p>po czym przeglądarkom interpretującym selektor &bdquo;dziecko&rdquo; oraz\r\natrybuty <span class="zmienna">min-</span> podajemy poprawne wartości:</p>\r\n\r\n<pre class="syntax-highlight:xml">body&gt;#strona&gt;#prawa {\r\n    height     : auto;\r\n    min-height : 400px;\r\n}</pre>\r\n\r\n<p>Powyższa technika polega na podaniu błędnych stylów, które są\r\nprzeznaczone dla <span class="program">IE</span>,\r\npo czym, stosując selektor &bdquo;dziecko&rdquo;\r\nniedostępny dla <span class="program">IE</span>,  podajemy pozostałym przeglądarkom\r\npoprawne style.</p>\r\n\r\n<p>W ten sposób, stosując wyłącznie <span class="jezyk">CSS</span> możemy\r\nw pewnym stopniu decydować o tym, dla której przeglądarki są przeznaczone jakie style.\r\nCiągle mamy do czynienia z techniką przygotowywania stylu dla konkretnej przeglądarki,\r\ntyle tylko, że selekcja stylów dla przeglądarki jest ukryta w <span class="jezyk">CSS</span>.\r\nOczywiście opieranie się na takich mechanizmach jest bardzo ryzykowne.\r\nMoże się okazać na przykład, że kolejne wersje <span class="program">Internet Explorera</span>\r\ninterpretują selektor dziecko w inny sposób, przez co układ witryny\r\nulegnie zmianie.</p>\r\n\r\n<h3 id="R7">7. Witryna dla przeglądarek nie interpretujących stylów</h3>\r\n\r\n<p>Starsze przeglądarki, na przykład <span class="program">Netscape</span> w wersji 4,\r\ninterpretują style dość wybiórczo, efektem czego, witryna może stać się zupełnie nieczytelna.\r\nTaka sytuacja jest oczywiście nie do zaakceptowania.\r\nDo rozwiązania problemu stosujemy &mdash; podobnie jak w przypadku\r\natrybutów <span class="zmienna">min-</span> oraz <span class="zmienna">max-</span> &mdash;\r\nwyłącznie <span class="jezyk">CSS</span>.\r\nInstrukcja <span class="zmienna">@import</span> występująca wewnątrz arkusza stylów\r\nimportuje style z podanego pliku <span class="jezyk">CSS</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">@import url(nowe-style.css);</pre>\r\n\r\n<p>Jest ona poprawnie interpretowana jedynie przez najnowsze wersje przeglądarek.\r\nJeśli zatem całe style witryny zapiszemy w pliku <span class="plik">nowe-style.css</span>\r\ni dołączymy je powyższą instrukcją, jedynie najnowsze przeglądarki będą stosowały style,\r\nwszystkie starsze natomiast wyświetlą surową, wprawdzie pozbawioną stylów,\r\nale za to czytelną witrynę.</p>\r\n\r\n<p>Dodatkowo, jak już powiedzieliśmy, należy zadbać o kolejność elementów\r\nna stronie wyświetlanej z pominięciem stylów.\r\nNajlepiej, jeśli na stronie najpierw pojawiają się menu, a dopiero potem zawartość.\r\nW tym celu należy ewentualnie zmodyfikować kolejność sekcji <span class="zmienna">div</span> w kodzie <span class="jezyk">HTML</span>,\r\npilnując, by sekcje zawierające menu pojawiały się w kodzie\r\nprzed sekcjami z treścią.</p>\r\n\r\n<h3 id="R8">8. Białe znaki</h3>\r\n\r\n<p>Ponieważ białe znaki zawarte w kodzie <span class="jezyk">HTML</span> mogą niekiedy zburzyć układ witryny,\r\nnależy je usunąć ze źródła strony.\r\nFaktyczne usunięcie spacji oraz znaków złamania wiersza\r\nspowoduje, że kod będzie zupełnie nieczytelny i trudny w edycji.\r\nDobrym sposobem rozwiązania tego problemu jest zastosowanie\r\nfunkcji <span class="zmienna">strip</span> szablonów <span class="program">Smarty</span>.</p>\r\n\r\n<p>Po umieszczeniu w szablonie głównym\r\nfunkcji <span class="zmienna">strip</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">{strip}\r\n&lt;!DOCTYPE ...&gt;\r\n&lt;html&gt;\r\n...\r\n&lt;/html&gt;\r\n{strip}</pre>\r\n\r\n<p>otrzymamy stronę WWW, która &mdash; po odwiedzeniu przeglądarką &mdash;\r\njest pozbawiona białych znaków.</p>\r\n\r\n<p>Pamiętajmy, że sklejenie następujących po sobie wierszy może niekiedy doprowadzić do\r\nsklejenia wyrazów. Na przykład całe akapity tekstu musimy zapisywać w pojedynczej linijce.\r\nJeśli w pliku stosującym funkcję <span class="zmienna">strip</span>\r\numieścimy tekst (rozkład na linie jest istotny):</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;p&gt;\r\nala\r\nma\r\nkota\r\n&lt;/p&gt;</pre>\r\n\r\n<p>to po przetworzeniu szablonu stosującego funkcję <span class="zmienna">strip</span> otrzymamy tekst:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;p&gt;alamakota&lt;/p&gt;</pre>\r\n\r\n<p>Poprawnie zapisany akapit powinien zawierać się w jednej linijce:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;p&gt;ala ma kota&lt;/p&gt;</pre>\r\n\r\n<h3 id="R9">9. Selektor potomek</h3>\r\n\r\n<p>Z racji na fakt, że witryna w całości zrealizowana w oparciu o style będzie\r\nzawierała dziesiątki różnych elementów, warto stosować\r\nselektory typu <span class="tytul">&bdquo;potomek&rdquo;</span>.\r\nSelektory takie składają się z kilku wymienionych po sobie elementów ewentualnie oznaczonych\r\nidentyfikatorami i klasami.</p>\r\n\r\n<p>Jeśli na stronie występuje sekcja <span class="zmienna">div</span>\r\no identyfikatorze <span class="zmienna">pierwsza</span>,\r\nktóra zawiera akapit:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;pierwsza&quot;&gt;\r\n&lt;p&gt;Pierwsza...&lt;/p&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n<p>to style akapitu możemy modyfikować selektorem:</p>\r\n\r\n<pre class="syntax-highlight:xml">div#pierwsza p {\r\n    ...\r\n}</pre>\r\n\r\n<p>Dzięki temu w kodzie <span class="jezyk">HTML</span> nie musimy stosować identyfikatorów\r\ni klas przy każdym niemal znaczniku.\r\nAkapit w powyższym przykładzie jest otoczony gołymi\r\nznacznikami\r\n<span class="zmienna">&lt;p&gt;</span>\r\noraz\r\n<span class="zmienna">&lt;/p&gt;</span>\r\npozbawionymi identyfikatora i klasy.\r\nWystarczy, że zwykły akapit <span class="zmienna">p</span>\r\numieścimy wewnątrz unikalnie nazwanej sekcji\r\n<span class="zmienna">div</span>, a dostępnym staje się\r\nselektor typu &bdquo;potomek&rdquo;.</p>\r\n\r\n<h3 id="R10">10. Menu wykonane listami wypunktowanymi</h3>\r\n\r\n<p>Menu witryny wykonanej w oparciu o style tworzymy stosując\r\nlisty wypunktowane.\r\nMenu takie, zarówno poziome jak i pionowe, zostało opisane w artykule\r\nŁukasza Lacha p.t.\r\n<span class="tytul">&bdquo;CSS w praktyce: lista nawigacyjna&rdquo;</span>.</p>\r\n\r\n<p>Zwróćmy uwagę, by tworzone menu miało dokładnie zdefiniowaną szerokość.\r\nW przypadku menu pionowego nie stwarza to problemów (posługujemy się atrybutami\r\n<span class="zmienna">margin</span>,\r\n<span class="zmienna">border</span>,\r\n\r\n<span class="zmienna">padding</span> oraz\r\n<span class="zmienna">width</span> w odniesieniu do całej listy oraz jej elementów).</p>\r\n\r\n<p>Natomiast w przypadku menu poziomego szerokość całego menu jest zależna od szerokości poszczególnych\r\nopcji, a te z kolei zależą od stosowanej czcionki.\r\nJeśli menu ma wypełniać podany obszar w całości\r\n(w przykładzie jest to 600 pikseli), wtedy należy odpowiednio dobrać wartości atrybutów\r\n<span class="zmienna">padding</span> dla wszystkich elementów menu oraz dodatkowo, indywidualnie zmodyfikować\r\n<span class="zmienna">padding</span> pierwszego elementu.\r\nOczywiście rozwiązanie takie jest bardzo sztywne i rozjedzie się w przypadku\r\nna przykład zastąpienia czcionki przez przeglądarkę.</p>\r\n\r\n<p>Dosunięcie opcji do siebie wykonujemy usuwając\r\n&mdash; za pomocą funkcji <span class="zmienna">strip</span> &mdash; znaki złamania\r\nwiersza oddzielające poszczególne opcje.</p>\r\n\r\n<h3 id="R11">11. Sprawdzanie poprawności dokumentu</h3>\r\n\r\n\r\n<p>Do badania poprawności dokumentu możemy wykorzystać\r\nwalidatory dostępne na witrynie W3C.\r\nWalidator kodu <span class="jezyk">HTML</span> jest dostępny pod adresem\r\n\r\n<a href="http://validator.w3.org">http://validator.w3.org</a>,\r\nzaś walidator <span class="jezyk">CSS</span>\r\n<a href="http://jigsaw.w3.org/css-validator/">http://jigsaw.w3.org/css-validator/</a>.</p>\r\n\r\n<p>Jeśli dokument publikujemy w Internecie, to wystarczy\r\nw nim umieścić hiperłącza:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;a href=&quot;http://validator.w3.org/check?uri=referer&quot;&quot;&gt;HTML&lt;/a&gt;\r\n&lt;a href=&quot;http://jigsaw.w3.org/css-validator/check/referer&quot;&gt;CSS&lt;/a&gt;</pre>\r\n\r\n<p>Kliknięcie pierwszego z hiperłączy spowoduje sprawdzenie kodu <span class="jezyk">HTML</span> dokumentu,\r\nzaś drugiego &mdash; sprawdzenie kodu <span class="jezyk">CSS</span>.</p>\r\n\r\n<p>Dodatkowo pod adresem <a href="http://www.contentquality.com">http://www.contentquality.com</a> znajdziemy\r\nwalidator sprawdzający kod witryny pod względem przestrzegania zaleceń związanych z dostępnością.\r\nHiperłącze:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;a href=&quot;http://www.contentquality.com/mynewtester/cynthia.exe?Url1=http://adres.w.sieci&quot;&gt;508&lt;/a&gt;</pre>\r\n\r\n<p>ułatwi korzystanie z serwisu.</p>\r\n\r\n<p>Ewentualnie, korzystając z <span class="program">Firefoxa</span> uzbrojonego w\r\n<span class="program">Web Developer Toolbar</span>,\r\nwszystkie wymienione walidatory są dostępne w\r\nza pośrednictwem opcji <span class="opcja">Tools</span>,\r\nna przykład <span class="opcja">Tools &rarr; Validate HTML</span>.\r\nW kodzie <span class="jezyk">HTML</span> nie umieszczamy\r\nżadnych hiperłączy, a i tak walidacja witryny jest wygodna.</p>\r\n\r\n<h3 id="R12">12. Struktura dokumentu</h3>\r\n\r\n<p>Badając kod <span class="jezyk">HTML</span> walidatorem dostępnym na stronach W3C warto zwrócić uwagę na opcję\r\n<span class="opcja">Outline</span>. Opcja ta podaje szkic badanej strony uzyskany na podstawie\r\nnagłówków od <span class="zmienna">h1</span> do <span class="zmienna">h6</span>.\r\nPrzygotowując kod strony należy zadbać o stosowanie elementów nagłówkowych do\r\nokreślenia struktury dokumentu.</p>\r\n\r\n<h3 id="R13">13. Podsumowanie</h3>\r\n\r\n<p>Przystępując do pracy nad układem witryny należy od samego początku\r\nzadbać o ustalenie celu oraz o organizację pracy.\r\nPierwsza decyzja dotyczy generacji przeglądarek,\r\ndla jakich będzie przeznaczona witryna.\r\nNajłatwiejszym wyjściem jest tworzenie\r\nwitryny przeznaczonej dla najnowszych przeglądarek, która w starszych przeglądarkach\r\njest po prostu czytelna.\r\nEfekt ten osiągniemy importując style instrukcją <span class="zmienna">@import</span>.</p>\r\n\r\n<p>Ponieważ nawet najnowsze przeglądarki nie są w stu procentach zgodne\r\npod względem interpretacji stylów, zatem pracując nad układem witryny\r\nna bieżąco badamy jej wygląd w czterech najnowszych przeglądarkach.\r\nW przypadku kłopotów, modyfikujemy tło elementów powodujących problemy i badamy ich\r\nrozmiar oraz położenie. Jest to technika pracy, która w rozsądnym tempie\r\nprowadzi wykonania zamierzonego układu.</p>\r\n\r\n\r\n\r\n<div>\r\n<table>\r\n<thead>\r\n<tr><th>Atrybut</th><th>Znaczenie</th><th>Uwagi</th></tr>\r\n\r\n</thead><tfoot>\r\n<tr><th>Atrybut</th><th>Znaczenie</th><th>Uwagi</th></tr>\r\n\r\n</tfoot><tbody>\r\n\r\n<tr><td><span class="zmienna">margin</span></td>\r\n\r\n<td>Wielkość marginesu</td>\r\n\r\n<td>Może być stosowany w odniesieniu do krawędzi lewej, prawej, górnej i dolnej.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">border</span></td>\r\n\r\n<td>Obramowanie</td>\r\n\r\n<td>Może być stosowany w odniesieniu do krawędzi lewej, prawej, górnej i dolnej.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">padding</span></td>\r\n\r\n<td>Otaczanie</td>\r\n\r\n<td>Może być stosowany w odniesieniu do krawędzi lewej, prawej, górnej i dolnej.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">width</span></td>\r\n\r\n<td>Szerokość elementu</td>\r\n\r\n<td>Podana liczba dotyczy wyłącznie zawartości elementu. Nie uwzględnia marginesów, obramowania i otaczania.</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">min-width</span></td>\r\n\r\n<td>Minimalna szerokość</td>\r\n\r\n<td>Nie interpretowany przez IE.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">max-width</span></td>\r\n\r\n<td>Maksymalna szerokość</td>\r\n\r\n<td>Nie interpretowany przez IE.</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">height</span></td>\r\n\r\n<td>Wysokość</td>\r\n\r\n<td>Inaczej interpretowana przez IE niż przez inne przeglądarki.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">min-height</span></td>\r\n\r\n<td>Minimalna wysokość</td>\r\n\r\n<td>Nie interpretowany przez IE.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">max-height</span></td>\r\n\r\n<td>Maksymalna wysokość</td>\r\n\r\n<td>Nie interpretowany przez IE.</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">vertical-align</span></td>\r\n\r\n<td>Wyrównanie pionowe zawartości</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">z-index</span></td>\r\n\r\n<td>Kolejność warstw</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">visibility</span></td>\r\n\r\n<td>Widoczność</td>\r\n\r\n<td>Element generuje pudełko, ale pudełko nie jest widoczne.</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">display</span></td>\r\n\r\n<td>Widoczność i sposób wyświetlania elementu.</td>\r\n\r\n<td>Ustalamy typ elementu (blokowy lub tekstowy) oraz ewentualnie jego widoczność. Element niewyświetlany nie generuje pudełka.</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">top</span></td>\r\n\r\n<td>Położenie elementu: krawędź górna</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">right</span></td>\r\n\r\n<td>Położenie elementu: krawędź prawa</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">bottom</span></td>\r\n\r\n<td>Położenie elementu: krawędź dolna</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">left</span></td>\r\n\r\n<td>Położenie elementu: krawędź lewa</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">position</span></td>\r\n\r\n<td>Sposób wyznaczania położenia elementu</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">float</span></td>\r\n\r\n<td>Przesunięcie do lewej lub prawej krawędzi.</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">clear</span></td>\r\n\r\n<td>Umieszczenie pod elementami przesuniętymi do tej samej krawędzi</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td class="komorkaseparator" colspan="3"></td></tr>\r\n\r\n<tr><td><span class="zmienna">overflow</span></td>\r\n\r\n<td>Przycinanie zawartości do nadrzędnego pudełka</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n\r\n<tr><td><span class="zmienna">clip</span></td>\r\n\r\n<td>Prostokąt, do jakiego zawartość jest przycinana</td>\r\n\r\n<td>&nbsp;</td>\r\n\r\n</tr>\r\n</tbody>\r\n</table>\r\n\r\n<p class="podpis">\r\nTabela 1.\r\nAtrybuty CSS dotyczące pudełek</p>\r\n</div>', 'projekt-ukladu-strony-w-oparciu-o-elementy-div');
INSERT INTO `artykul` (`artykul_id`, `tytul`, `lid`, `spistresci`, `tresc`, `slug`) VALUES
(12, 'Elementy div i style CSS w praktyce', 'Artykuł omawia kulisy powstawania witryny internetowej\r\nwyłącznie w oparciu o elementy <span class="zmienna">div</span>\r\noraz kaskadowe arkusze stylów.\r\nJako przykład służy witryna <a href="http://gwz.gajdaw.pl">http://gwz.gajdaw.pl</a>\r\nstanowiąca suplement\r\ndo książki <span class="tytul">&bdquo;Gimp w zastosowaniach&rdquo;</span>.', '\r\n<div class="toc">\r\n<h3>Spis treści</h3>\r\n<ol>\r\n<li><a href="#R1">1. Zanim przystąpimy do kodowania</a></li>\r\n<li><a href="#R2">2. Krok 1: główny pojemnik</a></li>\r\n<li><a href="#R3">3. Krok 2: cztery główne obszary witryny</a></li>\r\n<li><a href="#R4">4. Krok 3: podział kolumn lewej i prawej</a></li>\r\n<li><a href="#R5">5. Krok 4: menu pionowe i poziome </a></li>\r\n<li><a href="#R6">6. Krok 5: nagłówek, stopka i treść strony</a></li>\r\n<li><a href="#R7">7. Uwagi końcowe</a></li>\r\n</ol>\r\n</div>\r\n\r\n', '<h3 id="R1">1. Zanim przystąpimy do kodowania</h3>\r\n\r\n<p>Przed rozpoczęciem pisania kodu <span class="jezyk">HTML</span> i <span class="jezyk">CSS</span> witryny należy\r\nustalić główne założenia dotyczące serwisu.\r\nZagadnieniami wymagającymi zdefiniowania są:\r\ndocelowa grupa przeglądarek oraz szerokość układu witryny.</p>\r\n\r\n<p>Przeglądarki internetowe dzielimy na trzy główne rodziny:</p>\r\n\r\n<ul>\r\n<li>pierwsza generacja: przeglądarki nie wspierające <span class="jezyk">CSS</span>,</li>\r\n<li>druga generacja: przeglądarki częściowo wspierające <span class="jezyk">CSS</span>,</li>\r\n<li>trzecia generacja: przeglądarki z pełnym wsparciem <span class="jezyk">CSS</span>.</li>\r\n</ul>\r\n\r\n<p>Do pierwszej rodziny zaliczamy między innymi\r\nprzeglądarki tekstowe oraz archaiczne wersje współczesnego oprogramowania,\r\nna przykład <span class="program">Inernet Explorer</span> 4.0\r\nczy <span class="program">Netscape</span> 4.\r\nOprogramowanie to interpretuje wybiórczo kilka podstawowych atrybutów <span class="jezyk">CSS</span>.</p>\r\n\r\n<p>Przeglądarki drugiej generacji, należą do nich na przykład <span class="program">Netscape</span> 6\r\noraz <span class="program">Internet Explorer</span> 5,\r\ninterpretują dużą część <span class="jezyk">CSS</span>, jednak robią to w sposób na tyle niezgodny i niespójny,\r\nże przygotowywanie układu witryny w oparciu o style jest zadaniem trudnym.</p>\r\n\r\n<p>Wreszcie najnowsza generacja przeglądarek,\r\n<span class="program">Internet Explorer</span> 6,\r\n<span class="program">Opera</span> 7,\r\n<span class="program">Firefox</span> oraz\r\n<span class="program">Netscape</span> 8,\r\nzawiera pełne wsparcie dla <span class="jezyk">CSS</span> różniąc się jedynie w szczegółach.</p>\r\n\r\n<p>Witryna <span class="tytul">&bdquo;Gimp w zastosowaniach&rdquo;</span> jest przygotowana\r\nz myślą o najnowszych wersjach przeglądarek, które posiadają pełne wsparcie dla <span class="jezyk">CSS</span>.\r\nPozwala to na korzystanie ze wszystkich atrybutów <span class="jezyk">CSS</span> dotyczących warstw\r\noraz pudełek.</p>\r\n\r\n<p>Drugim ważnym zagadnieniem jest szerokość układu witryny.\r\nPowszechnie stosowanymi rozwiązaniami są:</p>\r\n\r\n<ul>\r\n<li>układ o stałej szerokości, niezależnej od szerokości okna przeglądarki,</li>\r\n<li>układ o szerokości zależnej od szerokości okna przeglądarki,</li>\r\n<li>układ o szerokości zależnej od szerokości okna przeglądarki posiadający\r\nminimalną szerokość.</li>\r\n</ul>\r\n\r\n<p>Witryna <a href="http://gwz.gajdaw.pl">http://gwz.gajdaw.pl</a> posiada stałą szerokość wynoszącą 760 pikseli.\r\nSzerokość ta pozwala na pełne wyświetlenie witryny na monitorach o rozdzielczości\r\nod 800&times;600 wzwyż.\r\nOwe 40 pikseli marginesu jest zarezerwowane na pionowy pasek przewijania, który jest\r\nwyświetlany na podstronach zawierających więcej tekstu.\r\nW ten sposób na witrynie nigdy nie pojawia się poziomy pasek przewijania\r\nuznawany za błąd w układzie witryny.</p>\r\n\r\n<h3 id="R2">2. Krok 1: główny pojemnik</h3>\r\n\r\n<p>W pierwszym kroku w kodzie <span class="jezyk">HTML</span> umieszczamy\r\nsekcję <span class="zmienna">div</span>, która będzie pojemnikiem na całą zawartość strony.\r\nSekcji tej nadajemy style:</p>\r\n\r\n<pre class="syntax-highlight:xml">#strona {\r\n    margin     : auto;\r\n    border     : 1px solid black;\r\n    padding    : 0px;\r\n    width      : 758px;\r\n}</pre>\r\n\r\n<p>Dzięki czemu będzie ona wyśrodkowana na stronie (właściwość <span class="zmienna">margin</span>)\r\noraz będzie posiadała zadaną szerokość.\r\nSzerokość całego elementu <span class="zmienna">div</span> wynosi 760 pikseli, z czego\r\n758 jest przeznaczone na zawartość, a 2 na obramowanie.</p>\r\n\r\n<p>Cała zawartość witryny będzie umieszczona wewnątrz głównego pojemnika\r\n<span class="zmienna">div</span> o identyfikatorze <span class="zmienna">#strona</span>.</p>\r\n\r\n<p>Style zapisujemy w pliku <span class="plik">style.css</span>\r\ni dołączamy do kodu strony w następujący sposób:</p>\r\n\r\n<pre class="syntax-highlight:xml">@import url(style.css);</pre>\r\n\r\n<p>dzięki czemu staną się one niedostępne dla przeglądarek pierwszej generacji.\r\nW ten sposób stare przeglądarki (pierwszej generacji) wyświetlą wprawdzie\r\nnieatrakcyjną, ale za to czytelną witrynę.</p>\r\n\r\n<p>Pierwsza z ilustracji przedstawia wygląd witryny\r\nzawierającej jedynie głowne pudełko\r\n<span class="zmienna">div#strona</span>\r\npo modyfikacji koloru tła.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/12-01.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 1.\r\nGłówny pojemnik</p>\r\n</div>\r\n\r\n\r\n\r\n<h3 id="R3">3. Krok 2: cztery główne obszary witryny</h3>\r\n\r\n<p>Pojemnik główny witryny dzielimy następnie na\r\ncztery podobszary: nagłówek, stopkę, lewą kolumnę oraz prawą kolumnę.\r\nPodział ten realizujemy umieszczając w głównym pojemniku\r\ncztery sekcje <span class="zmienna">div</span>,\r\ntak jak to przedstawiono na listingu 1.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;strona&quot;&gt;\r\n\r\n    &lt;div id=&quot;naglowek&quot;&gt;\r\n    &lt;/div&gt;\r\n\r\n    &lt;div id=&quot;kolumnaLewa&quot;&gt;\r\n    &lt;/div&gt;\r\n\r\n    &lt;div id=&quot;kolumnaPrawa&quot;&gt;\r\n    &lt;/div&gt;\r\n\r\n    &lt;div id=&quot;stopka&quot;&gt;\r\n    &lt;/div&gt;\r\n\r\n&lt;/div&gt;</pre>\r\n<p class="podpis">\r\nListing 1.\r\nGłówny kontener po podzieleniu na cztery obszary.</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<p>Szerokości nagłówka i stopki odpowiadają szerokości głównego pojemnika\r\ni wynoszą 758 pikseli.\r\nNatomiast szerokości kolumn lewej i prawej mają tak ustalone wartości, by\r\nłącznie tworzyły blok o szerokości 758 pikseli.\r\nKolumna lewa nie posiada obramowania, a jej szerokość wynosi 180 pikseli.\r\nNatomiast kolumna prawa posiada lewą jednopikselową krawędź, więc\r\njej szerokość musi wynosić 577 pikseli.\r\nTak by w sumie:</p>\r\n\r\n<pre class="syntax-highlight:xml">180 + 1 + 577 = 758</pre>\r\n\r\n<p>Elementy <span class="zmienna">div</span> zawarte w głównym\r\nkontenerze przylegają ściśle do siebie nawzajem i\r\ndo brzegów głownego pojemnika.\r\nEfekt ten osiągniemy za pomocą atrybutów <span class="zmienna">margin</span>,\r\n<span class="zmienna">padding</span> oraz <span class="zmienna">border</span> nadając im wartości:</p>\r\n\r\n<pre class="syntax-highlight:xml">margin  : 0px;\r\nborder  : none;\r\npadding : 0px;</pre>\r\n\r\n<p>Szerokości elementów ustalamy oczywiście atrybutem <span class="zmienna">width</span>.</p>\r\n\r\n<p>Kolumny lewą i prawą umieszczamy z lewej i z prawej strony za\r\npomocą atrybutów <span class="zmienna">float</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">float : left;\r\nfloat : right;</pre>\r\n\r\n<p>Natomiast stopkę przesuwamy pod spód kolumn lewej i prawej\r\natrybutem <span class="zmienna">clear</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">clear : both;</pre>\r\n\r\n<p>Otrzymany układ, z zaznaczeniem poszczególnych fragmentów i ich szerokości jest\r\nprzedstawiony na ilustracji 2.\r\nNa tym etapie pracy warto sprawdzić, czy otrzymana witryna\r\nwygląda zgodnie z oczekiwaniami we wszystkich przeglądarkach,\r\nna jakie jest opracowywana.\r\nW naszym przypadku są to cztery przeglądarki:\r\n<span class="zmienna">Internet Explorer 6</span>,\r\n<span class="zmienna">Opara 7</span>,\r\n\r\n<span class="zmienna">FireFox</span> oraz\r\n<span class="zmienna">Netscape 8</span>.\r\nPo stwierdzeniu, że witryna wygląda dobrze\r\nnależy jeszcze dokonać sprawdzenia faktycznych rozmiarów sekcji <span class="zmienna">div</span>.\r\nW tym celu modyfikujemy kolor tła wszystkich sekcji <span class="zmienna">div</span>,\r\na następnie dokonujemy pomiaru na przykład za pomocą programu <span class="program">Miarka</span>.</p>\r\n\r\n<p>Jakiekolwiek niedociągnięcia zbagatelizowane na tym poziomie\r\n(w szczególności choćby jednopikselowa różnica szerokości\r\nktórejkolwiek z sekcji <span class="zmienna">div</span>)\r\nbędą powodowały zamieszanie w kolejnych etapach pracy.\r\nZ tym, że im później, tym trudniej będzie odnaleźć błąd\r\nw kodzie <span class="jezyk">HTML</span> czy <span class="jezyk">CSS</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/12-02.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 2.\r\nNagłówek, stopka, lewa i prawa kolumna</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R4">4. Krok 3: podział kolumn lewej i prawej</h3>\r\n\r\n<p>Następnie kolumny lewą i prawą dzielimy na mniejsze obszary.\r\nTym razem podział jest poziomy.</p>\r\n\r\n<p>W kolumnie lewej umieszczamy dwie sekcje <span class="zmienna">div</span>: jedną przeznaczoną na ilustrację,\r\ndrugą &mdash; na menu pionowe.\r\nSekcje te otrzymają identyfikatory <span class="zmienna">obrazOkladka</span>\r\noraz <span class="zmienna">menuPion</span>.\r\nObie one mają szerokość 180 pikseli i ściśle przylegają do brzegów\r\nsekcji nadrzędnej (czyli <span class="zmienna">div#kolumnaLewa</span>).</p>\r\n\r\n<p>Podobnie, w kolumnie prawej umieszczamy dwie sekcje <span class="zmienna">div</span>.\r\nPierwsza z nich, <span class="zmienna">div#menuPoziome</span>, jest przeznaczona na menu,\r\nzaś druga, <span class="zmienna">div#tresc</span> &mdash; na zawartość strony.\r\nSekcje te przylegają ściśle do sekcji nadrzędnej\r\n(czyli <span class="zmienna">div#kolumnaPrawa</span>)\r\ni obie mają szerokość 577 pikseli.</p>\r\n\r\n<p>Otrzymamy kod <span class="jezyk">HTML</span> zawiera wszystkie elementy <span class="zmienna">div</span>, jakie będą stanowiły\r\nukład witryny. Kod ten jest zawarty na listingu 2.</p>\r\n\r\n\r\n\r\n<div class="listing">\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;strona&quot;&gt;\r\n\r\n    &lt;div id=&quot;naglowek&quot;&gt;\r\n\r\n    &lt;/div&gt;\r\n\r\n    &lt;div id=&quot;kolumnaLewa&quot;&gt;\r\n\r\n        &lt;div id=&quot;obrazOkladka&quot;&gt;\r\n        &lt;/div&gt;\r\n\r\n        &lt;div id=&quot;menuPion&quot;&gt;\r\n        &lt;/div&gt;\r\n\r\n    &lt;/div&gt;\r\n\r\n    &lt;div id=&quot;kolumnaPrawa&quot;&gt;\r\n\r\n        &lt;div id=&quot;menuPoziome&quot;&gt;\r\n        &lt;/div&gt;\r\n\r\n        &lt;div id=&quot;tresc&quot;&gt;\r\n        &lt;/div&gt;\r\n\r\n    &lt;/div&gt;\r\n\r\n    &lt;div id=&quot;stopka&quot;&gt;\r\n    &lt;/div&gt;\r\n\r\n&lt;/div&gt;</pre>\r\n<p class="podpis">\r\nListing 2.\r\nPodział kolumn lewej i prawej na podobszary.</p>\r\n</div>\r\n\r\n\r\n\r\n<p>Ilustracja 3 natomiast przedstawia wygląd otrzymanej witryny z zaznaczeniem poszczególnych\r\njej obszarów.\r\nPonownie dokonujemy sprawdzenia wyglądu witryny oraz rozmiaru poszczególnych sekcji.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/12-03.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 3.\r\nPodział kolumny lewej i prawej</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R5">5. Krok 4: menu pionowe i poziome </h3>\r\n\r\n<p>Kolejnym etapem tworzenia witryny jest przygotowanie menu poziomego i pionowego\r\noraz ilustracji w lewym górnym rogu witryny.\r\nIlustracja jest wstawiona zwykłym elementem <span class="zmienna">img</span>, zaś\r\nmenu tworzymy w oparciu o listy wypunktowane <span class="zmienna">ul</span>\r\ni odpowiednie arkusze stylów.\r\nNiezmiernie ważne jest, by otrzymane menu miało odpowiednią szerokość.\r\nMenu pionowe umieszczone w lewej kolumnie musi mieć szerokość 180 pikseli,\r\nnatomiast menu poziome, umieszczone w kolumnie prawej\r\nma szerokość 577 pikseli.</p>\r\n\r\n<p>Najpierw przygotowujemy menu pionowe, a następnie menu poziome.\r\nOpracowując menu poziome natrafimy na pewien problem.</p>\r\n\r\n<p>Wykonanie menu poziomego wymaga\r\nusunięcia białych znaków (w tym znaków złamania wiersza)\r\npomiędzy elementami listy <span class="zmienna">ul</span>.\r\nOczywiście możemy usunąć białe znaki z kodu <span class="jezyk">HTML</span>,\r\njednak jest to bardzo niewygodne, gdyż utrudnia dalszą edycję strony.\r\nProblem ten rozwiążemy stosując szablony <span class="program">Smarty</span>,\r\nw szczególności funkcję <span class="zmienna">{strip}</span>.\r\nKod menu poziomego umieszczamy w szablonie, który w\r\ncałości jest objęty funkcją <span class="zmienna">{strip}</span>.\r\nNa początku pliku umieszczamy znacznik <span class="program">Smarty</span>\r\n\r\n<span class="zmienna">{strip}</span>,\r\na na końcu &mdash; <span class="zmienna">{/strip}</span>.\r\nW ten sposób otrzymamy witrynę,\r\nktóra w trybie edycji\r\nzawiera białe znaki (podział na wiersze i wcięcia\r\nułatwiające pracę z kodem <span class="jezyk">HTML</span>).\r\nNatomiast po przesłaniu do przeglądarki,\r\nta sama witryna jest już pozbawiona białych znaków.</p>\r\n\r\n<p>Dla ułatwienia, oba menu przygotowujemy na osobnej pustej stronie,\r\nzawierającej ewentualnie jedną sekcję <span class="zmienna">div</span>.\r\nGdy menu jest gotowe i ma odpowiednią szerokość (wygląd i rozmiar sprawdzamy we\r\nwszystkich przeglądarkach!), wklejamy je w stronę z poprzedniego kroku,\r\npo czym dokonujemy sprawdzenia otrzymanej witryny.</p>\r\n\r\n<p>Strona otrzymana po dodaniu menu poziomego, menu pionowego i obrazka\r\njest widoczna na rysunku 4.\r\nOd tego kroku tworzona witryna będzie\r\njuż stosowała szablony <span class="program">Smarty</span>.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/12-04.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 4.\r\nStrona po dodaniu menu poziomego i pionowego</p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R6">6. Krok 5: nagłówek, stopka i treść strony</h3>\r\n\r\n<p>Kończąc pracę nad witryną, dodajemy treść nagłówka oraz stopkę strony.\r\nElementy te wymagają jedynie stylów modyfikujących\r\natrybuty czcionki. Ich rozmiar i położenie zostały już ustalone.\r\nW stopce witryny możemy umieścić hiperłącza do adresów\r\n<span class="zmienna">http://validator.w3.org/check?uri=referer</span>\r\noraz\r\n<span class="zmienna">http://jigsaw.w3.org/css-validator/check/referer</span>.\r\nOdnośniki takie umożliwią szybkie sprawdzenie poprawności kodu\r\n<span class="jezyk">HTML</span> oraz <span class="jezyk">CSS</span> walidatorami W3C (oczywiście strona musi być uprzednio\r\nopublikowana w Internecie).</p>\r\n\r\n<p>W miejscu przeznaczonym na treść witryny umieszczamy\r\nkilka akapitów tekstu <em>Lorem ipsum</em>.\r\nDo tego stosujemy funkcję <span class="zmienna">{include}</span>\r\nszablonów <span class="program">Smarty</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">{include file=&quot;zawartosc.tpl&quot;}</pre>\r\n\r\n<p>Dzięki temu umieszczenie odpowiedniej zawartości na stronie\r\nbędzie się odbywało w pliku <span class="plik">zawartosc.tpl</span>, czyli bez\r\njakichkolwiek modyfikacji układu witryny.\r\nOtrzymana witryna jest przedstawiona na rysunku 5.</p>\r\n\r\n\r\n\r\n<div class="ramka">\r\n\r\n<p><em>Lorem ipsum</em> to początkowe dwa wyrazy rozprawy napisanej w\r\nstarożytności przez Cycero.\r\nRozprawa ta jest od ponad 500 lat stosowana przez drukarzy do\r\nsprawdzania krojów pism i układu graficznego drukowanych publikacji.\r\nPowodem tego jest fakt, że oglądanie tekstu w nieznanym języku\r\npozwala się skupić na jego wizualnych aspektach.\r\nTekst w znanym języku podświadomie zaczynamy czytać, co odrywa uwagę od\r\njego graficznych cech.</p>\r\n\r\n<p>W środowisko twórców stron internetowych tekst <em>Lorem ipsum</em>\r\n\r\njest powszechnie stosowany jako wypełniacz szkieletów stron.</p>\r\n\r\n<p>Więcej informacji oraz pełny tekst <em>Lorem ipsum</em>\r\nznajdziemy\r\nna stronach Wikipedii\r\n<a href="http://pl.wikipedia.org/wiki/lorem_ipsum">http://pl.wikipedia.org/wiki/Lorem_ipsum</a>\r\noraz pod adresami\r\n<a href="http://www.lipsum.com">http://www.lipsum.com</a>\r\ni\r\n<a href="http://www.loremipsum.net">http://www.loremipsum.net</a>.</p>\r\n\r\n</div>\r\n\r\n\r\n\r\n<p>W ten sposób otrzymamy witrynę, w której układ strony jest\r\noddzielony fizycznie od treści.\r\nNależy odpowiednio zmodyfikować adresy URL zawarte w\r\nznacznikach <span class="zmienna">&lt;a href=&quot;&quot;&gt;</span> menu\r\npoziomego i pionowego oraz\r\nzorganizować &bdquo;wlewanie&rdquo; zawartości witryny\r\nw szablonie <span class="plik">zawartosc.tpl</span>.</p>\r\n\r\n<p>Oczywiście treść zawarta w sekcji\r\n<span class="zmienna">div#tresc</span> nie może nigdy przekroczyć maksymalnej dopuszczalnej szerokości,\r\nczyli 577 pikseli.\r\nJeśli tak się stanie, układ witryny będzie się rozjeżdżał.\r\nDo ustalenia stylów elementów zawartych w sekcji <span class="zmienna">div#tresc</span> stosujemy selektory\r\ntypu potomek. Na przykład akapity zawarte w treści formatujemy\r\numieszczając w pliku stylów wpisy:</p>\r\n\r\n<pre class="syntax-highlight:xml">#tresc p {\r\n    ...\r\n}</pre>\r\n\r\n<p>Stosowanie selektorów typu potomek z jednej strony nie będzie powodowało żadnych zmian\r\nw formatowaniu elementów odpowiedzialnych za układ witryny,\r\na z drugiej nie będzie wymagało umieszczania w kodzie <span class="jezyk">HTML</span>\r\n\r\nwszechobecnych identyfikatorów.\r\nPowyższy selektor <span class="zmienna">#tresc p</span> dotyczy jedynie elementów\r\n<span class="zmienna">p</span> zawartych wewnątrz\r\nsekcji <span class="zmienna">div</span> o identyfikatorze <span class="zmienna">tresc</span>:</p>\r\n\r\n<pre class="syntax-highlight:xml">&lt;div id=&quot;tresc&quot;&gt;\r\n    &lt;p&gt;Lorem ipsum...&lt;/p&gt;\r\n&lt;/div&gt;</pre>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/12-05.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 5.\r\nSzablon strony wypełniony tekstem <em>Lorem ipsum</em></p>\r\n</div>\r\n\r\n\r\n\r\n\r\n<h3 id="R7">7. Uwagi końcowe</h3>\r\n\r\n<p>Gotowa witryna jest przedstawiona na rysunku 6.\r\nOpracowując kod witryny warto od początku dbać o jego przejrzystość.\r\nStyle dotyczące poszczególnych\r\nsekcji <span class="zmienna">div</span> komentujemy i umieszczamy w\r\nkolejności ułatwiającej późniejszą edycję.\r\nNa przykład:</p>\r\n\r\n<ul>\r\n\r\n<li>style ogólne,</li>\r\n<li>style dotyczące układu (tj. sekcji <span class="zmienna">div</span> z listingu 2),</li>\r\n<li>poszczególne fragmenty układu (np. menu poziome, menu pionowe),</li>\r\n<li>oraz pozostałe. </li>\r\n</ul>\r\n\r\n<p>Porządkując style każdego z selektorów <span class="jezyk">CSS</span> warto stosować\r\nraz zdefiniowaną kolejność atrybutów.\r\nMożemy na przykład (taka kolejność jest stosowana w przykładach)\r\nna początek przenieść wpisy dotyczące pudełka\r\ni nadać im kolejność:\r\n\r\n<span class="zmienna">margin</span>,\r\n<span class="zmienna">border</span>,\r\n<span class="zmienna">padding</span>,\r\n<span class="zmienna">width</span>,\r\npozostałe: np. <span class="zmienna">float</span>,\r\n<span class="zmienna">clear</span>\r\n(kolejność <span class="zmienna">margin</span>,\r\n<span class="zmienna">border</span>,\r\n\r\n<span class="zmienna">padding</span>,\r\n<span class="zmienna">width</span>\r\njest posortowana od najbardziej zewnętrznego\r\ndo najbardziej wewnętrznego atrybutu pudełka).\r\nNatomiast wpisy dotyczące kolorów umieszczamy jako ostatnie.\r\nW środkowej części, grupujemy\r\npozostałe atrybuty (np. czcionki, czy atrybuty dotyczące tekstu).</p>\r\n\r\n<p>Ponadto już na samym początku pracy nad witryną należy\r\nzadbać o kolejność sekcji <span class="zmienna">div</span> w kodzie <span class="jezyk">HTML</span>.\r\nKolejność ta jest istotna dla\r\nprzeglądarek nie interpretujących stylów.\r\nW omawianym przykładzie witryna będzie zawierała kolejno:</p>\r\n\r\n<ul>\r\n\r\n<li>nagłówek,</li>\r\n<li>obraz tytułowy,</li>\r\n<li>menu pionowe,</li>\r\n<li>menu poziome,</li>\r\n<li>treść</li>\r\n<li>stopkę.</li>\r\n</ul>\r\n\r\n<p>Zmiana kolejności elementów <span class="zmienna">div</span> decydujących o układzie witryny\r\nw skończonym projekcie jest bardzo pracochłonna, gdyż\r\npociąga za sobą właściwie nowy projekt układu.</p>\r\n\r\n<p>Na zakończenie dodajmy, że\r\nnawet najnowsze wersje przeglądarek nie są do końca zgodne\r\nze sobą i zawierają pewne błędy.\r\nW omawianym  przykładzie błędy takie wystąpiły w dwóch miejscach.\r\nPo pierwsze przy wyznaczaniu minimalnej wysokości\r\npojemnika <span class="zmienna">div#tresc</span> przeznaczonego na treść,\r\npo drugie w przypadku szerokości akapitów zawartych w treści.</p>\r\n\r\n<p>Wysokość sekcji o identyfikatorze treść ustalamy\r\nsztucznie na 400 pikseli:</p>\r\n\r\n<pre class="syntax-highlight:xml">#tresc {\r\n    height : 400px;\r\n}</pre>\r\n\r\n<p>Podany atrybut jest interpretowany przez przeglądarkę\r\n<span class="program">IE</span> jako\r\nco najmniej 400 pikseli zaś przez trzy pozostałe jako dokładnie 400 pikseli.\r\nPonieważ <span class="program">IE</span> nie interpretuje selektorów typu dziecko,\r\nktóre zawierają znak <span class="zmienna">&gt;</span>,\r\nzatem wszystkie przeglądarki poza <span class="program">IE</span> informujemy jeszcze,\r\nże tak naprawdę wysokość sekcji <span class="zmienna">div#tresc</span>\r\nwynosi co najmniej 400 pikseli:</p>\r\n\r\n<pre class="syntax-highlight:xml">body&gt;#strona&gt;#kolumnaPrawa&gt;#tresc {\r\n    height     : auto;\r\n    min-height : 400px;\r\n}</pre>\r\n\r\n<p>W taki oto skomplikowany sposób walczymy z trzema błędami <span class="program">IE</span>:\r\nbłędną interpretacją atrybutów <span class="zmienna">height</span> i\r\n<span class="zmienna">min-height</span>\r\noraz brakiem interpretacji selektora dziecko.</p>\r\n\r\n<p>Drugi błąd, błędnie wyznaczaną szerokość akapitu\r\npoprawiamy dodając wpis:</p>\r\n\r\n<pre class="syntax-highlight:xml">#tresc  p {\r\n    width : 470px;\r\n}</pre>\r\n\r\n<p>który w przypadku pozostałych przeglądarek jest zbędny.</p>\r\n\r\n<p>Niestety tak wykonana witryna\r\nnie wygląda poprawnie w przeglądarkach drugiej generacji.</p>\r\n\r\n\r\n\r\n<div class="ilustracja">\r\n\r\n<img src="artimg/12-06.png" alt="" />\r\n\r\n<p class="podpis">\r\nRys. 6.\r\nStrona główna witryny <span class="zmienna">http://gwz.gajdaw.pl</span></p>\r\n</div>', 'elementy-div-i-style-css-w-praktyce');

SET FOREIGN_KEY_CHECKS=1;
