<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'piosenki',
    'encoding'       => 'utf-8',
    'defaultTagName' => 'piosenka',
);

$serializer->setOptions($options);

$dane = array();

$plks = glob('txt/*.txt');
shuffle($plks);
foreach ($plks as $k => $plk) {
    $tmp = file($plk);
    $tytul = trim($tmp[0]);
    $tmp[0] = '';
    $tresc = trim(implode('', $tmp));

    $tmp = array(
        'tytul' => $tytul,
        'tresc' => $tresc
    );
    array_push($dane, $tmp);
}

$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('piosenki-wojskowe.xml', $wynik);



