<?php

class Application_Form_Osoba extends Zend_Form
{

    public function init()
    {

        /*
         * Pierwsza metoda tworzenia kontrolek formularza
         * Pierwszy parametr (tj. text) określa klasę Zend_Form_Element_Text
         * Drugi parametr (tj. imie) ustala nazwę kontrolki: imie
         *
         * Kontrolka jest dostępna jako:
         *     $this->imie
         *     $this->getElement('imie')
         */
        $this->addElement('text', 'imie', array('label' => 'Imię:'));


        /*
         * Druga metoda tworzenia kontrolek formularza
         * O rodzaju tworzonej kontrolki decyduje
         * nazwa klasy (tj. Zend_Form_Element_Text)
         * Pierwszy parametr konstruktora (tj. nazwisko) ustala nazwę kontrolki: nazwisko
         *
         * Kontrolka jest dostępna jako:
         *     $this->nazwisko
         *     $this->getElement('nazwisko')
         */
        $kontrolka = new Zend_Form_Element_Text('nazwisko', array('label' => 'Nazwisko:'));
        $this->addElement($kontrolka);


        /*
         * Kontrolka typu Zend_Form_Element_Submit
         * Kontrolka jest dostępna jako:
         *     $this->zatwierdz
         *     $this->getElement('zatwierdz')
         */
        $this->addElement('submit', 'zatwierdz', array('label' => 'Przetwórz formularz'));




        /*
         * Modyfikacja atrybutu id formularza
         */
        $this->setOptions(array('id' => 'mojformularz'));


        /*
         * Zmieniamy dekoratory obiektu Zend_Form
         * Modyfikujemy elementy HTML tworzące formularz:
         *    <form>
         *    <dl>
         */
        $this->addDecorators(array(
            'FormElements',
            array('HtmlTag', array('tag' => 'div', 'class' => 'abc', 'id' => 'def')),
            array('Form',    array('class' =>'xyz', 'style' => 'color: red'))
        ));


        /*
         * Dekoratory kontrolki imie
         */
        $this->imie
            ->addDecorator('HtmlTag', array('tag' => 'div', 'class' => 'klasa'))
            ->addDecorator('Label', array('tag' => 'p', 'class' => 'klasa2'));


        /*
         * Dekoratory kontrolki nazwisko
         */
        $this->nazwisko->clearDecorators();
        $this->nazwisko
             ->addDecorator('ViewHelper')
             ->addDecorator('Errors')
             ->addDecorator('Description')
             ->addDecorator('HtmlTag', array('tag' => 'em'))
             ->addDecorator(array('Drugi' => 'HtmlTag'), array('tag' => 'strong'))
             ->addDecorator('Label');


        /*
         * Dekoratory wielu kontrolek: zatwierdz
         */
        $this->setElementDecorators(
            array(
                'ViewHelper',
                'Errors',
                array('Description', array('tag' => 'p', 'class' => 'description')),
                array('HtmlTag', array('tag' => 'div')),
                array('Label', array('tag' => 'p'))
            ),
            array(
                'zatwierdz',
            )
        );



    }

}
