<?php

class Application_Form_Kontynent extends Zend_Form
{

    public function init()
    {
        $this->addElement('text', 'nazwa', array(
            'label' => 'Kontynent:'
        ));
        $this->addElement('submit', 'submit', array('label' => 'Zapisz'));
    }

    public function dodajKontrolkePanstwa($obj = null)
    {
        $Panstwo = new Application_Model_DbTable_Panstwo();

        if ($obj === null) {
            $wartosci = array();
        } else {
            $wartosci = $obj->getPanstwaIds();
        }

        $kontrolka = new Zend_Form_Element_MultiCheckbox('panstwa', array(
            'label' => 'Dodaj nowe państwa:',
            'multiOptions' => $Panstwo->fetchPairs(),
            'value' => $wartosci,
            'validators' => array(
                'Int',
                array(
                    'Db_RecordExists',
                    true,
                    array('table' => 'panstwo', 'field' => 'panstwo_id')
                ),
            )
        ));
        $kontrolka->setOrder(1);

        $this->addElement($kontrolka);

        $this->panstwa->getValidator('Db_RecordExists')->setMessages(array(
            Zend_Validate_Db_RecordExists::ERROR_NO_RECORD_FOUND => "Brak rekordu!",
        ));

    }

}
