<?php

class IndexController extends Zend_Controller_Action
{

    public function indexAction()
    {
        $Plik = new Application_Model_DbTable_Plik();
        $this->view->pliki = $Plik->fetchAll();
    }

    public function createformAction()
    {
        $this->view->form = new Application_Form_Plik();
        $url = $this->view->url(array('action' => 'create'));
        $this->view->form->setAction($url);
    }

    public function createAction()
    {
        if ($this->getRequest()->isPost()) {
            $form = new Application_Form_Plik();
            if ($form->isValid($this->getRequest()->getPost())) {
                $dane = $form->getValues();
                $Plik = new Application_Model_DbTable_Plik();
                $Plik->insert($dane);
                $fld = realpath(APPLICATION_PATH . '/../public/uploads');
                My_Thumbnail::gdThumbnailFile(
                    $fld . '/' . $dane['nazwapliku'],
                    150, 100,
                    $fld . '/mini/' . $dane['nazwapliku']
                );
                My_Thumbnail::gdThumbnailFile(
                    $fld . '/' . $dane['nazwapliku'],
                    400, 300,
                    $fld . '/popup/' . $dane['nazwapliku']
                );
                My_Thumbnail::gdThumbnailFile(
                    $fld . '/' . $dane['nazwapliku'],
                    800, 600,
                    $fld . '/show/' . $dane['nazwapliku']
                );

                return $this->_helper->redirector('index');
            }
            $this->view->form = $form;
        } else {
            throw new Exception('Bdny adres!', 404);
        }
    }

    public function deleteAction()
    {
        $id = $this->getRequest()->getParam('plik_id');
        $Plik = new Application_Model_DbTable_Plik();
        $obj = $Plik->find($id)->current();
        if ($obj === null) {
            throw new Exception('Rekord nie istnieje!', 404);
        } else {

            $fld = realpath(APPLICATION_PATH . '/../public/uploads');

            $np1 = realpath($fld . '/' . $obj['nazwapliku']);
            $np2 = realpath($fld . '/mini/' . $obj['nazwapliku']);
            $np3 = realpath($fld . '/show/' . $obj['nazwapliku']);
            $np4 = realpath($fld . '/popup/' . $obj['nazwapliku']);
            unlink($np1);
            unlink($np2);
            unlink($np3);
            unlink($np4);


            $obj->delete();
            return $this->_helper->redirector('index');
        }
    }

}
