<?php

class My_Thumbnail
{

    /*
     * Jeśli obraz jest poziomy to jest skalowany do szerokości AWidth
     * Jeśli obraz jest pionowy to jest skalowany do wysokości AHeight
     * Kwadratowy: skalujemy do wysokości AHeight
     *
     * Parametr $AImg jest obiektem GD
     * Wynik - miniaturka - jest zwracany jako obiekt GD
     */
    public static function gdThumbnailObj($AImg, $AWidth, $AHeight)
    {
        if (!$AImg) {
            die('gd_thumbnail_obj() - $AImg error');
        }

        $AImg_X = ImageSX($AImg);
        $AImg_Y = ImageSY($AImg);

        $tmp_Y  = ($AWidth / $AImg_X) * $AImg_Y;
        $tmp_X  = ($AHeight / $AImg_Y) * $AImg_X;

        if ($tmp_Y <= $AHeight){
            $thumbnail_X = $AWidth;
            $thumbnail_Y = $tmp_Y;
        } else {
            $thumbnail_X = $tmp_X;
            $thumbnail_Y = $AHeight;
        }

        $thumbnail = ImageCreateTrueColor(
            $thumbnail_X,
            $thumbnail_Y
        );

        imageAlphaBlending($thumbnail, false);
        imageSaveAlpha($thumbnail, true);

        ImageCopyResized(
            $thumbnail, $AImg,           //przeznaczenie, zrodlo
            0, 0,                        //gdzie ma trafic w przeznaczeniu
            0, 0,                        //skad ma pochodzic ze zrodla
            $thumbnail_X, $thumbnail_Y,  //wymiary, jakie ma zająć w przeznaczeniu
            $AImg_X, $AImg_Y             //wymiary pobierane ze źródła
        );
        return $thumbnail;
    }


    /*
     * Funkcja identyczna jak function gd_thumbnail_obj()
     * Różni się parametrami.
     *
     * Pierwszy parametr - $AFileName - to nazwa pliku do przeskalowania
     * Wynik - miniaturka - jest zwracany jako obiekt GD
     */
    public static function gdThumbnailFile($AFileName, $AWidth, $AHeight, $destFilename, $quality = 95)
    {
        $img = ImageCreateFromJPEG($AFileName);
        $mini = self::gdThumbnailObj($img, $AWidth, $AHeight);
        imagejpeg($mini, $destFilename, $quality);
    }

}