<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'kontynenty',
    'encoding'       => 'utf-8',
    'defaultTagName' =>
        array(
            'kontynenty' => 'kontynent',
            'panstwa' => 'panstwo',
            'panstwo' => 'nazwa',
        )
);

$serializer->setOptions($options);

$dane = array();



$plk = file('txt/kontynenty.txt');
shuffle($plk);
foreach ($plk as $l) {
    $e = explode(',', trim($l));
    $str_kontynent = $e[0];
    array_shift($e);
    shuffle($e);
    $panstwa = array_map('trim', $e);
    $panstwa_nazwa = array();
    foreach ($panstwa as $tmp_p) {
        $panstwa_nazwa[] = array(
            $tmp_p
        );
    }
    $tmp = array(
        'nazwa' => $str_kontynent,
        'panstwa' => $panstwa_nazwa
    );
    $dane[] = $tmp;
}


$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('kontynenty.xml', $wynik);
