<?php

class Application_Form_Ksiazka extends Zend_Form
{

    public function init()
    {
        $this->setMethod('post');



        $this->addElement('text', 'tytul', array(
            'required' => true,
            'label'      => 'Tytuł:',
            'filters'    => array('StringTrim'),
            'validators' => array(
                array('NotEmpty', true),
                array('StringLength', true, array('min' => 3, 'max' => 120))
            )
        ));
        $this->tytul->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Tytuł nie może być pusty"
        ));
        $this->tytul->getValidator('StringLength')->setMessages(array(
            Zend_Validate_StringLength::INVALID   => "Niepoprawny napis",
            Zend_Validate_StringLength::TOO_SHORT => "Tytuł '%value%' jest zbyt krótki",
            Zend_Validate_StringLength::TOO_LONG  => "Tytuł '%value%' jest zbyt długi",
        ));



        $this->addElement('text', 'rokwydania', array(
            'required'   => true,
            'label'      => 'Rok wydania:',
            'filters'    => array('StringTrim'),
            'validators' => array('NotEmpty', 'Int')
        ));
        $this->rokwydania->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Rok wydania nie może być pusty",
        ));
        $this->rokwydania->getValidator('Int')->setMessages(array(
            Zend_Validate_Int::NOT_INT => "'%value%' nie jest poprawnym numerem roku"
        ));



        $this->addElement('text', 'miesiacwydania', array(
            'required'   => true,
            'label'      => 'Miesiąc wydania:',
            'filters'    => array('StringTrim'),
            'validators' => array(
                array('NotEmpty', true),
                array('Int', true),
                array('Between', true, array('min' => 1, 'max' => 12))
            )
        ));
        $this->miesiacwydania->getValidator('Between')->setMessages(array(
            Zend_Validate_Between::NOT_BETWEEN => "'%value%' nie jest z zakresu od '%min%' do and '%max%'",
        ));
        $this->miesiacwydania->getValidator('Int')->setMessages(array(
            Zend_Validate_Int::NOT_INT => "'%value%' nie jest poprawnym numerem roku"
        ));
        $this->miesiacwydania->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Miesiąc nie może być pusty"
        ));



        $this->addElement('text', 'dzienwydania', array(
            'required'   => true,
            'label'      => 'Dzień wydania:',
            'filters'    => array('StringTrim'),
            'validators' => array(
                array('NotEmpty', true)
            )
        ));
        $this->dzienwydania->addValidator(new My_Validate_Date());
        $this->dzienwydania->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Dzień nie może być pusty"
        ));



        $this->addElement('text', 'wydanie', array(
            'required'   => true,
            'label'      => 'Wydanie:',
            'filters'    => array('StringTrim', 'StringToUpper'),
            'validators' => array('NotEmpty')
        ));
        $this->wydanie->addValidator(new My_Validate_Roman());
        $this->wydanie->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Wydanie nie może być puste"
        ));



        $this->addElement('text', 'liczbastron', array(
            'required'   => true,
            'label'      => 'Lisczba stron:',
            'validators' => array(
                array('NotEmpty', true),
                array('Int', true)
            )
        ));
        $this->liczbastron->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Liczba stron nie może być pusta"
        ));
        $this->liczbastron->getValidator('Int')->setMessages(array(
            Zend_Validate_Int::NOT_INT => "'%value%' nie jest poprawną liczcbą całkowitą"
        ));



        $this->addElement('text', 'format', array(
            'label'      => 'Format:',
            'filters'    => array('StringTrim'),
        ));



        $this->addElement('text', 'oprawa', array(
            'label'      => 'Oprawa:',
            'filters'    => array('StringTrim'),
        ));



        $this->addElement('checkbox', 'zawiera_dvd', array(
            'label'          => 'Zawiera DVD:',
            'uncheckedvalue' => '0',
            'checkedvalue'   => '1',
            'validators' => array(
                array('InArray', true, array(array(0, 1)))
            )
        ));
        $this->zawiera_dvd->getValidator('InArray')->setMessages(array(
            Zend_Validate_InArray::NOT_IN_ARRAY => "'%value%' - wartość niedozwolona",
        ));



        $this->addElement('checkbox', 'ksiazkawkolorze', array(
            'label'          => 'Książka w kolorze:',
            'uncheckedvalue' => '0',
            'checkedvalue'   => '1',
            'validators' => array(
                array('InArray', true, array(array(0, 1)))
            )
        ));
        $this->ksiazkawkolorze->getValidator('InArray')->setMessages(array(
            Zend_Validate_InArray::NOT_IN_ARRAY => "'%value%' - wartość niedozwolona",
        ));



        $this->addElement('checkbox', 'zawiera_cdrom', array(
            'label'          => 'Zawiera CD-ROM:',
            'uncheckedvalue' => '0',
            'checkedvalue'   => '1',
            'validators' => array(
                array('InArray', true, array(array(0, 1)))
            )
        ));
        $this->zawiera_cdrom->getValidator('InArray')->setMessages(array(
            Zend_Validate_InArray::NOT_IN_ARRAY => "'%value%' - wartość niedozwolona",
        ));



        $this->addElement('text', 'isbn', array(
            'label'      => 'ISBN:',
            'validators' => array(
                array('Isbn', true, array('separator' => '-'))
            )
        ));
        $this->isbn->getValidator('Isbn')->setMessages(array(
            Zend_Validate_Isbn::INVALID => "Niepoprawny numer ISBN",
            Zend_Validate_Isbn::NO_ISBN => "'%value%' nie jest poprawnym numerem ISBN",
        ));



        $this->addElement('text', 'cena', array(
            'label'      => 'Cena:',
            'validators' => array(
                array('Float')
            )
        ));
        $this->cena->getValidator('Float')->setMessages(array(
            Zend_Validate_Float::INVALID   => "Cena musi być poprawną liczbą",
            Zend_Validate_Float::NOT_FLOAT => "'%value%' nie jest poprawną liczbą",
        ));



        $this->addElement('text', 'img_okladka', array(
            'label'      => 'Plik graficzny okładki:',
            'validators' => array(
                array(
                    'Regex',
                    false,
                    array('/^[a-z]{6}\.jpg$/')
                )
            )
        ));
        $this->img_okladka->getValidator('Regex')->setMessages(array(
            Zend_Validate_Regex::INVALID   => "Niepoprawna nazwa pliku graficznego",
            Zend_Validate_Regex::NOT_MATCH => "Nazwa pliku graficznego musi mieć postać XXXXXX.jpg",
        ));



        $this->addElement('text', 'url_stronadomowa', array(
            'label'      => 'Strona domowa:',
            'validators' => array(
                array(
                    'Regex',
                    false,
                    array('/^http:\/\/[a-z0-9.\-\/]{4,}$/i')
                )
            )
        ));
        $this->url_stronadomowa->getValidator('Regex')->setMessages(array(
            Zend_Validate_Regex::INVALID   => "Niepoprawny adres",
            Zend_Validate_Regex::NOT_MATCH => "Adres musi mieć postać: '%pattern%'",
        ));



        $this->addElement('text', 'url_ksiazkawhelionie', array(
            'label'      => 'Strona książki w księgarni Helion:',
            'validators' => array(
                array(
                    'Regex',
                    false,
                    array('/^http:\/\/[a-z0-9.\-\/]{4,}$/i')
                )
            )
        ));
        $this->url_ksiazkawhelionie->getValidator('Regex')->setMessages(array(
            Zend_Validate_Regex::INVALID   => "Niepoprawny adres",
            Zend_Validate_Regex::NOT_MATCH => "Adres musi mieć postać: '%pattern%'",
        ));



        $this->addElement('text', 'url_dodajdokoszyka', array(
            'label'      => 'Adres strony dodaj do koszyka:',
            'validators' => array(
                array(
                    'Regex',
                    false,
                    array('/^http:\/\/[a-z0-9.\-\/]{4,}$/i')
                )
            )
        ));
        $this->url_dodajdokoszyka->getValidator('Regex')->setMessages(array(
            Zend_Validate_Regex::INVALID   => "Niepoprawny adres",
            Zend_Validate_Regex::NOT_MATCH => "Adres musi mieć postać: '%pattern%'",
        ));



        $this->addElement('text', 'katalog', array(
            'required'   => true,
            'label'      => 'Numer książki w katalogu:',
            'filters'    => array('StringTrim'),
            'validators' => array('NotEmpty', 'Int')
        ));
        $this->katalog->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Numer z katalogu nie może być pusty"
        ));
        $this->katalog->getValidator('Int')->setMessages(array(
            Zend_Validate_Int::NOT_INT => "'%value%' nie jest poprawnym numerem z katalogu"
        ));



        $this->addElement('text', 'ident', array(
            'required'   => true,
            'label'      => 'Identyfikator książki w Helionie:',
            'filters'    => array('StringToLower'),
            'validators' => array(
                array(
                    'Regex',
                    true,
                    array('/^[a-z]{6}$/')
                ),
                'NotEmpty',
            )
        ));
        $this->ident->getValidator('Regex')->setMessages(array(
            Zend_Validate_Regex::INVALID   => "Niepoprawny identyfikator",
            Zend_Validate_Regex::NOT_MATCH => "Identyfikator powinien składać się z sześciu małych liter: '%pattern%'",
        ));



        $this->addElement('text', 'wydawnictwo', array(
            'required' => true,
            'label'      => 'Wydawnictwo:',
            'filters'    => array('StringTrim'),
            'value'    => 'Helion',
            'validators' => array(
                array('NotEmpty', true),
                array('StringLength', true, array('min' => 3, 'max' => 20))
            )
        ));
        $this->wydawnictwo->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Nazwa wydawnictwa nie może być pusta"
        ));
        $this->wydawnictwo->getValidator('StringLength')->setMessages(array(
            Zend_Validate_StringLength::INVALID   => "Niepoprawny napis",
            Zend_Validate_StringLength::TOO_SHORT => "Nazwa wydawnictwa jest zbyt krótka",
            Zend_Validate_StringLength::TOO_LONG  => "Nazwa wydawnictwa jest zbyt długa",
        ));



        $this->addElement('text', 'miasto', array(
            'required' => true,
            'label'      => 'Miasto:',
            'filters'    => array('StringTrim'),
            'value'    => 'Gliwice',
            'validators' => array(
                array('NotEmpty', true),
                array('StringLength', true, array('min' => 3, 'max' => 20))
            )
        ));
        $this->wydawnictwo->getValidator('NotEmpty')->setMessages(array(
            Zend_Validate_NotEmpty::IS_EMPTY => "Miasto nie może być pusta"
        ));
        $this->wydawnictwo->getValidator('StringLength')->setMessages(array(
            Zend_Validate_StringLength::INVALID   => "Niepoprawny napis",
            Zend_Validate_StringLength::TOO_SHORT => "Nazwa miasta jest zbyt krótka",
            Zend_Validate_StringLength::TOO_LONG  => "Nazwa miasta jest zbyt długa",
        ));



        $front = Zend_Controller_Front::getInstance();
        $request = $front->getRequest();
        $baseUrl = $request->getBaseUrl();

        $kontrolka = new Zend_Form_Element_Captcha('zabezpieczenie', array(
            'label' => 'Wpisz tekst widoczny na obrazku:',
            'captcha' => array(
                'captcha' => 'Image',
                'font' => 'C:/Windows/Fonts/times.ttf',
                'ImgUrl' => $baseUrl . '/images/captcha/',
                'wordLen' => 4,
                'fontSize' => 30,
            ),
        ));
        $this->addElement($kontrolka);
        $this->zabezpieczenie->getValidator('Zend_Captcha_Image')->setMessages(array(
            Zend_Captcha_Word::MISSING_VALUE => 'Napis zabezpieczający nie może być pusty',
            Zend_Captcha_Word::MISSING_ID    => 'Brak pola Captcha w formularzu',
            Zend_Captcha_Word::BAD_CAPTCHA   => 'Błędny napis',
        ));




/*
        $slownik = array(
            Zend_Validate_Int::NOT_INT => '"%value%" nie jest poprawnym numerem roku',
            Zend_Validate_NotEmpty::IS_EMPTY => 'Rok nie może być pusty',
        );

        $translate = new Zend_Translate(
            array(
                'adapter' => 'array',
                'content' => $slownik,
                'locale'  => 'pl'
            )
        );
        $this->rokwydania->setTranslator($translate);
*/


        $this->addElement('submit', 'submit', array('label' => 'Zapisz'));

//        $this->submit->addDecorator('HtmlTag', array('tag' => 'em'));

        $this->addDecorators(array(
            'FormElements',
            array('HtmlTag', array('tag' => 'dl')),
            array(array('Drugi' => 'HtmlTag'), array('tag' => 'div', 'class' => 'czyszczenie', 'placement' => 'append')),
            array('Form')
        ));



    }

}