<?php

class PanstwoController extends My_Crud_Controller
{

    public function init()
    {
        $this->_db_table_class = 'Application_Model_DbTable_Panstwo';
        $this->_form_class = 'Application_Form_Panstwo';
    }

    public function showAction()
    {
        $slug = $this->_request->getParam('slug', 'brak');
        $Panstwo = new Application_Model_DbTable_Panstwo();
        $this->view->panstwo = $Panstwo->findOneBySlug($slug);
        if (!$this->view->panstwo) {
            throw new Zend_Controller_Action_Exception(sprintf('PanstwoController/showAction: błędny slug: "%s" ', $slug), 404);
        }
    }

    public function createAction()
    {
        if ($this->getRequest()->isPost()) {
            $form = new $this->_form_class;
            if ($form->isValid($this->getRequest()->getPost())) {
                $data = $form->getValues();

                if ($data['kontynent_id'] === '0') {
                    unset($data['kontynent_id']);
                }

                $DbTable = new $this->_db_table_class;
                $id = $DbTable->createRow($data)->save();
                return $this->_helper->redirector(
                    'edit',
                    $this->getRequest()->getControllerName(),
                    $this->getRequest()->getModuleName(),
                    array('id' => $id)
                );
            }
            $this->view->form = $form;
        } else {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
    }

    public function updateAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }

        if ($this->getRequest()->isPost()) {
            $form = new $this->_form_class;
            if ($form->isValid($this->getRequest()->getPost())) {
                $data = $form->getValues();

                if ($data['kontynent_id'] === '0') {
                    unset($data['kontynent_id']);
                }

                $obj->setFromArray($data);
                $obj->save();
                return $this->_helper->redirector(
                    'edit',
                    $this->getRequest()->getControllerName(),
                    $this->getRequest()->getModuleName(),
                    array('id' => $id)
                );
            }
            $this->view->form = $form;
        } else {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
    }


    public function nieprzypisaneAction()
    {
        $Panstwo = new Application_Model_DbTable_Panstwo();
        $this->view->panstwa = $Panstwo->getNieprzypisane();
    }


    public function deleterelationAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
        $obj->deleteRelation();
        $obj->save();

        return $this->_helper->redirector(
            'edit',
            $this->getRequest()->getControllerName(),
            $this->getRequest()->getModuleName(),
            array('id' => $id)
        );
    }


}
