<?php

class Application_Model_DbTable_Film extends Zend_Db_Table_Abstract
{

    protected $_name = 'film';

    protected $_rowClass = 'Application_Model_DbTable_Film_Row';

    protected $_dependentTables = array('Application_Model_DbTable_FilmHasAktor');

    public function fetchAll($where = null, $order = null, $count = null, $offset = null)
    {
        if ($where === null) {
            $select = $this->select();
        } else if (!($where instanceof Zend_Db_Table_Select)) {
            $select = $this->select();

            if ($where !== null) {
                $this->_where($select, $where);
            }

            if ($order !== null) {
                $this->_order($select, $order);
            }

            if ($count !== null || $offset !== null) {
                $select->limit($count, $offset);
            }

        } else {
            $select = $where;
        }

        $select->order('tytul');

        return parent::fetchAll($select, $order, $count, $offset);
    }


    public function findOneBySlug($slug)
    {
        $select  = $this->select()->where('slug = ?', $slug);
        return $this->fetchRow($select);
    }

}

