<?php

class Application_Form_Plik extends Zend_Form
{

    public function init()
    {
        $this->setMethod('post');

        $element = new Zend_Form_Element_File('nazwapliku', array('required' => true));
        $element
            ->setLabel('Dodaj zdjęcie:')
            ->setDestination(realpath(APPLICATION_PATH . '/../public/uploads'))
            ->addValidator('NotEmpty', true)
            ->addValidator('Count', true, 1)
            ->addValidator('Size', true, 102400)
            ->addValidator('NotExists', realpath(APPLICATION_PATH . '/../public/uploads'))
            ->addValidator('Extension', false, 'jpg,png,gif');
        $this->addElement($element, 'nazwapliku');

        $this->nazwapliku->getValidator('NotExists')->setMessages(array(
            Zend_Validate_File_NotExists::DOES_EXIST => "Plik '%value%' już istnieje!",
        ));
        $this->nazwapliku->getValidator('Upload')->setMessages(array(
            Zend_Validate_File_Upload::NO_FILE => "Nazwa pliku nie może być pusta!",
        ));
        $this->nazwapliku->getValidator('Size')->setMessages(array(
            Zend_Validate_File_Size::TOO_BIG => "Maksymalny rozmiar pliku to '%max%'. Przesłany plik '%value%' ma rozmiar '%size%'.",
        ));

        $this->addElement('submit', 'submit', array(
            'label' => 'Zapisz',
        ));
    }

}