<?php

class My_Validate_Roman extends Zend_Validate_Abstract
{
    const WRONG_NUMBER = 'wrongNumber';

    protected $_messageTemplates = array(
        self::WRONG_NUMBER => 'Wymagana poprawna liczba rzymska z zakresu od I do X'
    );

    public function isValid($value, $context = null)
    {

        $number = (string) $value;
        $this->_setValue($number);

        $numbers = array('I', 'II', 'III', 'IV', 'V', 'VI', 'VII', 'VIII', 'IX', 'X');

        if (in_array($number, $numbers)) {
            return true;
        }

        $this->_error(self::WRONG_NUMBER);
        return false;
    }
}
