<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'filmy',
    'encoding'       => 'utf-8',
    'defaultTagName' =>
        array(
            'filmy' => 'film',
            'aktorzy' => 'aktor',
        )
);

$serializer->setOptions($options);

$dane = array();



$plk = file('filmy.txt');
shuffle($plk);
foreach ($plk as $l) {
    $e = explode('|', trim($l));
    $tytul = $e[0];
    $aktorzy = explode(',', trim($e[1]));
    $aktorzy = array_map('trim', $aktorzy);
    shuffle($aktorzy);

    $aktorzy_i_n = array();
    foreach ($aktorzy as $tmp) {
        $info = preg_split('/[ ]+/', trim($tmp));
        $aktorzy_i_n[] = array(
            'imie' => trim($info[0]),
            'nazwisko' => trim($info[1]),
        );
    }
    $tmp = array(
        'tytul' => $tytul,
        'aktorzy' => $aktorzy_i_n
    );
    $dane[] = $tmp;
}


$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('filmy.xml', $wynik);
