<?php

class Bootstrap extends Zend_Application_Bootstrap_Bootstrap
{

    protected function _initRouterBezdomyslnych()
    {
        $this->bootstrap('router');
        $router = $this->getResource('router');
        $router->removeDefaultRoutes();
        return $router;
    }

    protected function _initPage()
    {
        $this->bootstrap(array(
            'layout',
            'view',
            'frontController',
        ));

        $front = $this->getResource('frontController');
        $layout = $this->getResource('layout');
        $view = $this->getResource('view');

        $request = new Zend_Controller_Request_Http();
        $front->setRequest($request);
        $baseUrl = $request->getBaseUrl();

        $defaultsArray = array(
            'page' => array(
                'title'  => array(
                    'separator'          => '',
                    'content'            => '',
                    'defaultAttachOrder' => 'APPEND',
                ),
                'css'  => array(),
                'js'  => array(),
                'keywords' => false,
                'description' => false,
                'extension' => 'phtml',
            )
        );
        $defaults = new Zend_Config($defaultsArray, true);

        $cfg = new Zend_Config_Ini(APPLICATION_PATH . '/configs/application.ini', 'production');
        $cfg = $defaults->merge($cfg);


        $view->headTitle()
                ->setDefaultAttachOrder($cfg->page->title->defaultAttachOrder)
                ->setSeparator($cfg->page->title->separator)
                ->headTitle($cfg->page->title->content);

        foreach ($cfg->page->css as $css) {
            if (isset($css->media)) {
                $view->headLink()->appendStylesheet($baseUrl . $css->href, $css->media);
            } else {
                $view->headLink()->appendStylesheet($baseUrl . $css->href);
            }
        }

        foreach ($cfg->page->js as $js) {
            $view->headScript()->appendFile(
                    $baseUrl . $js,
                    'text/javascript'
            );
        }

        if ($cfg->page->keywords) {
            $view->headMeta()->appendName('keywords', $cfg->page->keywords);
        }

        if ($cfg->page->description) {
            $view->headMeta()->appendName('description', $cfg->page->description);
        }

        if ($cfg->page->extension != 'phtml') {
            $layout->setViewSuffix($cfg->page->extension);
            $viewRenderer = Zend_Controller_Action_HelperBroker::getStaticHelper('ViewRenderer');
            $viewRenderer->setViewSuffix($cfg->page->extension);
            $viewRenderer->setView($view);
        }

    }

}