<?php

class IndexController extends Zend_Controller_Action
{
    protected $_db_table_class = 'Application_Model_DbTable_Imie';
    protected $_form_class = 'Application_Form_Imie';

    public function indexAction()
    {
        $DbTable = new $this->_db_table_class;
        $this->view->objects = $DbTable->fetchAll();
    }

    public function createformAction()
    {
        $this->view->form = new $this->_form_class;
        $url = $this->view->url(array('action' => 'create'));
        $this->view->form->setAction($url);
    }

    public function createAction()
    {
        if ($this->getRequest()->isPost()) {
            $form = new $this->_form_class;
            if ($form->isValid($this->getRequest()->getPost())) {
                $data = $form->getValues();
                $DbTable = new $this->_db_table_class;
                $id = $DbTable->insert($data);
                return $this->_helper->redirector('edit', 'index', null, array('id' => $id));
            }
            $this->view->form = $form;
        } else {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
    }

    public function deleteAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
        $obj->delete();
        return $this->_helper->redirector('index');
    }

    public function editAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
        $this->view->form = new $this->_form_class;
        $this->view->form->populate($obj->toArray());
        $url = $this->view->url(array('action' => 'update', 'id' => $id));
        $this->view->form->setAction($url);
        $this->view->object = $obj;
    }

    public function updateAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }

        if ($this->getRequest()->isPost()) {
            $form = new $this->_form_class;
            if ($form->isValid($this->getRequest()->getPost())) {
                $data = $form->getValues();
                $obj->setFromArray($data);
                $obj->save();
                return $this->_helper->redirector('edit', 'index', null, array('id' => $id));
            }
            $this->view->form = $form;
        } else {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
    }

    public function showAction()
    {
        $id = $this->getRequest()->getParam('id');
        $DbTable = new $this->_db_table_class;
        $obj = $DbTable->find($id)->current();
        if (!$obj) {
            throw new Zend_Controller_Action_Exception('Błędny adres!', 404);
        }
        $this->view->object = $obj;
    }

}
