<?php

class Application_Model_DbTable_Panstwo extends Zend_Db_Table_Abstract
{

    protected $_name = 'panstwo';

    protected $_rowClass = 'Application_Model_DbTable_Panstwo_Row';

    protected $_referenceMap = array(
        'Kontynent' => array(
            'columns'         => array('kontynent_id'),
            'refTableClass'   => 'Application_Model_DbTable_Kontynent',
            'refTableColumns' => array('kontynent_id')
        )
    );

    public function fetchAll($where = null, $order = null, $count = null, $offset = null)
    {
        if ($where === null) {
            $select = $this->select();
        } else if (!($where instanceof Zend_Db_Table_Select)) {
            $select = $this->select();

            if ($where !== null) {
                $this->_where($select, $where);
            }

            if ($order !== null) {
                $this->_order($select, $order);
            }

            if ($count !== null || $offset !== null) {
                $select->limit($count, $offset);
            }

        } else {
            $select = $where;
        }

        $select->order('nazwa');

        return parent::fetchAll($select, $order, $count, $offset);
    }

    public function findOneBySlug($slug)
    {
        $select  = $this->select()->where('slug = ?', $slug);
        return $this->fetchRow($select);
    }

    public function fetchPairs()
    {
        $sql = 'select panstwo_id, nazwa from panstwo order by nazwa';
        return $this->getAdapter()->fetchPairs($sql);
    }

    public function getNieprzypisane()
    {
        $select = $this->select()->where('kontynent_id is null')->order('nazwa');
        return $this->fetchAll($select);
    }

}