<?php

class Application_Model_DbTable_Aktor extends Zend_Db_Table_Abstract
{

    protected $_name = 'aktor';

    protected $_rowClass = 'Application_Model_DbTable_Aktor_Row';

    protected $_dependentTables = array('Application_Model_DbTable_FilmHasAktor');

    public function fetchAll($where = null, $order = null, $count = null, $offset = null)
    {
        if ($where === null) {
            $select = $this->select();
        } else if (!($where instanceof Zend_Db_Table_Select)) {
            $select = $this->select();

            if ($where !== null) {
                $this->_where($select, $where);
            }

            if ($order !== null) {
                $this->_order($select, $order);
            }

            if ($count !== null || $offset !== null) {
                $select->limit($count, $offset);
            }

        } else {
            $select = $where;
        }

        $select->order('nazwisko')->order('imie');

        return parent::fetchAll($select, $order, $count, $offset);
    }

    public function insertIfNotExists($data)
    {

        $select = $this->select()
            ->from('aktor', array('aktor_id'))
            ->where('imie = ?', $data['imie'])
            ->where('nazwisko = ?', $data['nazwisko']);

        if ($aktor = $this->fetchRow($select)) {
            return $aktor->aktor_id;
        }

        return $this->createRow($data)->save();

    }


    public function findOneBySlug($slug)
    {
        $select  = $this->select()->where('slug = ?', $slug);
        return $this->fetchRow($select);
    }

}

