SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

DROP SCHEMA IF EXISTS `tcs` ;
CREATE SCHEMA IF NOT EXISTS `tcs` DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci ;
USE `tcs` ;

-- -----------------------------------------------------
-- Table `tcs`.`turniej`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `tcs`.`turniej` (
  `turniej_id` INT NOT NULL AUTO_INCREMENT ,
  `rok` INT NULL ,
  `slug` VARCHAR(45) NOT NULL ,
  PRIMARY KEY (`turniej_id`) ,
  UNIQUE INDEX `slug_UNIQUE` (`slug` ASC) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcs`.`panstwo`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `tcs`.`panstwo` (
  `panstwo_id` INT NOT NULL AUTO_INCREMENT ,
  `nazwa` VARCHAR(128) NULL ,
  `slug` VARCHAR(128) NOT NULL ,
  PRIMARY KEY (`panstwo_id`) ,
  UNIQUE INDEX `slug_UNIQUE` (`slug` ASC) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcs`.`zawodnik`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `tcs`.`zawodnik` (
  `zawodnik_id` INT NOT NULL AUTO_INCREMENT ,
  `imie` VARCHAR(45) NULL ,
  `nazwisko` VARCHAR(45) NULL ,
  `slug` VARCHAR(128) NOT NULL ,
  `panstwo_id` INT NULL ,
  PRIMARY KEY (`zawodnik_id`) ,
  INDEX `fk_zawodnik_panstwo` (`panstwo_id` ASC) ,
  UNIQUE INDEX `slug_UNIQUE` (`slug` ASC) ,
  CONSTRAINT `fk_zawodnik_panstwo`
    FOREIGN KEY (`panstwo_id` )
    REFERENCES `tcs`.`panstwo` (`panstwo_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `tcs`.`turniej_has_zawodnik`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `tcs`.`turniej_has_zawodnik` (
  `turniej_id` INT NOT NULL ,
  `zawodnik_id` INT NOT NULL ,
  `miejsce` INT NULL ,
  PRIMARY KEY (`turniej_id`, `zawodnik_id`) ,
  INDEX `fk_turniej_has_zawodnik_turniej1` (`turniej_id` ASC) ,
  INDEX `fk_turniej_has_zawodnik_zawodnik1` (`zawodnik_id` ASC) ,
  CONSTRAINT `fk_turniej_has_zawodnik_turniej1`
    FOREIGN KEY (`turniej_id` )
    REFERENCES `tcs`.`turniej` (`turniej_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE,
  CONSTRAINT `fk_turniej_has_zawodnik_zawodnik1`
    FOREIGN KEY (`zawodnik_id` )
    REFERENCES `tcs`.`zawodnik` (`zawodnik_id` )
    ON DELETE CASCADE
    ON UPDATE CASCADE)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

grant all on tcs.* to redaktor@localhost identified by 'tajnehaslo';
flush privileges;
