#!/usr/bin/env python3
# Reference Johannes Fahrenkrug's answer on https://stackoverflow.com/questions/15753390/how-can-i-mock-requests-and-the-response
import requests
import unittest
from unittest import mock

# Nasza klasa wykonująca wywołanie API przy użyciu requests
class MyClass:
    def fetch_json(self, url):
        response = requests.get(url)
        return response.json()

# Ta metoda zostanie użyta przez imitację do zastąpienia requests.get
def mocked_requests_get(*args, **kwargs):
    class MockResponse:
        def __init__(self, json_data, status_code):
            self.json_data = json_data
            self.status_code = status_code

        def json(self):
            return self.json_data

    if args[0] == 'http://url-1.com/test.json':
        return MockResponse({"key1": "value1"}, 200)
    elif args[0] == 'http://url-2.com/test.json':
        return MockResponse({"key2": "value2"}, 200)

    return MockResponse(None, 404)

# Nasza klasa testu
class MyClassTestCase(unittest.TestCase):
    # Zastępujemy 'requests.get' naszą metodą. Obiekt imitacji jest przekazywany do metody naszego tekstu
    @mock.patch('requests.get', side_effect=mocked_requests_get)
    def test_fetch(self, mock_get):
        # Sprawadzenie wywołań requests.get
        my_class = MyClass()
        # wywołanie do url-1
        json_data = my_class.fetch_json('http://url-1.com/test.json')
        self.assertEqual(json_data, {"key1": "value1"})
        # wywołanie do url-2
        json_data = my_class.fetch_json('http://url-2.com/test.json')
        self.assertEqual(json_data, {"key2": "value2"})
        # wywołanie do url-3, którego nie zastąpiliśmy imitacją
        json_data = my_class.fetch_json('http://url-3.com/test.json')
        self.assertIsNone(json_data)


if __name__ == '__main__':
    unittest.main()

