// przekaznik_siec
// Arduino Uno lub (Leonardo wraz z modułem ethernetowym w wersji R3)

#include <SPI.h>
#include <Ethernet.h>

// Adres MAC musi być niepowtarzalny. Ten powinien zadziałać
byte mac[] = { 0xDE, 0xAD, 0xBE, 0xEF, 0xFE, 0xED };
// Adres IP jest zależny od sieci lokalnej:
byte ip[] = { 192, 168, 1, 30 };
EthernetServer server(80);

int relayPin = A0;

char line1[100];

void setup()
{
  pinMode(relayPin, OUTPUT);
  Ethernet.begin(mac, ip);
  server.begin();
}

void loop()
{
  EthernetClient client = server.available();
  if (client) 
  {
    while (client.connected()) 
    {
      readHeader(client);
      if (! pageNameIs("/"))
      {
        client.stop();  
        return;
      }
      digitalWrite(relayPin, valueOfParam('a'));
      client.println("HTTP/1.1 200 OK");
      client.println("Content-Type: text/html");
      client.println();

      // Wysyła ciało strony
      client.println("<html><body>");
      client.println("<h1>Zdalny przekaznik</h1>");

      client.println("<h2><a href='?a=1'/>Wlaczony</a></h2>");
      client.println("<h2><a href='?a=0'/>Wylaczony</a></h2>");
      client.println("</body></html>");

      client.stop();            
    }
  }
}


void readHeader(EthernetClient client)
{
  // Odczytuje pierwszy wiersz nagłówka
  char ch;
  int i = 0;
  while (ch != '\n')
  {
    if (client.available())
    {
      ch = client.read();
      line1[i] = ch;
      i ++;
    }
  }
  line1[i] = '\0'; 
  Serial.println(line1);
}

boolean pageNameIs(char* name)
{
   // Nazwa strony zaczyna się od czwartego znaku
   // Kończy się spacją
   int i = 4;
   char ch = line1[i];
   while (ch != ' ' && ch != '\n' && ch != '?')
   {
     if (name[i-4] != line1[i])
     {
       return false;
     }
     i++;
     ch = line1[i];
   }
   return true;
}

int valueOfParam(char param)
{
  for (int i = 0; i < strlen(line1); i++)
  {
    if (line1[i] == param && line1[i+1] == '=')
    {
      return (line1[i+2] - '0');
    }
  }
  return 0;
}

