<?php

class BlogController extends Controller
{
	public function actionIndex()
	{
	   $this->pageTitle = 'Strona główna';

		$ModelKategorie = new BlogKategorie;

		$DaneKategorii = $ModelKategorie->PobierzKategorie();

		$ModelWpisy = new BlogWpisy;

		$IloscWpisow = $ModelWpisy->LiczWszystkieWpisy();

		$Strony = new CPagination(intval($IloscWpisow));
        $Strony->pageSize = 10;

		$DaneWpisow = $ModelWpisy->WybierzWpisy($Strony->pageSize, $Strony->currentPage);

        $this->render('index',
            array(
                'DaneKategorii' => $DaneKategorii,
                'DaneWpisow' => $DaneWpisow,
                'Strony' => $Strony,
                )
            );
	}

    public function actionKategoria($id)
	{
        if(!is_numeric($id))
        {
            exit;
        }

		$ModelKategorie = new BlogKategorie;

		$DaneKategorii = $ModelKategorie->PobierzJednaKategorie($id);

		foreach($DaneKategorii as $Kategoria)
		{
			$this->pageTitle = 'Kategoria: '.$Kategoria['kategoria_nazwa'];
        }

		$ModelWpisy = new BlogWpisy;

		$IloscWpisow = $ModelWpisy->LiczWpisyKategoria($id);

		$Strony = new CPagination(intval($IloscWpisow));
		$Strony->pageSize = 10;

		$DaneWpisow = $ModelWpisy->WybierzWpisyKategoria($id, $Strony->pageSize, $Strony->currentPage);

        $this->render('kategoria',
            array(
                'DaneWpisow' => $DaneWpisow,
                'Strony' => $Strony,
                )
            );
	}

	public function actionWpis($id)
	{
        if(!is_numeric($id))
        {
            exit;
        }

        $KomentarzDodany = false;

		$ModelKategorie = new BlogKategorie;
		$DaneKategorie = $ModelKategorie->PobierzKategorie();

		$ModelWpisy = new BlogWpisy;

		$DaneWpisu = $ModelWpisy->PobierzWpis($id);

		foreach($DaneWpisu as $Wpis)
		{
			$this->pageTitle = $Wpis['wpis_tytul'];
		}

        $ModelKomentarz = new BlogKomentarze;

        if(isset($_POST['BlogKomentarze']))
        {
            $ModelKomentarz->attributes=$_POST['BlogKomentarze'];

            $ModelKomentarz->komentarz_wpis_id = $id;
            $ModelKomentarz->komentarz_data = date('Y-m-d');

            if($ModelKomentarz->validate())
            {
                $ModelKomentarz->ZapiszKomentarz();

                $ModelKomentarz->komentarz_wpis_id = '';
                $ModelKomentarz->komentarz_uzytkownik = '';
                $ModelKomentarz->komentarz_tresc = '';
                $ModelKomentarz->komentarz_data = '';

                $KomentarzDodany = true;
            }
        }

		$DaneKomentarzy = $ModelKomentarz->WybierzKomentarzeWpisu($id);

		$this->render('wpis',
            array(
                'DaneKategorie' => $DaneKategorie,
                'DaneWpisu' => $DaneWpisu,
                'ModelKomentarz' => $ModelKomentarz,
                'KomentarzDodany' => $KomentarzDodany,
                'DaneKomentarzy' => $DaneKomentarzy,
                )
            );
	}
}

?>