<?php

class BlogKomentarze extends CFormModel
{
	public $komentarz_wpis_id;
	public $komentarz_uzytkownik;
	public $komentarz_tresc;
	public $komentarz_data;

	public function rules()
	{
		return array(
			array('komentarz_uzytkownik, komentarz_tresc', 'required'),
			array('komentarz_uzytkownik', 'length', 'max'=>65),
		);
	}

	public function attributeLabels()
	{
		return array(
			'komentarz_id' => 'ID',
			'komentarz_wpis_id' => 'Wpis bloga',
			'komentarz_uzytkownik' => 'Użytkownik',
			'komentarz_tresc' => 'Treść',
            'komentarz_data' => 'Data publikacji',
		);
	}

	public function ZapiszKomentarz()
	{
		$ZapiszKomentarz = Yii::app()->db->createCommand('INSERT INTO blog_komentarze
		(
		komentarz_wpis_id,
		komentarz_uzytkownik,
		komentarz_tresc,
		komentarz_data
		)
		VALUES
		(
		:KomentarzWpisId,
		:KomentarzUzytkownik,
		:KomentarzTresc,
		:KomentarzData
		)
		');

		$ZapiszKomentarz->bindValue(':KomentarzWpisId', $this->komentarz_wpis_id, PDO::PARAM_INT);
		$ZapiszKomentarz->bindValue(':KomentarzUzytkownik', $this->komentarz_uzytkownik, PDO::PARAM_STR);
		$ZapiszKomentarz->bindValue(':KomentarzTresc', $this->komentarz_tresc, PDO::PARAM_STR);
		$ZapiszKomentarz->bindValue(':KomentarzData', $this->komentarz_data, PDO::PARAM_STR);


		$ZapiszKomentarz->execute();
	}

	public function WybierzKomentarzeWpisu($id)
	{
		$WybierzKomentarze = Yii::app()->db->createCommand('SELECT * FROM blog_komentarze
		WHERE
		komentarz_wpis_id = :KomentarzWpisId
		ORDER BY
		komentarz_id DESC
		');
		$WybierzKomentarze->bindValue(':KomentarzWpisId', $id, PDO::PARAM_INT);
		$DaneKomentarzy = $WybierzKomentarze->queryAll();

		return $DaneKomentarzy;
	}

	public function LiczWszystkieKomentarze()
	{
		$LiczWpisy =  Yii::app()->db->createCommand('SELECT count(komentarz_id) AS IleWpisow FROM blog_komentarze');
		$IloscWpisow = $LiczWpisy->queryScalar();

		return $IloscWpisow;
	}

	public function WybierzKomentarze($LimitNaStrone, $ObecnaStrona)
	{
		$WybierzKomentarze =  Yii::app()->db->createCommand('SELECT * FROM blog_komentarze ORDER BY komentarz_id DESC LIMIT :ZacznijOd , :UstawLimit');
		$WybierzKomentarze->bindValue(':ZacznijOd', ($ObecnaStrona * $LimitNaStrone), PDO::PARAM_INT);
		$WybierzKomentarze->bindValue(':UstawLimit', $LimitNaStrone, PDO::PARAM_INT);
		$DaneKomentarzy = $WybierzKomentarze->queryAll();

		return $DaneKomentarzy;
	}

	public function UsunKomentarz($id)
	{
		$UsunKomentarz =  Yii::app()->db->createCommand('DELETE FROM blog_komentarze WHERE komentarz_id = :KomentarzId');
		$UsunKomentarz->bindValue(':KomentarzId', $id, PDO::PARAM_INT);
		$UsunKomentarz->execute();
	}

}

?>