import org.xml.sax.helpers.DefaultHandler;
import org.xml.sax.Attributes;

public class SAXCounterHandler extends DefaultHandler {

  private int elements;

  public SAXCounterHandler () {
    super();
  }

  // obsuga zdarzenia pocztek-dokumentu
  public void startDocument ()
  {
    System.out.println("Rozpoczcie analizy skadniowej...");
    elements = 0;
  }

  // obsuga zdarzenia koniec-dokumentu
  public void endDocument ()
  {
    System.out.println("Wykonano!");
    System.out.println("Liczba odczytanych elementw: " + elements);
  }

  // obsuga zdarzenia pocztek-elementu
  public void startElement (String uri, String name,
                            String qName, Attributes atts) {
    System.out.println("pocztek elementu (" + qName + ")");
    if ("".equals(uri));
    else
      System.out.println("  przestrze nazw: " + uri);
    System.out.println("  liczba atrybutw: " + atts.getLength());
  }

  // obsuga zdarzenia koniec-elementu
  public void endElement (String uri, String name, String qName)
  {
    elements ++;
    System.out.println("koniec elementu (" + qName + ")");
  }

  // obsuga zdarzenia znakowego
  public void characters (char ch[], int start, int length)
  {
        System.out.println("Znaki sekcji CDATA: " + length);
  }
}