﻿<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0"
                xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format">

  <xsl:template match="/">
    <fo:root>
      <fo:layout-master-set>
        <fo:simple-page-master master-name="only">
          <fo:region-body region-name="xsl-region-body"
                          margin="1.0in"
                          padding="10pt"/>
          <fo:region-before region-name="xsl-region-before"
                          extent="1.0in"
                          display-align="before"/>
          <fo:region-after region-name="xsl-region-after"
                          extent="1.0in"
                          display-align="after"/>
        </fo:simple-page-master>
      </fo:layout-master-set>
      <fo:page-sequence master-reference="only">
        <fo:flow flow-name="xsl-region-body">
          <xsl:apply-templates/>
        </fo:flow>
      </fo:page-sequence>
    </fo:root>
  </xsl:template>

  <xsl:template match="telegram">
    <fo:block font-size="18pt" 
              font-family="monospace" 
              line-height="24pt"
              space-after.optimum="15pt"
              background-color="blue"
              color="white"
              text-align="center"
              padding-top="0pt">
      <xsl:text>TELEGRAM</xsl:text>
    </fo:block>
    <xsl:apply-templates/>
  </xsl:template>

  <xsl:template match="do">
    <fo:block font-family="sans-serif" font-size="14pt">
      <xsl:text>Do: </xsl:text>
      <xsl:apply-templates/>
    </fo:block>
  </xsl:template>

  <xsl:template match="od">
    <fo:block font-family="sans-serif" font-size="14pt">
      <xsl:text>Od: </xsl:text>
      <xsl:apply-templates/>
    </fo:block>
  </xsl:template>

  <xsl:template match="temat">
    <fo:block font-family="sans-serif" font-size="14pt">
      <xsl:text>Temat: </xsl:text>
      <xsl:apply-templates/>
    </fo:block>
  </xsl:template>

  <xsl:template match="wiadomość">
    <fo:block font-family="monospace"
              font-size="10pt"
              text-align="justify">
      <xsl:apply-templates/>
    </fo:block>
  </xsl:template>

  <xsl:template match="wyróżnienie">
    <fo:inline font-style="italic">
      <xsl:apply-templates/>
    </fo:inline>
  </xsl:template>

  <xsl:template match="imię">
    <fo:inline color="green">
      <xsl:apply-templates/>
    </fo:inline>
  </xsl:template>

  <xsl:template match="nikczemnik">
    <fo:inline color="red">
      <xsl:apply-templates/>
    </fo:inline>
  </xsl:template>

</xsl:stylesheet>
