﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                xmlns:fo="http://www.w3.org/1999/XSL/Format"
                version="1.0"
>
<xsl:output method="xml"/>

<!-- Początek drzewa FO oraz układu strony -->

<xsl:template match="/">
  <fo:root>
    <fo:layout-master-set>
      <fo:simple-page-master 
            master-name="the-only-page-type"
            page-height="11in" page-width="8.5in"
            margin-top="1in" margin-bottom="1in"
            margin-left="1.2in" margin-right="1.2in">
        <fo:region-body margin-top="20mm"/>
        <fo:region-before extent="0.3in"/>
      </fo:simple-page-master>
    </fo:layout-master-set>
    <xsl:apply-templates/>
  </fo:root>
</xsl:template>

<!-- Początek przepływów -->

<xsl:template match="TEI.2">
  <fo:page-sequence master-reference="the-only-page-type">
    <fo:static-content flow-name="xsl-region-before">
      <fo:block
        font-family="geneva, sans-serif"
        font-size="8pt"
        text-align="left"
        border-bottom="solid 1pt black"
      >
        <xsl:value-of select="teiHeader//sourceDesc"/>
      </fo:block>
    </fo:static-content>
    <fo:flow flow-name="xsl-region-body"
      font-family="didot, serif"
      font-size="10pt"
    >
      <xsl:apply-templates select="teiHeader//title"/>
      <xsl:apply-templates select="teiHeader//author"/>
      <xsl:apply-templates select="text/body"/>
    </fo:flow>
  </fo:page-sequence>
</xsl:template>

<!-- Tytuł czcionką pogrubioną w celu odróżnienia go od treści sonetu. -->

<xsl:template match="teiHeader//title">
  <fo:block
    font-weight="bold"
    space-before="2mm"
    space-after="4mm"
  >
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<!-- Imię i nazwisko autora kursywą w celu odróżnienia ich od treści sonetu. -->

<xsl:template match="teiHeader//author">
  <fo:block
    font-style="italic"
    space-after="4mm"
  >
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<xsl:template match="text/body">
  <xsl:apply-templates/>
</xsl:template>

<!--
Umieszczenie wierszy w jednym bloku w celu ich zgrupowania. Później może okazać się przydatne zrobienie czegoś szczególnego z całą grupą, na przykład otoczenie jej krawędzią. Wskazówka: używamy instrukcji "select", tak aby móc później użyć funkcji position() w celu wybrania wierszy posiadających wcięcia.
-->

<xsl:template match="lg">
  <fo:block>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

<!-- 
Jako elegancki efekt formatujący umieszczamy wcięcia lub odstępy w przypadku określonych wierszy. Co drugi wiersz zostaje wcięty 4 mm. Dodajemy odstęp po każdym czwartym wierszu. Dwa końcowe wiersze, zgodnie z konwencjami stosowanymi w przypadku sonetów, są wcięte.
-->

<xsl:template match="l">
  <fo:block>
    <xsl:if test="(count(preceding-sibling::l) mod 4) = 0">
      <xsl:attribute name="space-after">4mm</xsl:attribute>
    </xsl:if>
    <xsl:if test="count(preceding-sibling::l) &gt; 11">
      <xsl:attribute name="start-indent">5mm</xsl:attribute>
    </xsl:if>
    <xsl:if test="((count(preceding-sibling::l) mod 2) = 0)">
      <xsl:attribute name="start-indent">5mm</xsl:attribute>
    </xsl:if>
    <xsl:apply-templates/>
  </fo:block>
</xsl:template>

</xsl:stylesheet>