﻿using System;
using System.Collections.Generic;
using System.Text;

using System.Windows.Input;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Windows.UI.Xaml.Markup;

namespace ZadaniaUA
{
    [ContentProperty(Name="DialogContent")]
    public class CustomContentDialogBox : CommandDialogBox
    {
        public ContentDialogResult LastResult { get; protected set; }

        public double DialogHeight { get; set; }
        public object DialogContent { get; set; }
        public object DialogContentDataContext { get; set; }

        public string PrimaryButtonText { get; set; }
        public string SecondaryButtonText { get; set; }

        public CustomContentDialogBox()
        {
            DialogHeight = 480;
            PrimaryButtonText = "OK";
            SecondaryButtonText="Cancel";

            execute =
                async o =>
                {
                    ContentDialog dialog = new ContentDialog();
                    dialog.Height = DialogHeight;
                    dialog.Title = Caption;
                    dialog.Content = DialogContent;
                    dialog.DataContext = DialogContentDataContext;
                    dialog.PrimaryButtonText = PrimaryButtonText;                    
                    dialog.PrimaryButtonCommand = CommandPrimary;
                    dialog.PrimaryButtonCommandParameter = CommandParameter;
                    dialog.SecondaryButtonText = SecondaryButtonText;
                    dialog.SecondaryButtonCommand = CommandSecondary;
                    dialog.SecondaryButtonCommandParameter = CommandParameter;
                    LastResult = await dialog.ShowAsync();
                    OnPropertyChanged("LastResult");
                    dialog.Content = null;
                    dialog = null;
                };
        }

        public static DependencyProperty CommandPrimaryProperty = DependencyProperty.Register("CommandPrimary", typeof(ICommand), typeof(CustomContentDialogBox), new PropertyMetadata(null));
        public static DependencyProperty CommandSecondaryProperty = DependencyProperty.Register("CommandSecondary", typeof(ICommand), typeof(CustomContentDialogBox), new PropertyMetadata(null));
        
        public ICommand CommandPrimary
        {
            get
            {
                return (ICommand)GetValue(CommandPrimaryProperty);
            }
            set
            {
                SetValue(CommandPrimaryProperty, value);
            }
        }

        public ICommand CommandSecondary
        {
            get
            {
                return (ICommand)GetValue(CommandSecondaryProperty);
            }
            set
            {
                SetValue(CommandSecondaryProperty, value);
            }
        }
    }
}