﻿using System;

using Windows.UI;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Data;
using Windows.UI.Xaml.Media;

using Windows.Globalization;
using Windows.Globalization.DateTimeFormatting;

namespace ZadaniaUA
{
    public class BoolToBrushConverter : IValueConverter
    {
        public Brush KolorDlaFałszu { get; set; } = new SolidColorBrush(Colors.White);
        public Brush KolorDlaPrawdy { get; set; } = new SolidColorBrush(Colors.Gray);

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            bool bvalue = (bool)value;
            return !bvalue ? KolorDlaFałszu : KolorDlaPrawdy;
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    public class PriorytetZadaniaToString : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            Model.PriorytetZadania priorytetZadania = (Model.PriorytetZadania)value;
            return Model.Zadanie.OpisPriorytetu(priorytetZadania);
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            string opisPriorytetu = (value as string).ToLower();
            return Model.Zadanie.ParsujOpisPriorytetu(opisPriorytetu);
        }
    }

    public class PriorytetZadaniaToBrush : IValueConverter
    {
        private Brush kolorMniejWażne = new SolidColorBrush(Colors.Olive);
        private Brush kolorWażne = new SolidColorBrush(Colors.Orange);
        private Brush kolorKrytyczne = new SolidColorBrush(Colors.OrangeRed);

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            Model.PriorytetZadania priorytetZadania = (Model.PriorytetZadania)value;
            switch (priorytetZadania)
            {
                case Model.PriorytetZadania.MniejWażne:
                    return kolorMniejWażne;
                case Model.PriorytetZadania.Ważne:
                    return kolorWażne;
                case Model.PriorytetZadania.Krytyczne:
                    return kolorKrytyczne;
                default:
                    throw new Exception("Nierozpoznany priorytet zadania");
            }
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }

    public class BooleanToVisibilityConverter : IValueConverter
    {
        public bool OdwróćZależność { get; set; } = false;

        public object Convert(object value, Type targetType, object parameter, string language)
        {
            bool b = (bool)value;
            if (OdwróćZależność) b = !b;
            return b ? Visibility.Visible : Visibility.Collapsed;
        }
        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {            
            Visibility v = (Visibility)value;
            bool wynik = v == Visibility.Visible;
            if (OdwróćZależność) wynik = !wynik;
            return wynik;
        }
    }

    //http://stackoverflow.com/questions/23030120/how-to-format-a-date-in-an-windows-store-universal-app-w8-1-wp8-1
    public class DateConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, string language)
        {
            if (value == null || !(value is DateTime)) return null;

            DateTime dateTime = (DateTime)value;

            DateTimeFormatter dateTimeFormatter = new DateTimeFormatter(
                YearFormat.Full,
                MonthFormat.Full,
                DayFormat.Default,
                DayOfWeekFormat.None,
                HourFormat.None,
                MinuteFormat.None,
                SecondFormat.None,
                new[] { "pl-PL" },
                "PL",
                CalendarIdentifiers.Gregorian,
                ClockIdentifiers.TwentyFourHour);

            return dateTimeFormatter.Format(dateTime);
        }

        public object ConvertBack(object value, Type targetType, object parameter, string language)
        {
            throw new NotImplementedException();
        }
    }
}
