﻿using Windows.System;
using Windows.UI.Xaml;
using Windows.UI.Xaml.Controls;
using Microsoft.Xaml.Interactivity;

namespace KoloryUA
{
    public class ZamknięcieAplikacjiPoNaciśnieciuKlawisza : DependencyObject, IBehavior
    {
        public VirtualKey Klawisz { get; set; }

        void page_KeyDown(object sender, Windows.UI.Xaml.Input.KeyRoutedEventArgs e)
        {
            if (e.Key == Klawisz) Application.Current.Exit();
        }

        public DependencyObject AssociatedObject { get; set; }

        public void Attach(DependencyObject associatedObject)
        {
            AssociatedObject = associatedObject;
            Page page = (Page)associatedObject;
            if (page != null) page.KeyDown += page_KeyDown;
        }        

        public void Detach()
        {
            Page page = (Page)AssociatedObject;
            if (page != null) page.KeyDown -= page_KeyDown;
            AssociatedObject = null;
        }
    }
}
