//
//  IWalkNavService.cs
//  TrackMyWalks Navigation Service Interface
//
//  Autor: Steven F. Daniel, 03.09.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System.Threading.Tasks;
using TrackMyWalks.ViewModels;

namespace TrackMyWalks.Services
{
	public interface IWalkNavService
	{
		// powrt do poprzedniej strony na stosie NavigationStack
		Task PreviousPage();

		// powrt do pierwszej strony na stosie NavigationStack 
		Task BackToMainPage();

		// przejcie do wybranego modelu widoku w modelu MVVM
		// i przekazanie parametry
		Task NavigateToViewModel<ViewModel, WalkParam>(WalkParam parameter)
			where ViewModel : WalkBaseViewModel;
	}
}