﻿using Plugin.LocalNotifications.Abstractions;
using Xamarin.Forms;

namespace XamFormsLocalNotifications
{
    public class App : Application
    {
        public App()
        {
            ILocalNotifications localNotifications = DependencyService.Get<ILocalNotifications>();

            Button showNotificationButton = new Button();
            showNotificationButton.Text = "Pokaż lokalne powiadomienia";
            showNotificationButton.Clicked += (sender, e) => localNotifications.Show("Test", "Lokalne powiadomienie", 1);

            Button cancelNotificationButton = new Button();
            cancelNotificationButton.Text = "Przerwij lokalne powiadomienia";
            cancelNotificationButton.Clicked += (sender, e) => localNotifications.Cancel(1);

            MainPage = new ContentPage
            {
                Content = new StackLayout
                {
                    VerticalOptions = LayoutOptions.Center,
                    Children = {
                        showNotificationButton,
                        cancelNotificationButton
                    }
                }
            };
        }
    }
}
