﻿using Xamarin.Forms;
using System.Diagnostics;

namespace XamFormsSQLiteDataAccess
{
    public class App : Application
    {
        public App()
        {
            // Główna strona aplikacji
            ISQLiteConnection connection = DependencyService.Get<ISQLiteConnection>();

			if (connection.GetConnection () != null) {
				Debug.WriteLine ("Połączenie SQLite gotowe!");
			}

            MainPage = new ContentPage
            {
                Content = new StackLayout
                {
                    VerticalOptions = LayoutOptions.Center,
                    Children = {
                        new Label {
                            XAlign = TextAlignment.Center,
                            Text = connection.GetDataBasePath()
                        }
                    }
                }
            };
        }
    }
}
