﻿using System.Threading.Tasks;
using Xamarin.Forms;

namespace XamFormsSharedProject
{
    public class App : Application
	{
		public App ()
		{
            // Główna strona aplikacji

            Label label = new Label
            {
                XAlign = TextAlignment.Center
            };

            NameService nameService = new NameService();

            nameService.GetGreeting("Janie", "Kowalski")
                .ContinueWith((antecedent) =>
            {
                label.Text = antecedent.Result;
            }, TaskScheduler.FromCurrentSynchronizationContext());

            MainPage = new ContentPage {
				Content = new StackLayout {
					VerticalOptions = LayoutOptions.Center,
					Children = {
						label
					}
				}
			};
		}
	}
}
