﻿using Foundation;
using System.Diagnostics;
using System.Globalization;
using Xamarin.Forms;

[assembly: Dependency(typeof(XamFormsLocalization.iOS.Localize))]

namespace XamFormsLocalization.iOS
{
    public class Localize : ILocalize
    {
        public CultureInfo GetCurrentCultureInfo()
        {
            string netLanguage = "en";
            string prefLanguageOnly = "en";

            if (NSLocale.PreferredLanguages.Length > 0)
            {
                var pref = NSLocale.PreferredLanguages[0];
                prefLanguageOnly = pref.Substring(0, 2);
                netLanguage = pref.Replace("_", "-");
                Debug.WriteLine("Ustawiony język:" + netLanguage);
            }

            CultureInfo ci = null;
            try
            {
                ci = new CultureInfo(netLanguage);
            }
            catch
            {
              // Błędne ustawienie języka systemowego (np. "en-ES" : angielski w Hiszpanii).
              // Wyodrębniamy pierwsze dwa znaki, w tym przypadku "en".
                ci = new CultureInfo(prefLanguageOnly);
            }

            return ci;
        }
    }
}
