﻿using Foundation;
using UIKit;
using MonoTouch.NUnit.UI;

namespace UnitTestTouch
{
  // Klasa UIApplicationDelegate aplikacji, odpowiedzialna za uruchamianie interfejsu użytkownika,
  // jak również nasłuchiwanie (i opcjonalnie odpowiadanie) na zdarzenia zgłaszane przez aplikację.
  [Register("AppDelegate")]
  public class AppDelegate : UIApplicationDelegate
  {
    // Deklaracje na poziomie klasy

    public override UIWindow Window
    {
      get;
      set;
    }

    TouchRunner runner;

    public override bool FinishedLaunching(UIApplication application, NSDictionary launchOptions)
    {
      // Miejsce, w którym można dostosowywać testy po uruchomieniu aplikacji
      // Jeżeli metoda ta nie jest potrzebna w Twojej aplikacji, możesz ją usunąć

      // Utworzenie nowej instancji okna, odpowiedniej do rozmiaru ekranu
      Window = new UIWindow (UIScreen.MainScreen.Bounds);
      runner = new TouchRunner (Window);

      // Rejestracja wszystkich testów zawartych w głównym zbiorze aplikacji
      runner.Add (System.Reflection.Assembly.GetExecutingAssembly ());

      Window.RootViewController = new UINavigationController (runner.GetViewController ());

      // Wyświetlenie okna
      Window.MakeKeyAndVisible();

      return true;
    }

  }
}