//Rozdział 12.
//Pyłek

// Nazwy użytkowników

public class User
{
    public string FullName { get; }
    public User(string fullName)
    {
        FullName = fullName;
    }

public class User2
{
    private static List<string> strings = new List<string>();
    private int[] names;
    public User2(string fullName)
    {
        int getOrAdd(string s)
        {
            int idx = strings.IndexOf(s);
            if (idx != -1) return idx;
            else
            {
                strings.Add(s);
                return strings.Count - 1;
            }
        }
        names = fullName.Split(' ').Select(getOrAdd).ToArray();
    }
    public string FullName => string.Join(" ", names.Select(i => strings[i]));
}

public static string RandomString()
{
    Random rand = new Random();
    return new string(
        Enumerable.Range(0, 10)
            .Select(i => (char) ('a' + rand.
            Next(26))).ToArray());
}
var users = new List<User>(); // lub User2
foreach (var firstName in firstNames)
foreach (var lastName in lastNames)
    users.Add(new User($"{firstName} {lastName}"));

// Formatowanie tekstu

public class FormattedText
{
    private string plainText;
    public FormattedText(string plainText)
    {
        this.plainText = plainText;
        capitalize = new bool[plainText.Length];
    }
    public void Capitalize(int start, int end)
    {
        for (int i = start; i <= end; ++i)
        capitalize[i] = true;
    }
    private bool[] capitalize;
}

public override string ToString()
{
    var sb = new StringBuilder();
    for (var i = 0; i < plainText.Length; i++)
    {
        var c = plainText[i];
        sb.Append(capitalize[i] ? char.ToUpper(c) : c);
    }
    return sb.ToString();
}
var ft = new FormattedText("To nowy, wspaniały świat");
ft.Capitalize(10, 19);
WriteLine(ft); // To nowy, WSPANIAŁY świat

public class TextRange
{
    public int Start, End;
    public bool Capitalize; //także Bold, Italic itp.
    public bool Covers(int position)
    {
        return position >= Start && position <= End;
    }
}

public class BetterFormattedText
{
    private readonly string plainText;
    private readonly List<TextRange> formatting
        = new List<TextRange>();
    public BetterFormattedText(string plainText)
    {
        this.plainText = plainText;
    }
    public TextRange GetRange(int start, int end)
    {
        var range = new TextRange {Start = start, End = end};
        formatting.Add(range);
        return range;
    }
    public class TextRange { ... }
}

public override string ToString()
{
    var sb = new StringBuilder();
    for (var i = 0; i < plainText.Length; i++)
    {
        var c = plainText[i];
        foreach (var range in formatting)
            if (range.Covers(i) && range.Capitalize)
                c = char.ToUpperInvariant(c);
        sb.Append(c);
    }
    return sb.ToString();
}

var bft = new BetterFormattedText("To nowy, wspaniały świat");
bft.GetRange(10, 15).Capitalize = true;
WriteLine(bft); //To nowy, WSPANIAŁY świat
