//Rozdział 4.
//Fabryki


public class Point
{
    private double x, y;
    public Point(double x, double y)
    {
        this.x = x;
        this.y = y;
    }
}

Point(float r, float theta)
{
    x = r * Math.Cos(theta);
    y = r * Math.Sin(theta);
}

public enum CoordinateSystem
{
    Cartesian,
    Polar
}

public Point(double a,
    double b, //nazwy nie przekazują przeznaczenia
    CoordinateSystem cs = CoordinateSystem.Cartesian)
{
switch (cs)
{
    case CoordinateSystem.Polar:
        x = a * Math.Cos(b);
        y = a * Math.Sin(b);
        break;
    default:
        x = a;
        y = b;
        break;
    }
}

//Metoda wytwórcza
public class Point
{
    protected Point(double x, double y)
    {
        this.x = x;
        this.y = y;
    }
    public static Point NewCartesianPoint(double x, double y)
    {
        return new Point(x, y);
    }
    public static Point NewPolarPoint(double rho, double theta)
    {
        return new Point(rho*Math.Cos(theta), rho*Math.Sin(theta));
    }
    //inne składowe pominięto
}
var point = Point.NewPolarPoint(5, Math.PI / 4);

//Asynchroniczna metoda wytwórcza
InitAsync(): 
public class Foo
{
    private async Task InitAsync()
    {
        await Task.Delay(1000);
    }
}

var foo = new Foo();
await foo.InitAsync();

public class Foo
{
    protected Foo() { /* tutaj inicjalizacja */ }
    public static Task<Foo> CreateAsync()
    {
        var result = new Foo();
        return result.InitAsync();
    }
}

var foo = await Foo.CreateAsync();

//Fabryka


class PointFactory
{
    public static Point NewCartesianPoint(float x, float y)
    {
        return new Point(x, y); //musi być publiczny
    }
    //to samo dla NewPolarPoint
}

var myPoint = PointFactory.NewCartesian(3, 4);

//Fabryka wewnętrzna
public class Point
{
    //tutaj typowe składowe
    //zauważmy, że konstruktor jest ponownie prywatny
    private Point(double x, double y) { ... }
    public static class Factory
    {
       public static Point NewCartesianPoint(double x, double y)
       {
            return new Point(x, y); //użycie prywatnego konstruktora
       }
       //podobnie dla NewPolarPoint()
    }
}
var point = Point.Factory.NewCartesianPoint(2, 3);

//Separacja logiczna
public partial class Point { ... }
public partial class Point
{
    public static class Factory
    {
        //jak wcześniej
    }
}

//Fabryka Abstrakcyjna

public interface IShape
{
    void Draw();
}
public class Square : IShape
{
    public void Draw() => Console.WriteLine("Prosty kwadrat");
}
public class Rectangle : IShape
{
    public void Draw() => Console.WriteLine("Prosty prostokąt");
}

public class RoundedSquare : IShape
{
    public void Draw() => Console.WriteLine("Zaokrąglony kwadrat");
}
public class RoundedRectangle : IShape
{
    public void Draw() => Console.WriteLine("Zaokrąglony prostokąt");
}

public enum Shape
{
    Square,
    Rectangle
}

public class BasicShapeFactory : ShapeFactory
{
    public override IShape Create(Shape shape)
    {
        switch (shape)
        {
            case Shape.Square:
                return new Square();
            case Shape.Rectangle:
                return new Rectangle();
            default:
                throw new ArgumentOutOfRangeException(nameof(shape), shape, null);
        }
    }
}

public abstract class ShapeFactory
{
    public abstract IShape Create(Shape shape);
}

public static ShapeFactory GetFactory(bool rounded)
{
    if (rounded)
        return new RoundedShapeFactory();
    else
        return new BasicShapeFactory();
}

var basic = GetFactory(false);
var basicRectangle = basic.Create(Shape.Rectangle);
basicRectangle.Draw(); // Zwykły prostokąt

var roundedSquare = GetFactory(true).Create(Shape.Square);
roundedSquare.Draw(); // \Zaokrąglony prostokąt

//Fabryki–delegaty w IoC
public class Service
{
    public string DoSomething(int value)
    {
        return $"Mam wartość {value}";
    }
}

public class DomainObject
{
    private Service service;
    private int value;
    public DomainObject(Service service, int value)
    {
        this.service = service;
        this.value = value;
    }
    public override string ToString()
    {
        return service.DoSomething(value);
    }
}

var cb = new ContainerBuilder();
cb.RegisterType<Service>();
cb.RegisterType<DomainObject>();

using var container = cb.Build();
var dobj = container.Resolve<DomainObject>(
    new PositionalParameter(1, 42));
Console.WriteLine(dobj); // Mam wartość 42

public class DomainObject
{
    public delegate DomainObject Factory(int value);
    // tutaj inne składowe
}

var factory = container.Resolve<DomainObject.Factory>();
var dobj2 = factory(42);
Console.WriteLine(dobj2); // Mam wartość 42



//Fabryka Funkcyjna
type ICountryInfo =
    abstract member Capital : string
type Country =
    | USA
    | UK
let make country =
    match country with
    | USA -> {new ICountryInfo with
              member x.Capital = "Waszyngton" }
    | UK ->  {new ICountryInfo with
              member x.Capital = "Londyn" }
type Country =
    | USA
    | UK
with
    static member Create = function
        | "USA" | "Ameryka" -> USA
        | "UK" | "Anglia" -> UK
        | _ -> failwith "Nie ma takiego kraju"
let usa = Country.Create "Ameryka"
 
