package wzorceproj.metodaszablonowa.barista;

public abstract class NapójZKofeinąZHaczykiem {
 
   final void recepturaParzenia() {
      gotowanieWody();
      zaparzanie();
      nalewanieDoFiliżanki();
      if (czyKlientChceDodatki()) {
         domieszanieDodatków();
      }
   }
 
   abstract void zaparzanie();
 
   abstract void domieszanieDodatków();
 
   void gotowanieWody() {
      System.out.println("Gotowanie wody");
   }
 
   void nalewanieDoFiliżanki() {
      System.out.println("Nalewanie do filiżanki");
   }
 
   boolean czyKlientChceDodatki() {
      return true;
   }
}
