package wzorceproj.posrednik.virtualproxy;

import java.net.*;
import java.awt.*;
import javax.swing.*;

class PośrednikObrazków implements Icon {
   volatile ImageIcon imageIcon;
   final URL obrazekURL;
   Thread pobieranieThread;
   boolean pobieranie = false;
     
   public PośrednikObrazków(URL url) { obrazekURL = url; }
     
   public int getIconWidth() {
      if (imageIcon != null) {
            return imageIcon.getIconWidth();
        } else {
         return 800;
      }
   }
 
   public int getIconHeight() {
      if (imageIcon != null) {
            return imageIcon.getIconHeight();
        } else {
         return 600;
      }
   }
   
   synchronized void setImageIcon(ImageIcon imageIcon) {
      this.imageIcon = imageIcon;
   }
     
   public void paintIcon(final Component c, Graphics  g, int x,  int y) {
      if (imageIcon != null) {
         imageIcon.paintIcon(c, g, x, y);
      } else {
         g.drawString("Trwa pobieranie okładki albumu, proszę czekać...", x+200, y+190);
         if (!pobieranie) {
            pobieranie = true;
            
            pobieranieThread = new Thread(new Runnable() {
               public void run() {
                  try {
                     setImageIcon(new ImageIcon(obrazekURL, "Okładka albumu"));
                     c.repaint();
                  } catch (Exception e) {
                     e.printStackTrace();
                  }
               }
            });
            
            /*
            pobieranieThread = new Thread(() -> {
                  try {
                     setImageIcon(new ImageIcon(obrazekURL, "Okładka albumu"));
                     c.repaint();
                  } catch (Exception e) {
                     e.printStackTrace();
                  }
            });
            */
            pobieranieThread.start();            
         }
      }
   }
}
